/* $Id: crc_32.c,v 1.2 2001/05/15 19:14:33 ozra Exp $ */

/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2000 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *   Author:  Ledio Ago - lajesus   (email: lajesus@yahoo.com)            *
 *                                                                        *
 **************************************************************************
 *									  *
 *   File: crc_32.c							  *
 *   									  *
 *   Description: This file holds function for implementation of crc.	  *
 * 	The goal is calculate the crc of individual character.		  *
 *   	- gen_crc_table: It will build the crc table			  *
 * 	- crc_reset: It will reset the value of the variable where the 	  *
 *	  will be stored.						  *
 *	- get_crc: It will calculate the crc value of single character.	  *
 *									  *
 *************************************************************************/

#include "crc_32.h"

unsigned long crc_table[256]; /* Global variable	*/

/*
 * Function: 	gen_crc_table
 *
 * Description: Function gen_crc_table will build the crc table.
 *
 * Input:	None
 * Output: 	None.	
 */

void gen_crc_table(void)                /* build the crc table */
{
    unsigned long crc, poly;
    int i, j;

    poly = 0xEDB88320L;
    for (i = 0; i < 256; i++)
        {
        crc = i;
        for (j = 8; j > 0; j--)
            {
            if (crc & 1)
                crc = (crc >> 1) ^ poly;
            else
                crc >>= 1;
            }
        crc_table[i] = crc;
        }
}

/*
 * Function: 	crc_reset
 * 
 * Description: Function crc_reset will reset the value of the variable where the 
 * 		crc will be stored.
 * 
 * Input:	crc, unsigned long type pointer variable will be used to store the 
 *		individual crc value of each character in the block of characters
 * Output:	None.
 */

void crc_reset( unsigned long *crc ) {

    *crc = 0xFFFFFFFF;
}

/* 
 * Function: 	get_crc
 *
 * Description: Function get_crc will calculate the crc of each individual character
 * 		
 * Input:	crc, unsigned long type pointer will be used store the crc value of 
 *		a character.
 * 		ch, integer type will be use to store the integer value of each 
 *		character.
 * Output: 	It will return the crc value of each character.
 */

unsigned long get_crc( unsigned long *crc, int ch )    /* calculate the crc value */
{
    	*crc = (((*crc)>>8) & 0x00FFFFFF) ^ crc_table[ ((*crc)^ch) & 0xFF ];
	return ((*crc)^0xFFFFFFFF);
}

