#ifndef _MSGFACE_H_
#define _MSGFACE_H_

#include "common.h"

#ifndef GMSG_ERRBUFSIZE
#define GMSG_ERRBUFSIZE 512
#endif

#ifndef DEFAULT_TIMEOUT  /* in miliseconds */
#define DEFAULT_TIMEOUT 100
#endif

typedef unsigned int GMSG_ACK_T;
typedef unsigned int GMSG_SIZE_T;

struct grub_t {
	
	int is_init;
	SOCKET sock;
	unsigned int io_timeout;

	/* send */
	int send_notready;
	GMSG_ACK_T send_ackdata;
	GMSG_SIZE_T send_size;

	/* recv */
	int recv_available;
	GMSG_ACK_T recv_ackdata;
	GMSG_SIZE_T recv_size;

	char errstr[GMSG_ERRBUFSIZE];
};

extern grub_t grub_info;

void gmsg_init( SOCKET s );
void gmsg_set_timeout( unsigned int timeout );
void gmsg_uninit();

int gmsg_send_ready();
int gmsg_send( const char *msg, unsigned int len );

int gmsg_recv_available();
int gmsg_recv( char *buf );

const char *gmsg_strerror();

// utility stuff
int gmsg_socket_ready( SOCKET sock, bool write_sock, unsigned int msec );

#endif  /* _MSGFACE_H_ */
