#ifndef _ConsoleFace_H_
#define _ConsoleFace_H_

#include "Face.h"

class ConsoleFace : protected Face {
public:
	ConsoleFace();
	~ConsoleFace();

	// Posts, Rings, Events
	/////////////////////////

	void PostSetBandwidth(int Bandwidth);
	void PostSetCrawlerCount(int Count);

	void RingGetBandwidth();
	void RingGetBandwidthLimit();
	void RingGetCrawlerCount();
	void RingGetStatus();

	virtual void EventGetBandwidth(int Bandwidth);
	virtual void EventGetBandwidthLimit(int Limit);
	virtual void EventGetCrawlerCount(int Count);
	virtual void EventGetStatus(int Status);

	virtual void EventGettingBegin();
	virtual void EventGettingURL(const char *URL, int Size, int CRC);
	virtual void EventGettingEnd();
	virtual void EventCrawlingBegin();
	virtual void EventCrawlingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC,
		int Bandwidth);
	virtual void EventCrawlingURLDone(const char *URL, const char *Status);
	virtual void EventCrawlingEnd();
	virtual void EventPuttingBegin();
	virtual void EventPuttingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC);
	virtual void EventPuttingEnd();

	virtual void EventHostProtect();
	virtual void EventHostUnprotect();
	virtual void EventSleep(int Seconds);

	// properties
	///////////////

	void SetHost( const char *new_host );
	const char *GetHost();

	void SetPort( unsigned short new_port );
	unsigned short GetPort();

	// methods
	////////////

	void Connect();
	void Disconnect();
	void Refresh();
	bool IsConnected();

protected:
	virtual void readCallback( const char *data );
	virtual void errorCallback( const char *msg );

private:
	char *host;
	unsigned short port;

	DEFINE_FACE_EVENT(GetBandwidth);
	DEFINE_FACE_EVENT(GetBandwidthLimit);
	DEFINE_FACE_EVENT(GetCrawlerCount);
	DEFINE_FACE_EVENT(GetStatus);

	DEFINE_FACE_EVENT(GettingBegin);
	DEFINE_FACE_EVENT(GettingURL);
	DEFINE_FACE_EVENT(GettingEnd);
	DEFINE_FACE_EVENT(CrawlingBegin);
	DEFINE_FACE_EVENT(CrawlingURL);
	DEFINE_FACE_EVENT(CrawlingURLDone);
	DEFINE_FACE_EVENT(CrawlingEnd);
	DEFINE_FACE_EVENT(PuttingBegin);
	DEFINE_FACE_EVENT(PuttingURL);
	DEFINE_FACE_EVENT(PuttingEnd);

	DEFINE_FACE_EVENT(HostProtect);
	DEFINE_FACE_EVENT(HostUnprotect);
	DEFINE_FACE_EVENT(Sleep);
};

#endif  /* _ConsoleFace_H_ */
