#include "BaseFace.h"

BaseFace::BaseFace() : Face(), port(1025)
{
	ADD_FACE_EVENT(SetBandwidth);
	ADD_FACE_EVENT(SetCrawlerCount);

	ADD_FACE_EVENT(GetBandwidth);
	ADD_FACE_EVENT(GetBandwidthLimit);
	ADD_FACE_EVENT(GetCrawlerCount);
	ADD_FACE_EVENT(GetStatus);
}

BaseFace::~BaseFace() { }

//////////////////////////
// Posts, Rings, Events //
//////////////////////////

void BaseFace::EventSetBandwidth(int Bandwidth)
{
	ENTER_FACE_EVENT(SetBandwidth);

	EXIT_FACE_EVENT();
}

void BaseFace::EventSetCrawlerCount(int Count)
{
	ENTER_FACE_EVENT(SetCrawlerCount);

	EXIT_FACE_EVENT();
}


void BaseFace::EventGetBandwidth()
{
	ENTER_FACE_EVENT(GetBandwidth);

	EXIT_FACE_EVENT();
}

void BaseFace::EventGetBandwidthLimit()
{
	ENTER_FACE_EVENT(GetBandwidthLimit);

	EXIT_FACE_EVENT();
}

void BaseFace::EventGetCrawlerCount()
{
	ENTER_FACE_EVENT(GetCrawlerCount);

	EXIT_FACE_EVENT();
}

void BaseFace::EventGetStatus()
{
	ENTER_FACE_EVENT(GetStatus);

	EXIT_FACE_EVENT();
}


void BaseFace::PostGetBandwidth(int Bandwidth)
{
	ENTER_FACE_POST(GetBandwidth);

	APPEND_INTEGER(Bandwidth);

	EXIT_FACE_POST();
}

void BaseFace::PostGetBandwidthLimit(int Limit)
{
	ENTER_FACE_POST(GetBandwidthLimit);

	APPEND_INTEGER(Limit);

	EXIT_FACE_POST();
}

void BaseFace::PostGetCrawlerCount(int Count)
{
	ENTER_FACE_POST(GetCrawlerCount);

	APPEND_INTEGER(Count);

	EXIT_FACE_POST();
}

void BaseFace::PostGetStatus(int Status)
{
	ENTER_FACE_POST(GetStatus);

	APPEND_INTEGER(Status);

	EXIT_FACE_POST();
}


void BaseFace::PostGettingBegin()
{
	ENTER_FACE_POST(GettingBegin);

	EXIT_FACE_POST();
}

void BaseFace::PostGettingURL(const char *URL, int Size, int CRC)
{
	ENTER_FACE_POST(GettingURL);

	APPEND_STRING(URL);
	APPEND_INTEGER(Size);
	APPEND_INTEGER(CRC);

	EXIT_FACE_POST();
}

void BaseFace::PostGettingEnd()
{
	ENTER_FACE_POST(GettingEnd);

	EXIT_FACE_POST();
}

void BaseFace::PostCrawlingBegin()
{
	ENTER_FACE_POST(CrawlingBegin);

	EXIT_FACE_POST();
}

void BaseFace::PostCrawlingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC,
		int Bandwidth)
{
	ENTER_FACE_POST(CrawlingURL);

	APPEND_STRING(URL);
	APPEND_STRING(Status);
	APPEND_INTEGER(Size);
	APPEND_INTEGER(CRC);
	APPEND_INTEGER(Bandwidth);

	EXIT_FACE_POST();
}

void BaseFace::PostCrawlingURLDone(const char *URL, const char *Status)
{
	ENTER_FACE_POST(CrawlingURLDone);

	APPEND_STRING(URL);
	APPEND_STRING(Status);

	EXIT_FACE_POST();
}

void BaseFace::PostCrawlingEnd()
{
	ENTER_FACE_POST(CrawlingEnd);

	EXIT_FACE_POST();
}

void BaseFace::PostPuttingBegin()
{
	ENTER_FACE_POST(PuttingBegin);

	EXIT_FACE_POST();
}

void BaseFace::PostPuttingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC)
{
	ENTER_FACE_POST(PuttingURL);

	APPEND_STRING(URL);
	APPEND_STRING(Status);
	APPEND_INTEGER(Size);
	APPEND_INTEGER(CRC);

	EXIT_FACE_POST();
}

void BaseFace::PostPuttingEnd()
{
	ENTER_FACE_POST(PuttingEnd);

	EXIT_FACE_POST();
}


void BaseFace::PostHostProtect()
{
	ENTER_FACE_POST(HostProtect);

	EXIT_FACE_POST();
}

void BaseFace::PostHostUnprotect()
{
	ENTER_FACE_POST(HostUnprotect);

	EXIT_FACE_POST();
}

void BaseFace::PostSleep(int Seconds)
{
	ENTER_FACE_POST(Sleep);

	APPEND_INTEGER(Seconds);

	EXIT_FACE_POST();
}

////////////////
// properties //
////////////////

void BaseFace::SetPort( unsigned short new_port )
{
	port = new_port;
}

unsigned short BaseFace::GetPort()
{
	return port;
}

/////////////
// methods //
/////////////

void BaseFace::Connect()
{
	connectServer( port );
}

void BaseFace::Disconnect()
{
	disconnect();
}

void BaseFace::Refresh()
{
	refresh();
}

bool BaseFace::IsConnected()
{
	return isConnected();
}

///////////////
// protected //
///////////////

// msg == NULL will be treated as bad data
void BaseFace::readCallback( const char *msg )
{
	BEGIN_FIRE_EVENTS

	BEGIN_FIRE(SetBandwidth)
	{
		GET_INTEGER(Bandwidth)

		EventSetBandwidth(Bandwidth);
	}
	END_FIRE

	BEGIN_FIRE(SetCrawlerCount)
	{
		GET_INTEGER(Count)

		EventSetCrawlerCount(Count);
	}
	END_FIRE


	BEGIN_FIRE(GetBandwidth)
	{
		EventGetBandwidth();
	}
	END_FIRE

	BEGIN_FIRE(GetBandwidthLimit)
	{
		EventGetBandwidthLimit();
	}
	END_FIRE

	BEGIN_FIRE(GetCrawlerCount)
	{
		EventGetCrawlerCount();
	}
	END_FIRE

	BEGIN_FIRE(GetStatus)
	{
		EventGetStatus();
	}
	END_FIRE

	// Errors

	BEGIN_FIRE_BADPARSE
	{
		// XML parsing error
	}
	END_FIRE_BADPARSE

	BEGIN_FIRE_INVALIDMSG
	{
		// XML message was correct but invalid/unsupported
	}
	END_FIRE_INVALIDMSG

	END_FIRE_EVENTS
}

void BaseFace::errorCallback( const char *msg )
{
#ifdef DEBUG_FACE
	printf("IN BaseFace::errorCallback: '%s'\n", msg);
#endif
}
