//Crawler test main
// www.grub.org

#include "Crawler.h"
#include "ClientDB.h"
extern "C" {
#include <grubconf.h>
}
#include <clog.h>

using namespace std;

int main (void)
{
	int ret = readGrubConfig(&Config_File_Info);

	// create a new log object
	clog_init("testcrawl.log");	
	
	// create a new database object
	ClientDB *grubdata = new ClientDB();

	// set up some common variables to pass to the crawler
	Config_File_Info.MaxAmountOfBandwidth = 64000;
	Config_File_Info.NumOfCrawlersToRun = 2;
	Config_File_Info.ThreadsPerHost = 5;

	// you need to set up proxy stuff if testing through a proxy server
	// Config_File_Info.ProxyPort = 4088;
	// char *proxy = "192.168.0.1";
	// Config_File_Info.Proxy = proxy;

	// set up some variables for reading in the results
	string URL;
	string contents;
	unsigned long size;
	unsigned long CRC;
	status_t status;
	string mime = "text/html";
	string redirect = "";  

	URLHandler *url_info = 0;

	// set up the CRC stuff for the CRC of the URL itself (not the data)
	gen_crc_table();

	// a string to use as input
	string urlin;

	// hit enter
	cout << endl;

	// begin inserting URLs into the database object
	while (true)
	{
		// get our information from the user
		cout << "Enter a URL or \"done\" to continue: ";
		cin >> urlin;
		
		if (urlin == "done")
		{
			break;
		}
		else
		{	
			cout << "Inserting URL: " << urlin << endl;
			grubdata->GetInsert(urlin.c_str(),1,1);
		}
	}

	// hit enter
	cout << endl;	

	// create a new crawler to crawl the objects in the database
	//Crawler *grubcrawl = new Crawler(grublog, grubdata, num_crawlers, max_band, host_protect);
	cout << "creating crawler object..." << endl;
	cout << endl;
	Crawler *grubcrawl = new Crawler(grubdata);

	// start up the crawler
	cout << "starting up the crawler..." << endl;
	cout << endl;

	grubcrawl->start();

	// print out the archive summary
	cout << "-----------------------------" << endl;
	cout << "Begin Archiver Summary Output" << endl;
	cout << "-----------------------------" << endl;
//	grubdata->printArchive();
	cout << "---------------------------" << endl;
	cout << "End Archiver Summary Output" << endl;
	cout << "---------------------------" << endl;
	
	// print out the first record - set up a loop for more
	grubdata->CrawlRetrieve( &url_info );

	cout << endl;
	cout << "------------------------------" << endl;
	cout << "Start Archiver Detailed Output" << endl;
	cout << "------------------------------" << endl;
	cout << endl;
 
	printf("URL = %s\n",url_info->URL);
	printf("size = %u\n",url_info->size);
	printf("CRC = %u\n",url_info->CRC);
	printf("contents = %s\n",url_info->content);
	printf("status = %d\n",url_info->status);
	printf("MIME = %s\n",url_info->MIME);
	
	cout << endl;
	cout << "----------------------------" << endl;
	cout << "End Archiver Detailed Output" << endl;
	cout << "----------------------------" << endl;
	cout << endl;

	cout << endl << "done!" << endl;
	cout << endl;
	
	clog_uninit();

	delete url_info;	

	return 0;
}

