/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/* Project: GRUB 
 * <http://www.grub.org>
 * module: CRW
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 08 Jan, 2001
 * Files: CrwStat.cpp CrwStat.h
 * 
 * Module used to provide a certain level of statistics on the
 * crawling process as a whole. Should be modified or rewritten if 
 * more meaningful stats are needed such a the crawling time for
 * each process/URL.
 *
 */


//***********************************************************
#ifndef _CrwStat_H_
#define _CrwStat_H_

#include <stdio.h>
#include <time.h>

//File in which to store the stat output
#define TIME_STAT_FILE "grubstat.log"

class CrwStat
{
  public:
  	CrwStat(int psNum);
  	~CrwStat();
   	void go();
	void finish();
  private:
  	int psNum;
	FILE * outfile; 
	time_t checkpt;

};



#endif
