/* $Id: incrout.cpp,v 1.8 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.8 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "common/Dynagraph.h"
#include "common/emitGraph.h"
using namespace std;

const unsigned int AllFlags = 0xffffffff;

void emitStrChanges(ostream &os,StrAttrChanges &cha,StrAttrs &att) {
	os << "[";
	for(StrAttrChanges::iterator ci = cha.begin(); ci!=cha.end(); ++ci) {
	  if(ci!=cha.begin())
	    os << ",";
	  os << mquote(*ci) << "=" << mquote(att[*ci]);
	}
	os << "]\n";
	cha.clear();
}
void emitChanges(ostream &os,ChangeQueue &Q,const char *view) {
	os << "lock view " << view << endl;
	if(!gd<StrAttrChanges>(Q.client).empty()) {
	  os << "modify view " << view << " ";
	  emitStrChanges(os,gd<StrAttrChanges>(Q.client),gd<StrAttrs>(Q.client));
	}
	Layout::node_iter ni;
	Layout::graphedge_iter ei;
	for(ni = Q.delN.nodes().begin(); ni!=Q.delN.nodes().end(); ++ni) {
	  os << "delete " << view << " node " << mquote(gd<Name>(*ni).c_str()) << endl;
	  gd<StrAttrChanges>(*ni).clear();
	}
	for(ei = Q.delE.edges().begin(); ei!=Q.delE.edges().end(); ++ei) {
	  os << "delete " << view << " edge " << mquote(gd<Name>(*ei).c_str()) << endl;
	  gd<StrAttrChanges>(*ei).clear();
	}
	for(ni = Q.insN.nodes().begin(); ni!=Q.insN.nodes().end(); ++ni) {
	  os << "insert " << view << " node " << mquote(gd<Name>(*ni).c_str()) << " ";
	  emitStrChanges(os,gd<StrAttrChanges>(*ni),gd<StrAttrs>(*ni));
	}
	for(ei = Q.insE.edges().begin(); ei!=Q.insE.edges().end(); ++ei) {
	  os << "insert " << view << " edge " << mquote(gd<Name>(*ei))
	     << " " << mquote(gd<Name>((*ei)->tail))
	     << " " << mquote(gd<Name>((*ei)->head)) << " ";
	  emitStrChanges(os,gd<StrAttrChanges>(*ei),gd<StrAttrs>(*ei));
	}
	// all things that still have StrAttrChanges are either layout-modified or had an irrelevant string changed 
	for(ni = Q.client->nodes().begin(); ni!=Q.client->nodes().end(); ++ni)
	  if(!gd<StrAttrChanges>(*ni).empty()) {
	    os << "modify " << view << " node " << mquote(gd<Name>(*ni).c_str()) << " ";
	    emitStrChanges(os,gd<StrAttrChanges>(*ni),gd<StrAttrs>(*ni));
	  }
	for(ei = Q.client->edges().begin(); ei!=Q.client->edges().end(); ++ei)
	  if(!gd<StrAttrChanges>(*ei).empty()) {
	    os << "modify " << view << " edge " << mquote(gd<Name>(*ei)) << " ";
	    emitStrChanges(os,gd<StrAttrChanges>(*ei),gd<StrAttrs>(*ei));
	  }
	os << "unlock view " << view << endl;
}
