/* $Id: options.h,v 1.3 2004/12/11 19:26:06 ellson Exp $ $Revision: 1.3 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifndef OPTIONS_H
#define OPTIONS_H

    typedef enum {
	seed_unset, seed_val, seed_time, seed_regular
    } seedMode;

    /* Parameters set from command line */
    typedef struct {
	int numIters;
	double K;
	double T0;
	seedMode smode;
    } cmd_args;

    extern cmd_args fdp_args;

    extern int fdp_doArgs(int argc, char **argv);
    extern int fdp_setSeed(seedMode * sm, char *arg);

#endif

#ifdef __cplusplus
}
#endif
