/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef TYPEDEFS_H
#define TYPEDEFS_H


typedef enum {
	SORT_NONE,
	SORT_NAME,
	SORT_SIZE,
	SORT_TIME,
	SORT_PATH,
	SORT_NUMBER
} SortType;

typedef enum {
	ALTER_NONE,		/* do nothing */
	ALTER_ROTATE_90,
	ALTER_ROTATE_90_CC,	/* counterclockwise */
	ALTER_ROTATE_180,
	ALTER_MIRROR,
	ALTER_FLIP
} AlterType;

typedef struct _ImageLoader ImageLoader;
struct _ImageLoader
{
	GdkPixbuf *pixbuf;
	gchar *path;

	gint bytes_read;
	gint bytes_total;

	guint buffer_size;

	gint done;
	gint idle_id;
	gint idle_priority;

	GdkPixbufLoader *loader;
	gint load_fd;

	void (*func_area_ready)(ImageLoader *, guint x, guint y, guint w, guint h, gpointer);
	void (*func_error)(ImageLoader *, gpointer);
	void (*func_done)(ImageLoader *, gpointer);
	void (*func_percent)(ImageLoader *, gfloat, gpointer);

	gpointer data_area_ready;
	gpointer data_error;
	gpointer data_done;
	gpointer data_percent;

	gint idle_done_id;
};

typedef struct _ThumbLoader ThumbLoader;
struct _ThumbLoader
{
	GdkPixbuf *pixbuf;	/* contains final (scaled) image when done */
	ImageLoader *il;
	gchar *path;

	gint from_cache;
	gfloat percent_done;

	gint max_w;
	gint max_h;

	void (*func_error)(ThumbLoader *, gpointer);
	void (*func_done)(ThumbLoader *, gpointer);
	void (*func_percent)(ThumbLoader *, gfloat, gpointer);

	gpointer data_error;
	gpointer data_done;
	gpointer data_percent;

	gint idle_done_id;
};

typedef struct _CollectInfo CollectInfo;
struct _CollectInfo
{
	gchar *path;
	gint size;
	time_t date;

	GdkPixmap *pixmap;
	GdkBitmap *mask;
};

typedef struct _CollectionData CollectionData;
struct _CollectionData
{
	gchar *path;
	gchar *name;
	GList *list;
	SortType sort_method;

	ThumbLoader *thumb_loader;
	CollectInfo *thumb_info;

	void (*info_updated_func)(CollectionData *, CollectInfo *, gpointer);
	gpointer info_updated_data;

	gint ref;

	/* geometry */
	gint window_read;
	gint window_x;
	gint window_y;
	gint window_w;
	gint window_h;

	/* contents changed since save flag */
	gint changed;
};

typedef struct _CollectTable CollectTable;
struct _CollectTable
{
	GtkWidget *scrolled;
	GtkWidget *clist;
	gint columns;
	gint rows;

	CollectionData *cd;

	GList *selection;
	CollectInfo *prev_selection;

	gint mouse_in_drag;
	gint mouse_add;
	CollectInfo *mouse_start;
	CollectInfo *mouse_current;
	gint scroll_timeout_id;

	GtkWidget *tip_window;
	gint tip_delay_id;
	CollectInfo *tip_info;

	GtkWidget *marker_window;
	CollectInfo *marker_info;

	GtkWidget *status_label;
	GtkWidget *extra_label;

	gint focus_row;
	gint focus_column;
	CollectInfo *focus_info;

	gint frozen;
};

typedef struct _CollectWindow CollectWindow;
struct _CollectWindow
{
	GtkWidget *window;
	CollectTable *table;
	GtkWidget *status_box;
	GList *list;

	GtkWidget *close_dialog;

	CollectionData *cd;
};

typedef struct _ImageWindow ImageWindow;
struct _ImageWindow
{
	GtkWidget *widget;	/* use this to add it and show it */
	GtkWidget *eventbox;
	GtkWidget *image;

	gchar *image_path;
	const gchar *image_name;

	gint image_width;	/* image actual dimensions (pixels) */
	gint image_height;
	GdkPixbuf *pixbuf;
	gint size;		/* file size (bytes) */
	gint unknown;		/* failed to load image */

	gint window_width;	/* allocated size of window (drawing area) */
	gint window_height;

	gint x_offset;		/* offset of image start (non-zero when image < window) */
	gint y_offset;

	gint vis_width;		/* dimensions of visible part of image */
	gint vis_height;

	gint width;		/* size of scaled image (result) */
	gint height;

	gint x_scroll;		/* scroll offset of image (into width, height to start drawing) */
	gint y_scroll;

	gfloat zoom;		/* zoom we want (0 is auto) */
	gfloat scale;		/* zoom we got (should never be 0) */

	gint tile_width;
	gint tile_height;
	gint tile_cols;		/* count of tile columns */
	GList *tiles;		/* list of buffer tiles */
	GList *tile_cache;	/* list of pixmap/pixbuf tile allocations */
	gint tile_cache_size;	/* allocated size of pixmaps/pixbufs */
	GList *draw_queue;	/* list of areas to redraw */

	ImageLoader *il;

	gint draw_idle_id;

	gint in_drag;
	gint drag_last_x;
	gint drag_last_y;
	gint drag_moved;

	gint has_frame;
	gint top_window_sync;	/* resize top_window when image dimensions change */

	/* top level (not necessarily parent) window */
	GtkWidget *top_window;	/* window that gets title, and window to resize when 'fitting' */
	gchar *title;		/* window title to display left of file name */
	gchar *title_right;	/* window title to display right of file name */
	gint title_show_zoom;	/* option to include zoom in window title */

	void (*update_func)(ImageWindow *, gpointer);
	gpointer update_data;

	/* button functions */
	void (*func_btn1)(ImageWindow *, GdkEventButton *, gpointer);
	void (*func_btn2)(ImageWindow *, GdkEventButton *, gpointer);
	void (*func_btn3)(ImageWindow *, GdkEventButton *, gpointer);
	void (*func_btn4)(ImageWindow *, GdkEventButton *, gpointer);
	void (*func_btn5)(ImageWindow *, GdkEventButton *, gpointer);

	gpointer data_btn1;
	gpointer data_btn2;
	gpointer data_btn3;
	gpointer data_btn4;
	gpointer data_btn5;

	/* collection info */
	CollectionData *collection;
	CollectInfo *collection_info;

	AlterType delay_alter_type;

	ImageLoader *read_ahead_il;
	GdkPixbuf *read_ahead_pixbuf;
	gchar *read_ahead_path;
};


#endif

