/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef IMG_MAIN_H
#define IMG_MAIN_H

void main_image_full_screen_start(void);
void main_image_full_screen_stop(void);
void main_image_full_screen_toggle(void);
gint main_image_full_screen_active(void);

void main_image_slideshow_next(void);
void main_image_slideshow_prev(void);
void main_image_slideshow_start(void);
void main_image_slideshow_start_from_list(GList *list);
void main_image_slideshow_stop(void);
void main_image_slideshow_toggle(void);
gint main_image_slideshow_active(void);
gint main_image_slideshow_pause_toggle(void);
gint main_image_slideshow_paused(void);
gint main_image_slideshow_continue_check(void);

void main_image_scroll(gint x, gint y);
void main_image_adjust_zoom(gfloat increment);
void main_image_set_zoom(gfloat zoom);
void main_image_alter(AlterType type);
void main_image_set_path(const gchar *path);

const gchar *main_image_get_path(void);
const gchar *main_image_get_name(void);
CollectionData *main_image_get_collection(CollectInfo **info);

void main_image_change_to(const gchar *path, const gchar *read_ahead_path);
void main_image_change_to_from_collection(CollectionData *cd, CollectInfo *info);
void main_image_reload(void);

void main_image_next(void);
void main_image_prev(void);
void main_image_first(void);
void main_image_last(void);

void main_image_set_labels(GtkWidget *info, GtkWidget *zoom);

GtkWidget *main_image_create(void);

void main_image_to_root(void);


#endif

