/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_FILE04_H__
#define __GPASS_FILE04_H__

#include <glib-object.h>

#include "gpass/crypt-stream.h"
#include "gpass/entry-factory.h"

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassFile04
 *
 ***********************************************************/
#define GPASS_TYPE_DB (gpass_file04_get_type())
#define GPASS_FILE04(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_DB, GPassFile04))
#define GPASS_FILE04_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_DB, GPassFile04Class))
#define GPASS_IS_DB(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_DB))
#define GPASS_IS_DB_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_DB))
#define GPASS_FILE04_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_DB, GPassFile04Class))

typedef struct {
    GObject parent;

    gchar *path;
    gchar *master_password;
} GPassFile04;

typedef struct {
    GObjectClass parent;
} GPassFile04Class;

GType gpass_file04_get_type(void);

GError *gpass_file04_create(const gchar *path, const gchar *master_password);
GError *gpass_file04_open(GPassFile04 **self, const gchar *path,
                          const gchar *master_password);
GError *gpass_file04_read(GPassFile04 *self, GPassEntryFactory *factory,
                          GPassEntry **entries);
GError *gpass_file04_write(GPassFile04 *self, GPassEntry *entries);
GError *gpass_file04_backup(GPassFile04 *self, const gchar *backup_path);
GError *gpass_file04_restore(GPassFile04 *self, const gchar *backup_path);
void gpass_file04_close(GPassFile04 *self);

/***********************************************************
 *
 * GPassFile04Reader
 *
 ***********************************************************/
#define GPASS_TYPE_DB_READER (gpass_file04_reader_get_type())
#define GPASS_FILE04_READER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_DB_READER, GPassFile04Reader))
#define GPASS_FILE04_READER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_DB_READER, \
                             GPassFile04ReaderClass))
#define GPASS_IS_DB_READER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_DB_READER))
#define GPASS_IS_DB_READER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_DB_READER))
#define GPASS_FILE04_READER_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_DB_READER, \
                               GPassFile04ReaderClass))

typedef struct {
    GObject parent;
    
    GPassDecryptStream *decrypt;
    GPassEntryFactory *factory;
} GPassFile04Reader;

typedef struct {
    GObjectClass parent;
} GPassFile04ReaderClass;

GType gpass_file04_reader_get_type(void);

GError *gpass_file04_reader_read(GPassFile04Reader *self, GPassEntry *entries);

/***********************************************************
 *
 * GPassFile04Writer
 *
 ***********************************************************/
#define GPASS_TYPE_DB_WRITER (gpass_file04_writer_get_type())
#define GPASS_FILE04_WRITER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_DB_WRITER, GPassFile04Writer))
#define GPASS_FILE04_WRITER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_DB_WRITER, \
                             GPassFile04WriterClass))
#define GPASS_IS_DB_WRITER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_DB_WRITER))
#define GPASS_IS_DB_WRITER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_DB_WRITER))
#define GPASS_FILE04_WRITER_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_DB_WRITER, \
                               GPassFile04WriterClass))

typedef struct {
    GObject parent;
    
    GPassEncryptStream *encrypt;
} GPassFile04Writer;

typedef struct {
    GObjectClass parent;
} GPassFile04WriterClass;

GType gpass_file04_writer_get_type(void);

GError *gpass_file04_writer_write(GPassFile04Writer *self, GPassEntry *entries);

G_END_DECLS

#endif /* #ifndef __GPASS_FILE04_H__ */
