# gozerbot/fleet.py
#
#

""" fleet is a list of bots """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
from gozerbot.generic import rlog, handle_exception, waitforqueue
from gozerbot.eventhandler import commandhandler
from gozerbot.persist import Persist
from gozerbot.config import config
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
import Queue, os, types, threading, time, pickle

class Fleet(object):

    """ contains multiple bots (list of bots) """

    def __init__(self, fname):
        if config['jabberenable']:
            self.mainbotname = config['mainbotname'] or 'jabbermain'
        else:
            self.mainbotname = config['mainbotname'] or 'main'
        self.startok = threading.Event()
        self.bots = []
        self.botdata = Persist(fname)
        if not self.botdata.data:
            self.botdata.data = {}

    def updatenick(self, name, nick):
        try:
            self.botdata.data[name][2] = nick
            self.botdata.save()
            return 1
        except KeyError:
            return 0

    def getmainbot(self):
        """ return the main bot of the fleet """
        return self.byname(self.mainbotname)

    def getfirstbot(self):
        """ return the main bot of the fleet """
        return self.bots[0]
        
    def size(self):
        """ return number of bots """
        return len(self.bots)

    def start(self, mainbot=None):
        """ startup the bots """
        got = False
        if mainbot:
            self.bots.append(mainbot)
            start_new_thread(mainbot.joinchannels, ())
            got = True
        for i in self.botdata.data:
            if not config['jabberenable'] and \
self.botdata.data[i][0] == 'jabber':
                rlog(10, 'fleet', 'jabber not enabled .. skipping %s' % i)
                continue
            if config['ircdisable'] and \
self.botdata.data[i][0] == 'irc':
                rlog(10, 'fleet', 'irc not enabled .. skipping %s' % i)
                continue
            start_new_thread(self.startbot, (i, ))
            got = True
        if not got:
            rlog(100, 'fleet', 'no bots enabled')
        else:
            time.sleep(5)
            self.startok.set()

    def resume(self, sessionfile):
        session = pickle.load(open(sessionfile))
        for name in session['bots'].keys():
            reto = None
            if name == session['name']:
                reto = session['channel']
            start_new_thread(self.resumebot, (name, session['bots'][name], reto))
        time.sleep(5)
        self.startok.set()

    def save(self):
        """ save fleet data and call save on all the bots """
        try:
            self.botdata.save()
        except Exception, ex:
            handle_exception()
        for i in self.bots:
            try:
                i.save()
            except Exception, ex:
                handle_exception()

    def list(self):
        """ return list of bot names """
        result = []
        for i in self.bots:
            result.append(i.name)
        return result

    def stopall(self):
        """ return bot by name """
        for i in self.bots:
            try:
                i.stop()
            except:
                pass

    def byname(self, name):
        """ return bot by name """
        name = name.lower()
        for i in self.bots:
            if name == i.name:
                return i

    def replace(self, name, bot):
        """ replace bot """
        name = name.lower()
        for i in range(len(self.bots)):
            if name == self.bots[i].name:
                self.bots[i] = bot

    def addbot(self, bot):
        """ add a irc or jabber bot based on bot type """
        self.bots.append(bot)
        if bot.type == 'irc':
            datalist = ['irc', bot.owner, bot.nick, bot.server, bot.port, \
bot.password, bot.ipv6, bot.ssl]
        elif bot.type == 'jabber':
            datalist = ['jabber', bot.owner, bot.host, bot.user, \
bot.password, bot.port]
        self.botdata.data[bot.name.lower()] = datalist
        self.botdata.save()

    def startbot(self, name):
        """ get a bot up and running .. create it if it is not in fleet """
        name = name.lower()
        try:
            bd = self.botdata.data[name]
            got = False
            if bd[0] == 'irc' and not config['ircdisable']:
                bot = self.byname(name)
                if not bot:
                    from gozerbot.bot import Bot
                    bot = Bot(name, bd[1])
                if bot.connect(*bd[2:]):
                    got = True
            elif bd[0] == 'jabber' and config['jabberenable']:
                bot = self.byname(name)
                if not bot:
                    from gozerbot.jabberbot import Jabberbot
                    bot = Jabberbot(name)
                if bot.connect(*bd[2:]):
                    got = True
            if got:
                if bot not in self.bots:
                    self.bots.append(bot)
                bot.joinchannels()
                rlog(10, 'fleet', 'started %s bot' % bot.name)
            else:
                rlog(10, 'fleet', 'failed to start %s bot' % bot.name)
        except Exception, ex:
            handle_exception()

    def resumebot(self, name, data, reto):
        name = name.lower()
        try:
            bd = self.botdata.data[name]
            got = False
            if bd[0] == 'irc':
                bot = self.byname(name)
                if not bot:
                    from gozerbot.bot import Bot
                    bot = Bot(name, bd[1])
                if bot._resume(data, reto):
                    got = True
                elif bot.connect(*bd[2:]):
                    got = True
            elif bd[0] == 'jabber' and config['jabberenable']:
                bot = self.byname(name)
                if not bot:
                    from gozerbot.jabberbot import Jabberbot
                    bot = Jabberbot(name)
                if bot.connect(*bd[2:]):
                    got = True
            if got:
                if bot not in self.bots:
                    self.bots.append(bot)
                bot.joinchannels()
                rlog(10, 'fleet', 'resumed %s bot' % bot.name)
            else:
                rlog(10, 'fleet', 'failed to resume %s bot' % bot.name)
        except Exception, ex:
            handle_exception()

    def connect(self, name):
        """ connect bot to irc server"""
        name = name.lower()
        for i in self.bots:
            if i.name == name:
                try:
                    data = self.botdata.data[name]
                except KeyError:
                    return
                got = 0
                if i.type == 'irc':
                    got = i._connect(*data[2:])
                elif i.type == 'jabber':
                    got = i.connect(*data[2:])
                if got:
                    i.joinchannels()
                    return 1
                else:
                    return 0

    def delete(self, name):
        """ delete bot with name from fleet """
        for i in self.bots:
            if i.name == name:
                try:
                    del self.botdata.data[name]
                    self.botdata.save()
                except KeyError:
                    pass
                i.exit()
                self.remove(i)
                rlog(10, 'fleet', '%s deleted' % i.name)
                return 1

    def remove(self, bot):
        """ delete bot by object """
        self.bots.remove(bot)

    def exit(self, name):
        """ call exit on all bots """
        name = name.lower()
        for i in self.bots:
            if i.name == name:
                try:
                    i.exit()
                except:
                    handle_exception()
                return 1

    def exitall(self):
        """ call exit on all bots """
        commandhandler.stop()
        for i in self.bots:
            try:
                i.exit()
            except Exception, ex:
                handle_exception()

    def cmnd(self, event, name, cmnd):
        """ do command on a bot by name """
        name = name.lower()
        bot = self.byname(name)
        if not bot:
            return 0
        if bot.type == 'irc':
            from gozerbot.ircevent import Ircevent
            j = Ircevent()
        elif bot.type == 'jabber':
            from gozerbot.jabbermsg import Jabbermsg
            j = Jabbermsg()
        j.copyin(event)
        j.txt = cmnd
        q = Queue.Queue()
        j.queues = [q]
        j.speed = 3
        start_new_thread(plugins.trydispatch, (bot, j))
        result = waitforqueue(q)
        if not result:
            return
        res = ["[%s]" % bot.name, ]
        res += result
        event.reply(res)

    def cmndall(self, event, cmnd):
        """ do a command on all bots """
        threads = []
        for i in self.bots:
            thread = start_new_thread(self.cmnd, (event, i.name, cmnd))
            threads.append(thread)
        for i in threads:
            i.join(10)

    def broadcast(self, txt):
        for i in self.bots:
            start_new_thread(i.broadcast, (txt, ))

fleet = Fleet(datadir + os.sep + 'fleet')
