// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53recoveryreadiness

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCell = "CreateCell"

// CreateCellRequest generates a "aws/request.Request" representing the
// client's request for the CreateCell operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCell for more information on using the CreateCell
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCellRequest method.
//    req, resp := client.CreateCellRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCell
func (c *Route53RecoveryReadiness) CreateCellRequest(input *CreateCellInput) (req *request.Request, output *CreateCellOutput) {
	op := &request.Operation{
		Name:       opCreateCell,
		HTTPMethod: "POST",
		HTTPPath:   "/cells",
	}

	if input == nil {
		input = &CreateCellInput{}
	}

	output = &CreateCellOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCell API operation for AWS Route53 Recovery Readiness.
//
// Creates a cell in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation CreateCell for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCell
func (c *Route53RecoveryReadiness) CreateCell(input *CreateCellInput) (*CreateCellOutput, error) {
	req, out := c.CreateCellRequest(input)
	return out, req.Send()
}

// CreateCellWithContext is the same as CreateCell with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCell for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) CreateCellWithContext(ctx aws.Context, input *CreateCellInput, opts ...request.Option) (*CreateCellOutput, error) {
	req, out := c.CreateCellRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCrossAccountAuthorization = "CreateCrossAccountAuthorization"

// CreateCrossAccountAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCrossAccountAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCrossAccountAuthorization for more information on using the CreateCrossAccountAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCrossAccountAuthorizationRequest method.
//    req, resp := client.CreateCrossAccountAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCrossAccountAuthorization
func (c *Route53RecoveryReadiness) CreateCrossAccountAuthorizationRequest(input *CreateCrossAccountAuthorizationInput) (req *request.Request, output *CreateCrossAccountAuthorizationOutput) {
	op := &request.Operation{
		Name:       opCreateCrossAccountAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/crossaccountauthorizations",
	}

	if input == nil {
		input = &CreateCrossAccountAuthorizationInput{}
	}

	output = &CreateCrossAccountAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCrossAccountAuthorization API operation for AWS Route53 Recovery Readiness.
//
// Creates a cross-account readiness authorization. This lets you authorize
// another account to work with Route 53 Application Recovery Controller, for
// example, to check the readiness status of resources in a separate account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation CreateCrossAccountAuthorization for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCrossAccountAuthorization
func (c *Route53RecoveryReadiness) CreateCrossAccountAuthorization(input *CreateCrossAccountAuthorizationInput) (*CreateCrossAccountAuthorizationOutput, error) {
	req, out := c.CreateCrossAccountAuthorizationRequest(input)
	return out, req.Send()
}

// CreateCrossAccountAuthorizationWithContext is the same as CreateCrossAccountAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCrossAccountAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) CreateCrossAccountAuthorizationWithContext(ctx aws.Context, input *CreateCrossAccountAuthorizationInput, opts ...request.Option) (*CreateCrossAccountAuthorizationOutput, error) {
	req, out := c.CreateCrossAccountAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReadinessCheck = "CreateReadinessCheck"

// CreateReadinessCheckRequest generates a "aws/request.Request" representing the
// client's request for the CreateReadinessCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReadinessCheck for more information on using the CreateReadinessCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReadinessCheckRequest method.
//    req, resp := client.CreateReadinessCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateReadinessCheck
func (c *Route53RecoveryReadiness) CreateReadinessCheckRequest(input *CreateReadinessCheckInput) (req *request.Request, output *CreateReadinessCheckOutput) {
	op := &request.Operation{
		Name:       opCreateReadinessCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/readinesschecks",
	}

	if input == nil {
		input = &CreateReadinessCheckInput{}
	}

	output = &CreateReadinessCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReadinessCheck API operation for AWS Route53 Recovery Readiness.
//
// Creates a readiness check in an account. A readiness check monitors a resource
// set in your application, such as a set of Amazon Aurora instances, that Application
// Recovery Controller is auditing recovery readiness for. The audits run once
// every minute on every resource that's associated with a readiness check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation CreateReadinessCheck for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateReadinessCheck
func (c *Route53RecoveryReadiness) CreateReadinessCheck(input *CreateReadinessCheckInput) (*CreateReadinessCheckOutput, error) {
	req, out := c.CreateReadinessCheckRequest(input)
	return out, req.Send()
}

// CreateReadinessCheckWithContext is the same as CreateReadinessCheck with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReadinessCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) CreateReadinessCheckWithContext(ctx aws.Context, input *CreateReadinessCheckInput, opts ...request.Option) (*CreateReadinessCheckOutput, error) {
	req, out := c.CreateReadinessCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecoveryGroup = "CreateRecoveryGroup"

// CreateRecoveryGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecoveryGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecoveryGroup for more information on using the CreateRecoveryGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRecoveryGroupRequest method.
//    req, resp := client.CreateRecoveryGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateRecoveryGroup
func (c *Route53RecoveryReadiness) CreateRecoveryGroupRequest(input *CreateRecoveryGroupInput) (req *request.Request, output *CreateRecoveryGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRecoveryGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/recoverygroups",
	}

	if input == nil {
		input = &CreateRecoveryGroupInput{}
	}

	output = &CreateRecoveryGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecoveryGroup API operation for AWS Route53 Recovery Readiness.
//
// Creates a recovery group in an account. A recovery group corresponds to an
// application and includes a list of the cells that make up the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation CreateRecoveryGroup for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateRecoveryGroup
func (c *Route53RecoveryReadiness) CreateRecoveryGroup(input *CreateRecoveryGroupInput) (*CreateRecoveryGroupOutput, error) {
	req, out := c.CreateRecoveryGroupRequest(input)
	return out, req.Send()
}

// CreateRecoveryGroupWithContext is the same as CreateRecoveryGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecoveryGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) CreateRecoveryGroupWithContext(ctx aws.Context, input *CreateRecoveryGroupInput, opts ...request.Option) (*CreateRecoveryGroupOutput, error) {
	req, out := c.CreateRecoveryGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceSet = "CreateResourceSet"

// CreateResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceSet for more information on using the CreateResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceSetRequest method.
//    req, resp := client.CreateResourceSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateResourceSet
func (c *Route53RecoveryReadiness) CreateResourceSetRequest(input *CreateResourceSetInput) (req *request.Request, output *CreateResourceSetOutput) {
	op := &request.Operation{
		Name:       opCreateResourceSet,
		HTTPMethod: "POST",
		HTTPPath:   "/resourcesets",
	}

	if input == nil {
		input = &CreateResourceSetInput{}
	}

	output = &CreateResourceSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceSet API operation for AWS Route53 Recovery Readiness.
//
// Creates a resource set. A resource set is a set of resources of one type
// that span multiple cells. You can associate a resource set with a readiness
// check to monitor the resources for failover readiness.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation CreateResourceSet for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateResourceSet
func (c *Route53RecoveryReadiness) CreateResourceSet(input *CreateResourceSetInput) (*CreateResourceSetOutput, error) {
	req, out := c.CreateResourceSetRequest(input)
	return out, req.Send()
}

// CreateResourceSetWithContext is the same as CreateResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) CreateResourceSetWithContext(ctx aws.Context, input *CreateResourceSetInput, opts ...request.Option) (*CreateResourceSetOutput, error) {
	req, out := c.CreateResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCell = "DeleteCell"

// DeleteCellRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCell operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCell for more information on using the DeleteCell
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCellRequest method.
//    req, resp := client.DeleteCellRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCell
func (c *Route53RecoveryReadiness) DeleteCellRequest(input *DeleteCellInput) (req *request.Request, output *DeleteCellOutput) {
	op := &request.Operation{
		Name:       opDeleteCell,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cells/{cellName}",
	}

	if input == nil {
		input = &DeleteCellInput{}
	}

	output = &DeleteCellOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCell API operation for AWS Route53 Recovery Readiness.
//
// Delete a cell. When successful, the response code is 204, with no response
// body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation DeleteCell for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCell
func (c *Route53RecoveryReadiness) DeleteCell(input *DeleteCellInput) (*DeleteCellOutput, error) {
	req, out := c.DeleteCellRequest(input)
	return out, req.Send()
}

// DeleteCellWithContext is the same as DeleteCell with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCell for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) DeleteCellWithContext(ctx aws.Context, input *DeleteCellInput, opts ...request.Option) (*DeleteCellOutput, error) {
	req, out := c.DeleteCellRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCrossAccountAuthorization = "DeleteCrossAccountAuthorization"

// DeleteCrossAccountAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCrossAccountAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCrossAccountAuthorization for more information on using the DeleteCrossAccountAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCrossAccountAuthorizationRequest method.
//    req, resp := client.DeleteCrossAccountAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCrossAccountAuthorization
func (c *Route53RecoveryReadiness) DeleteCrossAccountAuthorizationRequest(input *DeleteCrossAccountAuthorizationInput) (req *request.Request, output *DeleteCrossAccountAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteCrossAccountAuthorization,
		HTTPMethod: "DELETE",
		HTTPPath:   "/crossaccountauthorizations/{crossAccountAuthorization}",
	}

	if input == nil {
		input = &DeleteCrossAccountAuthorizationInput{}
	}

	output = &DeleteCrossAccountAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCrossAccountAuthorization API operation for AWS Route53 Recovery Readiness.
//
// Deletes cross account readiness authorization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation DeleteCrossAccountAuthorization for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCrossAccountAuthorization
func (c *Route53RecoveryReadiness) DeleteCrossAccountAuthorization(input *DeleteCrossAccountAuthorizationInput) (*DeleteCrossAccountAuthorizationOutput, error) {
	req, out := c.DeleteCrossAccountAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteCrossAccountAuthorizationWithContext is the same as DeleteCrossAccountAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCrossAccountAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) DeleteCrossAccountAuthorizationWithContext(ctx aws.Context, input *DeleteCrossAccountAuthorizationInput, opts ...request.Option) (*DeleteCrossAccountAuthorizationOutput, error) {
	req, out := c.DeleteCrossAccountAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReadinessCheck = "DeleteReadinessCheck"

// DeleteReadinessCheckRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReadinessCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReadinessCheck for more information on using the DeleteReadinessCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReadinessCheckRequest method.
//    req, resp := client.DeleteReadinessCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteReadinessCheck
func (c *Route53RecoveryReadiness) DeleteReadinessCheckRequest(input *DeleteReadinessCheckInput) (req *request.Request, output *DeleteReadinessCheckOutput) {
	op := &request.Operation{
		Name:       opDeleteReadinessCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/readinesschecks/{readinessCheckName}",
	}

	if input == nil {
		input = &DeleteReadinessCheckInput{}
	}

	output = &DeleteReadinessCheckOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReadinessCheck API operation for AWS Route53 Recovery Readiness.
//
// Deletes a readiness check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation DeleteReadinessCheck for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteReadinessCheck
func (c *Route53RecoveryReadiness) DeleteReadinessCheck(input *DeleteReadinessCheckInput) (*DeleteReadinessCheckOutput, error) {
	req, out := c.DeleteReadinessCheckRequest(input)
	return out, req.Send()
}

// DeleteReadinessCheckWithContext is the same as DeleteReadinessCheck with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReadinessCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) DeleteReadinessCheckWithContext(ctx aws.Context, input *DeleteReadinessCheckInput, opts ...request.Option) (*DeleteReadinessCheckOutput, error) {
	req, out := c.DeleteReadinessCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecoveryGroup = "DeleteRecoveryGroup"

// DeleteRecoveryGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecoveryGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecoveryGroup for more information on using the DeleteRecoveryGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRecoveryGroupRequest method.
//    req, resp := client.DeleteRecoveryGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteRecoveryGroup
func (c *Route53RecoveryReadiness) DeleteRecoveryGroupRequest(input *DeleteRecoveryGroupInput) (req *request.Request, output *DeleteRecoveryGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRecoveryGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/recoverygroups/{recoveryGroupName}",
	}

	if input == nil {
		input = &DeleteRecoveryGroupInput{}
	}

	output = &DeleteRecoveryGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecoveryGroup API operation for AWS Route53 Recovery Readiness.
//
// Deletes a recovery group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation DeleteRecoveryGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteRecoveryGroup
func (c *Route53RecoveryReadiness) DeleteRecoveryGroup(input *DeleteRecoveryGroupInput) (*DeleteRecoveryGroupOutput, error) {
	req, out := c.DeleteRecoveryGroupRequest(input)
	return out, req.Send()
}

// DeleteRecoveryGroupWithContext is the same as DeleteRecoveryGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecoveryGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) DeleteRecoveryGroupWithContext(ctx aws.Context, input *DeleteRecoveryGroupInput, opts ...request.Option) (*DeleteRecoveryGroupOutput, error) {
	req, out := c.DeleteRecoveryGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceSet = "DeleteResourceSet"

// DeleteResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceSet for more information on using the DeleteResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceSetRequest method.
//    req, resp := client.DeleteResourceSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteResourceSet
func (c *Route53RecoveryReadiness) DeleteResourceSetRequest(input *DeleteResourceSetInput) (req *request.Request, output *DeleteResourceSetOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resourcesets/{resourceSetName}",
	}

	if input == nil {
		input = &DeleteResourceSetInput{}
	}

	output = &DeleteResourceSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceSet API operation for AWS Route53 Recovery Readiness.
//
// Deletes a resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation DeleteResourceSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteResourceSet
func (c *Route53RecoveryReadiness) DeleteResourceSet(input *DeleteResourceSetInput) (*DeleteResourceSetOutput, error) {
	req, out := c.DeleteResourceSetRequest(input)
	return out, req.Send()
}

// DeleteResourceSetWithContext is the same as DeleteResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) DeleteResourceSetWithContext(ctx aws.Context, input *DeleteResourceSetInput, opts ...request.Option) (*DeleteResourceSetOutput, error) {
	req, out := c.DeleteResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchitectureRecommendations = "GetArchitectureRecommendations"

// GetArchitectureRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetArchitectureRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchitectureRecommendations for more information on using the GetArchitectureRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetArchitectureRecommendationsRequest method.
//    req, resp := client.GetArchitectureRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetArchitectureRecommendations
func (c *Route53RecoveryReadiness) GetArchitectureRecommendationsRequest(input *GetArchitectureRecommendationsInput) (req *request.Request, output *GetArchitectureRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetArchitectureRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/recoverygroups/{recoveryGroupName}/architectureRecommendations",
	}

	if input == nil {
		input = &GetArchitectureRecommendationsInput{}
	}

	output = &GetArchitectureRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchitectureRecommendations API operation for AWS Route53 Recovery Readiness.
//
// Gets recommendations about architecture designs for improving resiliency
// for an application, based on a recovery group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetArchitectureRecommendations for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetArchitectureRecommendations
func (c *Route53RecoveryReadiness) GetArchitectureRecommendations(input *GetArchitectureRecommendationsInput) (*GetArchitectureRecommendationsOutput, error) {
	req, out := c.GetArchitectureRecommendationsRequest(input)
	return out, req.Send()
}

// GetArchitectureRecommendationsWithContext is the same as GetArchitectureRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchitectureRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetArchitectureRecommendationsWithContext(ctx aws.Context, input *GetArchitectureRecommendationsInput, opts ...request.Option) (*GetArchitectureRecommendationsOutput, error) {
	req, out := c.GetArchitectureRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCell = "GetCell"

// GetCellRequest generates a "aws/request.Request" representing the
// client's request for the GetCell operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCell for more information on using the GetCell
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCellRequest method.
//    req, resp := client.GetCellRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCell
func (c *Route53RecoveryReadiness) GetCellRequest(input *GetCellInput) (req *request.Request, output *GetCellOutput) {
	op := &request.Operation{
		Name:       opGetCell,
		HTTPMethod: "GET",
		HTTPPath:   "/cells/{cellName}",
	}

	if input == nil {
		input = &GetCellInput{}
	}

	output = &GetCellOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCell API operation for AWS Route53 Recovery Readiness.
//
// Gets information about a cell including cell name, cell Amazon Resource Name
// (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs
// with their associated recovery group ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetCell for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCell
func (c *Route53RecoveryReadiness) GetCell(input *GetCellInput) (*GetCellOutput, error) {
	req, out := c.GetCellRequest(input)
	return out, req.Send()
}

// GetCellWithContext is the same as GetCell with the addition of
// the ability to pass a context and additional request options.
//
// See GetCell for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetCellWithContext(ctx aws.Context, input *GetCellInput, opts ...request.Option) (*GetCellOutput, error) {
	req, out := c.GetCellRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCellReadinessSummary = "GetCellReadinessSummary"

// GetCellReadinessSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetCellReadinessSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCellReadinessSummary for more information on using the GetCellReadinessSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCellReadinessSummaryRequest method.
//    req, resp := client.GetCellReadinessSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary
func (c *Route53RecoveryReadiness) GetCellReadinessSummaryRequest(input *GetCellReadinessSummaryInput) (req *request.Request, output *GetCellReadinessSummaryOutput) {
	op := &request.Operation{
		Name:       opGetCellReadinessSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/cellreadiness/{cellName}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCellReadinessSummaryInput{}
	}

	output = &GetCellReadinessSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCellReadinessSummary API operation for AWS Route53 Recovery Readiness.
//
// Gets readiness for a cell. Aggregates the readiness of all the resources
// that are associated with the cell into a single value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetCellReadinessSummary for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary
func (c *Route53RecoveryReadiness) GetCellReadinessSummary(input *GetCellReadinessSummaryInput) (*GetCellReadinessSummaryOutput, error) {
	req, out := c.GetCellReadinessSummaryRequest(input)
	return out, req.Send()
}

// GetCellReadinessSummaryWithContext is the same as GetCellReadinessSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetCellReadinessSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetCellReadinessSummaryWithContext(ctx aws.Context, input *GetCellReadinessSummaryInput, opts ...request.Option) (*GetCellReadinessSummaryOutput, error) {
	req, out := c.GetCellReadinessSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCellReadinessSummaryPages iterates over the pages of a GetCellReadinessSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCellReadinessSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCellReadinessSummary operation.
//    pageNum := 0
//    err := client.GetCellReadinessSummaryPages(params,
//        func(page *route53recoveryreadiness.GetCellReadinessSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) GetCellReadinessSummaryPages(input *GetCellReadinessSummaryInput, fn func(*GetCellReadinessSummaryOutput, bool) bool) error {
	return c.GetCellReadinessSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCellReadinessSummaryPagesWithContext same as GetCellReadinessSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetCellReadinessSummaryPagesWithContext(ctx aws.Context, input *GetCellReadinessSummaryInput, fn func(*GetCellReadinessSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCellReadinessSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCellReadinessSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCellReadinessSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetReadinessCheck = "GetReadinessCheck"

// GetReadinessCheckRequest generates a "aws/request.Request" representing the
// client's request for the GetReadinessCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadinessCheck for more information on using the GetReadinessCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReadinessCheckRequest method.
//    req, resp := client.GetReadinessCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheck
func (c *Route53RecoveryReadiness) GetReadinessCheckRequest(input *GetReadinessCheckInput) (req *request.Request, output *GetReadinessCheckOutput) {
	op := &request.Operation{
		Name:       opGetReadinessCheck,
		HTTPMethod: "GET",
		HTTPPath:   "/readinesschecks/{readinessCheckName}",
	}

	if input == nil {
		input = &GetReadinessCheckInput{}
	}

	output = &GetReadinessCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReadinessCheck API operation for AWS Route53 Recovery Readiness.
//
// Gets details about a readiness check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetReadinessCheck for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheck
func (c *Route53RecoveryReadiness) GetReadinessCheck(input *GetReadinessCheckInput) (*GetReadinessCheckOutput, error) {
	req, out := c.GetReadinessCheckRequest(input)
	return out, req.Send()
}

// GetReadinessCheckWithContext is the same as GetReadinessCheck with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadinessCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetReadinessCheckWithContext(ctx aws.Context, input *GetReadinessCheckInput, opts ...request.Option) (*GetReadinessCheckOutput, error) {
	req, out := c.GetReadinessCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReadinessCheckResourceStatus = "GetReadinessCheckResourceStatus"

// GetReadinessCheckResourceStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetReadinessCheckResourceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadinessCheckResourceStatus for more information on using the GetReadinessCheckResourceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReadinessCheckResourceStatusRequest method.
//    req, resp := client.GetReadinessCheckResourceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus
func (c *Route53RecoveryReadiness) GetReadinessCheckResourceStatusRequest(input *GetReadinessCheckResourceStatusInput) (req *request.Request, output *GetReadinessCheckResourceStatusOutput) {
	op := &request.Operation{
		Name:       opGetReadinessCheckResourceStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/readinesschecks/{readinessCheckName}/resource/{resourceIdentifier}/status",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReadinessCheckResourceStatusInput{}
	}

	output = &GetReadinessCheckResourceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReadinessCheckResourceStatus API operation for AWS Route53 Recovery Readiness.
//
// Gets individual readiness status for a readiness check. To see the overall
// readiness status for a recovery group, that considers the readiness status
// for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetReadinessCheckResourceStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus
func (c *Route53RecoveryReadiness) GetReadinessCheckResourceStatus(input *GetReadinessCheckResourceStatusInput) (*GetReadinessCheckResourceStatusOutput, error) {
	req, out := c.GetReadinessCheckResourceStatusRequest(input)
	return out, req.Send()
}

// GetReadinessCheckResourceStatusWithContext is the same as GetReadinessCheckResourceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadinessCheckResourceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetReadinessCheckResourceStatusWithContext(ctx aws.Context, input *GetReadinessCheckResourceStatusInput, opts ...request.Option) (*GetReadinessCheckResourceStatusOutput, error) {
	req, out := c.GetReadinessCheckResourceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReadinessCheckResourceStatusPages iterates over the pages of a GetReadinessCheckResourceStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReadinessCheckResourceStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReadinessCheckResourceStatus operation.
//    pageNum := 0
//    err := client.GetReadinessCheckResourceStatusPages(params,
//        func(page *route53recoveryreadiness.GetReadinessCheckResourceStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) GetReadinessCheckResourceStatusPages(input *GetReadinessCheckResourceStatusInput, fn func(*GetReadinessCheckResourceStatusOutput, bool) bool) error {
	return c.GetReadinessCheckResourceStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReadinessCheckResourceStatusPagesWithContext same as GetReadinessCheckResourceStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetReadinessCheckResourceStatusPagesWithContext(ctx aws.Context, input *GetReadinessCheckResourceStatusInput, fn func(*GetReadinessCheckResourceStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetReadinessCheckResourceStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReadinessCheckResourceStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetReadinessCheckResourceStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetReadinessCheckStatus = "GetReadinessCheckStatus"

// GetReadinessCheckStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetReadinessCheckStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReadinessCheckStatus for more information on using the GetReadinessCheckStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReadinessCheckStatusRequest method.
//    req, resp := client.GetReadinessCheckStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus
func (c *Route53RecoveryReadiness) GetReadinessCheckStatusRequest(input *GetReadinessCheckStatusInput) (req *request.Request, output *GetReadinessCheckStatusOutput) {
	op := &request.Operation{
		Name:       opGetReadinessCheckStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/readinesschecks/{readinessCheckName}/status",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReadinessCheckStatusInput{}
	}

	output = &GetReadinessCheckStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReadinessCheckStatus API operation for AWS Route53 Recovery Readiness.
//
// Gets the readiness status for an individual readiness check. To see the overall
// readiness status for a recovery group, that considers the readiness status
// for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetReadinessCheckStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus
func (c *Route53RecoveryReadiness) GetReadinessCheckStatus(input *GetReadinessCheckStatusInput) (*GetReadinessCheckStatusOutput, error) {
	req, out := c.GetReadinessCheckStatusRequest(input)
	return out, req.Send()
}

// GetReadinessCheckStatusWithContext is the same as GetReadinessCheckStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetReadinessCheckStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetReadinessCheckStatusWithContext(ctx aws.Context, input *GetReadinessCheckStatusInput, opts ...request.Option) (*GetReadinessCheckStatusOutput, error) {
	req, out := c.GetReadinessCheckStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReadinessCheckStatusPages iterates over the pages of a GetReadinessCheckStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReadinessCheckStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReadinessCheckStatus operation.
//    pageNum := 0
//    err := client.GetReadinessCheckStatusPages(params,
//        func(page *route53recoveryreadiness.GetReadinessCheckStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) GetReadinessCheckStatusPages(input *GetReadinessCheckStatusInput, fn func(*GetReadinessCheckStatusOutput, bool) bool) error {
	return c.GetReadinessCheckStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReadinessCheckStatusPagesWithContext same as GetReadinessCheckStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetReadinessCheckStatusPagesWithContext(ctx aws.Context, input *GetReadinessCheckStatusInput, fn func(*GetReadinessCheckStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetReadinessCheckStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReadinessCheckStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetReadinessCheckStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetRecoveryGroup = "GetRecoveryGroup"

// GetRecoveryGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetRecoveryGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecoveryGroup for more information on using the GetRecoveryGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecoveryGroupRequest method.
//    req, resp := client.GetRecoveryGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroup
func (c *Route53RecoveryReadiness) GetRecoveryGroupRequest(input *GetRecoveryGroupInput) (req *request.Request, output *GetRecoveryGroupOutput) {
	op := &request.Operation{
		Name:       opGetRecoveryGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/recoverygroups/{recoveryGroupName}",
	}

	if input == nil {
		input = &GetRecoveryGroupInput{}
	}

	output = &GetRecoveryGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecoveryGroup API operation for AWS Route53 Recovery Readiness.
//
// Gets details about a recovery group, including a list of the cells that are
// included in it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetRecoveryGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroup
func (c *Route53RecoveryReadiness) GetRecoveryGroup(input *GetRecoveryGroupInput) (*GetRecoveryGroupOutput, error) {
	req, out := c.GetRecoveryGroupRequest(input)
	return out, req.Send()
}

// GetRecoveryGroupWithContext is the same as GetRecoveryGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecoveryGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetRecoveryGroupWithContext(ctx aws.Context, input *GetRecoveryGroupInput, opts ...request.Option) (*GetRecoveryGroupOutput, error) {
	req, out := c.GetRecoveryGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecoveryGroupReadinessSummary = "GetRecoveryGroupReadinessSummary"

// GetRecoveryGroupReadinessSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetRecoveryGroupReadinessSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecoveryGroupReadinessSummary for more information on using the GetRecoveryGroupReadinessSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecoveryGroupReadinessSummaryRequest method.
//    req, resp := client.GetRecoveryGroupReadinessSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary
func (c *Route53RecoveryReadiness) GetRecoveryGroupReadinessSummaryRequest(input *GetRecoveryGroupReadinessSummaryInput) (req *request.Request, output *GetRecoveryGroupReadinessSummaryOutput) {
	op := &request.Operation{
		Name:       opGetRecoveryGroupReadinessSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/recoverygroupreadiness/{recoveryGroupName}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRecoveryGroupReadinessSummaryInput{}
	}

	output = &GetRecoveryGroupReadinessSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecoveryGroupReadinessSummary API operation for AWS Route53 Recovery Readiness.
//
// Displays a summary of information about a recovery group's readiness status.
// Includes the readiness checks for resources in the recovery group and the
// readiness status of each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetRecoveryGroupReadinessSummary for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary
func (c *Route53RecoveryReadiness) GetRecoveryGroupReadinessSummary(input *GetRecoveryGroupReadinessSummaryInput) (*GetRecoveryGroupReadinessSummaryOutput, error) {
	req, out := c.GetRecoveryGroupReadinessSummaryRequest(input)
	return out, req.Send()
}

// GetRecoveryGroupReadinessSummaryWithContext is the same as GetRecoveryGroupReadinessSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecoveryGroupReadinessSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetRecoveryGroupReadinessSummaryWithContext(ctx aws.Context, input *GetRecoveryGroupReadinessSummaryInput, opts ...request.Option) (*GetRecoveryGroupReadinessSummaryOutput, error) {
	req, out := c.GetRecoveryGroupReadinessSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetRecoveryGroupReadinessSummaryPages iterates over the pages of a GetRecoveryGroupReadinessSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetRecoveryGroupReadinessSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetRecoveryGroupReadinessSummary operation.
//    pageNum := 0
//    err := client.GetRecoveryGroupReadinessSummaryPages(params,
//        func(page *route53recoveryreadiness.GetRecoveryGroupReadinessSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) GetRecoveryGroupReadinessSummaryPages(input *GetRecoveryGroupReadinessSummaryInput, fn func(*GetRecoveryGroupReadinessSummaryOutput, bool) bool) error {
	return c.GetRecoveryGroupReadinessSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetRecoveryGroupReadinessSummaryPagesWithContext same as GetRecoveryGroupReadinessSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetRecoveryGroupReadinessSummaryPagesWithContext(ctx aws.Context, input *GetRecoveryGroupReadinessSummaryInput, fn func(*GetRecoveryGroupReadinessSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetRecoveryGroupReadinessSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRecoveryGroupReadinessSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetRecoveryGroupReadinessSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceSet = "GetResourceSet"

// GetResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceSet for more information on using the GetResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceSetRequest method.
//    req, resp := client.GetResourceSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetResourceSet
func (c *Route53RecoveryReadiness) GetResourceSetRequest(input *GetResourceSetInput) (req *request.Request, output *GetResourceSetOutput) {
	op := &request.Operation{
		Name:       opGetResourceSet,
		HTTPMethod: "GET",
		HTTPPath:   "/resourcesets/{resourceSetName}",
	}

	if input == nil {
		input = &GetResourceSetInput{}
	}

	output = &GetResourceSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceSet API operation for AWS Route53 Recovery Readiness.
//
// Displays the details about a resource set, including a list of the resources
// in the set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation GetResourceSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetResourceSet
func (c *Route53RecoveryReadiness) GetResourceSet(input *GetResourceSetInput) (*GetResourceSetOutput, error) {
	req, out := c.GetResourceSetRequest(input)
	return out, req.Send()
}

// GetResourceSetWithContext is the same as GetResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) GetResourceSetWithContext(ctx aws.Context, input *GetResourceSetInput, opts ...request.Option) (*GetResourceSetOutput, error) {
	req, out := c.GetResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCells = "ListCells"

// ListCellsRequest generates a "aws/request.Request" representing the
// client's request for the ListCells operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCells for more information on using the ListCells
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCellsRequest method.
//    req, resp := client.ListCellsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells
func (c *Route53RecoveryReadiness) ListCellsRequest(input *ListCellsInput) (req *request.Request, output *ListCellsOutput) {
	op := &request.Operation{
		Name:       opListCells,
		HTTPMethod: "GET",
		HTTPPath:   "/cells",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCellsInput{}
	}

	output = &ListCellsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCells API operation for AWS Route53 Recovery Readiness.
//
// Lists the cells for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListCells for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells
func (c *Route53RecoveryReadiness) ListCells(input *ListCellsInput) (*ListCellsOutput, error) {
	req, out := c.ListCellsRequest(input)
	return out, req.Send()
}

// ListCellsWithContext is the same as ListCells with the addition of
// the ability to pass a context and additional request options.
//
// See ListCells for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListCellsWithContext(ctx aws.Context, input *ListCellsInput, opts ...request.Option) (*ListCellsOutput, error) {
	req, out := c.ListCellsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCellsPages iterates over the pages of a ListCells operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCells method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCells operation.
//    pageNum := 0
//    err := client.ListCellsPages(params,
//        func(page *route53recoveryreadiness.ListCellsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListCellsPages(input *ListCellsInput, fn func(*ListCellsOutput, bool) bool) error {
	return c.ListCellsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCellsPagesWithContext same as ListCellsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListCellsPagesWithContext(ctx aws.Context, input *ListCellsInput, fn func(*ListCellsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCellsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCellsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCellsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCrossAccountAuthorizations = "ListCrossAccountAuthorizations"

// ListCrossAccountAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCrossAccountAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrossAccountAuthorizations for more information on using the ListCrossAccountAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCrossAccountAuthorizationsRequest method.
//    req, resp := client.ListCrossAccountAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations
func (c *Route53RecoveryReadiness) ListCrossAccountAuthorizationsRequest(input *ListCrossAccountAuthorizationsInput) (req *request.Request, output *ListCrossAccountAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opListCrossAccountAuthorizations,
		HTTPMethod: "GET",
		HTTPPath:   "/crossaccountauthorizations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCrossAccountAuthorizationsInput{}
	}

	output = &ListCrossAccountAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrossAccountAuthorizations API operation for AWS Route53 Recovery Readiness.
//
// Lists the cross-account readiness authorizations that are in place for an
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListCrossAccountAuthorizations for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations
func (c *Route53RecoveryReadiness) ListCrossAccountAuthorizations(input *ListCrossAccountAuthorizationsInput) (*ListCrossAccountAuthorizationsOutput, error) {
	req, out := c.ListCrossAccountAuthorizationsRequest(input)
	return out, req.Send()
}

// ListCrossAccountAuthorizationsWithContext is the same as ListCrossAccountAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrossAccountAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListCrossAccountAuthorizationsWithContext(ctx aws.Context, input *ListCrossAccountAuthorizationsInput, opts ...request.Option) (*ListCrossAccountAuthorizationsOutput, error) {
	req, out := c.ListCrossAccountAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCrossAccountAuthorizationsPages iterates over the pages of a ListCrossAccountAuthorizations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCrossAccountAuthorizations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCrossAccountAuthorizations operation.
//    pageNum := 0
//    err := client.ListCrossAccountAuthorizationsPages(params,
//        func(page *route53recoveryreadiness.ListCrossAccountAuthorizationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListCrossAccountAuthorizationsPages(input *ListCrossAccountAuthorizationsInput, fn func(*ListCrossAccountAuthorizationsOutput, bool) bool) error {
	return c.ListCrossAccountAuthorizationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCrossAccountAuthorizationsPagesWithContext same as ListCrossAccountAuthorizationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListCrossAccountAuthorizationsPagesWithContext(ctx aws.Context, input *ListCrossAccountAuthorizationsInput, fn func(*ListCrossAccountAuthorizationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCrossAccountAuthorizationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCrossAccountAuthorizationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCrossAccountAuthorizationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReadinessChecks = "ListReadinessChecks"

// ListReadinessChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListReadinessChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReadinessChecks for more information on using the ListReadinessChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReadinessChecksRequest method.
//    req, resp := client.ListReadinessChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks
func (c *Route53RecoveryReadiness) ListReadinessChecksRequest(input *ListReadinessChecksInput) (req *request.Request, output *ListReadinessChecksOutput) {
	op := &request.Operation{
		Name:       opListReadinessChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/readinesschecks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReadinessChecksInput{}
	}

	output = &ListReadinessChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReadinessChecks API operation for AWS Route53 Recovery Readiness.
//
// Lists the readiness checks for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListReadinessChecks for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks
func (c *Route53RecoveryReadiness) ListReadinessChecks(input *ListReadinessChecksInput) (*ListReadinessChecksOutput, error) {
	req, out := c.ListReadinessChecksRequest(input)
	return out, req.Send()
}

// ListReadinessChecksWithContext is the same as ListReadinessChecks with the addition of
// the ability to pass a context and additional request options.
//
// See ListReadinessChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListReadinessChecksWithContext(ctx aws.Context, input *ListReadinessChecksInput, opts ...request.Option) (*ListReadinessChecksOutput, error) {
	req, out := c.ListReadinessChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReadinessChecksPages iterates over the pages of a ListReadinessChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReadinessChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListReadinessChecks operation.
//    pageNum := 0
//    err := client.ListReadinessChecksPages(params,
//        func(page *route53recoveryreadiness.ListReadinessChecksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListReadinessChecksPages(input *ListReadinessChecksInput, fn func(*ListReadinessChecksOutput, bool) bool) error {
	return c.ListReadinessChecksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReadinessChecksPagesWithContext same as ListReadinessChecksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListReadinessChecksPagesWithContext(ctx aws.Context, input *ListReadinessChecksInput, fn func(*ListReadinessChecksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReadinessChecksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReadinessChecksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReadinessChecksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecoveryGroups = "ListRecoveryGroups"

// ListRecoveryGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecoveryGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecoveryGroups for more information on using the ListRecoveryGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecoveryGroupsRequest method.
//    req, resp := client.ListRecoveryGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups
func (c *Route53RecoveryReadiness) ListRecoveryGroupsRequest(input *ListRecoveryGroupsInput) (req *request.Request, output *ListRecoveryGroupsOutput) {
	op := &request.Operation{
		Name:       opListRecoveryGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/recoverygroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryGroupsInput{}
	}

	output = &ListRecoveryGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecoveryGroups API operation for AWS Route53 Recovery Readiness.
//
// Lists the recovery groups in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListRecoveryGroups for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups
func (c *Route53RecoveryReadiness) ListRecoveryGroups(input *ListRecoveryGroupsInput) (*ListRecoveryGroupsOutput, error) {
	req, out := c.ListRecoveryGroupsRequest(input)
	return out, req.Send()
}

// ListRecoveryGroupsWithContext is the same as ListRecoveryGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecoveryGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListRecoveryGroupsWithContext(ctx aws.Context, input *ListRecoveryGroupsInput, opts ...request.Option) (*ListRecoveryGroupsOutput, error) {
	req, out := c.ListRecoveryGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecoveryGroupsPages iterates over the pages of a ListRecoveryGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecoveryGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecoveryGroups operation.
//    pageNum := 0
//    err := client.ListRecoveryGroupsPages(params,
//        func(page *route53recoveryreadiness.ListRecoveryGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListRecoveryGroupsPages(input *ListRecoveryGroupsInput, fn func(*ListRecoveryGroupsOutput, bool) bool) error {
	return c.ListRecoveryGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecoveryGroupsPagesWithContext same as ListRecoveryGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListRecoveryGroupsPagesWithContext(ctx aws.Context, input *ListRecoveryGroupsInput, fn func(*ListRecoveryGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecoveryGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecoveryGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecoveryGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceSets = "ListResourceSets"

// ListResourceSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceSets for more information on using the ListResourceSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceSetsRequest method.
//    req, resp := client.ListResourceSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets
func (c *Route53RecoveryReadiness) ListResourceSetsRequest(input *ListResourceSetsInput) (req *request.Request, output *ListResourceSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceSets,
		HTTPMethod: "GET",
		HTTPPath:   "/resourcesets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceSetsInput{}
	}

	output = &ListResourceSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceSets API operation for AWS Route53 Recovery Readiness.
//
// Lists the resource sets in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListResourceSets for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets
func (c *Route53RecoveryReadiness) ListResourceSets(input *ListResourceSetsInput) (*ListResourceSetsOutput, error) {
	req, out := c.ListResourceSetsRequest(input)
	return out, req.Send()
}

// ListResourceSetsWithContext is the same as ListResourceSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListResourceSetsWithContext(ctx aws.Context, input *ListResourceSetsInput, opts ...request.Option) (*ListResourceSetsOutput, error) {
	req, out := c.ListResourceSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceSetsPages iterates over the pages of a ListResourceSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceSets operation.
//    pageNum := 0
//    err := client.ListResourceSetsPages(params,
//        func(page *route53recoveryreadiness.ListResourceSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListResourceSetsPages(input *ListResourceSetsInput, fn func(*ListResourceSetsOutput, bool) bool) error {
	return c.ListResourceSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceSetsPagesWithContext same as ListResourceSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListResourceSetsPagesWithContext(ctx aws.Context, input *ListResourceSetsInput, fn func(*ListResourceSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules
func (c *Route53RecoveryReadiness) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for AWS Route53 Recovery Readiness.
//
// Lists all readiness rules, or lists the readiness rules for a specific resource
// type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules
func (c *Route53RecoveryReadiness) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesPages iterates over the pages of a ListRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRules operation.
//    pageNum := 0
//    err := client.ListRulesPages(params,
//        func(page *route53recoveryreadiness.ListRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryReadiness) ListRulesPages(input *ListRulesInput, fn func(*ListRulesOutput, bool) bool) error {
	return c.ListRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesPagesWithContext same as ListRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListRulesPagesWithContext(ctx aws.Context, input *ListRulesInput, fn func(*ListRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResources = "ListTagsForResources"

// ListTagsForResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResources for more information on using the ListTagsForResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourcesRequest method.
//    req, resp := client.ListTagsForResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListTagsForResources
func (c *Route53RecoveryReadiness) ListTagsForResourcesRequest(input *ListTagsForResourcesInput) (req *request.Request, output *ListTagsForResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagsForResources,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourcesInput{}
	}

	output = &ListTagsForResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResources API operation for AWS Route53 Recovery Readiness.
//
// Lists the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation ListTagsForResources for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListTagsForResources
func (c *Route53RecoveryReadiness) ListTagsForResources(input *ListTagsForResourcesInput) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	return out, req.Send()
}

// ListTagsForResourcesWithContext is the same as ListTagsForResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) ListTagsForResourcesWithContext(ctx aws.Context, input *ListTagsForResourcesInput, opts ...request.Option) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/TagResource
func (c *Route53RecoveryReadiness) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Route53 Recovery Readiness.
//
// Adds a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/TagResource
func (c *Route53RecoveryReadiness) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UntagResource
func (c *Route53RecoveryReadiness) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Route53 Recovery Readiness.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UntagResource
func (c *Route53RecoveryReadiness) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCell = "UpdateCell"

// UpdateCellRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCell operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCell for more information on using the UpdateCell
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCellRequest method.
//    req, resp := client.UpdateCellRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateCell
func (c *Route53RecoveryReadiness) UpdateCellRequest(input *UpdateCellInput) (req *request.Request, output *UpdateCellOutput) {
	op := &request.Operation{
		Name:       opUpdateCell,
		HTTPMethod: "PUT",
		HTTPPath:   "/cells/{cellName}",
	}

	if input == nil {
		input = &UpdateCellInput{}
	}

	output = &UpdateCellOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCell API operation for AWS Route53 Recovery Readiness.
//
// Updates a cell to replace the list of nested cells with a new list of nested
// cells.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation UpdateCell for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateCell
func (c *Route53RecoveryReadiness) UpdateCell(input *UpdateCellInput) (*UpdateCellOutput, error) {
	req, out := c.UpdateCellRequest(input)
	return out, req.Send()
}

// UpdateCellWithContext is the same as UpdateCell with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCell for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) UpdateCellWithContext(ctx aws.Context, input *UpdateCellInput, opts ...request.Option) (*UpdateCellOutput, error) {
	req, out := c.UpdateCellRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReadinessCheck = "UpdateReadinessCheck"

// UpdateReadinessCheckRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReadinessCheck operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReadinessCheck for more information on using the UpdateReadinessCheck
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReadinessCheckRequest method.
//    req, resp := client.UpdateReadinessCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateReadinessCheck
func (c *Route53RecoveryReadiness) UpdateReadinessCheckRequest(input *UpdateReadinessCheckInput) (req *request.Request, output *UpdateReadinessCheckOutput) {
	op := &request.Operation{
		Name:       opUpdateReadinessCheck,
		HTTPMethod: "PUT",
		HTTPPath:   "/readinesschecks/{readinessCheckName}",
	}

	if input == nil {
		input = &UpdateReadinessCheckInput{}
	}

	output = &UpdateReadinessCheckOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReadinessCheck API operation for AWS Route53 Recovery Readiness.
//
// Updates a readiness check.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation UpdateReadinessCheck for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateReadinessCheck
func (c *Route53RecoveryReadiness) UpdateReadinessCheck(input *UpdateReadinessCheckInput) (*UpdateReadinessCheckOutput, error) {
	req, out := c.UpdateReadinessCheckRequest(input)
	return out, req.Send()
}

// UpdateReadinessCheckWithContext is the same as UpdateReadinessCheck with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReadinessCheck for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) UpdateReadinessCheckWithContext(ctx aws.Context, input *UpdateReadinessCheckInput, opts ...request.Option) (*UpdateReadinessCheckOutput, error) {
	req, out := c.UpdateReadinessCheckRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecoveryGroup = "UpdateRecoveryGroup"

// UpdateRecoveryGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecoveryGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecoveryGroup for more information on using the UpdateRecoveryGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRecoveryGroupRequest method.
//    req, resp := client.UpdateRecoveryGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateRecoveryGroup
func (c *Route53RecoveryReadiness) UpdateRecoveryGroupRequest(input *UpdateRecoveryGroupInput) (req *request.Request, output *UpdateRecoveryGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRecoveryGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/recoverygroups/{recoveryGroupName}",
	}

	if input == nil {
		input = &UpdateRecoveryGroupInput{}
	}

	output = &UpdateRecoveryGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecoveryGroup API operation for AWS Route53 Recovery Readiness.
//
// Updates a recovery group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation UpdateRecoveryGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateRecoveryGroup
func (c *Route53RecoveryReadiness) UpdateRecoveryGroup(input *UpdateRecoveryGroupInput) (*UpdateRecoveryGroupOutput, error) {
	req, out := c.UpdateRecoveryGroupRequest(input)
	return out, req.Send()
}

// UpdateRecoveryGroupWithContext is the same as UpdateRecoveryGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecoveryGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) UpdateRecoveryGroupWithContext(ctx aws.Context, input *UpdateRecoveryGroupInput, opts ...request.Option) (*UpdateRecoveryGroupOutput, error) {
	req, out := c.UpdateRecoveryGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceSet = "UpdateResourceSet"

// UpdateResourceSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceSet for more information on using the UpdateResourceSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceSetRequest method.
//    req, resp := client.UpdateResourceSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateResourceSet
func (c *Route53RecoveryReadiness) UpdateResourceSetRequest(input *UpdateResourceSetInput) (req *request.Request, output *UpdateResourceSetOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/resourcesets/{resourceSetName}",
	}

	if input == nil {
		input = &UpdateResourceSetInput{}
	}

	output = &UpdateResourceSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceSet API operation for AWS Route53 Recovery Readiness.
//
// Updates a resource set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Readiness's
// API operation UpdateResourceSet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateResourceSet
func (c *Route53RecoveryReadiness) UpdateResourceSet(input *UpdateResourceSetInput) (*UpdateResourceSetOutput, error) {
	req, out := c.UpdateResourceSetRequest(input)
	return out, req.Send()
}

// UpdateResourceSetWithContext is the same as UpdateResourceSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryReadiness) UpdateResourceSetWithContext(ctx aws.Context, input *UpdateResourceSetInput, opts ...request.Option) (*UpdateResourceSetOutput, error) {
	req, out := c.UpdateResourceSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a cell.
type CellOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the cell.
	//
	// CellArn is a required field
	CellArn *string `locationName:"cellArn" type:"string" required:"true"`

	// The name of the cell.
	//
	// CellName is a required field
	CellName *string `locationName:"cellName" type:"string" required:"true"`

	// A list of cell ARNs.
	//
	// Cells is a required field
	Cells []*string `locationName:"cells" type:"list" required:"true"`

	// The readiness scope for the cell, which can be a cell Amazon Resource Name
	// (ARN) or a recovery group ARN. This is a list but currently can have only
	// one element.
	//
	// ParentReadinessScopes is a required field
	ParentReadinessScopes []*string `locationName:"parentReadinessScopes" type:"list" required:"true"`

	// Tags on the resources.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CellOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CellOutput_) GoString() string {
	return s.String()
}

// SetCellArn sets the CellArn field's value.
func (s *CellOutput_) SetCellArn(v string) *CellOutput_ {
	s.CellArn = &v
	return s
}

// SetCellName sets the CellName field's value.
func (s *CellOutput_) SetCellName(v string) *CellOutput_ {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *CellOutput_) SetCells(v []*string) *CellOutput_ {
	s.Cells = v
	return s
}

// SetParentReadinessScopes sets the ParentReadinessScopes field's value.
func (s *CellOutput_) SetParentReadinessScopes(v []*string) *CellOutput_ {
	s.ParentReadinessScopes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CellOutput_) SetTags(v map[string]*string) *CellOutput_ {
	s.Tags = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCellInput struct {
	_ struct{} `type:"structure"`

	// CellName is a required field
	CellName *string `locationName:"cellName" type:"string" required:"true"`

	Cells []*string `locationName:"cells" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCellInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCellInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCellInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCellInput"}
	if s.CellName == nil {
		invalidParams.Add(request.NewErrParamRequired("CellName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellName sets the CellName field's value.
func (s *CreateCellInput) SetCellName(v string) *CreateCellInput {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *CreateCellInput) SetCells(v []*string) *CreateCellInput {
	s.Cells = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCellInput) SetTags(v map[string]*string) *CreateCellInput {
	s.Tags = v
	return s
}

type CreateCellOutput struct {
	_ struct{} `type:"structure"`

	CellArn *string `locationName:"cellArn" type:"string"`

	CellName *string `locationName:"cellName" type:"string"`

	Cells []*string `locationName:"cells" type:"list"`

	ParentReadinessScopes []*string `locationName:"parentReadinessScopes" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCellOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCellOutput) GoString() string {
	return s.String()
}

// SetCellArn sets the CellArn field's value.
func (s *CreateCellOutput) SetCellArn(v string) *CreateCellOutput {
	s.CellArn = &v
	return s
}

// SetCellName sets the CellName field's value.
func (s *CreateCellOutput) SetCellName(v string) *CreateCellOutput {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *CreateCellOutput) SetCells(v []*string) *CreateCellOutput {
	s.Cells = v
	return s
}

// SetParentReadinessScopes sets the ParentReadinessScopes field's value.
func (s *CreateCellOutput) SetParentReadinessScopes(v []*string) *CreateCellOutput {
	s.ParentReadinessScopes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCellOutput) SetTags(v map[string]*string) *CreateCellOutput {
	s.Tags = v
	return s
}

type CreateCrossAccountAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// CrossAccountAuthorization
	//
	// CrossAccountAuthorization is a required field
	CrossAccountAuthorization *string `locationName:"crossAccountAuthorization" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCrossAccountAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCrossAccountAuthorizationInput"}
	if s.CrossAccountAuthorization == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossAccountAuthorization"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossAccountAuthorization sets the CrossAccountAuthorization field's value.
func (s *CreateCrossAccountAuthorizationInput) SetCrossAccountAuthorization(v string) *CreateCrossAccountAuthorizationInput {
	s.CrossAccountAuthorization = &v
	return s
}

type CreateCrossAccountAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// CrossAccountAuthorization
	CrossAccountAuthorization *string `locationName:"crossAccountAuthorization" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrossAccountAuthorizationOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAuthorization sets the CrossAccountAuthorization field's value.
func (s *CreateCrossAccountAuthorizationOutput) SetCrossAccountAuthorization(v string) *CreateCrossAccountAuthorizationOutput {
	s.CrossAccountAuthorization = &v
	return s
}

type CreateReadinessCheckInput struct {
	_ struct{} `type:"structure"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string" required:"true"`

	// ResourceSetName is a required field
	ResourceSetName *string `locationName:"resourceSetName" type:"string" required:"true"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReadinessCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReadinessCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReadinessCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReadinessCheckInput"}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *CreateReadinessCheckInput) SetReadinessCheckName(v string) *CreateReadinessCheckInput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *CreateReadinessCheckInput) SetResourceSetName(v string) *CreateReadinessCheckInput {
	s.ResourceSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReadinessCheckInput) SetTags(v map[string]*string) *CreateReadinessCheckInput {
	s.Tags = v
	return s
}

type CreateReadinessCheckOutput struct {
	_ struct{} `type:"structure"`

	ReadinessCheckArn *string `locationName:"readinessCheckArn" type:"string"`

	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string"`

	ResourceSet *string `locationName:"resourceSet" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReadinessCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReadinessCheckOutput) GoString() string {
	return s.String()
}

// SetReadinessCheckArn sets the ReadinessCheckArn field's value.
func (s *CreateReadinessCheckOutput) SetReadinessCheckArn(v string) *CreateReadinessCheckOutput {
	s.ReadinessCheckArn = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *CreateReadinessCheckOutput) SetReadinessCheckName(v string) *CreateReadinessCheckOutput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSet sets the ResourceSet field's value.
func (s *CreateReadinessCheckOutput) SetResourceSet(v string) *CreateReadinessCheckOutput {
	s.ResourceSet = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReadinessCheckOutput) SetTags(v map[string]*string) *CreateReadinessCheckOutput {
	s.Tags = v
	return s
}

type CreateRecoveryGroupInput struct {
	_ struct{} `type:"structure"`

	Cells []*string `locationName:"cells" type:"list"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `locationName:"recoveryGroupName" type:"string" required:"true"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecoveryGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecoveryGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecoveryGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecoveryGroupInput"}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCells sets the Cells field's value.
func (s *CreateRecoveryGroupInput) SetCells(v []*string) *CreateRecoveryGroupInput {
	s.Cells = v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *CreateRecoveryGroupInput) SetRecoveryGroupName(v string) *CreateRecoveryGroupInput {
	s.RecoveryGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecoveryGroupInput) SetTags(v map[string]*string) *CreateRecoveryGroupInput {
	s.Tags = v
	return s
}

type CreateRecoveryGroupOutput struct {
	_ struct{} `type:"structure"`

	Cells []*string `locationName:"cells" type:"list"`

	RecoveryGroupArn *string `locationName:"recoveryGroupArn" type:"string"`

	RecoveryGroupName *string `locationName:"recoveryGroupName" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecoveryGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecoveryGroupOutput) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *CreateRecoveryGroupOutput) SetCells(v []*string) *CreateRecoveryGroupOutput {
	s.Cells = v
	return s
}

// SetRecoveryGroupArn sets the RecoveryGroupArn field's value.
func (s *CreateRecoveryGroupOutput) SetRecoveryGroupArn(v string) *CreateRecoveryGroupOutput {
	s.RecoveryGroupArn = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *CreateRecoveryGroupOutput) SetRecoveryGroupName(v string) *CreateRecoveryGroupOutput {
	s.RecoveryGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecoveryGroupOutput) SetTags(v map[string]*string) *CreateRecoveryGroupOutput {
	s.Tags = v
	return s
}

type CreateResourceSetInput struct {
	_ struct{} `type:"structure"`

	// ResourceSetName is a required field
	ResourceSetName *string `locationName:"resourceSetName" type:"string" required:"true"`

	// ResourceSetType is a required field
	ResourceSetType *string `locationName:"resourceSetType" type:"string" required:"true"`

	// Resources is a required field
	Resources []*Resource `locationName:"resources" type:"list" required:"true"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceSetInput"}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}
	if s.ResourceSetType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetType"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *CreateResourceSetInput) SetResourceSetName(v string) *CreateResourceSetInput {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *CreateResourceSetInput) SetResourceSetType(v string) *CreateResourceSetInput {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateResourceSetInput) SetResources(v []*Resource) *CreateResourceSetInput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResourceSetInput) SetTags(v map[string]*string) *CreateResourceSetInput {
	s.Tags = v
	return s
}

type CreateResourceSetOutput struct {
	_ struct{} `type:"structure"`

	ResourceSetArn *string `locationName:"resourceSetArn" type:"string"`

	ResourceSetName *string `locationName:"resourceSetName" type:"string"`

	ResourceSetType *string `locationName:"resourceSetType" type:"string"`

	Resources []*Resource `locationName:"resources" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceSetOutput) GoString() string {
	return s.String()
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *CreateResourceSetOutput) SetResourceSetArn(v string) *CreateResourceSetOutput {
	s.ResourceSetArn = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *CreateResourceSetOutput) SetResourceSetName(v string) *CreateResourceSetOutput {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *CreateResourceSetOutput) SetResourceSetType(v string) *CreateResourceSetOutput {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateResourceSetOutput) SetResources(v []*Resource) *CreateResourceSetOutput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResourceSetOutput) SetTags(v map[string]*string) *CreateResourceSetOutput {
	s.Tags = v
	return s
}

// A component for DNS/routing control readiness checks and architecture checks.
type DNSTargetResource struct {
	_ struct{} `type:"structure"`

	// The domain name that acts as an ingress point to a portion of the customer
	// application.
	DomainName *string `locationName:"domainName" type:"string"`

	// The hosted zone Amazon Resource Name (ARN) that contains the DNS record with
	// the provided name of the target resource.
	HostedZoneArn *string `locationName:"hostedZoneArn" type:"string"`

	// The Route 53 record set ID that uniquely identifies a DNS record, given a
	// name and a type.
	RecordSetId *string `locationName:"recordSetId" type:"string"`

	// The type of DNS record of the target resource.
	RecordType *string `locationName:"recordType" type:"string"`

	// The target resource of the DNS target resource.
	TargetResource *TargetResource `locationName:"targetResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DNSTargetResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DNSTargetResource) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DNSTargetResource) SetDomainName(v string) *DNSTargetResource {
	s.DomainName = &v
	return s
}

// SetHostedZoneArn sets the HostedZoneArn field's value.
func (s *DNSTargetResource) SetHostedZoneArn(v string) *DNSTargetResource {
	s.HostedZoneArn = &v
	return s
}

// SetRecordSetId sets the RecordSetId field's value.
func (s *DNSTargetResource) SetRecordSetId(v string) *DNSTargetResource {
	s.RecordSetId = &v
	return s
}

// SetRecordType sets the RecordType field's value.
func (s *DNSTargetResource) SetRecordType(v string) *DNSTargetResource {
	s.RecordType = &v
	return s
}

// SetTargetResource sets the TargetResource field's value.
func (s *DNSTargetResource) SetTargetResource(v *TargetResource) *DNSTargetResource {
	s.TargetResource = v
	return s
}

type DeleteCellInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// CellName is a required field
	CellName *string `location:"uri" locationName:"cellName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCellInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCellInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCellInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCellInput"}
	if s.CellName == nil {
		invalidParams.Add(request.NewErrParamRequired("CellName"))
	}
	if s.CellName != nil && len(*s.CellName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellName sets the CellName field's value.
func (s *DeleteCellInput) SetCellName(v string) *DeleteCellInput {
	s.CellName = &v
	return s
}

type DeleteCellOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCellOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCellOutput) GoString() string {
	return s.String()
}

type DeleteCrossAccountAuthorizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// CrossAccountAuthorization is a required field
	CrossAccountAuthorization *string `location:"uri" locationName:"crossAccountAuthorization" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCrossAccountAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCrossAccountAuthorizationInput"}
	if s.CrossAccountAuthorization == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossAccountAuthorization"))
	}
	if s.CrossAccountAuthorization != nil && len(*s.CrossAccountAuthorization) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrossAccountAuthorization", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossAccountAuthorization sets the CrossAccountAuthorization field's value.
func (s *DeleteCrossAccountAuthorizationInput) SetCrossAccountAuthorization(v string) *DeleteCrossAccountAuthorizationInput {
	s.CrossAccountAuthorization = &v
	return s
}

type DeleteCrossAccountAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrossAccountAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteReadinessCheckInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `location:"uri" locationName:"readinessCheckName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReadinessCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReadinessCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReadinessCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReadinessCheckInput"}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ReadinessCheckName != nil && len(*s.ReadinessCheckName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReadinessCheckName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *DeleteReadinessCheckInput) SetReadinessCheckName(v string) *DeleteReadinessCheckInput {
	s.ReadinessCheckName = &v
	return s
}

type DeleteReadinessCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReadinessCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReadinessCheckOutput) GoString() string {
	return s.String()
}

type DeleteRecoveryGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `location:"uri" locationName:"recoveryGroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecoveryGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecoveryGroupInput"}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}
	if s.RecoveryGroupName != nil && len(*s.RecoveryGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *DeleteRecoveryGroupInput) SetRecoveryGroupName(v string) *DeleteRecoveryGroupInput {
	s.RecoveryGroupName = &v
	return s
}

type DeleteRecoveryGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryGroupOutput) GoString() string {
	return s.String()
}

type DeleteResourceSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceSetName is a required field
	ResourceSetName *string `location:"uri" locationName:"resourceSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceSetInput"}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}
	if s.ResourceSetName != nil && len(*s.ResourceSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *DeleteResourceSetInput) SetResourceSetName(v string) *DeleteResourceSetInput {
	s.ResourceSetName = &v
	return s
}

type DeleteResourceSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceSetOutput) GoString() string {
	return s.String()
}

type GetArchitectureRecommendationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `location:"uri" locationName:"recoveryGroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchitectureRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchitectureRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchitectureRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchitectureRecommendationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}
	if s.RecoveryGroupName != nil && len(*s.RecoveryGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetArchitectureRecommendationsInput) SetMaxResults(v int64) *GetArchitectureRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetArchitectureRecommendationsInput) SetNextToken(v string) *GetArchitectureRecommendationsInput {
	s.NextToken = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *GetArchitectureRecommendationsInput) SetRecoveryGroupName(v string) *GetArchitectureRecommendationsInput {
	s.RecoveryGroupName = &v
	return s
}

type GetArchitectureRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The time that a recovery group was last assessed for recommendations, in
	// UTC ISO-8601 format.
	LastAuditTimestamp *time.Time `locationName:"lastAuditTimestamp" type:"timestamp" timestampFormat:"iso8601"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Recommendations []*Recommendation `locationName:"recommendations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchitectureRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchitectureRecommendationsOutput) GoString() string {
	return s.String()
}

// SetLastAuditTimestamp sets the LastAuditTimestamp field's value.
func (s *GetArchitectureRecommendationsOutput) SetLastAuditTimestamp(v time.Time) *GetArchitectureRecommendationsOutput {
	s.LastAuditTimestamp = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetArchitectureRecommendationsOutput) SetNextToken(v string) *GetArchitectureRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *GetArchitectureRecommendationsOutput) SetRecommendations(v []*Recommendation) *GetArchitectureRecommendationsOutput {
	s.Recommendations = v
	return s
}

type GetCellInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// CellName is a required field
	CellName *string `location:"uri" locationName:"cellName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCellInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCellInput"}
	if s.CellName == nil {
		invalidParams.Add(request.NewErrParamRequired("CellName"))
	}
	if s.CellName != nil && len(*s.CellName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellName sets the CellName field's value.
func (s *GetCellInput) SetCellName(v string) *GetCellInput {
	s.CellName = &v
	return s
}

type GetCellOutput struct {
	_ struct{} `type:"structure"`

	CellArn *string `locationName:"cellArn" type:"string"`

	CellName *string `locationName:"cellName" type:"string"`

	Cells []*string `locationName:"cells" type:"list"`

	ParentReadinessScopes []*string `locationName:"parentReadinessScopes" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellOutput) GoString() string {
	return s.String()
}

// SetCellArn sets the CellArn field's value.
func (s *GetCellOutput) SetCellArn(v string) *GetCellOutput {
	s.CellArn = &v
	return s
}

// SetCellName sets the CellName field's value.
func (s *GetCellOutput) SetCellName(v string) *GetCellOutput {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *GetCellOutput) SetCells(v []*string) *GetCellOutput {
	s.Cells = v
	return s
}

// SetParentReadinessScopes sets the ParentReadinessScopes field's value.
func (s *GetCellOutput) SetParentReadinessScopes(v []*string) *GetCellOutput {
	s.ParentReadinessScopes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCellOutput) SetTags(v map[string]*string) *GetCellOutput {
	s.Tags = v
	return s
}

type GetCellReadinessSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// CellName is a required field
	CellName *string `location:"uri" locationName:"cellName" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellReadinessSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellReadinessSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCellReadinessSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCellReadinessSummaryInput"}
	if s.CellName == nil {
		invalidParams.Add(request.NewErrParamRequired("CellName"))
	}
	if s.CellName != nil && len(*s.CellName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellName sets the CellName field's value.
func (s *GetCellReadinessSummaryInput) SetCellName(v string) *GetCellReadinessSummaryInput {
	s.CellName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCellReadinessSummaryInput) SetMaxResults(v int64) *GetCellReadinessSummaryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCellReadinessSummaryInput) SetNextToken(v string) *GetCellReadinessSummaryInput {
	s.NextToken = &v
	return s
}

type GetCellReadinessSummaryOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// The readiness status.
	Readiness *string `locationName:"readiness" type:"string" enum:"Readiness"`

	ReadinessChecks []*ReadinessCheckSummary `locationName:"readinessChecks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellReadinessSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCellReadinessSummaryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetCellReadinessSummaryOutput) SetNextToken(v string) *GetCellReadinessSummaryOutput {
	s.NextToken = &v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *GetCellReadinessSummaryOutput) SetReadiness(v string) *GetCellReadinessSummaryOutput {
	s.Readiness = &v
	return s
}

// SetReadinessChecks sets the ReadinessChecks field's value.
func (s *GetCellReadinessSummaryOutput) SetReadinessChecks(v []*ReadinessCheckSummary) *GetCellReadinessSummaryOutput {
	s.ReadinessChecks = v
	return s
}

type GetReadinessCheckInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `location:"uri" locationName:"readinessCheckName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadinessCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadinessCheckInput"}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ReadinessCheckName != nil && len(*s.ReadinessCheckName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReadinessCheckName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *GetReadinessCheckInput) SetReadinessCheckName(v string) *GetReadinessCheckInput {
	s.ReadinessCheckName = &v
	return s
}

type GetReadinessCheckOutput struct {
	_ struct{} `type:"structure"`

	ReadinessCheckArn *string `locationName:"readinessCheckArn" type:"string"`

	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string"`

	ResourceSet *string `locationName:"resourceSet" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckOutput) GoString() string {
	return s.String()
}

// SetReadinessCheckArn sets the ReadinessCheckArn field's value.
func (s *GetReadinessCheckOutput) SetReadinessCheckArn(v string) *GetReadinessCheckOutput {
	s.ReadinessCheckArn = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *GetReadinessCheckOutput) SetReadinessCheckName(v string) *GetReadinessCheckOutput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSet sets the ResourceSet field's value.
func (s *GetReadinessCheckOutput) SetResourceSet(v string) *GetReadinessCheckOutput {
	s.ResourceSet = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetReadinessCheckOutput) SetTags(v map[string]*string) *GetReadinessCheckOutput {
	s.Tags = v
	return s
}

type GetReadinessCheckResourceStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `location:"uri" locationName:"readinessCheckName" type:"string" required:"true"`

	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckResourceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckResourceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadinessCheckResourceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadinessCheckResourceStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ReadinessCheckName != nil && len(*s.ReadinessCheckName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReadinessCheckName", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReadinessCheckResourceStatusInput) SetMaxResults(v int64) *GetReadinessCheckResourceStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReadinessCheckResourceStatusInput) SetNextToken(v string) *GetReadinessCheckResourceStatusInput {
	s.NextToken = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *GetReadinessCheckResourceStatusInput) SetReadinessCheckName(v string) *GetReadinessCheckResourceStatusInput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetReadinessCheckResourceStatusInput) SetResourceIdentifier(v string) *GetReadinessCheckResourceStatusInput {
	s.ResourceIdentifier = &v
	return s
}

type GetReadinessCheckResourceStatusOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// The readiness status.
	Readiness *string `locationName:"readiness" type:"string" enum:"Readiness"`

	Rules []*RuleResult `locationName:"rules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckResourceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckResourceStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetReadinessCheckResourceStatusOutput) SetNextToken(v string) *GetReadinessCheckResourceStatusOutput {
	s.NextToken = &v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *GetReadinessCheckResourceStatusOutput) SetReadiness(v string) *GetReadinessCheckResourceStatusOutput {
	s.Readiness = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetReadinessCheckResourceStatusOutput) SetRules(v []*RuleResult) *GetReadinessCheckResourceStatusOutput {
	s.Rules = v
	return s
}

type GetReadinessCheckStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `location:"uri" locationName:"readinessCheckName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReadinessCheckStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReadinessCheckStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ReadinessCheckName != nil && len(*s.ReadinessCheckName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReadinessCheckName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReadinessCheckStatusInput) SetMaxResults(v int64) *GetReadinessCheckStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReadinessCheckStatusInput) SetNextToken(v string) *GetReadinessCheckStatusInput {
	s.NextToken = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *GetReadinessCheckStatusInput) SetReadinessCheckName(v string) *GetReadinessCheckStatusInput {
	s.ReadinessCheckName = &v
	return s
}

type GetReadinessCheckStatusOutput struct {
	_ struct{} `type:"structure"`

	Messages []*Message `locationName:"messages" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// The readiness status.
	Readiness *string `locationName:"readiness" type:"string" enum:"Readiness"`

	Resources []*ResourceResult `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReadinessCheckStatusOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *GetReadinessCheckStatusOutput) SetMessages(v []*Message) *GetReadinessCheckStatusOutput {
	s.Messages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReadinessCheckStatusOutput) SetNextToken(v string) *GetReadinessCheckStatusOutput {
	s.NextToken = &v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *GetReadinessCheckStatusOutput) SetReadiness(v string) *GetReadinessCheckStatusOutput {
	s.Readiness = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *GetReadinessCheckStatusOutput) SetResources(v []*ResourceResult) *GetReadinessCheckStatusOutput {
	s.Resources = v
	return s
}

type GetRecoveryGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `location:"uri" locationName:"recoveryGroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecoveryGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecoveryGroupInput"}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}
	if s.RecoveryGroupName != nil && len(*s.RecoveryGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *GetRecoveryGroupInput) SetRecoveryGroupName(v string) *GetRecoveryGroupInput {
	s.RecoveryGroupName = &v
	return s
}

type GetRecoveryGroupOutput struct {
	_ struct{} `type:"structure"`

	Cells []*string `locationName:"cells" type:"list"`

	RecoveryGroupArn *string `locationName:"recoveryGroupArn" type:"string"`

	RecoveryGroupName *string `locationName:"recoveryGroupName" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupOutput) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *GetRecoveryGroupOutput) SetCells(v []*string) *GetRecoveryGroupOutput {
	s.Cells = v
	return s
}

// SetRecoveryGroupArn sets the RecoveryGroupArn field's value.
func (s *GetRecoveryGroupOutput) SetRecoveryGroupArn(v string) *GetRecoveryGroupOutput {
	s.RecoveryGroupArn = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *GetRecoveryGroupOutput) SetRecoveryGroupName(v string) *GetRecoveryGroupOutput {
	s.RecoveryGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRecoveryGroupOutput) SetTags(v map[string]*string) *GetRecoveryGroupOutput {
	s.Tags = v
	return s
}

type GetRecoveryGroupReadinessSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `location:"uri" locationName:"recoveryGroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupReadinessSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupReadinessSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecoveryGroupReadinessSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecoveryGroupReadinessSummaryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}
	if s.RecoveryGroupName != nil && len(*s.RecoveryGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRecoveryGroupReadinessSummaryInput) SetMaxResults(v int64) *GetRecoveryGroupReadinessSummaryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRecoveryGroupReadinessSummaryInput) SetNextToken(v string) *GetRecoveryGroupReadinessSummaryInput {
	s.NextToken = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *GetRecoveryGroupReadinessSummaryInput) SetRecoveryGroupName(v string) *GetRecoveryGroupReadinessSummaryInput {
	s.RecoveryGroupName = &v
	return s
}

type GetRecoveryGroupReadinessSummaryOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// The readiness status.
	Readiness *string `locationName:"readiness" type:"string" enum:"Readiness"`

	ReadinessChecks []*ReadinessCheckSummary `locationName:"readinessChecks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupReadinessSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryGroupReadinessSummaryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetRecoveryGroupReadinessSummaryOutput) SetNextToken(v string) *GetRecoveryGroupReadinessSummaryOutput {
	s.NextToken = &v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *GetRecoveryGroupReadinessSummaryOutput) SetReadiness(v string) *GetRecoveryGroupReadinessSummaryOutput {
	s.Readiness = &v
	return s
}

// SetReadinessChecks sets the ReadinessChecks field's value.
func (s *GetRecoveryGroupReadinessSummaryOutput) SetReadinessChecks(v []*ReadinessCheckSummary) *GetRecoveryGroupReadinessSummaryOutput {
	s.ReadinessChecks = v
	return s
}

type GetResourceSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceSetName is a required field
	ResourceSetName *string `location:"uri" locationName:"resourceSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceSetInput"}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}
	if s.ResourceSetName != nil && len(*s.ResourceSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *GetResourceSetInput) SetResourceSetName(v string) *GetResourceSetInput {
	s.ResourceSetName = &v
	return s
}

type GetResourceSetOutput struct {
	_ struct{} `type:"structure"`

	ResourceSetArn *string `locationName:"resourceSetArn" type:"string"`

	ResourceSetName *string `locationName:"resourceSetName" type:"string"`

	ResourceSetType *string `locationName:"resourceSetType" type:"string"`

	Resources []*Resource `locationName:"resources" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSetOutput) GoString() string {
	return s.String()
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *GetResourceSetOutput) SetResourceSetArn(v string) *GetResourceSetOutput {
	s.ResourceSetArn = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *GetResourceSetOutput) SetResourceSetName(v string) *GetResourceSetOutput {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *GetResourceSetOutput) SetResourceSetType(v string) *GetResourceSetOutput {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *GetResourceSetOutput) SetResources(v []*Resource) *GetResourceSetOutput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetResourceSetOutput) SetTags(v map[string]*string) *GetResourceSetOutput {
	s.Tags = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCellsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCellsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCellsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCellsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCellsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCellsInput) SetMaxResults(v int64) *ListCellsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCellsInput) SetNextToken(v string) *ListCellsInput {
	s.NextToken = &v
	return s
}

type ListCellsOutput struct {
	_ struct{} `type:"structure"`

	Cells []*CellOutput_ `locationName:"cells" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCellsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCellsOutput) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *ListCellsOutput) SetCells(v []*CellOutput_) *ListCellsOutput {
	s.Cells = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCellsOutput) SetNextToken(v string) *ListCellsOutput {
	s.NextToken = &v
	return s
}

type ListCrossAccountAuthorizationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAuthorizationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCrossAccountAuthorizationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCrossAccountAuthorizationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCrossAccountAuthorizationsInput) SetMaxResults(v int64) *ListCrossAccountAuthorizationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountAuthorizationsInput) SetNextToken(v string) *ListCrossAccountAuthorizationsInput {
	s.NextToken = &v
	return s
}

type ListCrossAccountAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	CrossAccountAuthorizations []*string `locationName:"crossAccountAuthorizations" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrossAccountAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetCrossAccountAuthorizations sets the CrossAccountAuthorizations field's value.
func (s *ListCrossAccountAuthorizationsOutput) SetCrossAccountAuthorizations(v []*string) *ListCrossAccountAuthorizationsOutput {
	s.CrossAccountAuthorizations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrossAccountAuthorizationsOutput) SetNextToken(v string) *ListCrossAccountAuthorizationsOutput {
	s.NextToken = &v
	return s
}

type ListReadinessChecksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadinessChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadinessChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReadinessChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReadinessChecksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReadinessChecksInput) SetMaxResults(v int64) *ListReadinessChecksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadinessChecksInput) SetNextToken(v string) *ListReadinessChecksInput {
	s.NextToken = &v
	return s
}

type ListReadinessChecksOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	ReadinessChecks []*ReadinessCheckOutput_ `locationName:"readinessChecks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadinessChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReadinessChecksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReadinessChecksOutput) SetNextToken(v string) *ListReadinessChecksOutput {
	s.NextToken = &v
	return s
}

// SetReadinessChecks sets the ReadinessChecks field's value.
func (s *ListReadinessChecksOutput) SetReadinessChecks(v []*ReadinessCheckOutput_) *ListReadinessChecksOutput {
	s.ReadinessChecks = v
	return s
}

type ListRecoveryGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecoveryGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecoveryGroupsInput) SetMaxResults(v int64) *ListRecoveryGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryGroupsInput) SetNextToken(v string) *ListRecoveryGroupsInput {
	s.NextToken = &v
	return s
}

type ListRecoveryGroupsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	RecoveryGroups []*RecoveryGroupOutput_ `locationName:"recoveryGroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryGroupsOutput) SetNextToken(v string) *ListRecoveryGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRecoveryGroups sets the RecoveryGroups field's value.
func (s *ListRecoveryGroupsOutput) SetRecoveryGroups(v []*RecoveryGroupOutput_) *ListRecoveryGroupsOutput {
	s.RecoveryGroups = v
	return s
}

type ListResourceSetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceSetsInput) SetMaxResults(v int64) *ListResourceSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetsInput) SetNextToken(v string) *ListResourceSetsInput {
	s.NextToken = &v
	return s
}

type ListResourceSetsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	ResourceSets []*ResourceSetOutput_ `locationName:"resourceSets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSetsOutput) SetNextToken(v string) *ListResourceSetsOutput {
	s.NextToken = &v
	return s
}

// SetResourceSets sets the ResourceSets field's value.
func (s *ListResourceSetsOutput) SetResourceSets(v []*ResourceSetOutput_) *ListResourceSetsOutput {
	s.ResourceSets = v
	return s
}

type ListRulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRulesInput) SetMaxResults(v int64) *ListRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListRulesInput) SetResourceType(v string) *ListRulesInput {
	s.ResourceType = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Rules []*ListRulesOutput_ `locationName:"rules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*ListRulesOutput_) *ListRulesOutput {
	s.Rules = v
	return s
}

// Readiness rule information, including the resource type, rule ID, and rule
// description.
type ListRulesOutput_ struct {
	_ struct{} `type:"structure"`

	// The resource type that the readiness rule applies to.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The description of a readiness rule.
	//
	// RuleDescription is a required field
	RuleDescription *string `locationName:"ruleDescription" type:"string" required:"true"`

	// The ID for the readiness rule.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput_) GoString() string {
	return s.String()
}

// SetResourceType sets the ResourceType field's value.
func (s *ListRulesOutput_) SetResourceType(v string) *ListRulesOutput_ {
	s.ResourceType = &v
	return s
}

// SetRuleDescription sets the RuleDescription field's value.
func (s *ListRulesOutput_) SetRuleDescription(v string) *ListRulesOutput_ {
	s.RuleDescription = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *ListRulesOutput_) SetRuleId(v string) *ListRulesOutput_ {
	s.RuleId = &v
	return s
}

type ListTagsForResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourcesInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourcesInput) SetResourceArn(v string) *ListTagsForResourcesInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourcesOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourcesOutput) SetTags(v map[string]*string) *ListTagsForResourcesOutput {
	s.Tags = v
	return s
}

// Information relating to readiness check status.
type Message struct {
	_ struct{} `type:"structure"`

	// The text of a readiness check message.
	MessageText *string `locationName:"messageText" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) GoString() string {
	return s.String()
}

// SetMessageText sets the MessageText field's value.
func (s *Message) SetMessageText(v string) *Message {
	s.MessageText = &v
	return s
}

// The Network Load Balancer resource that a DNS target resource points to.
type NLBResource struct {
	_ struct{} `type:"structure"`

	// The Network Load Balancer resource Amazon Resource Name (ARN).
	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NLBResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NLBResource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NLBResource) SetArn(v string) *NLBResource {
	s.Arn = &v
	return s
}

// The Route 53 resource that a DNS target resource record points to.
type R53ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The DNS target domain name.
	DomainName *string `locationName:"domainName" type:"string"`

	// The Route 53 Resource Record Set ID.
	RecordSetId *string `locationName:"recordSetId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s R53ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s R53ResourceRecord) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *R53ResourceRecord) SetDomainName(v string) *R53ResourceRecord {
	s.DomainName = &v
	return s
}

// SetRecordSetId sets the RecordSetId field's value.
func (s *R53ResourceRecord) SetRecordSetId(v string) *R53ResourceRecord {
	s.RecordSetId = &v
	return s
}

// A readiness check.
type ReadinessCheckOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with a readiness check.
	//
	// ReadinessCheckArn is a required field
	ReadinessCheckArn *string `locationName:"readinessCheckArn" type:"string" required:"true"`

	// Name of a readiness check.
	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string"`

	// Name of the resource set to be checked.
	//
	// ResourceSet is a required field
	ResourceSet *string `locationName:"resourceSet" type:"string" required:"true"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadinessCheckOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadinessCheckOutput_) GoString() string {
	return s.String()
}

// SetReadinessCheckArn sets the ReadinessCheckArn field's value.
func (s *ReadinessCheckOutput_) SetReadinessCheckArn(v string) *ReadinessCheckOutput_ {
	s.ReadinessCheckArn = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *ReadinessCheckOutput_) SetReadinessCheckName(v string) *ReadinessCheckOutput_ {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSet sets the ResourceSet field's value.
func (s *ReadinessCheckOutput_) SetResourceSet(v string) *ReadinessCheckOutput_ {
	s.ResourceSet = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReadinessCheckOutput_) SetTags(v map[string]*string) *ReadinessCheckOutput_ {
	s.Tags = v
	return s
}

// Summary of all readiness check statuses in a recovery group, paginated in
// GetRecoveryGroupReadinessSummary and GetCellReadinessSummary.
type ReadinessCheckSummary struct {
	_ struct{} `type:"structure"`

	// The readiness status of this readiness check.
	Readiness *string `locationName:"readiness" type:"string" enum:"Readiness"`

	// The name of a readiness check.
	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadinessCheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReadinessCheckSummary) GoString() string {
	return s.String()
}

// SetReadiness sets the Readiness field's value.
func (s *ReadinessCheckSummary) SetReadiness(v string) *ReadinessCheckSummary {
	s.Readiness = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *ReadinessCheckSummary) SetReadinessCheckName(v string) *ReadinessCheckSummary {
	s.ReadinessCheckName = &v
	return s
}

// Recommendations that are provided to make an application more recovery resilient.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// Text of the recommendations that are provided to make an application more
	// recovery resilient.
	//
	// RecommendationText is a required field
	RecommendationText *string `locationName:"recommendationText" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetRecommendationText sets the RecommendationText field's value.
func (s *Recommendation) SetRecommendationText(v string) *Recommendation {
	s.RecommendationText = &v
	return s
}

// A representation of the application, typically containing multiple cells.
type RecoveryGroupOutput_ struct {
	_ struct{} `type:"structure"`

	// A list of a cell's Amazon Resource Names (ARNs).
	//
	// Cells is a required field
	Cells []*string `locationName:"cells" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) for the recovery group.
	//
	// RecoveryGroupArn is a required field
	RecoveryGroupArn *string `locationName:"recoveryGroupArn" type:"string" required:"true"`

	// The name of the recovery group.
	//
	// RecoveryGroupName is a required field
	RecoveryGroupName *string `locationName:"recoveryGroupName" type:"string" required:"true"`

	// The tags associated with the recovery group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryGroupOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryGroupOutput_) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *RecoveryGroupOutput_) SetCells(v []*string) *RecoveryGroupOutput_ {
	s.Cells = v
	return s
}

// SetRecoveryGroupArn sets the RecoveryGroupArn field's value.
func (s *RecoveryGroupOutput_) SetRecoveryGroupArn(v string) *RecoveryGroupOutput_ {
	s.RecoveryGroupArn = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *RecoveryGroupOutput_) SetRecoveryGroupName(v string) *RecoveryGroupOutput_ {
	s.RecoveryGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecoveryGroupOutput_) SetTags(v map[string]*string) *RecoveryGroupOutput_ {
	s.Tags = v
	return s
}

// The resource element of a resource set.
type Resource struct {
	_ struct{} `type:"structure"`

	// The component identifier of the resource, generated when DNS target resource
	// is used.
	ComponentId *string `locationName:"componentId" type:"string"`

	// The DNS target resource.
	DnsTargetResource *DNSTargetResource `locationName:"dnsTargetResource" type:"structure"`

	// A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that
	// this resource is contained within.
	ReadinessScopes []*string `locationName:"readinessScopes" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetComponentId sets the ComponentId field's value.
func (s *Resource) SetComponentId(v string) *Resource {
	s.ComponentId = &v
	return s
}

// SetDnsTargetResource sets the DnsTargetResource field's value.
func (s *Resource) SetDnsTargetResource(v *DNSTargetResource) *Resource {
	s.DnsTargetResource = v
	return s
}

// SetReadinessScopes sets the ReadinessScopes field's value.
func (s *Resource) SetReadinessScopes(v []*string) *Resource {
	s.ReadinessScopes = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Resource) SetResourceArn(v string) *Resource {
	s.ResourceArn = &v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The result of a successful Resource request, with status for an individual
// resource.
type ResourceResult struct {
	_ struct{} `type:"structure"`

	// The component id of the resource.
	ComponentId *string `locationName:"componentId" type:"string"`

	// The time (UTC) that the resource was last checked for readiness, in ISO-8601
	// format.
	//
	// LastCheckedTimestamp is a required field
	LastCheckedTimestamp *time.Time `locationName:"lastCheckedTimestamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The readiness of a resource.
	//
	// Readiness is a required field
	Readiness *string `locationName:"readiness" type:"string" required:"true" enum:"Readiness"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceResult) GoString() string {
	return s.String()
}

// SetComponentId sets the ComponentId field's value.
func (s *ResourceResult) SetComponentId(v string) *ResourceResult {
	s.ComponentId = &v
	return s
}

// SetLastCheckedTimestamp sets the LastCheckedTimestamp field's value.
func (s *ResourceResult) SetLastCheckedTimestamp(v time.Time) *ResourceResult {
	s.LastCheckedTimestamp = &v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *ResourceResult) SetReadiness(v string) *ResourceResult {
	s.Readiness = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceResult) SetResourceArn(v string) *ResourceResult {
	s.ResourceArn = &v
	return s
}

// A collection of resources of the same type.
type ResourceSetOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource set.
	//
	// ResourceSetArn is a required field
	ResourceSetArn *string `locationName:"resourceSetArn" type:"string" required:"true"`

	// The name of the resource set.
	//
	// ResourceSetName is a required field
	ResourceSetName *string `locationName:"resourceSetName" type:"string" required:"true"`

	// The resource type of the resources in the resource set. Enter one of the
	// following values for resource type:
	//
	// AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup,
	// AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table,
	// AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer,
	// AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
	// AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
	// AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource
	//
	// ResourceSetType is a required field
	ResourceSetType *string `locationName:"resourceSetType" type:"string" required:"true"`

	// A list of resource objects.
	//
	// Resources is a required field
	Resources []*Resource `locationName:"resources" type:"list" required:"true"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSetOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSetOutput_) GoString() string {
	return s.String()
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *ResourceSetOutput_) SetResourceSetArn(v string) *ResourceSetOutput_ {
	s.ResourceSetArn = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *ResourceSetOutput_) SetResourceSetName(v string) *ResourceSetOutput_ {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *ResourceSetOutput_) SetResourceSetType(v string) *ResourceSetOutput_ {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ResourceSetOutput_) SetResources(v []*Resource) *ResourceSetOutput_ {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceSetOutput_) SetTags(v map[string]*string) *ResourceSetOutput_ {
	s.Tags = v
	return s
}

// The result of a successful Rule request, with status for an individual rule.
type RuleResult struct {
	_ struct{} `type:"structure"`

	// The time the resource was last checked for readiness, in ISO-8601 format,
	// UTC.
	//
	// LastCheckedTimestamp is a required field
	LastCheckedTimestamp *time.Time `locationName:"lastCheckedTimestamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Details about the resource's readiness.
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" type:"list" required:"true"`

	// The readiness at rule level.
	//
	// Readiness is a required field
	Readiness *string `locationName:"readiness" type:"string" required:"true" enum:"Readiness"`

	// The identifier of the rule.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleResult) GoString() string {
	return s.String()
}

// SetLastCheckedTimestamp sets the LastCheckedTimestamp field's value.
func (s *RuleResult) SetLastCheckedTimestamp(v time.Time) *RuleResult {
	s.LastCheckedTimestamp = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *RuleResult) SetMessages(v []*Message) *RuleResult {
	s.Messages = v
	return s
}

// SetReadiness sets the Readiness field's value.
func (s *RuleResult) SetReadiness(v string) *RuleResult {
	s.Readiness = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleResult) SetRuleId(v string) *RuleResult {
	s.RuleId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// A collection of tags associated with a resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The target resource that the Route 53 record points to.
type TargetResource struct {
	_ struct{} `type:"structure"`

	// The Network Load Balancer Resource.
	NLBResource *NLBResource `locationName:"nLBResource" type:"structure"`

	// The Route 53 resource.
	R53Resource *R53ResourceRecord `locationName:"r53Resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetResource) GoString() string {
	return s.String()
}

// SetNLBResource sets the NLBResource field's value.
func (s *TargetResource) SetNLBResource(v *NLBResource) *TargetResource {
	s.NLBResource = v
	return s
}

// SetR53Resource sets the R53Resource field's value.
func (s *TargetResource) SetR53Resource(v *R53ResourceRecord) *TargetResource {
	s.R53Resource = v
	return s
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCellInput struct {
	_ struct{} `type:"structure"`

	// CellName is a required field
	CellName *string `location:"uri" locationName:"cellName" type:"string" required:"true"`

	// Cells is a required field
	Cells []*string `locationName:"cells" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCellInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCellInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCellInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCellInput"}
	if s.CellName == nil {
		invalidParams.Add(request.NewErrParamRequired("CellName"))
	}
	if s.CellName != nil && len(*s.CellName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CellName", 1))
	}
	if s.Cells == nil {
		invalidParams.Add(request.NewErrParamRequired("Cells"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCellName sets the CellName field's value.
func (s *UpdateCellInput) SetCellName(v string) *UpdateCellInput {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *UpdateCellInput) SetCells(v []*string) *UpdateCellInput {
	s.Cells = v
	return s
}

type UpdateCellOutput struct {
	_ struct{} `type:"structure"`

	CellArn *string `locationName:"cellArn" type:"string"`

	CellName *string `locationName:"cellName" type:"string"`

	Cells []*string `locationName:"cells" type:"list"`

	ParentReadinessScopes []*string `locationName:"parentReadinessScopes" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCellOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCellOutput) GoString() string {
	return s.String()
}

// SetCellArn sets the CellArn field's value.
func (s *UpdateCellOutput) SetCellArn(v string) *UpdateCellOutput {
	s.CellArn = &v
	return s
}

// SetCellName sets the CellName field's value.
func (s *UpdateCellOutput) SetCellName(v string) *UpdateCellOutput {
	s.CellName = &v
	return s
}

// SetCells sets the Cells field's value.
func (s *UpdateCellOutput) SetCells(v []*string) *UpdateCellOutput {
	s.Cells = v
	return s
}

// SetParentReadinessScopes sets the ParentReadinessScopes field's value.
func (s *UpdateCellOutput) SetParentReadinessScopes(v []*string) *UpdateCellOutput {
	s.ParentReadinessScopes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateCellOutput) SetTags(v map[string]*string) *UpdateCellOutput {
	s.Tags = v
	return s
}

type UpdateReadinessCheckInput struct {
	_ struct{} `type:"structure"`

	// ReadinessCheckName is a required field
	ReadinessCheckName *string `location:"uri" locationName:"readinessCheckName" type:"string" required:"true"`

	// ResourceSetName is a required field
	ResourceSetName *string `locationName:"resourceSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReadinessCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReadinessCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReadinessCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReadinessCheckInput"}
	if s.ReadinessCheckName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadinessCheckName"))
	}
	if s.ReadinessCheckName != nil && len(*s.ReadinessCheckName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReadinessCheckName", 1))
	}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *UpdateReadinessCheckInput) SetReadinessCheckName(v string) *UpdateReadinessCheckInput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *UpdateReadinessCheckInput) SetResourceSetName(v string) *UpdateReadinessCheckInput {
	s.ResourceSetName = &v
	return s
}

type UpdateReadinessCheckOutput struct {
	_ struct{} `type:"structure"`

	ReadinessCheckArn *string `locationName:"readinessCheckArn" type:"string"`

	ReadinessCheckName *string `locationName:"readinessCheckName" type:"string"`

	ResourceSet *string `locationName:"resourceSet" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReadinessCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReadinessCheckOutput) GoString() string {
	return s.String()
}

// SetReadinessCheckArn sets the ReadinessCheckArn field's value.
func (s *UpdateReadinessCheckOutput) SetReadinessCheckArn(v string) *UpdateReadinessCheckOutput {
	s.ReadinessCheckArn = &v
	return s
}

// SetReadinessCheckName sets the ReadinessCheckName field's value.
func (s *UpdateReadinessCheckOutput) SetReadinessCheckName(v string) *UpdateReadinessCheckOutput {
	s.ReadinessCheckName = &v
	return s
}

// SetResourceSet sets the ResourceSet field's value.
func (s *UpdateReadinessCheckOutput) SetResourceSet(v string) *UpdateReadinessCheckOutput {
	s.ResourceSet = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateReadinessCheckOutput) SetTags(v map[string]*string) *UpdateReadinessCheckOutput {
	s.Tags = v
	return s
}

type UpdateRecoveryGroupInput struct {
	_ struct{} `type:"structure"`

	// Cells is a required field
	Cells []*string `locationName:"cells" type:"list" required:"true"`

	// RecoveryGroupName is a required field
	RecoveryGroupName *string `location:"uri" locationName:"recoveryGroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecoveryGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecoveryGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecoveryGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecoveryGroupInput"}
	if s.Cells == nil {
		invalidParams.Add(request.NewErrParamRequired("Cells"))
	}
	if s.RecoveryGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryGroupName"))
	}
	if s.RecoveryGroupName != nil && len(*s.RecoveryGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCells sets the Cells field's value.
func (s *UpdateRecoveryGroupInput) SetCells(v []*string) *UpdateRecoveryGroupInput {
	s.Cells = v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *UpdateRecoveryGroupInput) SetRecoveryGroupName(v string) *UpdateRecoveryGroupInput {
	s.RecoveryGroupName = &v
	return s
}

type UpdateRecoveryGroupOutput struct {
	_ struct{} `type:"structure"`

	Cells []*string `locationName:"cells" type:"list"`

	RecoveryGroupArn *string `locationName:"recoveryGroupArn" type:"string"`

	RecoveryGroupName *string `locationName:"recoveryGroupName" type:"string"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecoveryGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecoveryGroupOutput) GoString() string {
	return s.String()
}

// SetCells sets the Cells field's value.
func (s *UpdateRecoveryGroupOutput) SetCells(v []*string) *UpdateRecoveryGroupOutput {
	s.Cells = v
	return s
}

// SetRecoveryGroupArn sets the RecoveryGroupArn field's value.
func (s *UpdateRecoveryGroupOutput) SetRecoveryGroupArn(v string) *UpdateRecoveryGroupOutput {
	s.RecoveryGroupArn = &v
	return s
}

// SetRecoveryGroupName sets the RecoveryGroupName field's value.
func (s *UpdateRecoveryGroupOutput) SetRecoveryGroupName(v string) *UpdateRecoveryGroupOutput {
	s.RecoveryGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRecoveryGroupOutput) SetTags(v map[string]*string) *UpdateRecoveryGroupOutput {
	s.Tags = v
	return s
}

type UpdateResourceSetInput struct {
	_ struct{} `type:"structure"`

	// ResourceSetName is a required field
	ResourceSetName *string `location:"uri" locationName:"resourceSetName" type:"string" required:"true"`

	// ResourceSetType is a required field
	ResourceSetType *string `locationName:"resourceSetType" type:"string" required:"true"`

	// Resources is a required field
	Resources []*Resource `locationName:"resources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceSetInput"}
	if s.ResourceSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetName"))
	}
	if s.ResourceSetName != nil && len(*s.ResourceSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceSetName", 1))
	}
	if s.ResourceSetType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSetType"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *UpdateResourceSetInput) SetResourceSetName(v string) *UpdateResourceSetInput {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *UpdateResourceSetInput) SetResourceSetType(v string) *UpdateResourceSetInput {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateResourceSetInput) SetResources(v []*Resource) *UpdateResourceSetInput {
	s.Resources = v
	return s
}

type UpdateResourceSetOutput struct {
	_ struct{} `type:"structure"`

	ResourceSetArn *string `locationName:"resourceSetArn" type:"string"`

	ResourceSetName *string `locationName:"resourceSetName" type:"string"`

	ResourceSetType *string `locationName:"resourceSetType" type:"string"`

	Resources []*Resource `locationName:"resources" type:"list"`

	// A collection of tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceSetOutput) GoString() string {
	return s.String()
}

// SetResourceSetArn sets the ResourceSetArn field's value.
func (s *UpdateResourceSetOutput) SetResourceSetArn(v string) *UpdateResourceSetOutput {
	s.ResourceSetArn = &v
	return s
}

// SetResourceSetName sets the ResourceSetName field's value.
func (s *UpdateResourceSetOutput) SetResourceSetName(v string) *UpdateResourceSetOutput {
	s.ResourceSetName = &v
	return s
}

// SetResourceSetType sets the ResourceSetType field's value.
func (s *UpdateResourceSetOutput) SetResourceSetType(v string) *UpdateResourceSetOutput {
	s.ResourceSetType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateResourceSetOutput) SetResources(v []*Resource) *UpdateResourceSetOutput {
	s.Resources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateResourceSetOutput) SetTags(v map[string]*string) *UpdateResourceSetOutput {
	s.Tags = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The readiness status.
const (
	// ReadinessReady is a Readiness enum value
	ReadinessReady = "READY"

	// ReadinessNotReady is a Readiness enum value
	ReadinessNotReady = "NOT_READY"

	// ReadinessUnknown is a Readiness enum value
	ReadinessUnknown = "UNKNOWN"

	// ReadinessNotAuthorized is a Readiness enum value
	ReadinessNotAuthorized = "NOT_AUTHORIZED"
)

// Readiness_Values returns all elements of the Readiness enum
func Readiness_Values() []string {
	return []string{
		ReadinessReady,
		ReadinessNotReady,
		ReadinessUnknown,
		ReadinessNotAuthorized,
	}
}
