indexing

	description:

		"Errors"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/08 23:54:39 $"
	revision: "$Revision: 1.7 $"

class ET_ERROR

inherit

	UT_ERROR

creation

	-- This class should be declared as deferred,
	-- but it has no deferred feature. The workaround
	-- to avoid VCCH-2 is to add this empty creation
	-- clause.

feature -- Access

	etl_code: STRING
			-- ETL validity code

	default_template: STRING
			-- Default template used to built the error message

	code: STRING
			-- Error code

feature -- Setting

	set_etl_code (a_code: like etl_code) is
			-- Set `etl_code' to `a_code'.
		require
			a_code_not_void: a_code /= Void
		do
			etl_code := a_code
		ensure
			etl_code_set: etl_code = a_code
		end

	set_default_template (a_template: like default_template) is
			-- Set `default_template' to `a_template'.
		require
			a_template_not_void: a_template /= Void
		do
			default_template := a_template
		ensure
			default_template_set: default_template = a_template
		end

	set_parameters (a_parameters: like parameters) is
			-- Set `parameters' to `a_parameters'.
		require
			a_parameters_not_void: a_parameters /= Void
			no_void_parameter: not STRING_ARRAY_.has (a_parameters, Void)
		do
			parameters := a_parameters
		ensure
			parameters_set: parameters = a_parameters
		end

	set_code (a_code: like code) is
			-- Set `code' to `a_code'.
		require
			a_code_not_void: a_code /= Void
		do
			code := a_code
		ensure
			code_set: code = a_code
		end

end
