indexing

	description:

		"Eiffel infix 'free-operator' feature names"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/01 17:11:42 $"
	revision: "$Revision: 1.6 $"

deferred class ET_INFIX_FREE

inherit

	ET_OPERATOR
		redefine
			name, hash_code, same_feature_name
		end

	KL_IMPORTED_STRING_ROUTINES

feature -- Access

	name: STRING is
			-- Name of feature
		do
			Result := STRING_.make (free_operator_name.count + 8)
			Result.append_string (infix_double_quote)
			Result.append_string (free_operator_name)
			Result.append_character ('%"')
		end

	free_operator_name: STRING is
			-- Name of free operator
		deferred
		ensure
			free_operator_name_not_void: Result /= Void
			free_operator_name_not_empty: Result.count > 0
		end

	hash_code: INTEGER is
			-- Hash code value
		do
			Result := cached_hash_code
			if Result = -1 then
				Result := STRING_.case_insensitive_hash_code (free_operator_name)
				cached_hash_code := Result
			end
		end

feature -- Comparison

	same_feature_name (other: ET_FEATURE_NAME): BOOLEAN is
			-- Are feature name and `other' the same feature name?
			-- (case insensitive)
		local
			op: ET_INFIX_FREE
		do
			if other = Current then
				Result := True
			elseif other.is_infix_freeop then
				op ?= other
				if op /= Void then
					if op.free_operator_name = free_operator_name then
						Result := True
					else
						Result := STRING_.same_case_insensitive (free_operator_name, op.free_operator_name)
					end
				end
			end
		end

feature {NONE} -- Implementation

	cached_hash_code: INTEGER
			-- Cached hash code

feature {NONE} -- Constants

	infix_double_quote: STRING is "infix %""

end
