/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details. */

#include <stdio.h>
#include <stdlib.h>

#include "lib.h"
#include "queue.h"

void fre_gq(Gnut_Queue **x, int bugnum)
{
  yfre((void **) x, bugnum);
}

Gnut_Queue * gnut_queue_new(int tracking_number)
{
  Gnut_Queue *a;

  a = (Gnut_Queue *) ymaloc(sizeof(Gnut_Queue), tracking_number);
  a->head = 0;
  a->tail = 0;
  a->size = 0;
  return a;
}

/* Removes an item from a queue, does NOT try to fr.ee its data block. */
void gnut_queue_delete(Gnut_Queue *q, void *d)
{
  Gnut_List *tmp;
  int flag=0;
  
  if ((q->tail) && d==(q->tail->data)) {
    flag=1;
  }
  
  q->head = gnut_list_remove(q->head, d, 5);

  if (flag==1) {
    /* we need to reset tail... */
    for (tmp = q->head; tmp; tmp = tmp->next) {
      if (tmp->next == 0) {
	q->tail = tmp;
      }
    }
  }
}  

/* Adds an item to the end (tail) of a queue */
void gnut_queue_insert(Gnut_Queue *q, void *d, int tracking_number)
{
  Gnut_List *tmp;

  if (!q) {
    GD_S(0, "gnut_queue.insert q="); GD_P(0, q); GD_S(0, " d="); GD_P(0, d);
    GD_S(0, " tn="); GD_I(0, tracking_number); GD_S(0, "\n");
    return;
  }
  GD_S(4,"gnut_queue_insert entering q="); GD_P(4, q); GD_S(4, " d=");
  GD_P(4, d); GD_S(4, "\n");

  tmp = (Gnut_List *) ymaloc(sizeof(Gnut_List), tracking_number);
  tmp->data = d;
  tmp->next = 0;
  q->size++;

  GD_S(4, "new size: "); GD_I(4, q->size); GD_S(4, "\n");

  if (q->head == 0) {
    q->head = q->tail = tmp;
  } else {
    gnut_mprobe(q->tail);
    q->tail->next = tmp;
    q->tail = tmp;
  }
}

/* Remove an item from the end of a queue, fr.ee the queue node but don't
 * fr.ee the data itself. A pointer to the data is returned so you can
 * fr.ee it if you need to. */
void * gnut_queue_remove(Gnut_Queue *q)
{
  Gnut_List *gltmp;
  void *ret;
  
  gnut_mprobe(q);
  
  if (!q) {
    GD_S(0, "gnut_queue_remove q="); GD_P(0, q); GD_S(0, "\n");
    return 0;
  }

  gltmp = q->head;

  if (gltmp) {
    gnut_mprobe(gltmp);

    q->head = q->head->next;
    if (q->head == 0) {
      q->tail = 0;
    }

    ret = gltmp->data;
    fre_gl(&gltmp, 407);

    q->size--;
    return ret;
  }
  /* else */
  return 0;
}

Gnut_List * gnut_queue_list(Gnut_Queue *q)
{
  if (!q) {
    GD_S(0, "gnut_queue_list q="); GD_P(0, q); GD_S(0, "\n");
    return 0;
  }
  return q->head;
}

/* Removes all the elements in a queue, but does not fr.ee the header
   structure *q */
void gnut_queue_fre(Gnut_Queue *q)
{
  Gnut_List *gltmp;
  Gnut_List *gltmp2;

  GD_S(2, "gnut_queue_fre entering q="); GD_P(2, q); GD_S(2, "\n");

  if (!q) {
    GD_S(0, "q="); GD_P(0, q); GD_S(0, "\n");
    return;
  }

  for (gltmp = q->head; gltmp; gltmp = gltmp2) {
    gltmp2 = gltmp->next;
    if (gltmp->data) {
      fre_v(&(gltmp->data), 408);
    }
    fre_gl(&gltmp, 409);
  }
  GD_S(2, "gnut_queue_fre returning\n");
}
