/* 
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef MODUTILS_H
#define MODUTILS_H

#include <audiofile.h>
#include <config.h>
#include "mem.h"
#include "module.h"
#include "shell.h"
#include "snd.h"
#include "gui.h"
#include "action.h"
#include "iterator.h"

#define RESAMPLE_BEST_ALGORITHM 0
#define HONOR_ENVELOPES 1
#define GUARANTEE_NEW_FRAME_COUNT 1

const char *
dirname(const char *s);

void
mix(shell *target_shell,
    int target_channel,
    AFframecount target_offset,
    snd *source_sr,
    int source_channel,
    AFframecount source_offset,
    AFframecount source_end_offset);

const char *
resample_algo_name(int algo);

const char *
resample_algo_description(int algo);

/*
 * Returns new number of frames written (length may be modified by
 * envelopes!).
 */
AFframecount
resample(shell *shl,
         int track,
         AFframecount start_offset,
         AFframecount end_offset,
         AFframecount new_frame_count,
         int algo,
         int honor_envelopes,
         int guarantee_new_frame_count);

void
reverse(shell *shl,
        int track,
        AFframecount start_offset,
        AFframecount end_offset);

void
amplify(shell *shl,
        int track,
        AFframecount start_offset,
        AFframecount end_offset,
        double factor,
        double slope);

int32_t
find_peak(shell *shl,
          int track,
          AFframecount start_offset,
          AFframecount end_offset);

action_group *
fade(shell *shl, 
     int undo,
     double factor,
     double slope);

AFframecount
find_zero(shell *shl,
          int track,
          AFframecount start_offset,
          AFframecount end_offset);

#endif /* ! MODUTILS_H */
