/**
 ** all_list.c - routine to deal with the all songs list
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "utility.h"
#include "mp3info.h"
#include "song_list.h"
#include "song_find.h"
#include "rule_list.h"
#include "mp3list.h"

void all_list_add_row(MP3 *mp3)
{
    char *text[2];
    int n;

    text[0] = mp3->display_name;
    text[1] = mp3list_build_time(mp3);
    n = gtk_clist_append( GTK_CLIST(gnomp3.all_clist), text );
    gtk_clist_set_row_data( GTK_CLIST(gnomp3.all_clist), n, mp3);
    mp3->row_alllist = n;
}

