/* ChannelListWriter.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from ChannelListWriter.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;
typedef struct _DVBioChannelListWriterPrivate DVBioChannelListWriterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

struct _DVBioChannelListWriter {
	GObject parent_instance;
	DVBioChannelListWriterPrivate * priv;
};

struct _DVBioChannelListWriterClass {
	GObjectClass parent_class;
};

struct _DVBioChannelListWriterPrivate {
	GFile* _file;
	GOutputStream* stream;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;


static gpointer dvb_io_channel_list_writer_parent_class = NULL;

GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_WRITER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_WRITER_FILE
};
static void dvb_io_channel_list_writer_open_stream (DVBioChannelListWriter* self, GError** error);
GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self);
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
const gchar* dvb_channel_get_Name (DVBChannel* self);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error);
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBSatelliteChannel* channel, GError** error);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBCableChannel* channel, GError** error);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
guint dvb_channel_get_Frequency (DVBChannel* self);
static gchar* dvb_io_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const gchar* prefix);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self);
const gchar* dvb_satellite_channel_get_Polarization (DVBSatelliteChannel* self);
gint dvb_satellite_channel_get_DiseqcSource (DVBSatelliteChannel* self);
guint dvb_satellite_channel_get_SymbolRate (DVBSatelliteChannel* self);
DVBDvbSrcInversion dvb_cable_channel_get_Inversion (DVBCableChannel* self);
guint dvb_cable_channel_get_SymbolRate (DVBCableChannel* self);
DVBDvbSrcCodeRate dvb_cable_channel_get_CodeRate (DVBCableChannel* self);
DVBDvbSrcModulation dvb_cable_channel_get_Modulation (DVBCableChannel* self);
const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value);
static void dvb_io_channel_list_writer_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void dvb_io_channel_list_writer_open_stream (DVBioChannelListWriter* self, GError** error) {
	GFileOutputStream* fostream;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFileOutputStream* _tmp8_;
	GBufferedOutputStream* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	fostream = NULL;
	_tmp0_ = self->priv->_file;
	_tmp1_ = g_file_query_exists (_tmp0_, NULL);
	if (_tmp1_) {
		GFile* _tmp2_;
		GFileOutputStream* _tmp3_ = NULL;
		GFileOutputStream* _tmp4_;
		_tmp2_ = self->priv->_file;
		_tmp3_ = g_file_replace (_tmp2_, NULL, TRUE, 0, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_g_object_unref0 (fostream);
		fostream = _tmp4_;
	} else {
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_ = NULL;
		GFileOutputStream* _tmp7_;
		_tmp5_ = self->priv->_file;
		_tmp6_ = g_file_create (_tmp5_, 0, NULL, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_g_object_unref0 (fostream);
		fostream = _tmp7_;
	}
	_tmp8_ = fostream;
	_tmp9_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) _tmp8_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = (GOutputStream*) _tmp9_;
	_g_object_unref0 (fostream);
}


DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file) {
	DVBioChannelListWriter * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (DVBioChannelListWriter*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file) {
	return dvb_io_channel_list_writer_construct (DVB_IO_TYPE_CHANNEL_LIST_WRITER, file);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	GOutputStream* _tmp0_;
	GOutputStream* _tmp1_;
	gchar* buffer = NULL;
	DVBChannel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	GOutputStream* _tmp6_;
	const gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	DVBChannel* _tmp10_;
	guint apid = 0U;
	DVBChannel* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	DVBChannel* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	DVBChannel* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	gchar* _tmp32_ = NULL;
	GOutputStream* _tmp33_;
	const gchar* _tmp34_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	guint8* _tmp36_;
	gint _tmp36__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->stream;
	if (_tmp0_ == NULL) {
		dvb_io_channel_list_writer_open_stream (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->stream;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = channel;
	_tmp3_ = dvb_channel_get_Name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s:", _tmp4_);
	_g_free0 (buffer);
	buffer = _tmp5_;
	_tmp6_ = self->priv->stream;
	_tmp7_ = buffer;
	_tmp8_ = string_get_data (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	g_output_stream_write_all (_tmp6_, _tmp9_, (gsize) _tmp9__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	_tmp10_ = channel;
	if (DVB_IS_TERRESTRIAL_CHANNEL (_tmp10_)) {
		DVBChannel* _tmp11_;
		_tmp11_ = channel;
		dvb_io_channel_list_writer_write_terrestrial_channel (self, DVB_TERRESTRIAL_CHANNEL (_tmp11_), &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (buffer);
			return;
		}
	} else {
		DVBChannel* _tmp12_;
		_tmp12_ = channel;
		if (DVB_IS_SATELLITE_CHANNEL (_tmp12_)) {
			DVBChannel* _tmp13_;
			_tmp13_ = channel;
			dvb_io_channel_list_writer_write_satellite_channel (self, DVB_SATELLITE_CHANNEL (_tmp13_), &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (buffer);
				return;
			}
		} else {
			DVBChannel* _tmp14_;
			_tmp14_ = channel;
			if (DVB_IS_CABLE_CHANNEL (_tmp14_)) {
				DVBChannel* _tmp15_;
				_tmp15_ = channel;
				dvb_io_channel_list_writer_write_cable_channel (self, DVB_CABLE_CHANNEL (_tmp15_), &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (buffer);
					return;
				}
			} else {
				g_warning ("ChannelListWriter.vala:76: Unknown channel type");
			}
		}
	}
	_tmp16_ = channel;
	_tmp17_ = dvb_channel_get_AudioPIDs (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == 0) {
		apid = (guint) 0;
	} else {
		DVBChannel* _tmp21_;
		GeeList* _tmp22_;
		GeeList* _tmp23_;
		gpointer _tmp24_ = NULL;
		_tmp21_ = channel;
		_tmp22_ = dvb_channel_get_AudioPIDs (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_list_get (_tmp23_, 0);
		apid = GPOINTER_TO_UINT (_tmp24_);
	}
	_tmp25_ = channel;
	_tmp26_ = dvb_channel_get_VideoPID (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = apid;
	_tmp29_ = channel;
	_tmp30_ = dvb_channel_get_Sid (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf (":%u:%u:%u\n", _tmp27_, _tmp28_, _tmp31_);
	_g_free0 (buffer);
	buffer = _tmp32_;
	_tmp33_ = self->priv->stream;
	_tmp34_ = buffer;
	_tmp35_ = string_get_data (_tmp34_, &_tmp35__length1);
	_tmp36_ = _tmp35_;
	_tmp36__length1 = _tmp35__length1;
	g_output_stream_write_all (_tmp33_, _tmp36_, (gsize) _tmp36__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	_g_free0 (buffer);
}


gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error) {
	gboolean result = FALSE;
	GOutputStream* _tmp0_;
	GOutputStream* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stream;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->stream;
	_tmp2_ = g_output_stream_close (_tmp1_, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp3_;
	return result;
}


static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error) {
	gchar** _tmp0_ = NULL;
	gchar** elements;
	gint elements_length1;
	gint _elements_size_;
	DVBTerrestrialChannel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	DVBTerrestrialChannel* _tmp6_;
	DVBDvbSrcInversion _tmp7_;
	DVBDvbSrcInversion _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	DVBTerrestrialChannel* _tmp11_;
	DVBDvbSrcBandwidth _tmp12_;
	DVBDvbSrcBandwidth _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	DVBTerrestrialChannel* _tmp16_;
	DVBDvbSrcCodeRate _tmp17_;
	DVBDvbSrcCodeRate _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	DVBTerrestrialChannel* _tmp21_;
	DVBDvbSrcCodeRate _tmp22_;
	DVBDvbSrcCodeRate _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	DVBTerrestrialChannel* _tmp26_;
	DVBDvbSrcModulation _tmp27_;
	DVBDvbSrcModulation _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	DVBTerrestrialChannel* _tmp31_;
	DVBDvbSrcTransmissionMode _tmp32_;
	DVBDvbSrcTransmissionMode _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	DVBTerrestrialChannel* _tmp36_;
	DVBDvbSrcGuard _tmp37_;
	DVBDvbSrcGuard _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	DVBTerrestrialChannel* _tmp41_;
	DVBDvbSrcHierarchy _tmp42_;
	DVBDvbSrcHierarchy _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* buffer;
	GOutputStream* _tmp47_;
	guint8* _tmp48_;
	gint _tmp48__length1;
	guint8* _tmp49_;
	gint _tmp49__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_new0 (gchar*, 9 + 1);
	elements = _tmp0_;
	elements_length1 = 9;
	_elements_size_ = elements_length1;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Frequency ((DVBChannel*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_g_free0 (elements[0]);
	elements[0] = _tmp4_;
	_tmp5_ = elements[0];
	_tmp6_ = channel;
	_tmp7_ = dvb_terrestrial_channel_get_Inversion (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) _tmp8_, "DVB_DVB_SRC_INVERSION_");
	_g_free0 (elements[1]);
	elements[1] = _tmp9_;
	_tmp10_ = elements[1];
	_tmp11_ = channel;
	_tmp12_ = dvb_terrestrial_channel_get_Bandwidth (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) _tmp13_, "DVB_DVB_SRC_BANDWIDTH_");
	_g_free0 (elements[2]);
	elements[2] = _tmp14_;
	_tmp15_ = elements[2];
	_tmp16_ = channel;
	_tmp17_ = dvb_terrestrial_channel_get_CodeRateHP (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp18_, "DVB_DVB_SRC_CODE_RATE_");
	_g_free0 (elements[3]);
	elements[3] = _tmp19_;
	_tmp20_ = elements[3];
	_tmp21_ = channel;
	_tmp22_ = dvb_terrestrial_channel_get_CodeRateLP (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp23_, "DVB_DVB_SRC_CODE_RATE_");
	_g_free0 (elements[4]);
	elements[4] = _tmp24_;
	_tmp25_ = elements[4];
	_tmp26_ = channel;
	_tmp27_ = dvb_terrestrial_channel_get_Constellation (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) _tmp28_, "DVB_DVB_SRC_MODULATION_");
	_g_free0 (elements[5]);
	elements[5] = _tmp29_;
	_tmp30_ = elements[5];
	_tmp31_ = channel;
	_tmp32_ = dvb_terrestrial_channel_get_TransmissionMode (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) _tmp33_, "DVB_DVB_SRC_TRANSMISSION_MODE_");
	_g_free0 (elements[6]);
	elements[6] = _tmp34_;
	_tmp35_ = elements[6];
	_tmp36_ = channel;
	_tmp37_ = dvb_terrestrial_channel_get_GuardInterval (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_GUARD, (gint) _tmp38_, "DVB_DVB_SRC_GUARD_");
	_g_free0 (elements[7]);
	elements[7] = _tmp39_;
	_tmp40_ = elements[7];
	_tmp41_ = channel;
	_tmp42_ = dvb_terrestrial_channel_get_Hierarchy (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) _tmp43_, "DVB_DVB_SRC_HIERARCHY_");
	_g_free0 (elements[8]);
	elements[8] = _tmp44_;
	_tmp45_ = elements[8];
	_tmp46_ = g_strjoinv (":", elements);
	buffer = _tmp46_;
	_tmp47_ = self->priv->stream;
	_tmp48_ = string_get_data (buffer, &_tmp48__length1);
	_tmp49_ = _tmp48_;
	_tmp49__length1 = _tmp48__length1;
	g_output_stream_write_all (_tmp47_, _tmp49_, (gsize) _tmp49__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_free0 (buffer);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
}


static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBSatelliteChannel* channel, GError** error) {
	DVBSatelliteChannel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	DVBSatelliteChannel* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	DVBSatelliteChannel* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	DVBSatelliteChannel* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* buffer;
	GOutputStream* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Frequency ((DVBChannel*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = channel;
	_tmp4_ = dvb_satellite_channel_get_Polarization (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = channel;
	_tmp7_ = dvb_satellite_channel_get_DiseqcSource (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = channel;
	_tmp10_ = dvb_satellite_channel_get_SymbolRate (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%u:%s:%d:%u", _tmp2_ / 1000, _tmp5_, _tmp8_, _tmp11_);
	buffer = _tmp12_;
	_tmp13_ = self->priv->stream;
	_tmp14_ = string_get_data (buffer, &_tmp14__length1);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	g_output_stream_write_all (_tmp13_, _tmp15_, (gsize) _tmp15__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		return;
	}
	_g_free0 (buffer);
}


static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBCableChannel* channel, GError** error) {
	gchar** _tmp0_ = NULL;
	gchar** elements;
	gint elements_length1;
	gint _elements_size_;
	DVBCableChannel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	DVBCableChannel* _tmp6_;
	DVBDvbSrcInversion _tmp7_;
	DVBDvbSrcInversion _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	DVBCableChannel* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	DVBCableChannel* _tmp16_;
	DVBDvbSrcCodeRate _tmp17_;
	DVBDvbSrcCodeRate _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	DVBCableChannel* _tmp21_;
	DVBDvbSrcModulation _tmp22_;
	DVBDvbSrcModulation _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* buffer;
	GOutputStream* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	guint8* _tmp29_;
	gint _tmp29__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_new0 (gchar*, 5 + 1);
	elements = _tmp0_;
	elements_length1 = 5;
	_elements_size_ = elements_length1;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Frequency ((DVBChannel*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_g_free0 (elements[0]);
	elements[0] = _tmp4_;
	_tmp5_ = elements[0];
	_tmp6_ = channel;
	_tmp7_ = dvb_cable_channel_get_Inversion (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) _tmp8_, "DVB_DVB_SRC_INVERSION_");
	_g_free0 (elements[1]);
	elements[1] = _tmp9_;
	_tmp10_ = elements[1];
	_tmp11_ = channel;
	_tmp12_ = dvb_cable_channel_get_SymbolRate (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%u", _tmp13_ * 1000);
	_g_free0 (elements[2]);
	elements[2] = _tmp14_;
	_tmp15_ = elements[2];
	_tmp16_ = channel;
	_tmp17_ = dvb_cable_channel_get_CodeRate (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp18_, "DVB_DVB_SRC_CODE_RATE_");
	_g_free0 (elements[3]);
	elements[3] = _tmp19_;
	_tmp20_ = elements[3];
	_tmp21_ = channel;
	_tmp22_ = dvb_cable_channel_get_Modulation (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = dvb_io_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) _tmp23_, "DVB_DVB_SRC_MODULATION_");
	_g_free0 (elements[4]);
	elements[4] = _tmp24_;
	_tmp25_ = elements[4];
	_tmp26_ = g_strjoinv (":", elements);
	buffer = _tmp26_;
	_tmp27_ = self->priv->stream;
	_tmp28_ = string_get_data (buffer, &_tmp28__length1);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _tmp28__length1;
	g_output_stream_write_all (_tmp27_, _tmp29_, (gsize) _tmp29__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (buffer);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_free0 (buffer);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* dvb_io_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const gchar* prefix) {
	gchar* result = NULL;
	GType _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* name;
	const gchar* _tmp4_;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = enumtype;
	_tmp1_ = val;
	_tmp2_ = dvb_utils_get_name_by_value_from_enum (_tmp0_, _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp5_ = name;
		_tmp6_ = prefix;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = name;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = prefix;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_substring (_tmp5_, (glong) _tmp8_, (glong) (_tmp11_ - _tmp14_));
		result = _tmp15_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	g_object_notify ((GObject *) self, "file");
}


static void dvb_io_channel_list_writer_class_init (DVBioChannelListWriterClass * klass) {
	dvb_io_channel_list_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_WRITER_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_io_channel_list_writer_instance_init (DVBioChannelListWriter * self) {
	self->priv = DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_writer_finalize (GObject* obj) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (obj);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (dvb_io_channel_list_writer_parent_class)->finalize (obj);
}


/**
     * Example:
     * try {
     *     var writer = new DVB.ChannelListWriter (File.new_for_path ("/path/to/channels.conf"));
     *     foreach (DVB.Channel c in reader.Channels) {
     *         writer.write (c);
     *     }
     *     writer.close ();
     * } catch (IOError e) {
     *     error (e.message);
     * }
     */
GType dvb_io_channel_list_writer_get_type (void) {
	static volatile gsize dvb_io_channel_list_writer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListWriter), 0, (GInstanceInitFunc) dvb_io_channel_list_writer_instance_init, NULL };
		GType dvb_io_channel_list_writer_type_id;
		dvb_io_channel_list_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListWriter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_writer_type_id__volatile, dvb_io_channel_list_writer_type_id);
	}
	return dvb_io_channel_list_writer_type_id__volatile;
}


static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		g_value_set_object (value, dvb_io_channel_list_writer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = DVB_IO_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		dvb_io_channel_list_writer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



