/* IDBusRecordingsStore.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from IDBusRecordingsStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE_PROXY (dvb_id_bus_recordings_store_proxy_get_type ())
typedef GDBusProxy DVBIDBusRecordingsStoreProxy;
typedef GDBusProxyClass DVBIDBusRecordingsStoreProxyClass;

struct _DVBRecordingInfo {
	guint32 id;
	gchar* name;
	gchar* description;
	gint64 length;
	gint64 start_timestamp;
	gchar* channel;
	gchar* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};



GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recordings_store_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
gboolean dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
gboolean dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
gboolean dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
gboolean dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
gboolean dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
gboolean dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
gboolean dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
gboolean dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_recordings_store_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_recordings_store_changed (DVBIDBusRecordingsStore* self, GVariant* parameters);
static guint32* dvb_id_bus_recordings_store_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
static gboolean dvb_id_bus_recordings_store_proxy_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
static void dvb_id_bus_recordings_store_proxy_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface* iface);
static void _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_recordings_store_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_recordings_store_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_recordings_store_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, gpointer* _data);
static void _dvb_id_bus_recordings_store_unregister_object (gpointer user_data);

static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetRecordings = {-1, "GetRecordings", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetRecordings_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_location = {-1, "location", "s"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_location, &_dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetLocation = {-1, "GetLocation", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetLocation_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetName_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetName_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetName_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetName_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetName_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetName_name, &_dvb_id_bus_recordings_store_dbus_arg_info_GetName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetName = {-1, "GetName", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetName_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetName_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_description = {-1, "description", "s"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_description, &_dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetDescription = {-1, "GetDescription", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetDescription_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_start_time = {-1, "start_time", "au"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_start_time, &_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetStartTime = {-1, "GetStartTime", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTime_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_timestamp = {-1, "timestamp", "x"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_timestamp, &_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetStartTimestamp = {-1, "GetStartTimestamp", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetStartTimestamp_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLength_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLength_length = {-1, "length", "x"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetLength_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetLength_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetLength_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetLength_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetLength_length, &_dvb_id_bus_recordings_store_dbus_arg_info_GetLength_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetLength = {-1, "GetLength", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetLength_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetLength_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_Delete_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_Delete_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_Delete_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_Delete_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_Delete_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_Delete_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_Delete = {-1, "Delete", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_Delete_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_Delete_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_name, &_dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetChannelName = {-1, "GetChannelName", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetChannelName_out)};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_infos = {-1, "infos", "(ussxxss)"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_in[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_rec_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_out[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_infos, &_dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recordings_store_dbus_method_info_GetAllInformations = {-1, "GetAllInformations", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_in), (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_GetAllInformations_out)};
static const GDBusMethodInfo * const _dvb_id_bus_recordings_store_dbus_method_info[] = {&_dvb_id_bus_recordings_store_dbus_method_info_GetRecordings, &_dvb_id_bus_recordings_store_dbus_method_info_GetLocation, &_dvb_id_bus_recordings_store_dbus_method_info_GetName, &_dvb_id_bus_recordings_store_dbus_method_info_GetDescription, &_dvb_id_bus_recordings_store_dbus_method_info_GetStartTime, &_dvb_id_bus_recordings_store_dbus_method_info_GetStartTimestamp, &_dvb_id_bus_recordings_store_dbus_method_info_GetLength, &_dvb_id_bus_recordings_store_dbus_method_info_Delete, &_dvb_id_bus_recordings_store_dbus_method_info_GetChannelName, &_dvb_id_bus_recordings_store_dbus_method_info_GetAllInformations, NULL};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_changed_rec_id = {-1, "rec_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recordings_store_dbus_arg_info_changed_type = {-1, "type", "u"};
static const GDBusArgInfo * const _dvb_id_bus_recordings_store_dbus_arg_info_changed[] = {&_dvb_id_bus_recordings_store_dbus_arg_info_changed_rec_id, &_dvb_id_bus_recordings_store_dbus_arg_info_changed_type, NULL};
static const GDBusSignalInfo _dvb_id_bus_recordings_store_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_dvb_id_bus_recordings_store_dbus_arg_info_changed)};
static const GDBusSignalInfo * const _dvb_id_bus_recordings_store_dbus_signal_info[] = {&_dvb_id_bus_recordings_store_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_recordings_store_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_recordings_store_dbus_interface_info = {-1, "org.gnome.DVB.RecordingsStore", (GDBusMethodInfo **) (&_dvb_id_bus_recordings_store_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_recordings_store_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_recordings_store_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_recordings_store_dbus_interface_vtable = {dvb_id_bus_recordings_store_dbus_interface_method_call, dvb_id_bus_recordings_store_dbus_interface_get_property, dvb_id_bus_recordings_store_dbus_interface_set_property};

void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest) {
	guint32 _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
	_tmp3_ = (*self).description;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp4_;
	_tmp5_ = (*self).length;
	(*dest).length = _tmp5_;
	_tmp6_ = (*self).start_timestamp;
	(*dest).start_timestamp = _tmp6_;
	_tmp7_ = (*self).channel;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).channel);
	(*dest).channel = _tmp8_;
	_tmp9_ = (*self).location;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 ((*dest).location);
	(*dest).location = _tmp10_;
}


void dvb_recording_info_destroy (DVBRecordingInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).channel);
	_g_free0 ((*self).location);
}


DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self) {
	DVBRecordingInfo* dup;
	dup = g_new0 (DVBRecordingInfo, 1);
	dvb_recording_info_copy (self, dup);
	return dup;
}


void dvb_recording_info_free (DVBRecordingInfo* self) {
	dvb_recording_info_destroy (self);
	g_free (self);
}


GType dvb_recording_info_get_type (void) {
	static volatile gsize dvb_recording_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recording_info_type_id__volatile)) {
		GType dvb_recording_info_type_id;
		dvb_recording_info_type_id = g_boxed_type_register_static ("DVBRecordingInfo", (GBoxedCopyFunc) dvb_recording_info_dup, (GBoxedFreeFunc) dvb_recording_info_free);
		g_once_init_leave (&dvb_recording_info_type_id__volatile, dvb_recording_info_type_id);
	}
	return dvb_recording_info_type_id__volatile;
}


/**
         * @returns: A list of ids for all recordings
         */
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetRecordings (self, result_length1, error);
}


/**
         * @rec_id: The id of the recording
         * @location: The location of the recording on the filesystem
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLocation (self, rec_id, location, error);
}


/**
         * @rec_id: The id of the recording
         * @name: The name of the recording (e.g. the name of
         * a TV show)
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetName (self, rec_id, name, error);
}


/**
         * @rec_id: The id of the recording
         * @description: A short text describing the recorded item
         * (e.g. the description from EPG)
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetDescription (self, rec_id, description, error);
}


/**
         * @rec_id: The id of the recording
         * @start_time: The starting time of the recording
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTime (self, rec_id, start_time, start_time_length1, error);
}


/**
         * @rec_id: The id of the recording
         * @timestamp: Start time as UNIX timestamp
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTimestamp (self, rec_id, timestamp, error);
}


/**
         * @rec_id: The id of the recording
         * @length: The length of the recording in seconds
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLength (self, rec_id, length, error);
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->Delete (self, rec_id, error);
}


/**
         * @rec_id: The id of the recording
         * @name: The channel's name or an empty string if
         * rec_id doesn't exist
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetChannelName (self, rec_id, name, error);
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success
         *
         * This method can be used to retrieve all informations
         * about a particular recording at once
         */
gboolean dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetAllInformations (self, rec_id, infos, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void dvb_id_bus_recordings_store_base_init (DVBIDBusRecordingsStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		         * @type: 0: added, 1: deleted, 2: updated
		         */
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDINGS_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	}
}


GType dvb_id_bus_recordings_store_get_type (void) {
	static volatile gsize dvb_id_bus_recordings_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_recordings_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecordingsStoreIface), (GBaseInitFunc) dvb_id_bus_recordings_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_recordings_store_type_id;
		dvb_id_bus_recordings_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecordingsStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recordings_store_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_recordings_store_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_recordings_store_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_recordings_store_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.RecordingsStore");
		g_type_set_qdata (dvb_id_bus_recordings_store_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_recordings_store_register_object);
		g_once_init_leave (&dvb_id_bus_recordings_store_type_id__volatile, dvb_id_bus_recordings_store_type_id);
	}
	return dvb_id_bus_recordings_store_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecordingsStoreProxy, dvb_id_bus_recordings_store_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDINGS_STORE, dvb_id_bus_recordings_store_proxy_dvb_id_bus_recordings_store_interface_init) )
static void dvb_id_bus_recordings_store_proxy_class_init (DVBIDBusRecordingsStoreProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_recordings_store_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_recordings_store_changed (DVBIDBusRecordingsStore* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp289_;
	guint type = 0U;
	GVariant* _tmp290_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp289_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp289_);
	g_variant_unref (_tmp289_);
	_tmp290_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp290_);
	g_variant_unref (_tmp290_);
	g_signal_emit_by_name (self, "changed", rec_id, type);
}


static void dvb_id_bus_recordings_store_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_dvb_id_bus_recordings_store_changed ((DVBIDBusRecordingsStore*) proxy, parameters);
	}
}


static void dvb_id_bus_recordings_store_proxy_init (DVBIDBusRecordingsStoreProxy* self) {
}


static guint32* dvb_id_bus_recordings_store_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32* _result;
	int _result_length1;
	GVariant* _tmp291_;
	guint32* _tmp292_;
	int _tmp292__length;
	int _tmp292__size;
	int _tmp292__length1;
	GVariantIter _tmp293_;
	GVariant* _tmp294_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetRecordings");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp291_ = g_variant_iter_next_value (&_reply_iter);
	_tmp292_ = g_new (guint32, 5);
	_tmp292__length = 0;
	_tmp292__size = 4;
	_tmp292__length1 = 0;
	g_variant_iter_init (&_tmp293_, _tmp291_);
	for (; (_tmp294_ = g_variant_iter_next_value (&_tmp293_)) != NULL; _tmp292__length1++) {
		if (_tmp292__size == _tmp292__length) {
			_tmp292__size = 2 * _tmp292__size;
			_tmp292_ = g_renew (guint32, _tmp292_, _tmp292__size + 1);
		}
		_tmp292_[_tmp292__length++] = g_variant_get_uint32 (_tmp294_);
		g_variant_unref (_tmp294_);
	}
	_result_length1 = _tmp292__length1;
	_result = _tmp292_;
	g_variant_unref (_tmp291_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_location;
	GVariant* _tmp295_;
	gboolean _result;
	GVariant* _tmp296_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetLocation");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp295_ = g_variant_iter_next_value (&_reply_iter);
	_vala_location = g_variant_dup_string (_tmp295_, NULL);
	g_variant_unref (_tmp295_);
	*location = _vala_location;
	_tmp296_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp296_);
	g_variant_unref (_tmp296_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_name;
	GVariant* _tmp297_;
	gboolean _result;
	GVariant* _tmp298_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp297_ = g_variant_iter_next_value (&_reply_iter);
	_vala_name = g_variant_dup_string (_tmp297_, NULL);
	g_variant_unref (_tmp297_);
	*name = _vala_name;
	_tmp298_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp298_);
	g_variant_unref (_tmp298_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_description;
	GVariant* _tmp299_;
	gboolean _result;
	GVariant* _tmp300_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetDescription");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp299_ = g_variant_iter_next_value (&_reply_iter);
	_vala_description = g_variant_dup_string (_tmp299_, NULL);
	g_variant_unref (_tmp299_);
	*description = _vala_description;
	_tmp300_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp300_);
	g_variant_unref (_tmp300_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _vala_start_time;
	int _vala_start_time_length1;
	GVariant* _tmp301_;
	guint* _tmp302_;
	int _tmp302__length;
	int _tmp302__size;
	int _tmp302__length1;
	GVariantIter _tmp303_;
	GVariant* _tmp304_;
	gboolean _result;
	GVariant* _tmp305_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetStartTime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_start_time_length1 = 0;
	_tmp301_ = g_variant_iter_next_value (&_reply_iter);
	_tmp302_ = g_new (guint, 5);
	_tmp302__length = 0;
	_tmp302__size = 4;
	_tmp302__length1 = 0;
	g_variant_iter_init (&_tmp303_, _tmp301_);
	for (; (_tmp304_ = g_variant_iter_next_value (&_tmp303_)) != NULL; _tmp302__length1++) {
		if (_tmp302__size == _tmp302__length) {
			_tmp302__size = 2 * _tmp302__size;
			_tmp302_ = g_renew (guint, _tmp302_, _tmp302__size + 1);
		}
		_tmp302_[_tmp302__length++] = g_variant_get_uint32 (_tmp304_);
		g_variant_unref (_tmp304_);
	}
	_vala_start_time_length1 = _tmp302__length1;
	_vala_start_time = _tmp302_;
	g_variant_unref (_tmp301_);
	*start_time = _vala_start_time;
	*start_time_length1 = _vala_start_time_length1;
	_tmp305_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp305_);
	g_variant_unref (_tmp305_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint64 _vala_timestamp;
	GVariant* _tmp306_;
	gboolean _result;
	GVariant* _tmp307_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetStartTimestamp");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp306_ = g_variant_iter_next_value (&_reply_iter);
	_vala_timestamp = g_variant_get_int64 (_tmp306_);
	g_variant_unref (_tmp306_);
	*timestamp = _vala_timestamp;
	_tmp307_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp307_);
	g_variant_unref (_tmp307_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint64 _vala_length;
	GVariant* _tmp308_;
	gboolean _result;
	GVariant* _tmp309_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetLength");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp308_ = g_variant_iter_next_value (&_reply_iter);
	_vala_length = g_variant_get_int64 (_tmp308_);
	g_variant_unref (_tmp308_);
	*length = _vala_length;
	_tmp309_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp309_);
	g_variant_unref (_tmp309_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp310_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "Delete");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp310_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp310_);
	g_variant_unref (_tmp310_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetChannelName (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_name;
	GVariant* _tmp311_;
	gboolean _result;
	GVariant* _tmp312_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetChannelName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp311_ = g_variant_iter_next_value (&_reply_iter);
	_vala_name = g_variant_dup_string (_tmp311_, NULL);
	g_variant_unref (_tmp311_);
	*name = _vala_name;
	_tmp312_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp312_);
	g_variant_unref (_tmp312_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_proxy_GetAllInformations (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBRecordingInfo _vala_infos;
	GVariant* _tmp313_;
	DVBRecordingInfo _tmp314_;
	GVariantIter _tmp315_;
	GVariant* _tmp316_;
	GVariant* _tmp317_;
	GVariant* _tmp318_;
	GVariant* _tmp319_;
	GVariant* _tmp320_;
	GVariant* _tmp321_;
	GVariant* _tmp322_;
	gboolean _result;
	GVariant* _tmp323_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.RecordingsStore", "GetAllInformations");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp313_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp315_, _tmp313_);
	_tmp316_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.id = g_variant_get_uint32 (_tmp316_);
	g_variant_unref (_tmp316_);
	_tmp317_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.name = g_variant_dup_string (_tmp317_, NULL);
	g_variant_unref (_tmp317_);
	_tmp318_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.description = g_variant_dup_string (_tmp318_, NULL);
	g_variant_unref (_tmp318_);
	_tmp319_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.length = g_variant_get_int64 (_tmp319_);
	g_variant_unref (_tmp319_);
	_tmp320_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.start_timestamp = g_variant_get_int64 (_tmp320_);
	g_variant_unref (_tmp320_);
	_tmp321_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.channel = g_variant_dup_string (_tmp321_, NULL);
	g_variant_unref (_tmp321_);
	_tmp322_ = g_variant_iter_next_value (&_tmp315_);
	_tmp314_.location = g_variant_dup_string (_tmp322_, NULL);
	g_variant_unref (_tmp322_);
	_vala_infos = _tmp314_;
	g_variant_unref (_tmp313_);
	*infos = _vala_infos;
	_tmp323_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp323_);
	g_variant_unref (_tmp323_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_recordings_store_proxy_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface* iface) {
	iface->GetRecordings = dvb_id_bus_recordings_store_proxy_GetRecordings;
	iface->GetLocation = dvb_id_bus_recordings_store_proxy_GetLocation;
	iface->GetName = dvb_id_bus_recordings_store_proxy_GetName;
	iface->GetDescription = dvb_id_bus_recordings_store_proxy_GetDescription;
	iface->GetStartTime = dvb_id_bus_recordings_store_proxy_GetStartTime;
	iface->GetStartTimestamp = dvb_id_bus_recordings_store_proxy_GetStartTimestamp;
	iface->GetLength = dvb_id_bus_recordings_store_proxy_GetLength;
	iface->Delete = dvb_id_bus_recordings_store_proxy_Delete;
	iface->GetChannelName = dvb_id_bus_recordings_store_proxy_GetChannelName;
	iface->GetAllInformations = dvb_id_bus_recordings_store_proxy_GetAllInformations;
}


static void _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32* result;
	int result_length1 = 0;
	guint32* _tmp324_;
	GVariantBuilder _tmp325_;
	int _tmp326_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_recordings_store_GetRecordings (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp324_ = result;
	g_variant_builder_init (&_tmp325_, G_VARIANT_TYPE ("au"));
	for (_tmp326_ = 0; _tmp326_ < result_length1; _tmp326_++) {
		g_variant_builder_add_value (&_tmp325_, g_variant_new_uint32 (*_tmp324_));
		_tmp324_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp325_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp327_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* location = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp327_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp327_);
	g_variant_unref (_tmp327_);
	result = dvb_id_bus_recordings_store_GetLocation (self, rec_id, &location, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (location));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (location);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp328_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp328_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp328_);
	g_variant_unref (_tmp328_);
	result = dvb_id_bus_recordings_store_GetName (self, rec_id, &name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp329_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* description = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp329_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp329_);
	g_variant_unref (_tmp329_);
	result = dvb_id_bus_recordings_store_GetDescription (self, rec_id, &description, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (description));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (description);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp330_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* start_time = NULL;
	int start_time_length1 = 0;
	guint* _tmp331_;
	GVariantBuilder _tmp332_;
	int _tmp333_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp330_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp330_);
	g_variant_unref (_tmp330_);
	result = dvb_id_bus_recordings_store_GetStartTime (self, rec_id, &start_time, &start_time_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp331_ = start_time;
	g_variant_builder_init (&_tmp332_, G_VARIANT_TYPE ("au"));
	for (_tmp333_ = 0; _tmp333_ < start_time_length1; _tmp333_++) {
		g_variant_builder_add_value (&_tmp332_, g_variant_new_uint32 (*_tmp331_));
		_tmp331_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp332_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	start_time = (g_free (start_time), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp334_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint64 timestamp = 0LL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp334_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp334_);
	g_variant_unref (_tmp334_);
	result = dvb_id_bus_recordings_store_GetStartTimestamp (self, rec_id, &timestamp, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int64 (timestamp));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp335_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint64 length = 0LL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp335_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp335_);
	g_variant_unref (_tmp335_);
	result = dvb_id_bus_recordings_store_GetLength (self, rec_id, &length, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int64 (length));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp336_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp336_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp336_);
	g_variant_unref (_tmp336_);
	result = dvb_id_bus_recordings_store_Delete (self, rec_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetChannelName (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp337_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp337_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp337_);
	g_variant_unref (_tmp337_);
	result = dvb_id_bus_recordings_store_GetChannelName (self, rec_id, &name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recordings_store_GetAllInformations (DVBIDBusRecordingsStore* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 rec_id = 0U;
	GVariant* _tmp338_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBRecordingInfo infos = {0};
	GVariantBuilder _tmp339_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp338_ = g_variant_iter_next_value (&_arguments_iter);
	rec_id = g_variant_get_uint32 (_tmp338_);
	g_variant_unref (_tmp338_);
	result = dvb_id_bus_recordings_store_GetAllInformations (self, rec_id, &infos, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp339_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp339_, g_variant_new_uint32 (infos.id));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_string (infos.name));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_string (infos.description));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_int64 (infos.length));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_int64 (infos.start_timestamp));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_string (infos.channel));
	g_variant_builder_add_value (&_tmp339_, g_variant_new_string (infos.location));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp339_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	dvb_recording_info_destroy (&infos);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_recordings_store_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetRecordings") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetRecordings (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLocation") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetLocation (object, parameters, invocation);
	} else if (strcmp (method_name, "GetName") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDescription") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetDescription (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStartTime") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetStartTime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStartTimestamp") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetStartTimestamp (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLength") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetLength (object, parameters, invocation);
	} else if (strcmp (method_name, "Delete") == 0) {
		_dbus_dvb_id_bus_recordings_store_Delete (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelName") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetChannelName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetAllInformations") == 0) {
		_dbus_dvb_id_bus_recordings_store_GetAllInformations (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_recordings_store_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_recordings_store_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (rec_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.RecordingsStore", "Changed", _arguments, NULL);
}


guint dvb_id_bus_recordings_store_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_recordings_store_dbus_interface_info), &_dvb_id_bus_recordings_store_dbus_interface_vtable, data, _dvb_id_bus_recordings_store_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recordings_store_changed, data);
	return result;
}


static void _dvb_id_bus_recordings_store_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_recordings_store_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



