/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


static void
on_close (GtkButton *button, GtkWidget *dialog)
{
	gtk_widget_hide (dialog);
}


GtkWidget*
gnome_cmd_file_props_dialog_create (GnomeCmdFile *finfo)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *hbox1;
	GtkWidget *pixmap5;
	GtkWidget *table1;
	GtkWidget *filename;	
	GtkWidget *type;
	GtkWidget *mime;
	GtkWidget *owner;
	GtkWidget *group;
	GtkWidget *date;
	GtkWidget *size;
	GtkWidget *perm;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *label8;
	GtkWidget *label13;
	GtkWidget *label14;
	GtkWidget *label15;
	GtkWidget *label16;
	GtkWidget *close_button;


	dialog = gnome_dialog_new (_("File properties..."), NULL);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog", dialog);

	dialog_vbox1 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	hbox1 = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "hbox1", hbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox1, TRUE, TRUE, 0);

	
	pixmap5 = create_pixmap (dialog, NULL, FALSE);
	gtk_widget_ref (pixmap5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap5", pixmap5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap5);
	gtk_box_pack_start (GTK_BOX (hbox1), pixmap5, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (pixmap5), 0.5, 0.1);

	gtk_pixmap_set (GTK_PIXMAP (pixmap5),
					gnome_cmd_file_get_type_pixmap_big (finfo),
					gnome_cmd_file_get_type_mask_big (finfo));

	
	table1 = gtk_table_new (6, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table1", table1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (hbox1), table1, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 20);


	
	label5 = gtk_label_new (_("filename"));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label5", label5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

	label6 = gtk_label_new (_("type"));
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label6", label6,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);
	
	label16 = gtk_label_new (_("mime-type"));
	gtk_widget_ref (label16);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label16", label16,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label16);
	gtk_table_attach (GTK_TABLE (table1), label16, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label16), 0, 0.5);
	
	label7 = gtk_label_new (_("owner"));
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label7", label7,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_table_attach (GTK_TABLE (table1), label7, 0, 1, 3, 4,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

	label8 = gtk_label_new (_("group"));
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label8", label8,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_table_attach (GTK_TABLE (table1), label8, 0, 1, 4, 5,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

	label13 = gtk_label_new (_("date"));
	gtk_widget_ref (label13);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label13", label13,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label13);
	gtk_table_attach (GTK_TABLE (table1), label13, 0, 1, 5, 6,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);

	label14 = gtk_label_new (_("size"));
	gtk_widget_ref (label14);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label14", label14,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label14);
	gtk_table_attach (GTK_TABLE (table1), label14, 0, 1, 6, 7,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label14), 0, 0.5);

	label15 = gtk_label_new (_("permissions"));
	gtk_widget_ref (label15);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label15", label15,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label15);
	gtk_table_attach (GTK_TABLE (table1), label15, 0, 1, 7, 8,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label15), 0, 0.5);


	
	filename = gtk_label_new (gnome_cmd_file_get_name (finfo));
	gtk_widget_ref (filename);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "filename", filename,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (filename);
	gtk_table_attach (GTK_TABLE (table1), filename, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (filename), 0, 0.5);

	type = gtk_label_new (gnome_cmd_file_get_type_desc (finfo));
	gtk_widget_ref (type);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "type", type,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (type);
	gtk_table_attach (GTK_TABLE (table1), type, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (type), 0, 0.5);
	
	mime = gtk_label_new (gnome_cmd_file_get_mime_type (finfo));
	gtk_widget_ref (mime);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "mime", mime,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mime);
	gtk_table_attach (GTK_TABLE (table1), mime, 1, 2, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (mime), 0, 0.5);
	
	owner = gtk_label_new (gnome_cmd_file_get_owner (finfo));
	gtk_widget_ref (owner);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "owner", owner,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (owner);
	gtk_table_attach (GTK_TABLE (table1), owner, 1, 2, 3, 4,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (owner), 0, 0.5);

	group = gtk_label_new (gnome_cmd_file_get_group (finfo));
	gtk_widget_ref (group);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "group", group,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (group);
	gtk_table_attach (GTK_TABLE (table1), group, 1, 2, 4, 5,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (group), 0, 0.5);

	date = gtk_label_new (gnome_cmd_file_get_date (finfo));
	gtk_widget_ref (date);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "date", date,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (date);
	gtk_table_attach (GTK_TABLE (table1), date, 1, 2, 5, 6,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (date), 0, 0.5);

	size = gtk_label_new (gnome_cmd_file_get_size (finfo));
	gtk_widget_ref (size);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "size", size,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (size);
	gtk_table_attach (GTK_TABLE (table1), size, 1, 2, 6, 7,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (size), 0, 0.5);

	perm = gtk_label_new (gnome_cmd_file_get_perm (finfo));
	gtk_widget_ref (perm);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "perm", perm,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (perm);
	gtk_table_attach (GTK_TABLE (table1), perm, 1, 2, 7, 8,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (perm), 0, 0.5);


	
	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CLOSE);
	close_button = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog)->buttons)->data);
	gtk_widget_ref (close_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "close_button", close_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);


	gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
						GTK_SIGNAL_FUNC (on_close), dialog);

	return dialog;
}

