------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2007 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: dbind.adb,v 1.5 2007/10/22 14:02:27 vagul Exp $

--  Example of using dynamically allocated bind variables.

with Ada.Text_IO;

with OCI.Thick.Statements;
with OCI.Thick.Strings;

procedure DBind is

   use OCI.Thick;
   use OCI.Thick.Statements;
   use OCI.Thick.Strings;

   Stmt : Statement := Prepare
        ("begin if false then :result1 := nvl(:result1, 'eeeeeeeeeeeee');"
       & " end if;"
       & " end;");

   Result1 : Var_Type;
   Binded  : Boolean;

begin
   Bind (Stmt, Result1, "result1", Binded);

   Ada.Text_IO.Put_Line ("binded " & Boolean'Image (Binded));

   Bind (Stmt, Result1, "result2", Binded);

   Ada.Text_IO.Put_Line ("binded " & Boolean'Image (Binded));
end DBind;
