with Ada.Containers.Hashed_Maps;
with Ada.Strings.Bounded.Hash;
limited with OCI.Thick.DB;

package OCI.Thick.Containers.Strings is

   type Container_Type is new Containers.Container_Type with private;

   procedure Name_Bind_Positions
     (Container : in out Container_Type; Statement : in DB.Statement);
   --  Initialise container bind name index from DB module.

   procedure Name_Define_Positions
     (Container : in out Container_Type; Statement : in DB.Statement);
   --  Initialise container define name index from DB module.
   --  Use this routine only if select statement do not have case insensitive
   --  quoted oracle column names and do not have duplicated column names.

   function Index
     (Container : in Container_Type; Name : in String) return Natural;
   --  Returns index of the name in container.
   --  Return 0 if name does not found.

   procedure Clear
     (Container : in out Container_Type;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Clear);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Data_Holder;
      Name      : in     String;
      Iteration : in     Positive := 1);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Integer;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Long_Float;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     String;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     OCINumber;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Ada.Calendar.Time;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Lobs.Locator;
      Name      : in     String;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   function Is_Null
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Boolean;

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Data_Holder;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Integer;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Long_Float;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return String;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return OCINumber;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Ada.Calendar.Time;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in String;
      Iteration : in Positive := 1) return Lobs.Locator;
   pragma Inline (Get);

   procedure Get
     (Container : in     Container_Type;
      Item      :    out Data_Holder;
      Name      : in     String;
      Iteration : in     Positive := 1);

private

   function Bounded_Hash is new Ada.Strings.Bounded.Hash (Bind_Names);

   package Name_Indexes is new Ada.Containers.Hashed_Maps
     (Key_Type        => Bind_Names.Bounded_String,
      Hash            => Bounded_Hash,
      Element_Type    => Positive,
      Equivalent_Keys => Bind_Names."=");

   type Container_Type is new Containers.Container_Type with record
      Index : Name_Indexes.Map;
   end record;

end OCI.Thick.Containers.Strings;
