-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/Makefile
--  Description     : Monetary accounts                                      --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Text_IO;			use Ada.Text_IO;
with TAM.Persistent;			use TAM.Persistent;

with Objects;				use Objects;

package body Account is

   ------------
   -- Create --
   ------------
   procedure Create(
      Owner : in Persistent.Object'Class;
      Title : in String;
      Value : in Integer := 0) is
      Acc   : Account.Object;
   begin
      Acc.Title := To_Unbounded_String( Title );
      Acc.Ballance := Value;
      Put_Object( Acc );

      Relate( Owner, Acc, "Has_Account" );
   end Create;


   -----------
   -- Query --
   -----------
   procedure Query(
      This   : in out Object;
      Owner  : in Persistent.Object'Class;
      Title  : in Unbounded_String ) is

      Acct   : OID_Array_Type( 1..100 );
      Length : Integer := 0;
      Found  : Boolean := False;
   begin
      Get_Related( OID(Owner), "Has_Account", Acct, Length );
      for i in 1..Length loop
         declare
            A : Account.Object;
         begin
            Get_Object(A, ID => Acct(i));

            Found := A.Title = Title;
            if Found then
               This := A;
               exit;
            end if;
         end ;
      end loop;

      if not Found then
         raise Not_Existing;
      end if;

   end Query;

   -------------
   -- Display --
   -------------
   procedure Display(
      Acct  : in Object ) is
   begin
      Put_Line( To_String( Acct.Title ) & " : " & Integer'Image( Acct.Ballance ) );
   end Display;

end Account;
