------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_bounded.adb,v 1.10 2004/04/20 09:02:55 vagul Exp $

with OCI.Lib, OCI.Thread;

package body OCI.Thick.String_Bounded is

   use Lib;

   procedure Bind
     (Stmt  : in     Statement;
      Value : in out Variable;
      Name  : in     String)
   is
      Rc : SWord := OCIBindByName
                  (stmtp       => OCIStmt (Handle (Stmt)),
                   bindpp      => Value.Bind'Access,
                   errhp       => Thread.Error,
                   placeholder => C.To_C (Name),
                   placeh_len  => Name'Length,
                   valuep      => Value.Value'Address,
                   value_sz    => Value.Value'Length,
                   dty         => SQLT_STR,
                   indp        => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive)
   is
      Rc : SWord := OCIBindByPos
                  (stmtp    => OCIStmt (Handle (Stmt)),
                   bindpp   => Value.Bind'Access,
                   errhp    => Thread.Error,
                   Position => Ub4 (Position),
                   valuep   => Value.Value'Address,
                   value_sz => Value.Value'Length,
                   dty      => SQLT_STR,
                   indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive)
   is
      Rc : SWord := OCIDefineByPos
                  (stmtp => OCIStmt (Handle (Stmt)),
                   defnpp => Value.Define'Access,
                   errhp => Thread.Error,
                   position => Ub4 (Position),
                   value => Value.Value'Address,
                   value_sz => Value.Value'Length,
                   dty => SQLT_STR,
                   indp => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Define;

   ---------------
   -- Get_Value --
   ---------------

   function Get_Value (Var : Variable) return String is
   begin
      if Is_Null (Var) then
         raise Null_Value;
      else
         return C.To_Ada (Var.Value);
      end if;
   end Get_Value;

   function Get_Value
     (Var     : in Variable;
      Default : in String;
      Mode    : in Default_Mode := Instead_Any)
      return  String is
   begin
      if not Is_Attached (Var) then
         if Mode = Instead_Not_Attached or Mode = Instead_Any then
            return Default;
         else
            raise Not_Attached;
         end if;

      elsif Is_Null (Var) then
         if Mode = Instead_Null or Mode = Instead_Any then
            return Default;
         else
            raise Null_Value;
         end if;

      else
         return C.To_Ada (Var.Value);
      end if;
   end Get_Value;

   ---------------
   -- Set_Value --
   ---------------

   procedure Set_Value (Var : in out Variable; Value : String) is
      Len : String_Size;
      use type String_Size;
   begin
      if Value'Length > Var.Length then
         raise Constraint_Error;
      end if;

      Var.Indicator := 0;

      C.To_C
        (Item       => Value,
         Target     => Var.Value,
         Count      => Len,
         Append_Nul => True);
   end Set_Value;

end OCI.Thick.String_Bounded;
