.TH GMTSTITCH GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
gmtstitch \- Join line segments whose end points match within tolerance
.SH SYNOPSIS
\fBgmtstitc\fP \fIinfiles\fP [ \fB\-D\fP[\fItemplate\fP] ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] 
[ \fB\-T\fP\fIcutoff\fP[\fBm\fP|\fBc\fP|\fBk\fP|\fBK\fP] ] [ \fB\-V\fP ] 
[ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBgmtstitch\fP reads one or more data files (which may be multisegment files; see \fB\-M\fP)
and examines the coordinates of the end points of all line segments.  If a pair of end points
are identical or closer to each other than the specified separation tolerance then the
two line segments are joined into a single segment.  The process repeats until all the
remaining endpoints no longer pass the tolerance test; the resulting segments are then
written out to standard output.
.TP
\fIfile(s)\fP
One of more data files.  If none are supplied then we read standard input.
.SH OPTIONS
.TP
.B \-D
For multiple segment data, dump each segment to a separate output file [Default writes a multiple segment
file to stdout].  Append a format template for the individual file names; this template \fBmust\fP contain a
C format specifier that can format an integer argument (the segment number); this is usually %d but could
be %8.8d which gives leading zeros, etc. [Default is gmtstitch_segment_%d.d].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-T
Specifies the separation tolerance in the data coordinate units [0].  
Append \fBm\fP or \fBc\fP for minutes or seconds, \fBk\fP for km (implies \fB\-fg\fP and
use flat Earth approximation, or \fBK\fP for km (implies -fg, and use exact geodesic distances.
If the current ELLIPSOID is Sphere then spherical great circle distances are used.
If two lines has endpoints that are closer than this cutoff they will be joined.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
.sp
To combine the digitized multisegment lines segment_*.d (whose coordinates are in cm)
into as few complete lines as possible,
assuming the end points slop could be up to 0.1 mm, run
.br
.sp
\fBgmtstitch\fP segment_*.d \fB\-Tf\fP0.1 \fB\-M\fP > new_segments.d
.br
.sp
To combine the digitized segments in the multisegment file my_lines.d (whose coordinates are in lon,lat)
into as few complete lines as possible, assuming the end points slop could be up to 150 m, and write
the complete segments to separate files called Map_segment_0001.dat,  Map_segment_0002.dat, etc., run
.sp
\fBgmtstitch\fP my_lines.d \fB\-Tf\fP0.15k \fB\-M\fP \fB\-D\fPMap_segment_%4.4d.dat
.sp
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION),
.IR mapproject (GMTMANSECTION)
