// Gmsh - Copyright (C) 1997-2009 C. Geuzaine, J.-F. Remacle
//
// See the LICENSE.txt file for license information. Please report all
// bugs and problems to <gmsh@geuz.org>.

#include "Gauss.h"
#include "GaussLegendre1D.h"

/* constants for 4-point rule */
#define  a4  0.5854101966249685
#define  b4  0.138196601125015

/* constants for 5-point rule */
#define  a5  0.500000000000000
#define  b5  0.166666666666667

/* constants for 16-point rule */
#define  a16  0.00839563235002047
#define  b16  0.0110903447722154
#define  c16  0.7716429020672371
#define  d16  0.0761190326442543
#define  e16  0.1197005277978019
#define  f16  0.0718316452676693
#define  g16  0.4042339134672644

/* constants for 17-p9oint rule */
#define  a17  0.0314030927894235
#define  b17  0.0111730972876738
#define  c17  0.00754759872721232
#define  p17  0.7316369079576180
#define  q17  0.0894543640141273
#define  e17  0.1325810999384657
#define  f17  0.0245400397290300
#define  g17  0.4214394310662522

/* constants for 29-point rule */
#define  a29  0.0150668817433579
#define  b29  0.00318663904649853
#define  c29  0.00726915640111095
#define  d29  0.00430194599366527
#define  p29  0.8277192480479295
#define  q29  0.0574269173173568
#define  e29  0.0513518841255634
#define  f29  0.4860510285706072
#define  g29  0.2312985436519147
#define  h29  0.2967538129690260
#define  i29  0.6081079894015281
#define  j29  0.0475690988147229

IntPt GQTet1[1] = {
  {{.25, .25, .25}, 0.166666666666667}
};

IntPt GQTet2[4] = {
  { {a4, b4, b4}, 0.0416666666666667},
  { {b4, a4, b4}, 0.0416666666666667},
  { {b4, b4, a4}, 0.0416666666666667},
  { {b4, b4, b4}, 0.0416666666666667}
};

IntPt GQTet3[5] = {
  {{0.25, 0.25, 0.25}, -0.133333333333333},
  {{a5, b5, b5}, 0.075},
  {{b5, a5, b5}, 0.075},
  {{b5, b5, a5}, 0.075},
  {{b5, b5, b5}, 0.075}
};

IntPt GQTet4[16] = {
  {{c16, d16, d16}, a16},
  {{d16, c16, d16}, a16},
  {{d16, d16, c16}, a16},
  {{d16, d16, d16}, a16},
  {{e16, f16, g16}, b16},
  {{f16, e16, g16}, b16},
  {{e16, g16, g16}, b16},
  {{f16, g16, g16}, b16},
  {{g16, g16, e16}, b16},
  {{g16, g16, f16}, b16},
  {{g16, e16, f16}, b16},
  {{g16, f16, e16}, b16},
  {{e16, g16, f16}, b16},
  {{f16, g16, e16}, b16},
  {{g16, e16, g16}, b16},
  {{g16, f16, g16}, b16}
};

IntPt GQTet5[17] = {
  {{0.25, 0.25, 0.25}, a17},
  {{p17, q17, q17}, b17},
  {{q17, p17, q17}, b17},
  {{q17, q17, p17}, b17},
  {{q17, q17, q17}, b17},
  {{e17, f17, g17}, c17},
  {{f17, e17, g17}, c17},
  {{e17, g17, g17}, c17},
  {{f17, g17, g17}, c17},
  {{g17, g17, e17}, c17},
  {{g17, g17, f17}, c17},
  {{g17, e17, f17}, c17},
  {{g17, f17, e17}, c17},
  {{e17, g17, f17}, c17},
  {{f17, g17, e17}, c17},
  {{g17, e17, g17}, c17},
  {{g17, f17, g17}, c17}
};

IntPt GQTet6[29] = {
  {{0.25, 0.25, 0.25}, a29},
  {{p29, q29, q29}, b29},
  {{q29, p29, q29}, b29},
  {{q29, q29, p29}, b29},
  {{q29, q29, q29}, b29},
  {{e29, f29, g29}, c29},
  {{f29, e29, g29}, c29},
  {{e29, g29, g29}, c29},
  {{f29, g29, g29}, c29},
  {{g29, g29, e29}, c29},
  {{g29, g29, f29}, c29},
  {{g29, e29, f29}, c29},
  {{g29, f29, e29}, c29},
  {{e29, g29, f29}, c29},
  {{f29, g29, e29}, c29},
  {{g29, e29, g29}, c29},
  {{g29, f29, g29}, c29},
  {{h29, i29, j29}, d29},
  {{i29, h29, j29}, d29},
  {{h29, j29, j29}, d29},
  {{i29, j29, j29}, d29},
  {{j29, j29, h29}, d29},
  {{j29, j29, i29}, d29},
  {{j29, h29, i29}, d29},
  {{j29, i29, h29}, d29},
  {{h29, j29, i29}, d29},
  {{i29, j29, h29}, d29},
  {{j29, h29, j29}, d29},
  {{j29, i29, j29}, d29}
};


IntPt * GQTet[7] = {GQTet1,GQTet1,GQTet2,GQTet3,GQTet4,GQTet5,GQTet6};
IntPt * GQTetDegen[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int GQTetnPt[7] = {1,1,4,5,16,17,29};

// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 1 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP1Solin[1] = {
  {{0.25, 0.25, 0.25}, 0.166666666666667}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1/6

// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 2 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP2Solin[4] = {
  {{0.138196601125, 0.138196601125, 0.138196601125}, 0.0416666666666667},
  {{0.585410196625, 0.138196601125, 0.138196601125}, 0.0416666666666667},
  {{0.138196601125, 0.585410196625, 0.138196601125}, 0.0416666666666667},
  {{0.138196601125, 0.138196601125, 0.585410196625}, 0.0416666666666667}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1/6

// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 3 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP3Solin[5] = {
  {{0.250000000000, 0.250000000000, 0.250000000000}, -0.133333333333333},
  {{0.166666666667, 0.166666666667, 0.166666666667}, +0.075000000000000},
  {{0.166666666667, 0.166666666667, 0.500000000000}, +0.075000000000000},
  {{0.166666666667, 0.500000000000, 0.166666666667}, +0.075000000000000},
  {{0.500000000000, 0.166666666667, 0.166666666667}, +0.075000000000000}
};

// 1 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1/6

// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 4 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP4Solin[11] = {
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.0131555555555},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, +0.0076222222222},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, +0.0076222222222},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, +0.0076222222222},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, +0.0076222222222},
  {{0.3994035761670, 0.3994035761670, 0.1005964238330}, +0.0248888888888},
  {{0.3994035761670, 0.1005964238330, 0.3994035761670}, +0.0248888888888},
  {{0.1005964238330, 0.3994035761670, 0.3994035761670}, +0.0248888888888},
  {{0.3994035761670, 0.1005964238330, 0.1005964238330}, +0.0248888888888},
  {{0.1005964238330, 0.3994035761670, 0.1005964238330}, +0.0248888888888},
  {{0.1005964238330, 0.1005964238330, 0.3994035761670}, +0.0248888888888}
};

// 1 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1/6


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 5 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP5Solin[14] = {
  {{0.0927352503109, 0.0927352503109, 0.0927352503109}, 0.01224884051940},
  {{0.7217942490670, 0.0927352503109, 0.0927352503109}, 0.01224884051940},
  {{0.0927352503109, 0.7217942490670, 0.0927352503109}, 0.01224884051940},
  {{0.0927352503109, 0.0927352503109, 0.7217942490670}, 0.01224884051940},
  {{0.3108859192630, 0.3108859192630, 0.3108859192630}, 0.01878132095300},
  {{0.0673422422101, 0.3108859192630, 0.3108859192630}, 0.01878132095300},
  {{0.3108859192630, 0.0673422422101, 0.3108859192630}, 0.01878132095300},
  {{0.3108859192630, 0.3108859192630, 0.0673422422101}, 0.01878132095300},
  {{0.4544962958740, 0.4544962958740, 0.0455037041256}, 0.00709100346285},
  {{0.4544962958740, 0.0455037041256, 0.4544962958740}, 0.00709100346285},
  {{0.0455037041256, 0.4544962958740, 0.4544962958740}, 0.00709100346285},
  {{0.4544962958740, 0.0455037041256, 0.0455037041256}, 0.00709100346285},
  {{0.0455037041256, 0.4544962958740, 0.0455037041256}, 0.00709100346285},
  {{0.0455037041256, 0.0455037041256, 0.4544962958740}, 0.00709100346285}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 6 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP6Solin[24] = {
  {{0.2146028712590, 0.2146028712590, 0.2146028712590}, 0.006653791709700},
  {{0.3561913862230, 0.2146028712590, 0.2146028712590}, 0.006653791709700},
  {{0.2146028712590, 0.3561913862230, 0.2146028712590}, 0.006653791709700},
  {{0.2146028712590, 0.2146028712590, 0.3561913862230}, 0.006653791709700},
  {{0.0406739585346, 0.0406739585346, 0.0406739585346}, 0.001679535175883},
  {{0.8779781243960, 0.0406739585346, 0.0406739585346}, 0.001679535175883},
  {{0.0406739585346, 0.8779781243960, 0.0406739585346}, 0.001679535175883},
  {{0.0406739585346, 0.0406739585346, 0.8779781243960}, 0.001679535175883},
  {{0.3223378901420, 0.3223378901420, 0.3223378901420}, 0.009226196923950},
  {{0.0329863295732, 0.3223378901420, 0.3223378901420}, 0.009226196923950},
  {{0.3223378901420, 0.0329863295732, 0.3223378901420}, 0.009226196923950},
  {{0.3223378901420, 0.3223378901420, 0.0329863295732}, 0.009226196923950},
  {{0.0636610018750, 0.0636610018750, 0.2696723314580}, 0.008035714285717},
  {{0.0636610018750, 0.2696723314580, 0.0636610018750}, 0.008035714285717},
  {{0.0636610018750, 0.0636610018750, 0.6030056647920}, 0.008035714285717},
  {{0.0636610018750, 0.6030056647920, 0.0636610018750}, 0.008035714285717},
  {{0.0636610018750, 0.2696723314580, 0.6030056647920}, 0.008035714285717},
  {{0.0636610018750, 0.6030056647920, 0.2696723314580}, 0.008035714285717},
  {{0.2696723314580, 0.0636610018750, 0.0636610018750}, 0.008035714285717},
  {{0.2696723314580, 0.0636610018750, 0.6030056647920}, 0.008035714285717},
  {{0.2696723314580, 0.6030056647920, 0.0636610018750}, 0.008035714285717},
  {{0.6030056647920, 0.0636610018750, 0.2696723314580}, 0.008035714285717},
  {{0.6030056647920, 0.0636610018750, 0.0636610018750}, 0.008035714285717},
  {{0.6030056647920, 0.2696723314580, 0.0636610018750}, 0.008035714285717}
};

// 0 negative weights, 0 points outside of the tetrahedron,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 7 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP7Solin[31] = {
  {{0.50000000000000, 0.50000000000000, 0.00000000000000}, +0.000970017636685},
  {{0.50000000000000, 0.00000000000000, 0.50000000000000}, +0.000970017636685},
  {{0.00000000000000, 0.50000000000000, 0.50000000000000}, +0.000970017636685},
  {{0.00000000000000, 0.00000000000000, 0.50000000000000}, +0.000970017636685},
  {{0.00000000000000, 0.50000000000000, 0.00000000000000}, +0.000970017636685},
  {{0.50000000000000, 0.00000000000000, 0.00000000000000}, +0.000970017636685},
  {{0.25000000000000, 0.25000000000000, 0.25000000000000}, +0.018264223466167},
  {{0.07821319233030, 0.07821319233030, 0.07821319233030}, +0.010599941524417},
  {{0.07821319233030, 0.07821319233030, 0.76536042300900}, +0.010599941524417},
  {{0.07821319233030, 0.76536042300900, 0.07821319233030}, +0.010599941524417},
  {{0.76536042300900, 0.07821319233030, 0.07821319233030}, +0.010599941524417},
  {{0.12184321666400, 0.12184321666400, 0.12184321666400}, -0.062517740114333},
  {{0.12184321666400, 0.12184321666400, 0.63447035000800}, -0.062517740114333},
  {{0.12184321666400, 0.63447035000800, 0.12184321666400}, -0.062517740114333},
  {{0.63447035000800, 0.12184321666400, 0.12184321666400}, -0.062517740114333},
  {{0.33253916444600, 0.33253916444600, 0.33253916444600}, +0.004891425263067},
  {{0.33253916444600, 0.33253916444600, 0.00238250666074}, +0.004891425263067},
  {{0.33253916444600, 0.00238250666074, 0.33253916444600}, +0.004891425263067},
  {{0.00238250666074, 0.33253916444600, 0.33253916444600}, +0.004891425263067},
  {{0.10000000000000, 0.10000000000000, 0.20000000000000}, +0.027557319224000},
  {{0.10000000000000, 0.20000000000000, 0.10000000000000}, +0.027557319224000},
  {{0.10000000000000, 0.10000000000000, 0.60000000000000}, +0.027557319224000},
  {{0.10000000000000, 0.60000000000000, 0.10000000000000}, +0.027557319224000},
  {{0.10000000000000, 0.20000000000000, 0.60000000000000}, +0.027557319224000},
  {{0.10000000000000, 0.60000000000000, 0.20000000000000}, +0.027557319224000},
  {{0.20000000000000, 0.10000000000000, 0.10000000000000}, +0.027557319224000},
  {{0.20000000000000, 0.10000000000000, 0.60000000000000}, +0.027557319224000},
  {{0.20000000000000, 0.60000000000000, 0.10000000000000}, +0.027557319224000},
  {{0.60000000000000, 0.10000000000000, 0.20000000000000}, +0.027557319224000},
  {{0.60000000000000, 0.10000000000000, 0.10000000000000}, +0.027557319224000},
  {{0.60000000000000, 0.20000000000000, 0.10000000000000}, +0.027557319224000}
};

// 4 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 8 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP8Solin[43] = {
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.020500188658667},
  {{0.2068299316110, 0.2068299316110, 0.2068299316110}, +0.014250305822867},
  {{0.2068299316110, 0.2068299316110, 0.3795102051680}, +0.014250305822867},
  {{0.2068299316110, 0.3795102051680, 0.2068299316110}, +0.014250305822867},
  {{0.3795102051680, 0.2068299316110, 0.2068299316110}, +0.014250305822867},
  {{0.0821035883105, 0.0821035883105, 0.0821035883105}, +0.001967033313133},
  {{0.0821035883105, 0.0821035883105, 0.7536892350680}, +0.001967033313133},
  {{0.0821035883105, 0.7536892350680, 0.0821035883105}, +0.001967033313133},
  {{0.7536892350680, 0.0821035883105, 0.0821035883105}, +0.001967033313133},
  {{0.0057819505052, 0.0057819505052, 0.0057819505052}, +0.000169834109093},
  {{0.0057819505052, 0.0057819505052, 0.9826541484840}, +0.000169834109093},
  {{0.0057819505052, 0.9826541484840, 0.0057819505052}, +0.000169834109093},
  {{0.9826541484840, 0.0057819505052, 0.0057819505052}, +0.000169834109093},
  {{0.0505327400189, 0.0505327400189, 0.4494672599810}, +0.004579683824467},
  {{0.0505327400189, 0.4494672599810, 0.0505327400189}, +0.004579683824467},
  {{0.4494672599810, 0.0505327400189, 0.0505327400189}, +0.004579683824467},
  {{0.0505327400189, 0.4494672599810, 0.4494672599810}, +0.004579683824467},
  {{0.4494672599810, 0.0505327400189, 0.4494672599810}, +0.004579683824467},
  {{0.4494672599810, 0.4494672599810, 0.0505327400189}, +0.004579683824467},
  {{0.2290665361170, 0.2290665361170, 0.0356395827885}, +0.005704485808683},
  {{0.2290665361170, 0.0356395827885, 0.2290665361170}, +0.005704485808683},
  {{0.2290665361170, 0.2290665361170, 0.5062273449780}, +0.005704485808683},
  {{0.2290665361170, 0.5062273449780, 0.2290665361170}, +0.005704485808683},
  {{0.2290665361170, 0.0356395827885, 0.5062273449780}, +0.005704485808683},
  {{0.2290665361170, 0.5062273449780, 0.0356395827885}, +0.005704485808683},
  {{0.0356395827885, 0.2290665361170, 0.2290665361170}, +0.005704485808683},
  {{0.0356395827885, 0.2290665361170, 0.5062273449780}, +0.005704485808683},
  {{0.0356395827885, 0.5062273449780, 0.2290665361170}, +0.005704485808683},
  {{0.5062273449780, 0.2290665361170, 0.0356395827885}, +0.005704485808683},
  {{0.5062273449780, 0.2290665361170, 0.2290665361170}, +0.005704485808683},
  {{0.5062273449780, 0.0356395827885, 0.2290665361170}, +0.005704485808683},
  {{0.0366077495532, 0.0366077495532, 0.1904860419350}, +0.002140519141167},
  {{0.0366077495532, 0.1904860419350, 0.0366077495532}, +0.002140519141167},
  {{0.0366077495532, 0.0366077495532, 0.7362984589590}, +0.002140519141167},
  {{0.0366077495532, 0.7362984589590, 0.0366077495532}, +0.002140519141167},
  {{0.0366077495532, 0.1904860419350, 0.7362984589590}, +0.002140519141167},
  {{0.0366077495532, 0.7362984589590, 0.1904860419350}, +0.002140519141167},
  {{0.1904860419350, 0.0366077495532, 0.0366077495532}, +0.002140519141167},
  {{0.1904860419350, 0.0366077495532, 0.7362984589590}, +0.002140519141167},
  {{0.1904860419350, 0.7362984589590, 0.0366077495532}, +0.002140519141167},
  {{0.7362984589590, 0.0366077495532, 0.1904860419350}, +0.002140519141167},
  {{0.7362984589590, 0.0366077495532, 0.0366077495532}, +0.002140519141167},
  {{0.7362984589590, 0.1904860419350, 0.0366077495532}, +0.002140519141167}
};

// 1 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 9 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP9Solin[53] = {
  {{+0.25000000000000, +0.25000000000000, +0.25000000000000}, -0.137799038326167},
  {{+0.04835103854970, +0.04835103854970, +0.04835103854970}, +0.001865336569083},
  {{+0.04835103854970, +0.04835103854970, +0.85494688435100}, +0.001865336569083},
  {{+0.04835103854970, +0.85494688435100, +0.04835103854970}, +0.001865336569083},
  {{+0.85494688435100, +0.04835103854970, +0.04835103854970}, +0.001865336569083},
  {{+0.32457928011800, +0.32457928011800, +0.32457928011800}, +0.004309423969500},
  {{+0.32457928011800, +0.32457928011800, +0.02626215964640}, +0.004309423969500},
  {{+0.32457928011800, +0.02626215964640, +0.32457928011800}, +0.004309423969500},
  {{+0.02626215964640, +0.32457928011800, +0.32457928011800}, +0.004309423969500},
  {{+0.11461654022400, +0.11461654022400, +0.11461654022400}, -0.090184766481167},
  {{+0.11461654022400, +0.11461654022400, +0.65615037932800}, -0.090184766481167},
  {{+0.11461654022400, +0.65615037932800, +0.11461654022400}, -0.090184766481167},
  {{+0.65615037932800, +0.11461654022400, +0.11461654022400}, -0.090184766481167},
  {{+0.22548995191200, +0.22548995191200, +0.22548995191200}, +0.044672576202500},
  {{+0.22548995191200, +0.22548995191200, +0.32353014426500}, +0.044672576202500},
  {{+0.22548995191200, +0.32353014426500, +0.22548995191200}, +0.044672576202500},
  {{+0.32353014426500, +0.22548995191200, +0.22548995191200}, +0.044672576202500},
  {{+0.13162780924700, +0.13162780924700, +0.08366470161720}, +0.034700405884500},
  {{+0.13162780924700, +0.08366470161720, +0.13162780924700}, +0.034700405884500},
  {{+0.13162780924700, +0.13162780924700, +0.65307967988900}, +0.034700405884500},
  {{+0.13162780924700, +0.65307967988900, +0.13162780924700}, +0.034700405884500},
  {{+0.13162780924700, +0.08366470161720, +0.65307967988900}, +0.034700405884500},
  {{+0.13162780924700, +0.65307967988900, +0.08366470161720}, +0.034700405884500},
  {{+0.08366470161720, +0.13162780924700, +0.13162780924700}, +0.034700405884500},
  {{+0.08366470161720, +0.13162780924700, +0.65307967988900}, +0.034700405884500},
  {{+0.08366470161720, +0.65307967988900, +0.13162780924700}, +0.034700405884500},
  {{+0.65307967988900, +0.13162780924700, +0.08366470161720}, +0.034700405884500},
  {{+0.65307967988900, +0.13162780924700, +0.13162780924700}, +0.034700405884500},
  {{+0.65307967988900, +0.08366470161720, +0.13162780924700}, +0.034700405884500},
  {{+0.43395146141100, +0.43395146141100, +0.10776985954900}, +0.003352583902667},
  {{+0.43395146141100, +0.10776985954900, +0.43395146141100}, +0.003352583902667},
  {{+0.43395146141100, +0.43395146141100, +0.02432721762780}, +0.003352583902667},
  {{+0.43395146141100, +0.02432721762780, +0.43395146141100}, +0.003352583902667},
  {{+0.43395146141100, +0.10776985954900, +0.02432721762780}, +0.003352583902667},
  {{+0.43395146141100, +0.02432721762780, +0.10776985954900}, +0.003352583902667},
  {{+0.10776985954900, +0.43395146141100, +0.43395146141100}, +0.003352583902667},
  {{+0.10776985954900, +0.43395146141100, +0.02432721762780}, +0.003352583902667},
  {{+0.10776985954900, +0.02432721762780, +0.43395146141100}, +0.003352583902667},
  {{+0.02432721762780, +0.43395146141100, +0.10776985954900}, +0.003352583902667},
  {{+0.02432721762780, +0.43395146141100, +0.43395146141100}, +0.003352583902667},
  {{+0.02432721762780, +0.10776985954900, +0.43395146141100}, +0.003352583902667},
  {{-0.00137627731814, -0.00137627731814, +0.27655347263700}, +0.000431628875557},
  {{-0.00137627731814, +0.27655347263700, -0.00137627731814}, +0.000431628875557},
  {{-0.00137627731814, -0.00137627731814, +0.72619908199900}, +0.000431628875557},
  {{-0.00137627731814, +0.72619908199900, -0.00137627731814}, +0.000431628875557},
  {{-0.00137627731814, +0.27655347263700, +0.72619908199900}, +0.000431628875557},
  {{-0.00137627731814, +0.72619908199900, +0.27655347263700}, +0.000431628875557},
  {{+0.27655347263700, -0.00137627731814, -0.00137627731814}, +0.000431628875557},
  {{+0.27655347263700, -0.00137627731814, +0.72619908199900}, +0.000431628875557},
  {{+0.27655347263700, +0.72619908199900, -0.00137627731814}, +0.000431628875557},
  {{+0.72619908199900, -0.00137627731814, +0.27655347263700}, +0.000431628875557},
  {{+0.72619908199900, -0.00137627731814, -0.00137627731814}, +0.000431628875557},
  {{+0.72619908199900, +0.27655347263700, -0.00137627731814}, +0.000431628875557}
};

// 5 negative weights, 12 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 11 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP11Solin[126] = {
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, +0.045362824065000},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, +0.045362824065000},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, +0.045362824065000},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, +0.045362824065000},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, +0.045362824065000},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, +0.045362824065000},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, +0.045362824065000},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, +0.045362824065000},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, +0.045362824065000},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, +0.045362824065000},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, +0.045362824065000},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, +0.045362824065000},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, +0.045362824065000},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, +0.045362824065000},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, +0.045362824065000},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, +0.045362824065000},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, +0.045362824065000},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, +0.045362824065000},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, +0.045362824065000},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, +0.045362824065000},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, +0.045362824065000},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, +0.045362824065000},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, +0.045362824065000},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, +0.045362824065000},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, +0.045362824065000},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, +0.045362824065000},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, +0.045362824065000},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, +0.045362824065000},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, +0.045362824065000},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, +0.045362824065000},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, +0.045362824065000},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, +0.045362824065000},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, +0.045362824065000},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, +0.045362824065000},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, +0.045362824065000},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, +0.045362824065000},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, +0.045362824065000},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, +0.045362824065000},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, +0.045362824065000},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, +0.045362824065000},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, +0.045362824065000},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, +0.045362824065000},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, +0.045362824065000},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, +0.045362824065000},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, +0.045362824065000},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, +0.045362824065000},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, +0.045362824065000},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, +0.045362824065000},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, +0.045362824065000},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, +0.045362824065000},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, +0.045362824065000},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, -0.116523476523500},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, -0.116523476523500},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, -0.116523476523500},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, -0.116523476523500},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, -0.116523476523500},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, -0.116523476523500},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, -0.116523476523500},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, -0.116523476523500},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, -0.116523476523500},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, -0.116523476523500},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, -0.116523476523500},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, -0.116523476523500},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, -0.116523476523500},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, -0.116523476523500},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, -0.116523476523500},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, -0.116523476523500},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, -0.116523476523500},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, -0.116523476523500},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, -0.116523476523500},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, -0.116523476523500},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.116523476523500},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, -0.116523476523500},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, -0.116523476523500},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, -0.116523476523500},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, -0.116523476523500},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, -0.116523476523500},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, -0.116523476523500},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, -0.116523476523500},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, -0.116523476523500},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, -0.116523476523500},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, -0.116523476523500},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, -0.116523476523500},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, -0.116523476523500},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, -0.116523476523500},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, -0.116523476523500},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, +0.101937289979833},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, -0.035025386136500},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, -0.035025386136500},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, -0.035025386136500},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, -0.035025386136500},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, -0.035025386136500},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, -0.035025386136500},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, -0.035025386136500},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, -0.035025386136500},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, -0.035025386136500},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, -0.035025386136500},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, +0.004068080357150},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, +0.004068080357150},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, +0.004068080357150},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, +0.004068080357150},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -9.4062316284e-05}
};

// 46 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 13 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP13Solin[210] = {
  {{0.0625000000000, 0.0625000000000, 0.8125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.6875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.3125000000000, 0.5625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.4375000000000, 0.4375000000000}, +0.052550909016500},
  {{0.0625000000000, 0.5625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.6875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.8125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.6875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.1875000000000, 0.5625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.3125000000000, 0.4375000000000}, +0.052550909016500},
  {{0.1875000000000, 0.4375000000000, 0.3125000000000}, +0.052550909016500},
  {{0.1875000000000, 0.5625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.6875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.0625000000000, 0.5625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.1875000000000, 0.4375000000000}, +0.052550909016500},
  {{0.3125000000000, 0.3125000000000, 0.3125000000000}, +0.052550909016500},
  {{0.3125000000000, 0.4375000000000, 0.1875000000000}, +0.052550909016500},
  {{0.3125000000000, 0.5625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.4375000000000, 0.0625000000000, 0.4375000000000}, +0.052550909016500},
  {{0.4375000000000, 0.1875000000000, 0.3125000000000}, +0.052550909016500},
  {{0.4375000000000, 0.3125000000000, 0.1875000000000}, +0.052550909016500},
  {{0.4375000000000, 0.4375000000000, 0.0625000000000}, +0.052550909016500},
  {{0.5625000000000, 0.0625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.5625000000000, 0.1875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.5625000000000, 0.3125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.6875000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.6875000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.8125000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.6875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.5625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.3125000000000, 0.4375000000000}, +0.052550909016500},
  {{0.0625000000000, 0.4375000000000, 0.3125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.5625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.6875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.5625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.1875000000000, 0.4375000000000}, +0.052550909016500},
  {{0.1875000000000, 0.3125000000000, 0.3125000000000}, +0.052550909016500},
  {{0.1875000000000, 0.4375000000000, 0.1875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.5625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.0625000000000, 0.4375000000000}, +0.052550909016500},
  {{0.3125000000000, 0.1875000000000, 0.3125000000000}, +0.052550909016500},
  {{0.3125000000000, 0.3125000000000, 0.1875000000000}, +0.052550909016500},
  {{0.3125000000000, 0.4375000000000, 0.0625000000000}, +0.052550909016500},
  {{0.4375000000000, 0.0625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.4375000000000, 0.1875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.4375000000000, 0.3125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.5625000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.5625000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.6875000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.5625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.4375000000000}, +0.052550909016500},
  {{0.0625000000000, 0.3125000000000, 0.3125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.4375000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.5625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.4375000000000}, +0.052550909016500},
  {{0.1875000000000, 0.1875000000000, 0.3125000000000}, +0.052550909016500},
  {{0.1875000000000, 0.3125000000000, 0.1875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.4375000000000, 0.0625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.0625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.3125000000000, 0.1875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.3125000000000, 0.3125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.4375000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.4375000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.5625000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.4375000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.3125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.3125000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.4375000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.1875000000000, 0.1875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.3125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.3125000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.4375000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.3125000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.3125000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.1875000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.3125000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.1875000000000}, +0.052550909016500},
  {{0.0625000000000, 0.1875000000000, 0.0625000000000}, +0.052550909016500},
  {{0.1875000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0625000000000, 0.0625000000000, 0.0625000000000}, +0.052550909016500},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, -0.148185225279333},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, -0.148185225279333},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, -0.148185225279333},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, -0.148185225279333},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, -0.148185225279333},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, -0.148185225279333},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, -0.148185225279333},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, -0.148185225279333},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, -0.148185225279333},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, -0.148185225279333},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, -0.148185225279333},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, -0.148185225279333},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, -0.148185225279333},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, -0.148185225279333},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, -0.148185225279333},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, -0.148185225279333},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, -0.148185225279333},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, -0.148185225279333},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, -0.148185225279333},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, -0.148185225279333},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, -0.148185225279333},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, -0.148185225279333},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, -0.148185225279333},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, -0.148185225279333},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, -0.148185225279333},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, -0.148185225279333},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, -0.148185225279333},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, -0.148185225279333},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, -0.148185225279333},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, -0.148185225279333},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, -0.148185225279333},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, -0.148185225279333},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, -0.148185225279333},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, -0.148185225279333},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, -0.148185225279333},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, -0.148185225279333},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, -0.148185225279333},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, -0.148185225279333},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, -0.148185225279333},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, -0.148185225279333},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, -0.148185225279333},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, -0.148185225279333},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, -0.148185225279333},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, -0.148185225279333},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, -0.148185225279333},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, -0.148185225279333},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, -0.148185225279333},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, -0.148185225279333},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, -0.148185225279333},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, -0.148185225279333},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, -0.148185225279333},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, +0.149815898387333},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, +0.149815898387333},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, +0.149815898387333},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, +0.149815898387333},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, +0.149815898387333},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, +0.149815898387333},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, +0.149815898387333},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, +0.149815898387333},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, +0.149815898387333},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, +0.149815898387333},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, +0.149815898387333},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, +0.149815898387333},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, +0.149815898387333},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, +0.149815898387333},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, +0.149815898387333},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, +0.149815898387333},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, +0.149815898387333},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, +0.149815898387333},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, +0.149815898387333},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, +0.149815898387333},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +0.149815898387333},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, +0.149815898387333},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, +0.149815898387333},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, +0.149815898387333},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, +0.149815898387333},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, +0.149815898387333},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, +0.149815898387333},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, +0.149815898387333},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, +0.149815898387333},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, +0.149815898387333},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, +0.149815898387333},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, +0.149815898387333},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, +0.149815898387333},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, +0.149815898387333},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, +0.149815898387333},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, -0.065344416653667},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, +0.011675128712167},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, +0.011675128712167},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, +0.011675128712167},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, +0.011675128712167},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, +0.011675128712167},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, +0.011675128712167},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, +0.011675128712167},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, +0.011675128712167},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, +0.011675128712167},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, +0.011675128712167},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, -0.000665685876623},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, -0.000665685876623},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, -0.000665685876623},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, -0.000665685876623},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +6.270821086e-06}
};

// 80 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 15 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP15Solin[330] = {
  {{0.0555555555556, 0.0555555555556, 0.8333333333330}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.7222222222220}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.6111111111110}, +0.064317124103667},
  {{0.0555555555556, 0.3888888888890, 0.5000000000000}, +0.064317124103667},
  {{0.0555555555556, 0.5000000000000, 0.3888888888890}, +0.064317124103667},
  {{0.0555555555556, 0.6111111111110, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.7222222222220, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.8333333333330, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.7222222222220}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.6111111111110}, +0.064317124103667},
  {{0.1666666666670, 0.2777777777780, 0.5000000000000}, +0.064317124103667},
  {{0.1666666666670, 0.3888888888890, 0.3888888888890}, +0.064317124103667},
  {{0.1666666666670, 0.5000000000000, 0.2777777777780}, +0.064317124103667},
  {{0.1666666666670, 0.6111111111110, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.7222222222220, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.6111111111110}, +0.064317124103667},
  {{0.2777777777780, 0.1666666666670, 0.5000000000000}, +0.064317124103667},
  {{0.2777777777780, 0.2777777777780, 0.3888888888890}, +0.064317124103667},
  {{0.2777777777780, 0.3888888888890, 0.2777777777780}, +0.064317124103667},
  {{0.2777777777780, 0.5000000000000, 0.1666666666670}, +0.064317124103667},
  {{0.2777777777780, 0.6111111111110, 0.0555555555556}, +0.064317124103667},
  {{0.3888888888890, 0.0555555555556, 0.5000000000000}, +0.064317124103667},
  {{0.3888888888890, 0.1666666666670, 0.3888888888890}, +0.064317124103667},
  {{0.3888888888890, 0.2777777777780, 0.2777777777780}, +0.064317124103667},
  {{0.3888888888890, 0.3888888888890, 0.1666666666670}, +0.064317124103667},
  {{0.3888888888890, 0.5000000000000, 0.0555555555556}, +0.064317124103667},
  {{0.5000000000000, 0.0555555555556, 0.3888888888890}, +0.064317124103667},
  {{0.5000000000000, 0.1666666666670, 0.2777777777780}, +0.064317124103667},
  {{0.5000000000000, 0.2777777777780, 0.1666666666670}, +0.064317124103667},
  {{0.5000000000000, 0.3888888888890, 0.0555555555556}, +0.064317124103667},
  {{0.6111111111110, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.6111111111110, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.6111111111110, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.7222222222220, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.7222222222220, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.8333333333330, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.7222222222220}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.6111111111110}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.5000000000000}, +0.064317124103667},
  {{0.0555555555556, 0.3888888888890, 0.3888888888890}, +0.064317124103667},
  {{0.0555555555556, 0.5000000000000, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.6111111111110, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.7222222222220, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.6111111111110}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, +0.064317124103667},
  {{0.1666666666670, 0.2777777777780, 0.3888888888890}, +0.064317124103667},
  {{0.1666666666670, 0.3888888888890, 0.2777777777780}, +0.064317124103667},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.6111111111110, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.5000000000000}, +0.064317124103667},
  {{0.2777777777780, 0.1666666666670, 0.3888888888890}, +0.064317124103667},
  {{0.2777777777780, 0.2777777777780, 0.2777777777780}, +0.064317124103667},
  {{0.2777777777780, 0.3888888888890, 0.1666666666670}, +0.064317124103667},
  {{0.2777777777780, 0.5000000000000, 0.0555555555556}, +0.064317124103667},
  {{0.3888888888890, 0.0555555555556, 0.3888888888890}, +0.064317124103667},
  {{0.3888888888890, 0.1666666666670, 0.2777777777780}, +0.064317124103667},
  {{0.3888888888890, 0.2777777777780, 0.1666666666670}, +0.064317124103667},
  {{0.3888888888890, 0.3888888888890, 0.0555555555556}, +0.064317124103667},
  {{0.5000000000000, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.5000000000000, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.6111111111110, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.6111111111110, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.7222222222220, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.6111111111110}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.5000000000000}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.3888888888890}, +0.064317124103667},
  {{0.0555555555556, 0.3888888888890, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.5000000000000, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.6111111111110, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.5000000000000}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.3888888888890}, +0.064317124103667},
  {{0.1666666666670, 0.2777777777780, 0.2777777777780}, +0.064317124103667},
  {{0.1666666666670, 0.3888888888890, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.5000000000000, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.3888888888890}, +0.064317124103667},
  {{0.2777777777780, 0.1666666666670, 0.2777777777780}, +0.064317124103667},
  {{0.2777777777780, 0.2777777777780, 0.1666666666670}, +0.064317124103667},
  {{0.2777777777780, 0.3888888888890, 0.0555555555556}, +0.064317124103667},
  {{0.3888888888890, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.3888888888890, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.3888888888890, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.5000000000000, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.5000000000000, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.6111111111110, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.5000000000000}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.3888888888890}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.3888888888890, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.5000000000000, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.3888888888890}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.2777777777780}, +0.064317124103667},
  {{0.1666666666670, 0.2777777777780, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.3888888888890, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.2777777777780, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.2777777777780, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.3888888888890, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.3888888888890, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.5000000000000, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.3888888888890}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.3888888888890, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.2777777777780, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.3888888888890, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.2777777777780}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.2777777777780, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.1666666666670, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.2777777777780, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.1666666666670}, +0.064317124103667},
  {{0.0555555555556, 0.1666666666670, 0.0555555555556}, +0.064317124103667},
  {{0.1666666666670, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0555555555556, 0.0555555555556, 0.0555555555556}, +0.064317124103667},
  {{0.0625000000000, 0.0625000000000, 0.8125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.6875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.3125000000000, 0.5625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.4375000000000, 0.4375000000000}, -0.197838716296667},
  {{0.0625000000000, 0.5625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.6875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.8125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.6875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.1875000000000, 0.5625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.3125000000000, 0.4375000000000}, -0.197838716296667},
  {{0.1875000000000, 0.4375000000000, 0.3125000000000}, -0.197838716296667},
  {{0.1875000000000, 0.5625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.6875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.0625000000000, 0.5625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.1875000000000, 0.4375000000000}, -0.197838716296667},
  {{0.3125000000000, 0.3125000000000, 0.3125000000000}, -0.197838716296667},
  {{0.3125000000000, 0.4375000000000, 0.1875000000000}, -0.197838716296667},
  {{0.3125000000000, 0.5625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.4375000000000, 0.0625000000000, 0.4375000000000}, -0.197838716296667},
  {{0.4375000000000, 0.1875000000000, 0.3125000000000}, -0.197838716296667},
  {{0.4375000000000, 0.3125000000000, 0.1875000000000}, -0.197838716296667},
  {{0.4375000000000, 0.4375000000000, 0.0625000000000}, -0.197838716296667},
  {{0.5625000000000, 0.0625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.5625000000000, 0.1875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.5625000000000, 0.3125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.6875000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.6875000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.8125000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.6875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.5625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.3125000000000, 0.4375000000000}, -0.197838716296667},
  {{0.0625000000000, 0.4375000000000, 0.3125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.5625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.6875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.5625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.1875000000000, 0.4375000000000}, -0.197838716296667},
  {{0.1875000000000, 0.3125000000000, 0.3125000000000}, -0.197838716296667},
  {{0.1875000000000, 0.4375000000000, 0.1875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.5625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.0625000000000, 0.4375000000000}, -0.197838716296667},
  {{0.3125000000000, 0.1875000000000, 0.3125000000000}, -0.197838716296667},
  {{0.3125000000000, 0.3125000000000, 0.1875000000000}, -0.197838716296667},
  {{0.3125000000000, 0.4375000000000, 0.0625000000000}, -0.197838716296667},
  {{0.4375000000000, 0.0625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.4375000000000, 0.1875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.4375000000000, 0.3125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.5625000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.5625000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.6875000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.5625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.4375000000000}, -0.197838716296667},
  {{0.0625000000000, 0.3125000000000, 0.3125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.4375000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.5625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.4375000000000}, -0.197838716296667},
  {{0.1875000000000, 0.1875000000000, 0.3125000000000}, -0.197838716296667},
  {{0.1875000000000, 0.3125000000000, 0.1875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.4375000000000, 0.0625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.0625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.3125000000000, 0.1875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.3125000000000, 0.3125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.4375000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.4375000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.5625000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.4375000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.3125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.3125000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.4375000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.1875000000000, 0.1875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.3125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.3125000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.4375000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.3125000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.3125000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.1875000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.3125000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.1875000000000}, -0.197838716296667},
  {{0.0625000000000, 0.1875000000000, 0.0625000000000}, -0.197838716296667},
  {{0.1875000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0625000000000, 0.0625000000000, 0.0625000000000}, -0.197838716296667},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, +0.226908626208333},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, +0.226908626208333},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, +0.226908626208333},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, +0.226908626208333},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, +0.226908626208333},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, +0.226908626208333},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, +0.226908626208333},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, +0.226908626208333},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, +0.226908626208333},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, +0.226908626208333},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, +0.226908626208333},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, +0.226908626208333},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, +0.226908626208333},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, +0.226908626208333},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, +0.226908626208333},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, +0.226908626208333},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, +0.226908626208333},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, +0.226908626208333},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, +0.226908626208333},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, +0.226908626208333},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, +0.226908626208333},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, +0.226908626208333},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, +0.226908626208333},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, +0.226908626208333},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, +0.226908626208333},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, +0.226908626208333},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, +0.226908626208333},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, +0.226908626208333},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, +0.226908626208333},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, +0.226908626208333},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, +0.226908626208333},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, +0.226908626208333},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, +0.226908626208333},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, +0.226908626208333},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, +0.226908626208333},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, +0.226908626208333},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, +0.226908626208333},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, +0.226908626208333},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, +0.226908626208333},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, +0.226908626208333},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, +0.226908626208333},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, +0.226908626208333},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, +0.226908626208333},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, +0.226908626208333},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, +0.226908626208333},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, +0.226908626208333},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, +0.226908626208333},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, +0.226908626208333},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, +0.226908626208333},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, +0.226908626208333},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, +0.226908626208333},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, -0.119852718709833},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, -0.119852718709833},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, -0.119852718709833},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, -0.119852718709833},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, -0.119852718709833},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, -0.119852718709833},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, -0.119852718709833},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, -0.119852718709833},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, -0.119852718709833},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, -0.119852718709833},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, -0.119852718709833},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, -0.119852718709833},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, -0.119852718709833},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, -0.119852718709833},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, -0.119852718709833},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, -0.119852718709833},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, -0.119852718709833},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, -0.119852718709833},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, -0.119852718709833},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, -0.119852718709833},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.119852718709833},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, -0.119852718709833},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, -0.119852718709833},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, -0.119852718709833},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, -0.119852718709833},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, -0.119852718709833},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, -0.119852718709833},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, -0.119852718709833},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, -0.119852718709833},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, -0.119852718709833},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, -0.119852718709833},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, -0.119852718709833},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, -0.119852718709833},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, -0.119852718709833},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, -0.119852718709833},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, +0.029171614577500},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, -0.002873877836833},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, -0.002873877836833},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, -0.002873877836833},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, -0.002873877836833},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, -0.002873877836833},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, -0.002873877836833},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, -0.002873877836833},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, -0.002873877836833},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, -0.002873877836833},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, -0.002873877836833},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, +8.3210734578e-05},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, +8.3210734578e-05},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, +8.3210734578e-05},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, +8.3210734578e-05},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -3.25756939e-07}
};

// 130 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 17 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP17Solin[495] = {
  {{0.0500000000000, 0.0500000000000, 0.8500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.7500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.4500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.5500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.6500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.7500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.8500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.7500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.3500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.4500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.5500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.6500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.7500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.2500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.3500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.4500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.5500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.6500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.1500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.2500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.3500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.4500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.5500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.0500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.1500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.2500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.3500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.4500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.7500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.7500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.8500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.7500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.4500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.5500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.6500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.7500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.3500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.4500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.5500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.6500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.2500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.3500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.4500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.5500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.1500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.2500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.3500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.4500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.7500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.6500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.4500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.5500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.6500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.3500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.4500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.5500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.3500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.4500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.6500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.5500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.4500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.5500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.3500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.4500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.5500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.4500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.4500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.4500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.3500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.3500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.3500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.2500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.2500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.2500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.1500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.1500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.1500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0500000000000, 0.0500000000000, 0.0500000000000}, +0.082206352466167},
  {{0.0555555555556, 0.0555555555556, 0.8333333333330}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.7222222222220}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.6111111111110}, -0.274194055390000},
  {{0.0555555555556, 0.3888888888890, 0.5000000000000}, -0.274194055390000},
  {{0.0555555555556, 0.5000000000000, 0.3888888888890}, -0.274194055390000},
  {{0.0555555555556, 0.6111111111110, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.7222222222220, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.8333333333330, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.7222222222220}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.6111111111110}, -0.274194055390000},
  {{0.1666666666670, 0.2777777777780, 0.5000000000000}, -0.274194055390000},
  {{0.1666666666670, 0.3888888888890, 0.3888888888890}, -0.274194055390000},
  {{0.1666666666670, 0.5000000000000, 0.2777777777780}, -0.274194055390000},
  {{0.1666666666670, 0.6111111111110, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.7222222222220, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.6111111111110}, -0.274194055390000},
  {{0.2777777777780, 0.1666666666670, 0.5000000000000}, -0.274194055390000},
  {{0.2777777777780, 0.2777777777780, 0.3888888888890}, -0.274194055390000},
  {{0.2777777777780, 0.3888888888890, 0.2777777777780}, -0.274194055390000},
  {{0.2777777777780, 0.5000000000000, 0.1666666666670}, -0.274194055390000},
  {{0.2777777777780, 0.6111111111110, 0.0555555555556}, -0.274194055390000},
  {{0.3888888888890, 0.0555555555556, 0.5000000000000}, -0.274194055390000},
  {{0.3888888888890, 0.1666666666670, 0.3888888888890}, -0.274194055390000},
  {{0.3888888888890, 0.2777777777780, 0.2777777777780}, -0.274194055390000},
  {{0.3888888888890, 0.3888888888890, 0.1666666666670}, -0.274194055390000},
  {{0.3888888888890, 0.5000000000000, 0.0555555555556}, -0.274194055390000},
  {{0.5000000000000, 0.0555555555556, 0.3888888888890}, -0.274194055390000},
  {{0.5000000000000, 0.1666666666670, 0.2777777777780}, -0.274194055390000},
  {{0.5000000000000, 0.2777777777780, 0.1666666666670}, -0.274194055390000},
  {{0.5000000000000, 0.3888888888890, 0.0555555555556}, -0.274194055390000},
  {{0.6111111111110, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.6111111111110, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.6111111111110, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.7222222222220, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.7222222222220, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.8333333333330, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.7222222222220}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.6111111111110}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.5000000000000}, -0.274194055390000},
  {{0.0555555555556, 0.3888888888890, 0.3888888888890}, -0.274194055390000},
  {{0.0555555555556, 0.5000000000000, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.6111111111110, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.7222222222220, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.6111111111110}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, -0.274194055390000},
  {{0.1666666666670, 0.2777777777780, 0.3888888888890}, -0.274194055390000},
  {{0.1666666666670, 0.3888888888890, 0.2777777777780}, -0.274194055390000},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.6111111111110, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.5000000000000}, -0.274194055390000},
  {{0.2777777777780, 0.1666666666670, 0.3888888888890}, -0.274194055390000},
  {{0.2777777777780, 0.2777777777780, 0.2777777777780}, -0.274194055390000},
  {{0.2777777777780, 0.3888888888890, 0.1666666666670}, -0.274194055390000},
  {{0.2777777777780, 0.5000000000000, 0.0555555555556}, -0.274194055390000},
  {{0.3888888888890, 0.0555555555556, 0.3888888888890}, -0.274194055390000},
  {{0.3888888888890, 0.1666666666670, 0.2777777777780}, -0.274194055390000},
  {{0.3888888888890, 0.2777777777780, 0.1666666666670}, -0.274194055390000},
  {{0.3888888888890, 0.3888888888890, 0.0555555555556}, -0.274194055390000},
  {{0.5000000000000, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.5000000000000, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.6111111111110, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.6111111111110, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.7222222222220, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.6111111111110}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.5000000000000}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.3888888888890}, -0.274194055390000},
  {{0.0555555555556, 0.3888888888890, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.5000000000000, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.6111111111110, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.5000000000000}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.3888888888890}, -0.274194055390000},
  {{0.1666666666670, 0.2777777777780, 0.2777777777780}, -0.274194055390000},
  {{0.1666666666670, 0.3888888888890, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.5000000000000, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.3888888888890}, -0.274194055390000},
  {{0.2777777777780, 0.1666666666670, 0.2777777777780}, -0.274194055390000},
  {{0.2777777777780, 0.2777777777780, 0.1666666666670}, -0.274194055390000},
  {{0.2777777777780, 0.3888888888890, 0.0555555555556}, -0.274194055390000},
  {{0.3888888888890, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.3888888888890, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.3888888888890, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.5000000000000, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.5000000000000, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.6111111111110, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.5000000000000}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.3888888888890}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.3888888888890, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.5000000000000, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.3888888888890}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.2777777777780}, -0.274194055390000},
  {{0.1666666666670, 0.2777777777780, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.3888888888890, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.2777777777780, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.2777777777780, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.3888888888890, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.3888888888890, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.5000000000000, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.3888888888890}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.3888888888890, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.2777777777780, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.3888888888890, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.2777777777780}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.2777777777780, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.1666666666670, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.2777777777780, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.1666666666670}, -0.274194055390000},
  {{0.0555555555556, 0.1666666666670, 0.0555555555556}, -0.274194055390000},
  {{0.1666666666670, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0555555555556, 0.0555555555556, 0.0555555555556}, -0.274194055390000},
  {{0.0625000000000, 0.0625000000000, 0.8125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.6875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.3125000000000, 0.5625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.4375000000000, 0.4375000000000}, +0.351713273418333},
  {{0.0625000000000, 0.5625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.6875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.8125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.6875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.1875000000000, 0.5625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.3125000000000, 0.4375000000000}, +0.351713273418333},
  {{0.1875000000000, 0.4375000000000, 0.3125000000000}, +0.351713273418333},
  {{0.1875000000000, 0.5625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.6875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.0625000000000, 0.5625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.1875000000000, 0.4375000000000}, +0.351713273418333},
  {{0.3125000000000, 0.3125000000000, 0.3125000000000}, +0.351713273418333},
  {{0.3125000000000, 0.4375000000000, 0.1875000000000}, +0.351713273418333},
  {{0.3125000000000, 0.5625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.4375000000000, 0.0625000000000, 0.4375000000000}, +0.351713273418333},
  {{0.4375000000000, 0.1875000000000, 0.3125000000000}, +0.351713273418333},
  {{0.4375000000000, 0.3125000000000, 0.1875000000000}, +0.351713273418333},
  {{0.4375000000000, 0.4375000000000, 0.0625000000000}, +0.351713273418333},
  {{0.5625000000000, 0.0625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.5625000000000, 0.1875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.5625000000000, 0.3125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.6875000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.6875000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.8125000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.6875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.5625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.3125000000000, 0.4375000000000}, +0.351713273418333},
  {{0.0625000000000, 0.4375000000000, 0.3125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.5625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.6875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.5625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.1875000000000, 0.4375000000000}, +0.351713273418333},
  {{0.1875000000000, 0.3125000000000, 0.3125000000000}, +0.351713273418333},
  {{0.1875000000000, 0.4375000000000, 0.1875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.5625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.0625000000000, 0.4375000000000}, +0.351713273418333},
  {{0.3125000000000, 0.1875000000000, 0.3125000000000}, +0.351713273418333},
  {{0.3125000000000, 0.3125000000000, 0.1875000000000}, +0.351713273418333},
  {{0.3125000000000, 0.4375000000000, 0.0625000000000}, +0.351713273418333},
  {{0.4375000000000, 0.0625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.4375000000000, 0.1875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.4375000000000, 0.3125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.5625000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.5625000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.6875000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.5625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.4375000000000}, +0.351713273418333},
  {{0.0625000000000, 0.3125000000000, 0.3125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.4375000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.5625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.4375000000000}, +0.351713273418333},
  {{0.1875000000000, 0.1875000000000, 0.3125000000000}, +0.351713273418333},
  {{0.1875000000000, 0.3125000000000, 0.1875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.4375000000000, 0.0625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.0625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.3125000000000, 0.1875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.3125000000000, 0.3125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.4375000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.4375000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.5625000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.4375000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.3125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.3125000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.4375000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.1875000000000, 0.1875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.3125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.3125000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.4375000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.3125000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.3125000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.1875000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.3125000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.1875000000000}, +0.351713273418333},
  {{0.0625000000000, 0.1875000000000, 0.0625000000000}, +0.351713273418333},
  {{0.1875000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0625000000000, 0.0625000000000, 0.0625000000000}, +0.351713273418333},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, -0.218010248710000},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, -0.218010248710000},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, -0.218010248710000},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, -0.218010248710000},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, -0.218010248710000},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, -0.218010248710000},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, -0.218010248710000},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, -0.218010248710000},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, -0.218010248710000},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, -0.218010248710000},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, -0.218010248710000},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, -0.218010248710000},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, -0.218010248710000},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, -0.218010248710000},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, -0.218010248710000},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, -0.218010248710000},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, -0.218010248710000},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, -0.218010248710000},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, -0.218010248710000},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, -0.218010248710000},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, -0.218010248710000},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, -0.218010248710000},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, -0.218010248710000},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, -0.218010248710000},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, -0.218010248710000},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, -0.218010248710000},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, -0.218010248710000},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, -0.218010248710000},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, -0.218010248710000},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, -0.218010248710000},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, -0.218010248710000},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, -0.218010248710000},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, -0.218010248710000},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, -0.218010248710000},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, -0.218010248710000},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, -0.218010248710000},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, -0.218010248710000},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, -0.218010248710000},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, -0.218010248710000},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, -0.218010248710000},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, -0.218010248710000},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, -0.218010248710000},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, -0.218010248710000},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, -0.218010248710000},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, -0.218010248710000},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, -0.218010248710000},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, -0.218010248710000},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, -0.218010248710000},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, -0.218010248710000},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, -0.218010248710000},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, -0.218010248710000},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, +0.067417154274333},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, +0.067417154274333},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, +0.067417154274333},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, +0.067417154274333},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, +0.067417154274333},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, +0.067417154274333},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, +0.067417154274333},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, +0.067417154274333},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, +0.067417154274333},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, +0.067417154274333},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, +0.067417154274333},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, +0.067417154274333},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, +0.067417154274333},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, +0.067417154274333},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, +0.067417154274333},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, +0.067417154274333},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, +0.067417154274333},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, +0.067417154274333},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, +0.067417154274333},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, +0.067417154274333},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +0.067417154274333},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, +0.067417154274333},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, +0.067417154274333},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, +0.067417154274333},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, +0.067417154274333},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, +0.067417154274333},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, +0.067417154274333},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, +0.067417154274333},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, +0.067417154274333},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, +0.067417154274333},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, +0.067417154274333},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, +0.067417154274333},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, +0.067417154274333},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, +0.067417154274333},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, +0.067417154274333},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, -0.009723871525850},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, +0.000547405302255},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, +0.000547405302255},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, +0.000547405302255},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, +0.000547405302255},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, +0.000547405302255},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, +0.000547405302255},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, +0.000547405302255},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, +0.000547405302255},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, +0.000547405302255},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, +0.000547405302255},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, -8.22963309013e-06},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, -8.22963309013e-06},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, -8.22963309013e-06},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, -8.22963309013e-06},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +1.3573205875e-08}
};

// 200 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 19 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP19Solin[715] = {
  {{0.0454545454545, 0.0454545454545, 0.8636363636360}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.7727272727270}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.6818181818180}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.5909090909090}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.5000000000000}, +0.108823933894333},
  {{0.0454545454545, 0.5000000000000, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.5909090909090, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.6818181818180, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.7727272727270, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.8636363636360, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.7727272727270}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.6818181818180}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.5909090909090}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.5000000000000}, +0.108823933894333},
  {{0.1363636363640, 0.4090909090910, 0.4090909090910}, +0.108823933894333},
  {{0.1363636363640, 0.5000000000000, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.5909090909090, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.6818181818180, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.7727272727270, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.6818181818180}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.5909090909090}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.5000000000000}, +0.108823933894333},
  {{0.2272727272730, 0.3181818181820, 0.4090909090910}, +0.108823933894333},
  {{0.2272727272730, 0.4090909090910, 0.3181818181820}, +0.108823933894333},
  {{0.2272727272730, 0.5000000000000, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.5909090909090, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.6818181818180, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.5909090909090}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.5000000000000}, +0.108823933894333},
  {{0.3181818181820, 0.2272727272730, 0.4090909090910}, +0.108823933894333},
  {{0.3181818181820, 0.3181818181820, 0.3181818181820}, +0.108823933894333},
  {{0.3181818181820, 0.4090909090910, 0.2272727272730}, +0.108823933894333},
  {{0.3181818181820, 0.5000000000000, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.5909090909090, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.5000000000000}, +0.108823933894333},
  {{0.4090909090910, 0.1363636363640, 0.4090909090910}, +0.108823933894333},
  {{0.4090909090910, 0.2272727272730, 0.3181818181820}, +0.108823933894333},
  {{0.4090909090910, 0.3181818181820, 0.2272727272730}, +0.108823933894333},
  {{0.4090909090910, 0.4090909090910, 0.1363636363640}, +0.108823933894333},
  {{0.4090909090910, 0.5000000000000, 0.0454545454545}, +0.108823933894333},
  {{0.5000000000000, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.5000000000000, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.5000000000000, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.5000000000000, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.5000000000000, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.5909090909090, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.5909090909090, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.5909090909090, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.5909090909090, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.6818181818180, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.6818181818180, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.6818181818180, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.7727272727270, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.7727272727270, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.8636363636360, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.7727272727270}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.6818181818180}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.5909090909090}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.5000000000000}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.5000000000000, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.5909090909090, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.6818181818180, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.7727272727270, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.6818181818180}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.5909090909090}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.5000000000000}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.4090909090910}, +0.108823933894333},
  {{0.1363636363640, 0.4090909090910, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.5000000000000, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.5909090909090, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.6818181818180, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.5909090909090}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.5000000000000}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.4090909090910}, +0.108823933894333},
  {{0.2272727272730, 0.3181818181820, 0.3181818181820}, +0.108823933894333},
  {{0.2272727272730, 0.4090909090910, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.5000000000000, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.5909090909090, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.5000000000000}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.4090909090910}, +0.108823933894333},
  {{0.3181818181820, 0.2272727272730, 0.3181818181820}, +0.108823933894333},
  {{0.3181818181820, 0.3181818181820, 0.2272727272730}, +0.108823933894333},
  {{0.3181818181820, 0.4090909090910, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.5000000000000, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.4090909090910, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.4090909090910, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.4090909090910, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.4090909090910, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.5000000000000, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.5000000000000, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.5000000000000, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.5000000000000, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.5909090909090, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.5909090909090, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.5909090909090, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.6818181818180, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.6818181818180, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.7727272727270, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.6818181818180}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.5909090909090}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.5000000000000}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.5000000000000, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.5909090909090, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.6818181818180, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.5909090909090}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.5000000000000}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.4090909090910}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.4090909090910, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.5000000000000, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.5909090909090, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.5000000000000}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.4090909090910}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.3181818181820}, +0.108823933894333},
  {{0.2272727272730, 0.3181818181820, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.4090909090910, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.5000000000000, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.3181818181820, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.3181818181820, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.4090909090910, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.4090909090910, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.4090909090910, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.5000000000000, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.5000000000000, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.5000000000000, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.5909090909090, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.5909090909090, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.6818181818180, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.5909090909090}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.5000000000000}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.5000000000000, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.5909090909090, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.5000000000000}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.4090909090910}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.4090909090910, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.5000000000000, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.3181818181820, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.4090909090910, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.4090909090910, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.5000000000000, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.5000000000000, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.5909090909090, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.5000000000000}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.5000000000000, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.4090909090910, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.5000000000000, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.4090909090910}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.4090909090910, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.3181818181820, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.4090909090910, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.3181818181820}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.3181818181820, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.2272727272730, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.3181818181820, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.2272727272730}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.2272727272730, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.1363636363640, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.2272727272730, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.1363636363640}, +0.108823933894333},
  {{0.0454545454545, 0.1363636363640, 0.0454545454545}, +0.108823933894333},
  {{0.1363636363640, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0454545454545, 0.0454545454545, 0.0454545454545}, +0.108823933894333},
  {{0.0500000000000, 0.0500000000000, 0.8500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.7500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.4500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.5500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.6500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.7500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.8500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.7500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.3500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.4500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.5500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.6500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.7500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.2500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.3500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.4500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.5500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.6500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.1500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.2500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.3500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.4500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.5500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.0500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.1500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.2500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.3500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.4500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.7500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.7500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.8500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.7500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.4500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.5500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.6500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.7500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.3500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.4500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.5500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.6500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.2500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.3500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.4500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.5500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.1500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.2500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.3500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.4500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.7500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.6500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.4500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.5500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.6500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.3500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.4500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.5500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.3500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.4500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.6500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.5500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.4500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.5500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.3500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.4500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.5500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.4500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.4500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.4500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.3500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.3500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.3500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.2500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.2500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.2500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.1500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.1500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.1500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0500000000000, 0.0500000000000, 0.0500000000000}, -0.391458821268333},
  {{0.0555555555556, 0.0555555555556, 0.8333333333330}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.7222222222220}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.6111111111110}, +0.555242962163333},
  {{0.0555555555556, 0.3888888888890, 0.5000000000000}, +0.555242962163333},
  {{0.0555555555556, 0.5000000000000, 0.3888888888890}, +0.555242962163333},
  {{0.0555555555556, 0.6111111111110, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.7222222222220, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.8333333333330, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.7222222222220}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.6111111111110}, +0.555242962163333},
  {{0.1666666666670, 0.2777777777780, 0.5000000000000}, +0.555242962163333},
  {{0.1666666666670, 0.3888888888890, 0.3888888888890}, +0.555242962163333},
  {{0.1666666666670, 0.5000000000000, 0.2777777777780}, +0.555242962163333},
  {{0.1666666666670, 0.6111111111110, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.7222222222220, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.6111111111110}, +0.555242962163333},
  {{0.2777777777780, 0.1666666666670, 0.5000000000000}, +0.555242962163333},
  {{0.2777777777780, 0.2777777777780, 0.3888888888890}, +0.555242962163333},
  {{0.2777777777780, 0.3888888888890, 0.2777777777780}, +0.555242962163333},
  {{0.2777777777780, 0.5000000000000, 0.1666666666670}, +0.555242962163333},
  {{0.2777777777780, 0.6111111111110, 0.0555555555556}, +0.555242962163333},
  {{0.3888888888890, 0.0555555555556, 0.5000000000000}, +0.555242962163333},
  {{0.3888888888890, 0.1666666666670, 0.3888888888890}, +0.555242962163333},
  {{0.3888888888890, 0.2777777777780, 0.2777777777780}, +0.555242962163333},
  {{0.3888888888890, 0.3888888888890, 0.1666666666670}, +0.555242962163333},
  {{0.3888888888890, 0.5000000000000, 0.0555555555556}, +0.555242962163333},
  {{0.5000000000000, 0.0555555555556, 0.3888888888890}, +0.555242962163333},
  {{0.5000000000000, 0.1666666666670, 0.2777777777780}, +0.555242962163333},
  {{0.5000000000000, 0.2777777777780, 0.1666666666670}, +0.555242962163333},
  {{0.5000000000000, 0.3888888888890, 0.0555555555556}, +0.555242962163333},
  {{0.6111111111110, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.6111111111110, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.6111111111110, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.7222222222220, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.7222222222220, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.8333333333330, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.7222222222220}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.6111111111110}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.5000000000000}, +0.555242962163333},
  {{0.0555555555556, 0.3888888888890, 0.3888888888890}, +0.555242962163333},
  {{0.0555555555556, 0.5000000000000, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.6111111111110, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.7222222222220, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.6111111111110}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, +0.555242962163333},
  {{0.1666666666670, 0.2777777777780, 0.3888888888890}, +0.555242962163333},
  {{0.1666666666670, 0.3888888888890, 0.2777777777780}, +0.555242962163333},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.6111111111110, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.5000000000000}, +0.555242962163333},
  {{0.2777777777780, 0.1666666666670, 0.3888888888890}, +0.555242962163333},
  {{0.2777777777780, 0.2777777777780, 0.2777777777780}, +0.555242962163333},
  {{0.2777777777780, 0.3888888888890, 0.1666666666670}, +0.555242962163333},
  {{0.2777777777780, 0.5000000000000, 0.0555555555556}, +0.555242962163333},
  {{0.3888888888890, 0.0555555555556, 0.3888888888890}, +0.555242962163333},
  {{0.3888888888890, 0.1666666666670, 0.2777777777780}, +0.555242962163333},
  {{0.3888888888890, 0.2777777777780, 0.1666666666670}, +0.555242962163333},
  {{0.3888888888890, 0.3888888888890, 0.0555555555556}, +0.555242962163333},
  {{0.5000000000000, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.5000000000000, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.6111111111110, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.6111111111110, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.7222222222220, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.6111111111110}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.5000000000000}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.3888888888890}, +0.555242962163333},
  {{0.0555555555556, 0.3888888888890, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.5000000000000, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.6111111111110, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.5000000000000}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.3888888888890}, +0.555242962163333},
  {{0.1666666666670, 0.2777777777780, 0.2777777777780}, +0.555242962163333},
  {{0.1666666666670, 0.3888888888890, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.5000000000000, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.3888888888890}, +0.555242962163333},
  {{0.2777777777780, 0.1666666666670, 0.2777777777780}, +0.555242962163333},
  {{0.2777777777780, 0.2777777777780, 0.1666666666670}, +0.555242962163333},
  {{0.2777777777780, 0.3888888888890, 0.0555555555556}, +0.555242962163333},
  {{0.3888888888890, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.3888888888890, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.3888888888890, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.5000000000000, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.5000000000000, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.6111111111110, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.5000000000000}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.3888888888890}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.3888888888890, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.5000000000000, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.3888888888890}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.2777777777780}, +0.555242962163333},
  {{0.1666666666670, 0.2777777777780, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.3888888888890, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.2777777777780, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.2777777777780, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.3888888888890, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.3888888888890, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.5000000000000, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.3888888888890}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.3888888888890, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.2777777777780, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.3888888888890, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.2777777777780}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.2777777777780, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.1666666666670, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.2777777777780, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.1666666666670}, +0.555242962163333},
  {{0.0555555555556, 0.1666666666670, 0.0555555555556}, +0.555242962163333},
  {{0.1666666666670, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0555555555556, 0.0555555555556, 0.0555555555556}, +0.555242962163333},
  {{0.0625000000000, 0.0625000000000, 0.8125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.6875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.3125000000000, 0.5625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.4375000000000, 0.4375000000000}, -0.394906131556667},
  {{0.0625000000000, 0.5625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.6875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.8125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.6875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.1875000000000, 0.5625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.3125000000000, 0.4375000000000}, -0.394906131556667},
  {{0.1875000000000, 0.4375000000000, 0.3125000000000}, -0.394906131556667},
  {{0.1875000000000, 0.5625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.6875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.0625000000000, 0.5625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.1875000000000, 0.4375000000000}, -0.394906131556667},
  {{0.3125000000000, 0.3125000000000, 0.3125000000000}, -0.394906131556667},
  {{0.3125000000000, 0.4375000000000, 0.1875000000000}, -0.394906131556667},
  {{0.3125000000000, 0.5625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.4375000000000, 0.0625000000000, 0.4375000000000}, -0.394906131556667},
  {{0.4375000000000, 0.1875000000000, 0.3125000000000}, -0.394906131556667},
  {{0.4375000000000, 0.3125000000000, 0.1875000000000}, -0.394906131556667},
  {{0.4375000000000, 0.4375000000000, 0.0625000000000}, -0.394906131556667},
  {{0.5625000000000, 0.0625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.5625000000000, 0.1875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.5625000000000, 0.3125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.6875000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.6875000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.8125000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.6875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.5625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.3125000000000, 0.4375000000000}, -0.394906131556667},
  {{0.0625000000000, 0.4375000000000, 0.3125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.5625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.6875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.5625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.1875000000000, 0.4375000000000}, -0.394906131556667},
  {{0.1875000000000, 0.3125000000000, 0.3125000000000}, -0.394906131556667},
  {{0.1875000000000, 0.4375000000000, 0.1875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.5625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.0625000000000, 0.4375000000000}, -0.394906131556667},
  {{0.3125000000000, 0.1875000000000, 0.3125000000000}, -0.394906131556667},
  {{0.3125000000000, 0.3125000000000, 0.1875000000000}, -0.394906131556667},
  {{0.3125000000000, 0.4375000000000, 0.0625000000000}, -0.394906131556667},
  {{0.4375000000000, 0.0625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.4375000000000, 0.1875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.4375000000000, 0.3125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.5625000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.5625000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.6875000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.5625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.4375000000000}, -0.394906131556667},
  {{0.0625000000000, 0.3125000000000, 0.3125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.4375000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.5625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.4375000000000}, -0.394906131556667},
  {{0.1875000000000, 0.1875000000000, 0.3125000000000}, -0.394906131556667},
  {{0.1875000000000, 0.3125000000000, 0.1875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.4375000000000, 0.0625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.0625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.3125000000000, 0.1875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.3125000000000, 0.3125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.4375000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.4375000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.5625000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.4375000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.3125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.3125000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.4375000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.1875000000000, 0.1875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.3125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.3125000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.4375000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.3125000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.3125000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.1875000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.3125000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.1875000000000}, -0.394906131556667},
  {{0.0625000000000, 0.1875000000000, 0.0625000000000}, -0.394906131556667},
  {{0.1875000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0625000000000, 0.0625000000000, 0.0625000000000}, -0.394906131556667},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, +0.148368085928000},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, +0.148368085928000},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, +0.148368085928000},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, +0.148368085928000},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, +0.148368085928000},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, +0.148368085928000},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, +0.148368085928000},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, +0.148368085928000},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, +0.148368085928000},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, +0.148368085928000},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, +0.148368085928000},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, +0.148368085928000},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, +0.148368085928000},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, +0.148368085928000},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, +0.148368085928000},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, +0.148368085928000},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, +0.148368085928000},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, +0.148368085928000},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, +0.148368085928000},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, +0.148368085928000},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, +0.148368085928000},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, +0.148368085928000},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, +0.148368085928000},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, +0.148368085928000},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, +0.148368085928000},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, +0.148368085928000},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, +0.148368085928000},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, +0.148368085928000},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, +0.148368085928000},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, +0.148368085928000},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, +0.148368085928000},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, +0.148368085928000},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, +0.148368085928000},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, +0.148368085928000},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, +0.148368085928000},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, +0.148368085928000},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, +0.148368085928000},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, +0.148368085928000},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, +0.148368085928000},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, +0.148368085928000},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, +0.148368085928000},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, +0.148368085928000},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, +0.148368085928000},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, +0.148368085928000},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, +0.148368085928000},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, +0.148368085928000},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, +0.148368085928000},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, +0.148368085928000},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, +0.148368085928000},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, +0.148368085928000},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, +0.148368085928000},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, -0.028553147692667},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, -0.028553147692667},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, -0.028553147692667},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, -0.028553147692667},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, -0.028553147692667},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, -0.028553147692667},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, -0.028553147692667},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, -0.028553147692667},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, -0.028553147692667},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, -0.028553147692667},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, -0.028553147692667},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, -0.028553147692667},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, -0.028553147692667},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, -0.028553147692667},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, -0.028553147692667},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, -0.028553147692667},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, -0.028553147692667},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, -0.028553147692667},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, -0.028553147692667},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, -0.028553147692667},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -0.028553147692667},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, -0.028553147692667},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, -0.028553147692667},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, -0.028553147692667},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, -0.028553147692667},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, -0.028553147692667},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, -0.028553147692667},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, -0.028553147692667},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, -0.028553147692667},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, -0.028553147692667},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, -0.028553147692667},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, -0.028553147692667},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, -0.028553147692667},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, -0.028553147692667},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, -0.028553147692667},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, +0.002532258209850},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, -8.3414141296e-05},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, -8.3414141296e-05},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, -8.3414141296e-05},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, -8.3414141296e-05},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, -8.3414141296e-05},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, +6.6130980188e-07},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, +6.6130980188e-07},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, +6.6130980188e-07},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, +6.6130980188e-07},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, -4.6404125000e-10}
};

// 295 negative weights, 0 points outside of the tetrahedron 


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 21 on the tetrahedron */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt tetP21Solin[1001] = {
  {{0.0416666666667, 0.0416666666667, 0.8750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.7916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.7083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.6250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.5416666666670}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.5416666666670, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.6250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.7083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.7916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.8750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.7916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.7083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.6250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.5416666666670}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.4583333333330}, +0.148296360441500},
  {{0.1250000000000, 0.4583333333330, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.5416666666670, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.6250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.7083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.7916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.7083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.6250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.5416666666670}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.4583333333330}, +0.148296360441500},
  {{0.2083333333330, 0.3750000000000, 0.3750000000000}, +0.148296360441500},
  {{0.2083333333330, 0.4583333333330, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.5416666666670, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.6250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.7083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.6250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.5416666666670}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.4583333333330}, +0.148296360441500},
  {{0.2916666666670, 0.2916666666670, 0.3750000000000}, +0.148296360441500},
  {{0.2916666666670, 0.3750000000000, 0.2916666666670}, +0.148296360441500},
  {{0.2916666666670, 0.4583333333330, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.5416666666670, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.6250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.5416666666670}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.4583333333330}, +0.148296360441500},
  {{0.3750000000000, 0.2083333333330, 0.3750000000000}, +0.148296360441500},
  {{0.3750000000000, 0.2916666666670, 0.2916666666670}, +0.148296360441500},
  {{0.3750000000000, 0.3750000000000, 0.2083333333330}, +0.148296360441500},
  {{0.3750000000000, 0.4583333333330, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.5416666666670, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.4583333333330, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.4583333333330, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.4583333333330, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.4583333333330, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.4583333333330, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.5416666666670, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.5416666666670, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.5416666666670, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.5416666666670, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.5416666666670, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.6250000000000, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.6250000000000, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.6250000000000, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.6250000000000, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.7083333333330, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.7083333333330, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.7083333333330, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.7916666666670, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.7916666666670, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.8750000000000, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.7916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.7083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.6250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.5416666666670}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.5416666666670, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.6250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.7083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.7916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.7083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.5416666666670}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.4583333333330}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.4583333333330, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.5416666666670, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.7083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.6250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.5416666666670}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.4583333333330}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.3750000000000}, +0.148296360441500},
  {{0.2083333333330, 0.3750000000000, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.4583333333330, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.5416666666670, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.6250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.5416666666670}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.4583333333330}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.3750000000000}, +0.148296360441500},
  {{0.2916666666670, 0.2916666666670, 0.2916666666670}, +0.148296360441500},
  {{0.2916666666670, 0.3750000000000, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.4583333333330, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.5416666666670, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.3750000000000, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.3750000000000, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.4583333333330, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.4583333333330, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.4583333333330, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.4583333333330, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.5416666666670, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.5416666666670, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.5416666666670, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.5416666666670, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.6250000000000, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.6250000000000, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.7083333333330, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.7083333333330, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.7916666666670, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.7083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.6250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.5416666666670}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.5416666666670, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.6250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.7083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.6250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.5416666666670}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.4583333333330}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.4583333333330, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.5416666666670, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.6250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.5416666666670}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.4583333333330}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.3750000000000}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.3750000000000, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.4583333333330, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.5416666666670, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.2916666666670, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.3750000000000, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.3750000000000, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.4583333333330, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.4583333333330, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.4583333333330, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.5416666666670, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.5416666666670, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.5416666666670, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.6250000000000, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.6250000000000, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.7083333333330, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.6250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.5416666666670}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.5416666666670, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.6250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.5416666666670}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.4583333333330}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.4583333333330, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.5416666666670, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.3750000000000, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.4583333333330, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.4583333333330, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.5416666666670, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.5416666666670, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.6250000000000, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.5416666666670}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.5416666666670, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.4583333333330, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.5416666666670, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.4583333333330}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.4583333333330, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.3750000000000, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.4583333333330, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.3750000000000}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.3750000000000, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.2916666666670, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.3750000000000, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.2916666666670}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2916666666670, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.2083333333330, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2916666666670, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.2083333333330}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.2083333333330, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.1250000000000, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.2083333333330, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.1250000000000}, +0.148296360441500},
  {{0.0416666666667, 0.1250000000000, 0.0416666666667}, +0.148296360441500},
  {{0.1250000000000, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0416666666667, 0.0416666666667, 0.0416666666667}, +0.148296360441500},
  {{0.0454545454545, 0.0454545454545, 0.8636363636360}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.7727272727270}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.6818181818180}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.5909090909090}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.5000000000000}, -0.572508521791667},
  {{0.0454545454545, 0.5000000000000, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.5909090909090, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.6818181818180, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.7727272727270, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.8636363636360, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.7727272727270}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.6818181818180}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.5909090909090}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.5000000000000}, -0.572508521791667},
  {{0.1363636363640, 0.4090909090910, 0.4090909090910}, -0.572508521791667},
  {{0.1363636363640, 0.5000000000000, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.5909090909090, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.6818181818180, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.7727272727270, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.6818181818180}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.5909090909090}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.5000000000000}, -0.572508521791667},
  {{0.2272727272730, 0.3181818181820, 0.4090909090910}, -0.572508521791667},
  {{0.2272727272730, 0.4090909090910, 0.3181818181820}, -0.572508521791667},
  {{0.2272727272730, 0.5000000000000, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.5909090909090, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.6818181818180, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.5909090909090}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.5000000000000}, -0.572508521791667},
  {{0.3181818181820, 0.2272727272730, 0.4090909090910}, -0.572508521791667},
  {{0.3181818181820, 0.3181818181820, 0.3181818181820}, -0.572508521791667},
  {{0.3181818181820, 0.4090909090910, 0.2272727272730}, -0.572508521791667},
  {{0.3181818181820, 0.5000000000000, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.5909090909090, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.5000000000000}, -0.572508521791667},
  {{0.4090909090910, 0.1363636363640, 0.4090909090910}, -0.572508521791667},
  {{0.4090909090910, 0.2272727272730, 0.3181818181820}, -0.572508521791667},
  {{0.4090909090910, 0.3181818181820, 0.2272727272730}, -0.572508521791667},
  {{0.4090909090910, 0.4090909090910, 0.1363636363640}, -0.572508521791667},
  {{0.4090909090910, 0.5000000000000, 0.0454545454545}, -0.572508521791667},
  {{0.5000000000000, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.5000000000000, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.5000000000000, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.5000000000000, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.5000000000000, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.5909090909090, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.5909090909090, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.5909090909090, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.5909090909090, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.6818181818180, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.6818181818180, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.6818181818180, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.7727272727270, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.7727272727270, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.8636363636360, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.7727272727270}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.6818181818180}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.5909090909090}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.5000000000000}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.5000000000000, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.5909090909090, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.6818181818180, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.7727272727270, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.6818181818180}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.5909090909090}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.5000000000000}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.4090909090910}, -0.572508521791667},
  {{0.1363636363640, 0.4090909090910, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.5000000000000, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.5909090909090, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.6818181818180, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.5909090909090}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.5000000000000}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.4090909090910}, -0.572508521791667},
  {{0.2272727272730, 0.3181818181820, 0.3181818181820}, -0.572508521791667},
  {{0.2272727272730, 0.4090909090910, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.5000000000000, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.5909090909090, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.5000000000000}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.4090909090910}, -0.572508521791667},
  {{0.3181818181820, 0.2272727272730, 0.3181818181820}, -0.572508521791667},
  {{0.3181818181820, 0.3181818181820, 0.2272727272730}, -0.572508521791667},
  {{0.3181818181820, 0.4090909090910, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.5000000000000, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.4090909090910, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.4090909090910, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.4090909090910, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.4090909090910, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.5000000000000, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.5000000000000, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.5000000000000, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.5000000000000, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.5909090909090, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.5909090909090, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.5909090909090, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.6818181818180, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.6818181818180, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.7727272727270, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.6818181818180}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.5909090909090}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.5000000000000}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.5000000000000, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.5909090909090, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.6818181818180, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.5909090909090}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.5000000000000}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.4090909090910}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.4090909090910, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.5000000000000, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.5909090909090, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.5000000000000}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.4090909090910}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.3181818181820}, -0.572508521791667},
  {{0.2272727272730, 0.3181818181820, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.4090909090910, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.5000000000000, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.3181818181820, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.3181818181820, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.4090909090910, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.4090909090910, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.4090909090910, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.5000000000000, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.5000000000000, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.5000000000000, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.5909090909090, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.5909090909090, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.6818181818180, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.5909090909090}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.5000000000000}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.5000000000000, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.5909090909090, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.5000000000000}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.4090909090910}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.4090909090910, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.5000000000000, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.3181818181820, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.4090909090910, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.4090909090910, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.5000000000000, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.5000000000000, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.5909090909090, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.5000000000000}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.5000000000000, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.4090909090910, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.5000000000000, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.4090909090910}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.4090909090910, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.3181818181820, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.4090909090910, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.3181818181820}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.3181818181820, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.2272727272730, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.3181818181820, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.2272727272730}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.2272727272730, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.1363636363640, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.2272727272730, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.1363636363640}, -0.572508521791667},
  {{0.0454545454545, 0.1363636363640, 0.0454545454545}, -0.572508521791667},
  {{0.1363636363640, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0454545454545, 0.0454545454545, 0.0454545454545}, -0.572508521791667},
  {{0.0500000000000, 0.0500000000000, 0.8500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.7500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.4500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.5500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.6500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.7500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.8500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.7500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.3500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.4500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.5500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.6500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.7500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.2500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.3500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.4500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.5500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.6500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.1500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.2500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.3500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.4500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.5500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.0500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.1500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.2500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.3500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.4500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.7500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.7500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.8500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.7500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.4500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.5500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.6500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.7500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.3500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.4500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.5500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.6500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.2500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.3500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.4500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.5500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.1500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.2500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.3500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.4500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.7500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.6500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.4500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.5500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.6500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.3500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.4500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.5500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.3500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.4500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.6500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.5500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.4500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.5500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.3500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.4500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.5500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.4500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.4500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.4500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.3500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.3500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.3500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.2500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.2500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.2500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.1500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.1500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.1500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0500000000000, 0.0500000000000, 0.0500000000000}, +0.889679139245000},
  {{0.0555555555556, 0.0555555555556, 0.8333333333330}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.7222222222220}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.6111111111110}, -0.713883808495000},
  {{0.0555555555556, 0.3888888888890, 0.5000000000000}, -0.713883808495000},
  {{0.0555555555556, 0.5000000000000, 0.3888888888890}, -0.713883808495000},
  {{0.0555555555556, 0.6111111111110, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.7222222222220, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.8333333333330, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.7222222222220}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.6111111111110}, -0.713883808495000},
  {{0.1666666666670, 0.2777777777780, 0.5000000000000}, -0.713883808495000},
  {{0.1666666666670, 0.3888888888890, 0.3888888888890}, -0.713883808495000},
  {{0.1666666666670, 0.5000000000000, 0.2777777777780}, -0.713883808495000},
  {{0.1666666666670, 0.6111111111110, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.7222222222220, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.6111111111110}, -0.713883808495000},
  {{0.2777777777780, 0.1666666666670, 0.5000000000000}, -0.713883808495000},
  {{0.2777777777780, 0.2777777777780, 0.3888888888890}, -0.713883808495000},
  {{0.2777777777780, 0.3888888888890, 0.2777777777780}, -0.713883808495000},
  {{0.2777777777780, 0.5000000000000, 0.1666666666670}, -0.713883808495000},
  {{0.2777777777780, 0.6111111111110, 0.0555555555556}, -0.713883808495000},
  {{0.3888888888890, 0.0555555555556, 0.5000000000000}, -0.713883808495000},
  {{0.3888888888890, 0.1666666666670, 0.3888888888890}, -0.713883808495000},
  {{0.3888888888890, 0.2777777777780, 0.2777777777780}, -0.713883808495000},
  {{0.3888888888890, 0.3888888888890, 0.1666666666670}, -0.713883808495000},
  {{0.3888888888890, 0.5000000000000, 0.0555555555556}, -0.713883808495000},
  {{0.5000000000000, 0.0555555555556, 0.3888888888890}, -0.713883808495000},
  {{0.5000000000000, 0.1666666666670, 0.2777777777780}, -0.713883808495000},
  {{0.5000000000000, 0.2777777777780, 0.1666666666670}, -0.713883808495000},
  {{0.5000000000000, 0.3888888888890, 0.0555555555556}, -0.713883808495000},
  {{0.6111111111110, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.6111111111110, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.6111111111110, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.7222222222220, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.7222222222220, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.8333333333330, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.7222222222220}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.6111111111110}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.5000000000000}, -0.713883808495000},
  {{0.0555555555556, 0.3888888888890, 0.3888888888890}, -0.713883808495000},
  {{0.0555555555556, 0.5000000000000, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.6111111111110, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.7222222222220, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.6111111111110}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, -0.713883808495000},
  {{0.1666666666670, 0.2777777777780, 0.3888888888890}, -0.713883808495000},
  {{0.1666666666670, 0.3888888888890, 0.2777777777780}, -0.713883808495000},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.6111111111110, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.5000000000000}, -0.713883808495000},
  {{0.2777777777780, 0.1666666666670, 0.3888888888890}, -0.713883808495000},
  {{0.2777777777780, 0.2777777777780, 0.2777777777780}, -0.713883808495000},
  {{0.2777777777780, 0.3888888888890, 0.1666666666670}, -0.713883808495000},
  {{0.2777777777780, 0.5000000000000, 0.0555555555556}, -0.713883808495000},
  {{0.3888888888890, 0.0555555555556, 0.3888888888890}, -0.713883808495000},
  {{0.3888888888890, 0.1666666666670, 0.2777777777780}, -0.713883808495000},
  {{0.3888888888890, 0.2777777777780, 0.1666666666670}, -0.713883808495000},
  {{0.3888888888890, 0.3888888888890, 0.0555555555556}, -0.713883808495000},
  {{0.5000000000000, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.5000000000000, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.6111111111110, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.6111111111110, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.7222222222220, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.6111111111110}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.5000000000000}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.3888888888890}, -0.713883808495000},
  {{0.0555555555556, 0.3888888888890, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.5000000000000, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.6111111111110, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.5000000000000}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.3888888888890}, -0.713883808495000},
  {{0.1666666666670, 0.2777777777780, 0.2777777777780}, -0.713883808495000},
  {{0.1666666666670, 0.3888888888890, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.5000000000000, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.3888888888890}, -0.713883808495000},
  {{0.2777777777780, 0.1666666666670, 0.2777777777780}, -0.713883808495000},
  {{0.2777777777780, 0.2777777777780, 0.1666666666670}, -0.713883808495000},
  {{0.2777777777780, 0.3888888888890, 0.0555555555556}, -0.713883808495000},
  {{0.3888888888890, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.3888888888890, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.3888888888890, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.5000000000000, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.5000000000000, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.6111111111110, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.5000000000000}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.3888888888890}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.3888888888890, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.5000000000000, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.3888888888890}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.2777777777780}, -0.713883808495000},
  {{0.1666666666670, 0.2777777777780, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.3888888888890, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.2777777777780, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.2777777777780, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.3888888888890, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.3888888888890, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.5000000000000, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.3888888888890}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.3888888888890, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.2777777777780, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.3888888888890, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.2777777777780}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.2777777777780, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.1666666666670, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.2777777777780, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.1666666666670}, -0.713883808495000},
  {{0.0555555555556, 0.1666666666670, 0.0555555555556}, -0.713883808495000},
  {{0.1666666666670, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0555555555556, 0.0555555555556, 0.0555555555556}, -0.713883808495000},
  {{0.0625000000000, 0.0625000000000, 0.8125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.6875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.3125000000000, 0.5625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.4375000000000, 0.4375000000000}, +0.315924905245000},
  {{0.0625000000000, 0.5625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.6875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.8125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.6875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.1875000000000, 0.5625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.3125000000000, 0.4375000000000}, +0.315924905245000},
  {{0.1875000000000, 0.4375000000000, 0.3125000000000}, +0.315924905245000},
  {{0.1875000000000, 0.5625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.6875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.0625000000000, 0.5625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.1875000000000, 0.4375000000000}, +0.315924905245000},
  {{0.3125000000000, 0.3125000000000, 0.3125000000000}, +0.315924905245000},
  {{0.3125000000000, 0.4375000000000, 0.1875000000000}, +0.315924905245000},
  {{0.3125000000000, 0.5625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.4375000000000, 0.0625000000000, 0.4375000000000}, +0.315924905245000},
  {{0.4375000000000, 0.1875000000000, 0.3125000000000}, +0.315924905245000},
  {{0.4375000000000, 0.3125000000000, 0.1875000000000}, +0.315924905245000},
  {{0.4375000000000, 0.4375000000000, 0.0625000000000}, +0.315924905245000},
  {{0.5625000000000, 0.0625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.5625000000000, 0.1875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.5625000000000, 0.3125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.6875000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.6875000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.8125000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.6875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.5625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.3125000000000, 0.4375000000000}, +0.315924905245000},
  {{0.0625000000000, 0.4375000000000, 0.3125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.5625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.6875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.5625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.1875000000000, 0.4375000000000}, +0.315924905245000},
  {{0.1875000000000, 0.3125000000000, 0.3125000000000}, +0.315924905245000},
  {{0.1875000000000, 0.4375000000000, 0.1875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.5625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.0625000000000, 0.4375000000000}, +0.315924905245000},
  {{0.3125000000000, 0.1875000000000, 0.3125000000000}, +0.315924905245000},
  {{0.3125000000000, 0.3125000000000, 0.1875000000000}, +0.315924905245000},
  {{0.3125000000000, 0.4375000000000, 0.0625000000000}, +0.315924905245000},
  {{0.4375000000000, 0.0625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.4375000000000, 0.1875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.4375000000000, 0.3125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.5625000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.5625000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.6875000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.5625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.4375000000000}, +0.315924905245000},
  {{0.0625000000000, 0.3125000000000, 0.3125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.4375000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.5625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.4375000000000}, +0.315924905245000},
  {{0.1875000000000, 0.1875000000000, 0.3125000000000}, +0.315924905245000},
  {{0.1875000000000, 0.3125000000000, 0.1875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.4375000000000, 0.0625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.0625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.3125000000000, 0.1875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.3125000000000, 0.3125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.4375000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.4375000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.5625000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.4375000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.3125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.3125000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.4375000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.1875000000000, 0.1875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.3125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.3125000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.4375000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.3125000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.3125000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.1875000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.3125000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.1875000000000}, +0.315924905245000},
  {{0.0625000000000, 0.1875000000000, 0.0625000000000}, +0.315924905245000},
  {{0.1875000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0625000000000, 0.0625000000000, 0.0625000000000}, +0.315924905245000},
  {{0.0714285714286, 0.0714285714286, 0.7857142857140}, -0.076526696952333},
  {{0.0714285714286, 0.2142857142860, 0.6428571428570}, -0.076526696952333},
  {{0.0714285714286, 0.3571428571430, 0.5000000000000}, -0.076526696952333},
  {{0.0714285714286, 0.5000000000000, 0.3571428571430}, -0.076526696952333},
  {{0.0714285714286, 0.6428571428570, 0.2142857142860}, -0.076526696952333},
  {{0.0714285714286, 0.7857142857140, 0.0714285714286}, -0.076526696952333},
  {{0.2142857142860, 0.0714285714286, 0.6428571428570}, -0.076526696952333},
  {{0.2142857142860, 0.2142857142860, 0.5000000000000}, -0.076526696952333},
  {{0.2142857142860, 0.3571428571430, 0.3571428571430}, -0.076526696952333},
  {{0.2142857142860, 0.5000000000000, 0.2142857142860}, -0.076526696952333},
  {{0.2142857142860, 0.6428571428570, 0.0714285714286}, -0.076526696952333},
  {{0.3571428571430, 0.0714285714286, 0.5000000000000}, -0.076526696952333},
  {{0.3571428571430, 0.2142857142860, 0.3571428571430}, -0.076526696952333},
  {{0.3571428571430, 0.3571428571430, 0.2142857142860}, -0.076526696952333},
  {{0.3571428571430, 0.5000000000000, 0.0714285714286}, -0.076526696952333},
  {{0.5000000000000, 0.0714285714286, 0.3571428571430}, -0.076526696952333},
  {{0.5000000000000, 0.2142857142860, 0.2142857142860}, -0.076526696952333},
  {{0.5000000000000, 0.3571428571430, 0.0714285714286}, -0.076526696952333},
  {{0.6428571428570, 0.0714285714286, 0.2142857142860}, -0.076526696952333},
  {{0.6428571428570, 0.2142857142860, 0.0714285714286}, -0.076526696952333},
  {{0.7857142857140, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0714285714286, 0.0714285714286, 0.6428571428570}, -0.076526696952333},
  {{0.0714285714286, 0.2142857142860, 0.5000000000000}, -0.076526696952333},
  {{0.0714285714286, 0.3571428571430, 0.3571428571430}, -0.076526696952333},
  {{0.0714285714286, 0.5000000000000, 0.2142857142860}, -0.076526696952333},
  {{0.0714285714286, 0.6428571428570, 0.0714285714286}, -0.076526696952333},
  {{0.2142857142860, 0.0714285714286, 0.5000000000000}, -0.076526696952333},
  {{0.2142857142860, 0.2142857142860, 0.3571428571430}, -0.076526696952333},
  {{0.2142857142860, 0.3571428571430, 0.2142857142860}, -0.076526696952333},
  {{0.2142857142860, 0.5000000000000, 0.0714285714286}, -0.076526696952333},
  {{0.3571428571430, 0.0714285714286, 0.3571428571430}, -0.076526696952333},
  {{0.3571428571430, 0.2142857142860, 0.2142857142860}, -0.076526696952333},
  {{0.3571428571430, 0.3571428571430, 0.0714285714286}, -0.076526696952333},
  {{0.5000000000000, 0.0714285714286, 0.2142857142860}, -0.076526696952333},
  {{0.5000000000000, 0.2142857142860, 0.0714285714286}, -0.076526696952333},
  {{0.6428571428570, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0714285714286, 0.0714285714286, 0.5000000000000}, -0.076526696952333},
  {{0.0714285714286, 0.2142857142860, 0.3571428571430}, -0.076526696952333},
  {{0.0714285714286, 0.3571428571430, 0.2142857142860}, -0.076526696952333},
  {{0.0714285714286, 0.5000000000000, 0.0714285714286}, -0.076526696952333},
  {{0.2142857142860, 0.0714285714286, 0.3571428571430}, -0.076526696952333},
  {{0.2142857142860, 0.2142857142860, 0.2142857142860}, -0.076526696952333},
  {{0.2142857142860, 0.3571428571430, 0.0714285714286}, -0.076526696952333},
  {{0.3571428571430, 0.0714285714286, 0.2142857142860}, -0.076526696952333},
  {{0.3571428571430, 0.2142857142860, 0.0714285714286}, -0.076526696952333},
  {{0.5000000000000, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0714285714286, 0.0714285714286, 0.3571428571430}, -0.076526696952333},
  {{0.0714285714286, 0.2142857142860, 0.2142857142860}, -0.076526696952333},
  {{0.0714285714286, 0.3571428571430, 0.0714285714286}, -0.076526696952333},
  {{0.2142857142860, 0.0714285714286, 0.2142857142860}, -0.076526696952333},
  {{0.2142857142860, 0.2142857142860, 0.0714285714286}, -0.076526696952333},
  {{0.3571428571430, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0714285714286, 0.0714285714286, 0.2142857142860}, -0.076526696952333},
  {{0.0714285714286, 0.2142857142860, 0.0714285714286}, -0.076526696952333},
  {{0.2142857142860, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0714285714286, 0.0714285714286, 0.0714285714286}, -0.076526696952333},
  {{0.0833333333333, 0.0833333333333, 0.7500000000000}, +0.009517715897550},
  {{0.0833333333333, 0.2500000000000, 0.5833333333330}, +0.009517715897550},
  {{0.0833333333333, 0.4166666666670, 0.4166666666670}, +0.009517715897550},
  {{0.0833333333333, 0.5833333333330, 0.2500000000000}, +0.009517715897550},
  {{0.0833333333333, 0.7500000000000, 0.0833333333333}, +0.009517715897550},
  {{0.2500000000000, 0.0833333333333, 0.5833333333330}, +0.009517715897550},
  {{0.2500000000000, 0.2500000000000, 0.4166666666670}, +0.009517715897550},
  {{0.2500000000000, 0.4166666666670, 0.2500000000000}, +0.009517715897550},
  {{0.2500000000000, 0.5833333333330, 0.0833333333333}, +0.009517715897550},
  {{0.4166666666670, 0.0833333333333, 0.4166666666670}, +0.009517715897550},
  {{0.4166666666670, 0.2500000000000, 0.2500000000000}, +0.009517715897550},
  {{0.4166666666670, 0.4166666666670, 0.0833333333333}, +0.009517715897550},
  {{0.5833333333330, 0.0833333333333, 0.2500000000000}, +0.009517715897550},
  {{0.5833333333330, 0.2500000000000, 0.0833333333333}, +0.009517715897550},
  {{0.7500000000000, 0.0833333333333, 0.0833333333333}, +0.009517715897550},
  {{0.0833333333333, 0.0833333333333, 0.5833333333330}, +0.009517715897550},
  {{0.0833333333333, 0.2500000000000, 0.4166666666670}, +0.009517715897550},
  {{0.0833333333333, 0.4166666666670, 0.2500000000000}, +0.009517715897550},
  {{0.0833333333333, 0.5833333333330, 0.0833333333333}, +0.009517715897550},
  {{0.2500000000000, 0.0833333333333, 0.4166666666670}, +0.009517715897550},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +0.009517715897550},
  {{0.2500000000000, 0.4166666666670, 0.0833333333333}, +0.009517715897550},
  {{0.4166666666670, 0.0833333333333, 0.2500000000000}, +0.009517715897550},
  {{0.4166666666670, 0.2500000000000, 0.0833333333333}, +0.009517715897550},
  {{0.5833333333330, 0.0833333333333, 0.0833333333333}, +0.009517715897550},
  {{0.0833333333333, 0.0833333333333, 0.4166666666670}, +0.009517715897550},
  {{0.0833333333333, 0.2500000000000, 0.2500000000000}, +0.009517715897550},
  {{0.0833333333333, 0.4166666666670, 0.0833333333333}, +0.009517715897550},
  {{0.2500000000000, 0.0833333333333, 0.2500000000000}, +0.009517715897550},
  {{0.2500000000000, 0.2500000000000, 0.0833333333333}, +0.009517715897550},
  {{0.4166666666670, 0.0833333333333, 0.0833333333333}, +0.009517715897550},
  {{0.0833333333333, 0.0833333333333, 0.2500000000000}, +0.009517715897550},
  {{0.0833333333333, 0.2500000000000, 0.0833333333333}, +0.009517715897550},
  {{0.2500000000000, 0.0833333333333, 0.0833333333333}, +0.009517715897550},
  {{0.0833333333333, 0.0833333333333, 0.0833333333333}, +0.009517715897550},
  {{0.1000000000000, 0.1000000000000, 0.7000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.3000000000000, 0.5000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.5000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.7000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.1000000000000, 0.5000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.3000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.5000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.5000000000000, 0.1000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.5000000000000, 0.3000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.7000000000000, 0.1000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.1000000000000, 0.5000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.3000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.5000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.1000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.3000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.5000000000000, 0.1000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.1000000000000, 0.3000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.3000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.3000000000000, 0.1000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.1000000000000, 0.1000000000000, 0.1000000000000}, -0.000531987018878},
  {{0.1250000000000, 0.1250000000000, 0.6250000000000}, +1.0426767662e-05},
  {{0.1250000000000, 0.3750000000000, 0.3750000000000}, +1.0426767662e-05},
  {{0.1250000000000, 0.6250000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.3750000000000, 0.1250000000000, 0.3750000000000}, +1.0426767662e-05},
  {{0.3750000000000, 0.3750000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.6250000000000, 0.1250000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.1250000000000, 0.1250000000000, 0.3750000000000}, +1.0426767662e-05},
  {{0.1250000000000, 0.3750000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.3750000000000, 0.1250000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.1250000000000, 0.1250000000000, 0.1250000000000}, +1.0426767662e-05},
  {{0.1666666666670, 0.1666666666670, 0.5000000000000}, -4.4087320125e-08},
  {{0.1666666666670, 0.5000000000000, 0.1666666666670}, -4.4087320125e-08},
  {{0.5000000000000, 0.1666666666670, 0.1666666666670}, -4.4087320125e-08},
  {{0.1666666666670, 0.1666666666670, 0.1666666666670}, -4.4087320125e-08},
  {{0.2500000000000, 0.2500000000000, 0.2500000000000}, +1.3258375e-11}
};

// 420 negative weights, 0 points outside of the tetrahedron 

IntPt * GQTetSolin[22] = {
  tetP1Solin,
  tetP1Solin,
  tetP2Solin,
  tetP3Solin,
  tetP4Solin,
  tetP5Solin,
  tetP6Solin,
  tetP7Solin,
  tetP8Solin,
  tetP9Solin,
  tetP11Solin,
  tetP11Solin,
  tetP13Solin,
  tetP13Solin,
  tetP15Solin,
  tetP15Solin,
  tetP17Solin,
  tetP17Solin,
  tetP19Solin,
  tetP19Solin,
  tetP21Solin,
  tetP21Solin
};  
                            
int GQTetnPtSolin[22] = {
  1,
  1,
  4,
  5,
  11,
  14,
  24,
  31,
  43,
  53,
  126,
  126,
  210,
  210,
  330,
  330,
  495,
  495,
  715,
  715,
  1001,
  1001};

IntPt *getGQTetPts(int order);
int getNGQTetPts(int order);

IntPt *getGQTetPts(int order)
{
  // if(order < 7)
  //     return GQTet[order]; 
  
  if (order < 22) return GQTetSolin[order];
  
  int n = (order+4)/2;
  int index = n-5;
  if(!GQTetDegen[index]){
    int npts = n*n*n;
    GQTetDegen[index] = new IntPt[npts];
    GaussLegendreTet(n,n,n,GQTetDegen[index]);
  }
  return GQTetDegen[index];  
}

int getNGQTetPts(int order)
{ 
  //   if(order < 7)
  //     return GQTetnPt[order];

  if (order < 22) return GQTetnPtSolin[order];

  
  int n = (order+4)/2;
  return n*n*n;
}
