/*
 * Gmail. A Gnome email client.
 * Copyright (C) 1999-2000 Wayne Schuller
 *
 * incoming.c - stuff to checkmail via pop3.
 * Alot of this code was done using Spruce as a reference. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <sys/param.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>

#include "main.h" 

#define	ERROR	0
#define SUCCESS	1

void  checkmail_cb (GtkWidget *widget, void *data);
int pop3_check(MailSetup *msetup);
gboolean parse_pop3_msg(GString *msg, gchar *uid, DTimer *timer);
ssize_t recvline(int sock, void *vptr, size_t maxlen);
ssize_t recvch(int sock, char *ptr);
static int p_user(int sock, char *login);
static int p_pass(int sock, char *passwd, DTimer *timer);
static int p_stat(int sock, gint *num, gint *size);
static int p_list(int sock);
static int p_retr(int sock, int id, gint total, gboolean delete, DTimer *timer);
static int p_dele(int sock, int id, DTimer *timer);
static int p_rset(int sock);
static int p_quit (int sock);
static int Resolve (Server *server);
static gchar * create_unique_uid(gchar *original);

enum pop3_errnos {P_NO_ERROR, P_ERR_RESOLVE, P_ERR_SOCKET, P_ERR_CONNECT, P_ERR_SERV_ACK, P_ERR_USER_SEND, P_ERR_USER_RECV, P_ERR_PASS_SEND, P_ERR_PASS_RECV, P_ERR_LIST_SEND, P_ERR_LIST_RECV, P_ERR_STAT_SEND, P_ERR_STAT_RECV, P_ERR_RETR_SEND, P_ERR_RETR_RECV, P_ERR_RSET_SEND, P_ERR_RSET_RECV, P_ERR_QUIT_SEND, P_ERR_QUIT_RECV, P_ERR_DELE_SEND, P_ERR_DELE_RECV};
					  
typedef enum pop3_errnos pop3errnos;

#define set_status_label(label, text) gtk_label_set_text((GtkLabel*)label, text); while (g_main_iteration(FALSE));

extern int errno;
pop3errnos pop3errno;

extern _GmailApp_	*GmailApp;

extern 	gboolean uid_present(gchar *uid);
extern	DTimer * msg_match_popup (void);
extern  void clear_vfolder_cache(Mailbox *mailbox);
extern void vfolder_display_rightpane_by_mailbox(Mailbox *mailbox);
extern int pop3_check(MailSetup *msetup);
extern gboolean check_db(MYSQL *mysql);
extern MailSetup *load_default_msetup(void);
extern void free_msetup(MailSetup *msetup);
extern gboolean add_msg_to_db(Message *message, DTimer *timer);
void free_message(Message *message);


/* Routine to check for new mail....*/
void
checkmail_cb (GtkWidget *widget, void *data)
{
	MailSetup *msetup;

	/* Quick check that the database is there. */
	if (!check_db(&GmailApp->mysql)) { 
		GtkWidget *dialog;
		gchar *msg;
		msg = g_strdup_printf ("Couldn't open a database connection.\nGmail won't attempt to download mail unless the database is ready.");
		dialog = gnome_message_box_new(msg, GNOME_MESSAGE_BOX_ERROR, "doh!", 0);
		gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
 		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
 		gtk_widget_show(dialog);
		g_free(msg);	
		return; 
		};

	mysql_close(&GmailApp->mysql);

	msetup = load_default_msetup();

	/* FIXME: Check if we have valid values in our pop settings. */

	if (msetup != NULL) 
		pop3_check(msetup);
	else {
		GtkWidget *dialog;
		gchar *msg;
		msg = g_strdup_printf (_("Couldn't find POP3 settings.\nPlease check your preferences.\nMake sure a mail setup is marked as 'default'."));
		dialog = gnome_message_box_new(msg, GNOME_MESSAGE_BOX_ERROR, _("doh!"), 0);
		gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
 		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
 		gtk_widget_show(dialog);
		g_free(msg);	
		return; 
		}

	free_msetup(msetup);
	return;
}

/* parse_pop3_msg - Parse a new msg and insert into database.
 * The goal is to put a message into the gmail Message format so it
 * can be put into the database.
 *
 * This function is called by the pop3 code as it downloads messages.
 *
 * FIXME: use gmime as much as possible to do this stuff.
 *
 * Note: we don't want the specially parsed fields to have newlines in them.
 * These are: to, subject, from, etc.
 * Only headers, message and attachments have newlines.
 */

gboolean
parse_pop3_msg(GString *msg, gchar *uid, DTimer *timer)
{
	Message *message;
	GMimeMessage *gmsg = NULL;
	gchar 	*line;
	gchar   *ptr;
	gboolean ret = TRUE;
	struct tm tm;
	gint time, offset;
	GList *rcp = NULL;
	GString *addresses = g_string_new(NULL);

	/* We're going to parse everything into a Message structure.
	 * Let just initialise it with some dummy values. 
	 */
	message = g_malloc(sizeof(Message));
	message->headers = g_string_new(NULL);
	message->message = g_string_new(NULL);
	message->date = NULL;
	message->subject = NULL;
	message->from = NULL;
	message->to = NULL;
	message->cc = NULL;
	message->bcc = NULL;
	message->readstatus = NULL;
	message->direction = NULL;

	gmsg = g_mime_parser_construct_message(msg->str, msg->len, TRUE);
	if (gmsg == NULL) {
			g_warning("GMime couldn't parse the message. Bailing out...\n");
			return(FALSE);
		}
	message->from = g_strdup(g_mime_message_get_sender(gmsg));
	message->subject = g_strdup(g_mime_message_get_subject(gmsg));

	/* Put the date in the ISO format suitable for MySQL.
	 */
	g_mime_message_get_date(gmsg, (time_t *) &time, &offset);
	time -= ((offset / 100) * (60 * 60)) + (offset % 100) * 60;
	memcpy (&tm, gmtime ((const time_t *) &time), sizeof (tm));

	message->date = g_strdup_printf("%d-%d-%d %i:%i:%i", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec); 

	g_print("Subject: '%s' Date is '%s'\n", message->subject, message->date);

	/* Lets parse grabbing only the special fields. */
	line = strdup(msg->str);

	/* Put the To field into the msg using gmime functions. */
	rcp = g_mime_message_get_recipients(gmsg, GMIME_RECIPIENT_TYPE_TO);
	while (rcp) {
		gchar *addr = internet_address_to_string(rcp->data, TRUE);
		g_string_append(addresses, addr);
		g_free(addr);
		if (rcp->next) g_string_append(addresses, ", ");
		rcp = rcp->next;
		}
	message->to = g_strdup(addresses->str);
	g_string_free(addresses, TRUE);
	addresses = g_string_new(NULL);

	/* Put the Cc field into the msg using gmime functions. */
	rcp = g_mime_message_get_recipients(gmsg, GMIME_RECIPIENT_TYPE_CC);
	while (rcp) {
		gchar *addr = internet_address_to_string(rcp->data, TRUE);
		g_string_append(addresses, addr);
		g_free(addr);
		if (rcp->next) g_string_append(addresses, ", ");
		rcp = rcp->next;
		}
	message->cc = g_strdup(addresses->str);

	g_string_free(addresses, TRUE);

	/* Free the message data. */
	g_mime_message_destroy(gmsg);

	/* g_print("to is %s, cc is %s\n", message->to, message->cc); */
	
	/* Work through the headers to the body.
	 * This code + algorithm taken from Spruce!
	 */
	for (ptr = msg->str; *ptr != '\0'; ptr++) {
		if (*ptr == '\n')
			if ((*(ptr - 1) == '\r' && *(ptr - 2) == '\n') || *(ptr - 1) == '\n')
				break;
		/* Don't save the \r's. */
		if (*ptr != '\r') g_string_append_c(message->headers, *ptr);
	}

	/* advance to the actual beginning of the message (gets rid of any
	 * extra line feeds that might be between the header and the actual
	 * message).
	 */
	for ( ; *ptr != '\0'; ptr++)
		if (*ptr != '\r' && *ptr != '\n')
			break;

	/* Add a \n to retain the double \n\n */
	g_string_append_c(message->message, '\n');

	/* Store the body in the message part. */
	for (; *ptr != '\0'; ptr++)
		g_string_append_c(message->message, *ptr); 


	/* g_print("split length is %i\n", message->message->len + message->headers->len); */
	/* Put in error messages if we have missed anything. */
	if (message->headers->str == NULL) message->headers = g_string_append(message->message, "Parse Error");
	if (message->message->str == NULL) message->message = g_string_append(message->message, "Parse Error");
	if (message->subject == NULL) message->subject = g_strdup("(no subject given)");
	if (message->from == NULL) message->from = g_strdup("Parse Error");
	if (message->to == NULL) message->to = g_strdup("Parse Error");
	if (message->cc == NULL) message->cc = g_strdup(" ");
	message->readstatus = g_strdup("Unread");
	message->direction = g_strdup("Incoming");
	message->uid = g_strdup(uid);

	if (!add_msg_to_db(message, timer)) ret = FALSE; 

	/* Free memory and stuff here. */
	free_message(message); /* Free the memory */

	return(ret);
}



static int p_user(int sock, char *login)
{
   /* login to the server - step 1 (send login name) */
   char buffer[256];
   char command[256];

   /* lets send our user login to the server */
   g_snprintf(command, 255, "USER %s\r\n", login);
	
   if (send (sock, command, strlen(command), 0) < 0)
   {
      pop3errno = P_ERR_USER_SEND;
      return ERROR;
   }

   if ( (recvline(sock, buffer, 255) < 0) 
        || (strstr(buffer, "+OK") == NULL) )
   {
      /* I'm guessing the pop3 server didn't like our USER command... */
      pop3errno = P_ERR_USER_RECV;
      return ERROR;
   }
	
   return SUCCESS;
}

static int p_pass(int sock, char *passwd, DTimer *timer)
{
	/* login to the server - step 2 (send passwd) */
	char buffer[256];
	char command[256];

	/* lets send our user passwd to the server */
	g_snprintf(command, 255, "PASS %s\r\n", passwd);

	if (send (sock, command, strlen(command), 0) < 0) {
		pop3errno = P_ERR_PASS_SEND;
		return ERROR;
	}

	if ( (recvline(sock, buffer, 255) < 0) || (strstr(buffer, "+OK") == NULL) ) {
		gchar msg[1024];

		/* Pop3 server didn't like our PASS command... */
		g_snprintf(msg, 1024, "POP3 Server Error:\n%s", buffer);
		set_status_label(timer->label, msg);
		pop3errno = P_ERR_USER_RECV;
		g_warning("POP3 PASS error: %s\n", buffer);
		return ERROR;
	}

	/* If there is an error the line is -ERR */
	if (buffer[0] == '-')  {
		gchar msg[1024];
		g_snprintf(msg, 1024, "Server Error: %s", buffer);
		set_status_label(timer->label, msg);
		return ERROR;
		}

	return SUCCESS;
}

static int p_stat(int sock, gint *num, gint *size)
{
	/* returns the number of messages on the server 
	 * or -1 to signify an error */
   char buffer[256];
   char command[256];

   /* lets STAT the pop3 server... */
   strncpy(command, "STAT\r\n", 255);

   if (send (sock, command, strlen(command), 0) < 0)
   {
      pop3errno = P_ERR_STAT_SEND;
      return ERROR;
   }

   if ( (recvline(sock, buffer, 255) < 0) 
        || (strstr(buffer, "+OK") == NULL) )
   {
      /* something went wrong... */
      pop3errno = P_ERR_STAT_RECV;
      return -1;
   }
	
	/* get the number of messages on the server */
	/* spruce had dodgy code here */
	if (sscanf(buffer, "+OK %d %d\r\n", num, size) != 2) 
		return(-1);
	else 	{
		return(TRUE);
		}
}

static int p_list(int sock)
{
	/* list the messages on the server 
	 * returns the number of messages or -1 if an error occurs */
   char buffer[256];
   char command[256];
	int num = 0;

   /* prepare the LIST command */
   strncpy(command, "LIST\r\n", 255);
	
   if (send (sock, command, strlen(command), 0) < 0)
   {
      pop3errno = P_ERR_LIST_SEND;
      return ERROR;
   }

   if ( (recvline(sock, buffer, 255) < 0) 
        || (strstr(buffer, "+OK") == NULL) )
   {
      /* something went wrong */
      pop3errno = P_ERR_LIST_RECV;
      return ERROR;
   }
	
	while (recvline(sock, buffer, 255) > 0)
	{
		num++;
	}
	
	num--;
	
	return num;
}

/* p_retr does 3 things: (we should probably change the name)
 * 1. Check the UID of the message. Stop if we've seen it before.
 * 2. Download the message using RETR, but obey the users d/l threshold limit.
 * 3. Delete the message if the user has that preference set and they have
 * downloaded the whole thing.
 *
 * If delete is FALSE we don't delete the message.
 * If delete is TRUE, but the message is cut off by our threshold limit, then
 * we don't delete the message. This is basically what Eudora does. 
 * Return TRUE if it goes ok.
 * Return FALSE if any problems.
 *
 * FIXME: there is a problem with long lines getting truncated.
 *
 */
static int p_retr(int sock, int id, gint total, gboolean delete, DTimer *timer)
{
 	char buffer[1024];
 	char command[256];
	GString	*msg;
	gchar	*uid = NULL;
 	int n;
	gint i, size;
	gchar *tmp;
	gchar *end;
	gint    index;
	gint threshold;

	g_snprintf(buffer, 255, _("Looking at message %d of %d."), id, total);
	set_status_label(timer->label, (gchar*) buffer);

	/* Get UID of message and check it first. */
 	g_snprintf(command, 255, "UIDL %d\r\n", id);
 	if (send (sock, command, strlen(command), 0) < 0) {
		pop3errno = P_ERR_RETR_SEND;
 		return FALSE;
   	}

	if ( (recvline(sock, buffer, sizeof(buffer)-1) < 0) || (strstr(buffer, "+OK") == NULL) ) {
		if (strstr(buffer, "+OK") == NULL)
			g_warning("pop3 UIDL: couldn't find \"+OK\" -> %s\n", buffer);
		pop3errno = P_ERR_RETR_RECV;
		return FALSE;
	}


	/* Parse the result of the UIDL command*/
	tmp = g_strdup_printf("+OK %d ", id);
	index = strlen(tmp); g_free(tmp);
	tmp = &buffer[index]; /* Remove intitial +OK text */
	/* Find the /r/n and chuck a \0 where the /r is. */
	for (end = tmp; *end != '\r'; end++) ;
	*end = '\0'; 
	uid = create_unique_uid(tmp);   /* Record the UIDL uniquely */

	/* g_warning("MSG (%d), UID (%s), UIDL (%s)", id, uid, buffer); */
	/* Check if this msg uid has been downloaded before. */
	if (uid_present(uid)) {
		g_warning("UID matched (%s). Skipping msg %d. UIDL returned: %s", uid, id, buffer);
		g_free(uid);
		if (delete) p_dele(sock, id, timer); /* delete if we have to. */
		return TRUE; /* Don't download it if we have this uid msg. */
	}

	memset((void*)&buffer, 0, sizeof(buffer)); /* Clear buffer. */

	g_snprintf(buffer, 255, _("Downloading message %d of %d."), id, total);
	set_status_label(timer->label, (gchar*) buffer);

	/* FIXME: We used to use the download threshold feature but
	 * it has become unmaintained.
	 */
	threshold = 0;
	/* threshold =  atoi(gnome_config_get_string("/gmail/POP3Servers/dlthreshold")); */

	/* lets tell the server which message to retrieve */
	if (threshold < 1) {
		g_snprintf(command, 255, "RETR %d\r\n", id);
	} else {
   		g_snprintf(command, 255, "TOP %d %d\r\n", id, threshold);
	}

	if (send (sock, command, strlen(command), 0) < 0) {
		pop3errno = P_ERR_RETR_SEND;
		return FALSE;
	}

	if ( (recvline(sock, buffer, sizeof(buffer)-1) < 0) 
		|| (strstr(buffer, "+OK") == NULL) ) {
		pop3errno = P_ERR_RETR_RECV;
		return FALSE;
	}

	if (sscanf(buffer, "+OK %d\r\n", &size) != 1) size = -1;

	i = 0;
	n = recvline(sock, buffer, sizeof(buffer)-1);/* Get line. */
	msg = g_string_new(NULL);

	while ( !(n <= 0) && (strncmp(buffer, ".\r\n", 3) != 0)) {

 		/* Strip off white space at end.
		 * Don't strip the leading white space!
		 * It is needed for MIME to get parsed properly.
		 */
		g_strchomp(buffer);

		timer->value += strlen(buffer);  /* Increment the timer */
		while (g_main_iteration(FALSE)); /* Wait for screen update. */

		msg = g_string_append(msg, buffer); /* copy to gstring */
		msg = g_string_append_c(msg, '\n'); /*  Add newline. */

		memset((void*)&buffer, 0, sizeof(buffer)); /* Clear buffer. */
		n = recvline(sock, buffer, sizeof(buffer)-1);/* Get next line. */
		i++;
   	}

	if (threshold > 0 && i >= threshold) {
		msg = g_string_append(msg, "\n\n---------------------------------------------------------\nThe rest of this message has not been downloaded. Please set a higher threshold to download the full text.\n");
		delete = FALSE; /* Don't delete a half downloaded msg??. */
	}


	/* Parse the message and insert into database. Don't delete the message
	 * off the server if there are any problems.
	 */
	if (!parse_pop3_msg(msg, uid, timer)) delete = FALSE; 
	GmailApp->newmsgs++; /* FIXME Should we increment if it didn't parse?*/
	g_free(uid);
	g_string_free(msg, TRUE);

	if (delete) p_dele(sock, id, timer); /* delete if we have to. */

	return TRUE;
}

/* delete message #id off the pop3 server */
static int p_dele(int sock, int id, DTimer *timer)
{
	char buffer[256];
	char command[256];

	g_snprintf(buffer, 255, _("Deleting message %d"), id);
	set_status_label(timer->label, (gchar*) buffer);

	/* lets tell the server which message to delete */
	/* g_print("DELE %d...", id); */
	g_snprintf(command, 255, "DELE %d\r\n", id);
	
	if (send (sock, command, strlen(command), 0) < 0) {
		pop3errno = P_ERR_DELE_SEND;
	return ERROR;
	}

   if ( (recvline(sock, buffer, sizeof(buffer)-1) < 0) 
        || (strstr(buffer, "+OK") == NULL) )
   {
      pop3errno = P_ERR_DELE_RECV;
      return ERROR;
   }
   return SUCCESS;
}

static int p_rset(int sock)
{
   /* we are going to reset the smtp server (just to be nice) */
   char buffer[256];
   char command[256];

   strncpy(command, "RSET\r\n", 255);
	
   if (send (sock, command, strlen(command), 0) < 0)
   {
      pop3errno = P_ERR_RSET_SEND;
      return ERROR;
   }
	
   if ( (recvline(sock, buffer, 255) < 0)
       || (strstr(buffer, "+OK") == NULL) )
   {
      /* the server should have told us that it's been reset */
      pop3errno = P_ERR_RSET_RECV;
      return ERROR;
   }

   return SUCCESS;
}

static int p_quit(int sock)
{
   /* lets tell the server we want to quit now */
   char buffer[256];
   char command[256];

   strncpy(command, "QUIT\r\n", 255);

   if (send (sock, command, strlen(command), 0) < 0)
   {
      pop3errno = P_ERR_QUIT_SEND;
      return ERROR;
   }
	
   if ( (recvline(sock, buffer, 255) < 0)
       || (strstr(buffer, "+OK") == NULL) )
   {
      /* mr server didn't say bye-bye :( */
      pop3errno = P_ERR_QUIT_RECV;
      return ERROR;
   }
	
   return SUCCESS;
}

/* pop3_check - Connect to POP3 server and download messages. */
gboolean
pop3_check(MailSetup *msetup)
{
	int sock;
	int num, size, i;
	char buffer[256];
	Server *serv;
	gchar tmp[255], *title;
	gboolean delete = FALSE;
	GtkWidget *child, *label;
	DTimer *timer;
	static const char *newmailsound[] = {"gmail", "newmail", NULL};
	static const char *nonewmailsound[] = {"gmail", "nonewmail", NULL};
	gchar *server = msetup->popserver;
	gint port = 110;
	gchar *user = msetup->popuser;
	gchar *pass = msetup->poppass;
	gboolean leaveonserver = msetup->leave_on_server;

	timer = msg_match_popup();
	timer->value = 0;
	timer->total = 1;

	title = g_strdup_printf("Server: %s", msetup->popserver);
	label = gtk_label_new(title);
	gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(timer->dialog)->vbox), label, FALSE, FALSE, 5);
	gtk_widget_show(label);
	g_free(title);

	set_status_label(timer->label, _("Looking up hostname."));

	serv = g_malloc(sizeof(Server));
	serv->hostname = server;
   	serv->port = (port_t) port;

	/* make sure we aren't claiming an error */
	pop3errno = P_NO_ERROR;
	
	/* resolve the hostname */
	if ( !Resolve(serv) ) {
		pop3errno = P_ERR_RESOLVE;
		set_status_label(timer->label, _("Bad POP3 hostname."));
		return ERROR;
	}

	/* assign and open a socket */
	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if ( sock < 0 )    /* if socket fails to open */ {
		pop3errno = P_ERR_SOCKET;
		set_status_label(timer->label, "No Socket Error.");
		return ERROR;
	}

	/* lets set up information about the server we will be connecting to... */
	serv->sin.sin_family = AF_INET;
	serv->sin.sin_port = htons(serv->port);

	set_status_label(timer->label, _("Connecting to server..."));

	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	
	/* call the server */
	if (connect(sock, (struct sockaddr*)&serv->sin, sizeof(serv->sin)) < 0) {
		/* we failed to connect */
		pop3errno = P_ERR_CONNECT;
		close(sock);
		set_status_label(timer->label, _("No POP3 response."));
		return ERROR;
	}
	
	if ( (recvline(sock, buffer, 255) < 0) || (strstr(buffer, "+OK") == NULL) ) {
		/* the pop3 server failed to send a response (usually version info) */
		pop3errno = P_ERR_SERV_ACK;
		close(sock);
		set_status_label(timer->label, _("No POP3 response."));
		return ERROR;
	}

	set_status_label(timer->label, _("Sending Login name..."));
	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);

	/* lets login to the server... */
	if ( !p_user(sock, user) )
	{
		/* bad login name maybe? I dunno... */
		set_status_label(timer->label, "Login Error");
		close(sock);
		return ERROR;
	}

	set_status_label(timer->label, _("Sending Password..."));
	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);

	if ( !p_pass(sock, pass, timer) )
	{
		/* The p_pass function will display the error. */
		close(sock);
		return ERROR;
	}

	set_status_label(timer->label, _("Sending STAT command..."));
	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);

	/* lets find out how many messages we got on the server */
	if ( (p_stat(sock, &num, &size)) < 0 )
	{
		/* something went wrong... */
		g_warning("stat returned %d", num);
		set_status_label(timer->label, "STAT command failed.");
		close(sock);
		return ERROR;
	}

	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	if (!leaveonserver) delete = TRUE;

 
	if (num == 0) {
	/* 0 messages is a special case. */
		timer->value = 1;
   	timer->total = 1;
		GmailApp->newmsgs = 0;

		} else {
		Mailbox *mailbox = gtk_ctree_node_get_row_data(GTK_CTREE (GmailApp->mblist), GTK_CTREE_NODE (GmailApp->node));

		/* Set the timer range, based on the size of the maildrop.
		 * FIXME: This isn't 100%
		 */
		timer->value = 0;	
		timer->total = size;
		GmailApp->newmsgs = 0;

		for (i = 1; i <= num; i++) {
			g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
			if (!p_retr(sock, i, num, delete, timer)) {
				/* eek! an error occured!! */
				set_status_label(timer->label, "RETR Error");
				close(sock);
				return ERROR;
				}
			}

		/* Redisplay the current vfolder in case it has changed. */
		vfolder_display_rightpane_by_mailbox(mailbox);
		}

	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	

	if ( !p_quit(sock) )
	{
		set_status_label(timer->label, "QUIT command failed.");
		close(sock);
		return ERROR;
	}
	
	/* close the socket */
	close(sock);

	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	timer->value = timer->total; 

	if (GmailApp->newmsgs == 1) {
		sprintf(tmp, _("You have one new message."));
		} else {
		sprintf(tmp, _("You have %i new messages."), GmailApp->newmsgs);
		}

	title = g_strdup_printf("Gmail - %s", tmp);
	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	gtk_window_set_title(GTK_WINDOW (timer->dialog), title);
	g_free(title);

	if (GmailApp->newmsgs == 0)
		gnome_triggers_vdo("", NULL, nonewmailsound); /* Play sound */

	if (GmailApp->newmsgs > 0)
		gnome_triggers_vdo("", NULL, newmailsound); /* Play sound */

	gnome_appbar_set_status (GNOME_APPBAR (GmailApp->appbar), tmp);

	set_status_label(timer->label, tmp);

	/* Update the button text. */
	g_return_val_if_fail(GTK_IS_WIDGET(timer->dialog), FALSE);
	child = GTK_BIN (timer->button)->child;
	if (GTK_IS_LABEL(child)) gtk_label_set(GTK_LABEL(child), "Close");

	g_free(serv);

	return SUCCESS;
}


ssize_t recvline(int sock, void *vptr, size_t maxlen)
{
   int n, rc;
   char c, *ptr;

   ptr = vptr;
   for (n = 1; n < maxlen; n++)
   {
      if ( (rc = recvch(sock, &c)) == 1)
      {
         *ptr++ = c;
         if (c == '\n')
         break;                      /* newline is stored, like fgets() */
      }
      else if (rc == 0)
      {
         if (n == 1)
            return 0;                   /* EOF, no data read */
         else
            break;                      /* EOF, some data read */
      }
      else
         return -1;                     /* error, errno set by read() */
   }
   
   *ptr = 0;                            /* null terminate like fgets() */
   return n;
}


static int Resolve (Server *server)
{
   /* Resolves server->hostname to it's corresponding IPv4 IP address.
    * The IP address is stored in server->ip if successful.
    * Returns SUCCESS (1) or ERROR (0).
   */
   struct hostent *ptr_host;

   if ( (ptr_host = gethostbyname(server->hostname)) == NULL)
      return ERROR;

   memcpy(&server->sin.sin_addr, ptr_host->h_addr, ptr_host->h_length);
   g_snprintf(server->ip, sizeof(server->ip), "%s", inet_ntoa(server->sin.sin_addr));

   return SUCCESS;
}



ssize_t recvch(int sock, char *ptr)
{
   static int read_cnt = 0;
   static char *read_ptr;
   static char read_buf[512];

   if (read_cnt <= 0)
   {
      again:
         if ( (read_cnt = read(sock, read_buf, sizeof(read_buf))) < 0)
         {
            if (errno == EINTR)
               goto again;
            return -1;
         }
         else if (read_cnt == 0)
            return 0;
         read_ptr = read_buf;
   }
   read_cnt--;
   *ptr = *read_ptr++;
   return 1;
}

/* create_unique_uid
 * Prepend pop3 username to the UID.
 * Some POP3 servers rightfully reuse UID's between users. So when a user
 * needs to download messages on different accounts on the same server,
 * they get UID clashes.
 * Prepending the pop3 username to the UID should prevent this.
 *
 * The string must be freed by the calling function.
 */
static gchar *
create_unique_uid(gchar *original)
{
	MailSetup *msetup;
	gchar *uid = NULL;

	msetup = load_default_msetup();
	uid = g_strdup_printf("%s%s", msetup->popuser, original);

	/* g_print("uid is %s\n", uid); */

	return(uid);
}
