// MM1IC.CPP

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1ic.h"

#include <iostream>
using namespace std;

/*################################################################################################*/

mm1_intcrd::mm1_intcrd(mm1_mdl & p1, i32s p2, i32s p3) : intcrd()
{
	mdl = (& p1);
	molnum = p2; crdset = p3;
	
	if (mdl->GetMoleculeCount() < 0)	// you must call mdl->GatherGroups before using this class!!!
	{
		cout << "FATAL ERROR: mm1_intcrd ctor: invalid model." << endl;
		exit(EXIT_FAILURE);
	}
	
	// get the atom range for the molecule.
	
	iter_mm1al range[2];
	mdl->GetRange(0, molnum, range);
	
	if (range[0] == mdl->GetAtomsEnd())
	{
		cout << "FATAL ERROR: mm1_intcrd ctor: invalid molecule." << endl;
		exit(EXIT_FAILURE);
	}
	
	// find the best atom (the one with least bonds) to work as an "anchor".
	
	iter_mm1al anchor = range[0];
	i32u nbonds = (* anchor).cr_list.size();
	
	for (iter_mm1al it1 = range[0];it1 != range[1];it1++)
	{
		if ((* it1).cr_list.size() < nbonds)
		{
			anchor = it1;
			nbonds = (* anchor).cr_list.size();
		}
	}
	
	// add it...
	
	vector<mm1_atom *> added_atoms;
	
	added_atoms.push_back(& (* anchor));
	AddNewPoint((* anchor).crd_vector[crdset].data, & base[2], false);
	
	// ...and also the rest of the atoms.
	
	while (true)
	{
		// first, try to find a not-yet-added atom
		// that is connected to an already-added one.
		
		i32s added_index = NOT_DEFINED;
		mm1_cr * matching_cr = NULL;
		
		iter_mm1al it1 = range[0];
		while (it1 != range[1])
		{
			i32u search1 = 0;
			while (search1 < added_atoms.size())
			{
				if (added_atoms[search1] == & (* it1)) break;
				else search1++;
			}
			
			if (search1 != added_atoms.size())
			{
				it1++;
				continue;
			}
			
			i32s search2 = NOT_DEFINED;
			iter_mm1cl it2 = (* it1).cr_list.begin();
			while (it2 != (* it1).cr_list.end())
			{
				search2 = 0;
				while (search2 < (i32s) added_atoms.size())
				{
					if (added_atoms[search2] == (* it2).atmr) break;
					else search2++;
				}
				
				if (search2 != (i32s) added_atoms.size()) break;
				else it2++;
			}
			
			if (it2 != (* it1).cr_list.end())
			{
				added_index = search2;
				matching_cr = & (* it2);
				break;
			}
			else it1++;
		}
		
		// if none was found, all atoms are added,
		// so we can leave the loop.
		
		if (it1 == range[1]) break;
		
		// now determine if we should mark this as variable...
		
		bool flag = true;
		
		if (added_atoms.size() < 2) flag = false;			// skip the first one.
		
		if ((* it1).cr_list.size() < 2) flag = false;			// there are further bonds.
		
		if (matching_cr->bndr->bt.GetSymbol1() == 'D') flag = false;	// double bonds are fixed.
		
		matching_cr->bndr->flags[0] = true;				// ring structures are fixed.
		if (mdl->FindPath(& (* it1), matching_cr->atmr, NOT_DEFINED, 0) != NOT_FOUND) flag = false;
		matching_cr->bndr->flags[0] = false;
		
		// AMIDE GROUPS!??!!?!
		// AMIDE GROUPS!??!!?!
		// AMIDE GROUPS!??!!?!
		
		// ...and add it.
		
		added_atoms.push_back(& (* it1));
		AddNewPoint((* it1).crd_vector[crdset].data, ic_vector[added_index], flag);
	}
}

mm1_intcrd::~mm1_intcrd(void)
{
}

/*################################################################################################*/

// eof
