{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Resource_stub_ffi.h" #-}
module Win32Resource where

import StdDIS
import Addr
import Word
import Win32Types


beginUpdateResource :: String -> Bool -> IO HANDLE
beginUpdateResource gc_arg1 gc_arg2 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg2) ->
  prim_beginUpdateResource arg1 arg2
  >>= \ gc_result ->
  access_prim_beginUpdateResource_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_beginUpdateResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_beginUpdateResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_beginUpdateResource" unsafe prim_beginUpdateResource :: Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_beginUpdateResource_res1" unsafe access_prim_beginUpdateResource_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_beginUpdateResource_gc_failed" unsafe access_prim_beginUpdateResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_beginUpdateResource_gc_failstring" unsafe access_prim_beginUpdateResource_gc_failstring :: Addr -> IO (Addr)

type ResourceImageType = UINT

type   HRSRC      = Addr

type   HGLOBAL    = Addr

iMAGE_BITMAP :: ResourceImageType
iMAGE_BITMAP =
  unsafePerformIO(
    prim_iMAGE_BITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_iMAGE_BITMAP" unsafe prim_iMAGE_BITMAP :: IO (Word32)
iMAGE_ICON :: ResourceImageType
iMAGE_ICON =
  unsafePerformIO(
    prim_iMAGE_ICON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_iMAGE_ICON" unsafe prim_iMAGE_ICON :: IO (Word32)
iMAGE_CURSOR :: ResourceImageType
iMAGE_CURSOR =
  unsafePerformIO(
    prim_iMAGE_CURSOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_iMAGE_CURSOR" unsafe prim_iMAGE_CURSOR :: IO (Word32)

copyImage :: HANDLE -> ResourceImageType -> Int -> Int -> UINT -> IO HANDLE
copyImage arg1 arg2 arg3 arg4 arg5 =
  prim_copyImage arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_copyImage_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_copyImage_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_copyImage_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_copyImage" unsafe prim_copyImage :: Addr -> Word32 -> Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_copyImage_res1" unsafe access_prim_copyImage_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_copyImage_gc_failed" unsafe access_prim_copyImage_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_copyImage_gc_failstring" unsafe access_prim_copyImage_gc_failstring :: Addr -> IO (Addr)

endUpdateResource :: HANDLE -> BOOL -> IO ()
endUpdateResource arg1 gc_arg1 =
  (marshall_bool_ gc_arg1) >>= \ (arg2) ->
  prim_endUpdateResource arg1 arg2
  >>= \ gc_result ->
  access_prim_endUpdateResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_endUpdateResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_endUpdateResource" unsafe prim_endUpdateResource :: Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_endUpdateResource_gc_failed" unsafe access_prim_endUpdateResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_endUpdateResource_gc_failstring" unsafe access_prim_endUpdateResource_gc_failstring :: Addr -> IO (Addr)

type ResourceType = Addr

--lPCTSTR_ x

rT_ACCELERATOR :: ResourceType
rT_ACCELERATOR =
  unsafePerformIO(
    prim_rT_ACCELERATOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_ACCELERATOR" unsafe prim_rT_ACCELERATOR :: IO (Addr)
rT_ANICURSOR :: ResourceType
rT_ANICURSOR =
  unsafePerformIO(
    prim_rT_ANICURSOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_ANICURSOR" unsafe prim_rT_ANICURSOR :: IO (Addr)
rT_ANIICON :: ResourceType
rT_ANIICON =
  unsafePerformIO(
    prim_rT_ANIICON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_ANIICON" unsafe prim_rT_ANIICON :: IO (Addr)
rT_BITMAP :: ResourceType
rT_BITMAP =
  unsafePerformIO(
    prim_rT_BITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_BITMAP" unsafe prim_rT_BITMAP :: IO (Addr)
rT_CURSOR :: ResourceType
rT_CURSOR =
  unsafePerformIO(
    prim_rT_CURSOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_CURSOR" unsafe prim_rT_CURSOR :: IO (Addr)
rT_DIALOG :: ResourceType
rT_DIALOG =
  unsafePerformIO(
    prim_rT_DIALOG
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_DIALOG" unsafe prim_rT_DIALOG :: IO (Addr)
rT_FONT :: ResourceType
rT_FONT =
  unsafePerformIO(
    prim_rT_FONT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_FONT" unsafe prim_rT_FONT :: IO (Addr)
rT_FONTDIR :: ResourceType
rT_FONTDIR =
  unsafePerformIO(
    prim_rT_FONTDIR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_FONTDIR" unsafe prim_rT_FONTDIR :: IO (Addr)
rT_GROUP_CURSOR :: ResourceType
rT_GROUP_CURSOR =
  unsafePerformIO(
    prim_rT_GROUP_CURSOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_GROUP_CURSOR" unsafe prim_rT_GROUP_CURSOR :: IO (Addr)
rT_GROUP_ICON :: ResourceType
rT_GROUP_ICON =
  unsafePerformIO(
    prim_rT_GROUP_ICON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_GROUP_ICON" unsafe prim_rT_GROUP_ICON :: IO (Addr)
rT_HTML :: ResourceType
rT_HTML =
  unsafePerformIO(
    prim_rT_HTML
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_HTML" unsafe prim_rT_HTML :: IO (Addr)
rT_ICON :: ResourceType
rT_ICON =
  unsafePerformIO(
    prim_rT_ICON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_ICON" unsafe prim_rT_ICON :: IO (Addr)
rT_MENU :: ResourceType
rT_MENU =
  unsafePerformIO(
    prim_rT_MENU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_MENU" unsafe prim_rT_MENU :: IO (Addr)
rT_MESSAGETABLE :: ResourceType
rT_MESSAGETABLE =
  unsafePerformIO(
    prim_rT_MESSAGETABLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_MESSAGETABLE" unsafe prim_rT_MESSAGETABLE :: IO (Addr)
rT_RCDATA :: ResourceType
rT_RCDATA =
  unsafePerformIO(
    prim_rT_RCDATA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_RCDATA" unsafe prim_rT_RCDATA :: IO (Addr)
rT_STRING :: ResourceType
rT_STRING =
  unsafePerformIO(
    prim_rT_STRING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_STRING" unsafe prim_rT_STRING :: IO (Addr)
rT_VERSION :: ResourceType
rT_VERSION =
  unsafePerformIO(
    prim_rT_VERSION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_rT_VERSION" unsafe prim_rT_VERSION :: IO (Addr)

findResource :: HMODULE -> String -> ResourceType -> IO HRSRC
findResource arg1 gc_arg1 arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg2) ->
  prim_findResource arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_findResource_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_findResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_findResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_findResource" unsafe prim_findResource :: Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_findResource_res1" unsafe access_prim_findResource_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_findResource_gc_failed" unsafe access_prim_findResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_findResource_gc_failstring" unsafe access_prim_findResource_gc_failstring :: Addr -> IO (Addr)

findResourceEx :: HMODULE -> LPCTSTR_ -> ResourceType -> WORD -> IO HRSRC
findResourceEx arg1 gc_arg1 arg3 gc_arg2 =
  (marshall_lpctstr_ gc_arg1) >>= \ (arg2) ->
  case ( word16ToWord32  gc_arg2) of { arg4 ->
  prim_findResourceEx arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_findResourceEx_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_findResourceEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_findResourceEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}
foreign import  ccall "prim_findResourceEx" unsafe prim_findResourceEx :: Addr -> Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_findResourceEx_res1" unsafe access_prim_findResourceEx_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_findResourceEx_gc_failed" unsafe access_prim_findResourceEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_findResourceEx_gc_failstring" unsafe access_prim_findResourceEx_gc_failstring :: Addr -> IO (Addr)

type ResourceSize = Int

lR_DEFAULTSIZE :: ResourceSize
lR_DEFAULTSIZE =
  unsafePerformIO(
    prim_lR_DEFAULTSIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_DEFAULTSIZE" unsafe prim_lR_DEFAULTSIZE :: IO (Int)

type LoadImageFlags = UINT

lR_DEFAULTCOLOR :: LoadImageFlags
lR_DEFAULTCOLOR =
  unsafePerformIO(
    prim_lR_DEFAULTCOLOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_DEFAULTCOLOR" unsafe prim_lR_DEFAULTCOLOR :: IO (Word32)
lR_CREATEDIBSECTION :: LoadImageFlags
lR_CREATEDIBSECTION =
  unsafePerformIO(
    prim_lR_CREATEDIBSECTION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_CREATEDIBSECTION" unsafe prim_lR_CREATEDIBSECTION :: IO (Word32)
lR_LOADFROMFILE :: LoadImageFlags
lR_LOADFROMFILE =
  unsafePerformIO(
    prim_lR_LOADFROMFILE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_LOADFROMFILE" unsafe prim_lR_LOADFROMFILE :: IO (Word32)
lR_LOADMAP3DCOLORS :: LoadImageFlags
lR_LOADMAP3DCOLORS =
  unsafePerformIO(
    prim_lR_LOADMAP3DCOLORS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_LOADMAP3DCOLORS" unsafe prim_lR_LOADMAP3DCOLORS :: IO (Word32)
lR_LOADTRANSPARENT :: LoadImageFlags
lR_LOADTRANSPARENT =
  unsafePerformIO(
    prim_lR_LOADTRANSPARENT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_LOADTRANSPARENT" unsafe prim_lR_LOADTRANSPARENT :: IO (Word32)
lR_MONOCHROME :: LoadImageFlags
lR_MONOCHROME =
  unsafePerformIO(
    prim_lR_MONOCHROME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_MONOCHROME" unsafe prim_lR_MONOCHROME :: IO (Word32)
lR_SHARED :: LoadImageFlags
lR_SHARED =
  unsafePerformIO(
    prim_lR_SHARED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lR_SHARED" unsafe prim_lR_SHARED :: IO (Word32)

-- % , LR_VGACOLOR (Not in mingw-20001111 headers)


loadImage :: HINSTANCE -> LPCTSTR_ -> ResourceImageType -> ResourceSize -> ResourceSize -> LoadImageFlags -> IO HANDLE
loadImage arg1 gc_arg1 arg3 arg4 arg5 arg6 =
  (marshall_lpctstr_ gc_arg1) >>= \ (arg2) ->
  prim_loadImage arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_loadImage_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_loadImage_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_loadImage_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_loadImage" unsafe prim_loadImage :: Addr -> Addr -> Word32 -> Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_loadImage_res1" unsafe access_prim_loadImage_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_loadImage_gc_failed" unsafe access_prim_loadImage_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_loadImage_gc_failstring" unsafe access_prim_loadImage_gc_failstring :: Addr -> IO (Addr)

loadResource :: HMODULE -> HRSRC -> IO HGLOBAL
loadResource arg1 arg2 =
  prim_loadResource arg1 arg2
  >>= \ gc_result ->
  access_prim_loadResource_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_loadResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_loadResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_loadResource" unsafe prim_loadResource :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_loadResource_res1" unsafe access_prim_loadResource_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_loadResource_gc_failed" unsafe access_prim_loadResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_loadResource_gc_failstring" unsafe access_prim_loadResource_gc_failstring :: Addr -> IO (Addr)

lockResource :: HGLOBAL -> IO Addr
lockResource arg1 =
  prim_lockResource arg1
  >>= \ gc_result ->
  access_prim_lockResource_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_lockResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_lockResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_lockResource" unsafe prim_lockResource :: Addr -> IO (Addr)
foreign import ccall "access_prim_lockResource_res1" unsafe access_prim_lockResource_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_lockResource_gc_failed" unsafe access_prim_lockResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_lockResource_gc_failstring" unsafe access_prim_lockResource_gc_failstring :: Addr -> IO (Addr)

sizeofResource :: HMODULE -> HRSRC -> IO DWORD
sizeofResource arg1 arg2 =
  prim_sizeofResource arg1 arg2
  >>= \ gc_result ->
  access_prim_sizeofResource_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_sizeofResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_sizeofResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_sizeofResource" unsafe prim_sizeofResource :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_sizeofResource_res1" unsafe access_prim_sizeofResource_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_sizeofResource_gc_failed" unsafe access_prim_sizeofResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_sizeofResource_gc_failstring" unsafe access_prim_sizeofResource_gc_failstring :: Addr -> IO (Addr)

updateResource :: HANDLE -> LPCTSTR_ -> ResourceType -> WORD -> Addr -> DWORD -> IO ()
updateResource arg1 gc_arg1 arg3 gc_arg2 arg5 arg6 =
  (marshall_lpctstr_ gc_arg1) >>= \ (arg2) ->
  case ( word16ToWord32  gc_arg2) of { arg4 ->
  prim_updateResource arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_updateResource_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_updateResource_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_updateResource" unsafe prim_updateResource :: Addr -> Addr -> Addr -> Word32 -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_updateResource_gc_failed" unsafe access_prim_updateResource_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_updateResource_gc_failstring" unsafe access_prim_updateResource_gc_failstring :: Addr -> IO (Addr)


