{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Palette_stub_ffi.h" #-}
module Win32Palette where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Palettes
----------------------------------------------------------------

type StockPalette   = WORD

dEFAULT_PALETTE :: StockPalette
dEFAULT_PALETTE =
  unsafePerformIO(
    prim_dEFAULT_PALETTE
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_dEFAULT_PALETTE" unsafe prim_dEFAULT_PALETTE :: IO (Word32)

getStockPalette :: StockPalette -> IO HPALETTE
getStockPalette gc_arg1 =
  case ( word16ToWord32  gc_arg1) of { arg1 ->
  prim_getStockPalette arg1
  >>= \ gc_result ->
  access_prim_getStockPalette_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getStockPalette_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getStockPalette_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}
foreign import  ccall "prim_getStockPalette" unsafe prim_getStockPalette :: Word32 -> IO (Addr)
foreign import ccall "access_prim_getStockPalette_res1" unsafe access_prim_getStockPalette_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getStockPalette_gc_failed" unsafe access_prim_getStockPalette_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getStockPalette_gc_failstring" unsafe access_prim_getStockPalette_gc_failstring :: Addr -> IO (Addr)

deletePalette :: HPALETTE -> IO ()
deletePalette arg1 =
  prim_deletePalette arg1
  >>= \ gc_result ->
  access_prim_deletePalette_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deletePalette_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deletePalette" unsafe prim_deletePalette :: Addr -> IO (Addr)
foreign import ccall "access_prim_deletePalette_gc_failed" unsafe access_prim_deletePalette_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deletePalette_gc_failstring" unsafe access_prim_deletePalette_gc_failstring :: Addr -> IO (Addr)

pALETTERGB :: BYTE -> BYTE -> BYTE -> COLORREF
pALETTERGB gc_arg1 gc_arg2 gc_arg3 =
  unsafePerformIO(
    case ( word8ToWord32   gc_arg1) of { arg1 ->
    case ( word8ToWord32   gc_arg2) of { arg2 ->
    case ( word8ToWord32   gc_arg3) of { arg3 ->
    prim_pALETTERGB arg1 arg2 arg3
    >>= \  res1  ->
    (return (res1))}}})
foreign import  ccall "prim_pALETTERGB" unsafe prim_pALETTERGB :: Word32 -> Word32 -> Word32 -> IO (Word32)
pALETTEINDEX :: WORD -> COLORREF
pALETTEINDEX gc_arg1 =
  unsafePerformIO(
    case ( word16ToWord32  gc_arg1) of { arg1 ->
    prim_pALETTEINDEX arg1
    >>= \  res1  ->
    (return (res1))})
foreign import  ccall "prim_pALETTEINDEX" unsafe prim_pALETTEINDEX :: Word32 -> IO (Word32)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
