{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Menu_stub_ffi.h" #-}
module Win32Menu 
{-
       (
         MenuName
       , checkMenuItem
       , checkMenuRadioItem
       , createMenu
       , createPopupMenu
       , deleteMenu
       , destroyMenu
       , drawMenuBar
       , enableMenuItem
       , getMenu
       , getMenuDefaultItem
       , getMenuItemCount
       , getMenuItemID
       , getMenuItemInfo
       , getMenuItemRect
       , getMenuState
       , getSubMenu
       , getSystemMenu
       , hiliteMenuItem
       , insertMenuItem
       , isMenu
       , loadMenu
       , menuItemFromPoint
       , setMenu
       , setMenuDefaultItem
       , setMenuItemBitmaps
       , setMenuItemInfo
       , trackPopupMenu
       , trackPopupMenuEx
       
       , GMDIFlag(..)
       , MenuItem(..)
       , MenuFlag(..)
       , MenuState(..)
       , TrackMenuFlag(..)
       , SystemMenuCommand(..)

         -- Obsolete:
       , appendMenu
       , insertMenu
       , modifyMenu
       , removeMenu
       
       ) -} where

import StdDIS
  
import Win32Types
import GDITypes


type MenuName = LPCSTR



checkMenuItem :: HMENU -> MenuItem -> MenuFlag -> IO Bool
checkMenuItem arg1 arg2 arg3 =
  prim_checkMenuItem arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_checkMenuItem_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_checkMenuItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_checkMenuItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_bool_ gc_res2) >>= \ gc_res1 ->
       (return (gc_res1))
foreign import  ccall "prim_checkMenuItem" unsafe prim_checkMenuItem :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_checkMenuItem_gc_res2" unsafe access_prim_checkMenuItem_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_checkMenuItem_gc_failed" unsafe access_prim_checkMenuItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_checkMenuItem_gc_failstring" unsafe access_prim_checkMenuItem_gc_failstring :: Addr -> IO (Addr)

checkMenuRadioItem :: HMENU -> MenuItem -> MenuItem -> MenuItem -> MenuFlag -> IO ()
checkMenuRadioItem arg1 arg2 arg3 arg4 arg5 =
  prim_checkMenuRadioItem arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_checkMenuRadioItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_checkMenuRadioItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_checkMenuRadioItem" unsafe prim_checkMenuRadioItem :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_checkMenuRadioItem_gc_failed" unsafe access_prim_checkMenuRadioItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_checkMenuRadioItem_gc_failstring" unsafe access_prim_checkMenuRadioItem_gc_failstring :: Addr -> IO (Addr)

createMenu :: IO HMENU
createMenu =
  prim_createMenu
  >>= \ gc_result ->
  access_prim_createMenu_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createMenu" unsafe prim_createMenu :: IO (Addr)
foreign import ccall "access_prim_createMenu_res1" unsafe access_prim_createMenu_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createMenu_gc_failed" unsafe access_prim_createMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createMenu_gc_failstring" unsafe access_prim_createMenu_gc_failstring :: Addr -> IO (Addr)

createPopupMenu :: IO HMENU
createPopupMenu =
  prim_createPopupMenu
  >>= \ gc_result ->
  access_prim_createPopupMenu_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createPopupMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createPopupMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createPopupMenu" unsafe prim_createPopupMenu :: IO (Addr)
foreign import ccall "access_prim_createPopupMenu_res1" unsafe access_prim_createPopupMenu_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPopupMenu_gc_failed" unsafe access_prim_createPopupMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createPopupMenu_gc_failstring" unsafe access_prim_createPopupMenu_gc_failstring :: Addr -> IO (Addr)

drawMenuBar :: HWND -> IO ()
drawMenuBar arg1 =
  prim_drawMenuBar arg1
  >>= \ gc_result ->
  access_prim_drawMenuBar_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_drawMenuBar_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_drawMenuBar" unsafe prim_drawMenuBar :: Addr -> IO (Addr)
foreign import ccall "access_prim_drawMenuBar_gc_failed" unsafe access_prim_drawMenuBar_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_drawMenuBar_gc_failstring" unsafe access_prim_drawMenuBar_gc_failstring :: Addr -> IO (Addr)

type MenuState = MenuFlag

enableMenuItem :: HMENU -> MenuItem -> MenuFlag -> IO MenuState
enableMenuItem arg1 arg2 arg3 =
  prim_enableMenuItem arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_enableMenuItem_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_enableMenuItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_enableMenuItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_enableMenuItem" unsafe prim_enableMenuItem :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_enableMenuItem_res1" unsafe access_prim_enableMenuItem_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_enableMenuItem_gc_failed" unsafe access_prim_enableMenuItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_enableMenuItem_gc_failstring" unsafe access_prim_enableMenuItem_gc_failstring :: Addr -> IO (Addr)

type GMDIFlag = UINT

type MenuFlag = UINT

gMDI_USEDISABLED :: GMDIFlag
gMDI_USEDISABLED =
  unsafePerformIO(
    prim_gMDI_USEDISABLED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMDI_USEDISABLED" unsafe prim_gMDI_USEDISABLED :: IO (Word32)
gMDI_GOINTOPOPUPS :: GMDIFlag
gMDI_GOINTOPOPUPS =
  unsafePerformIO(
    prim_gMDI_GOINTOPOPUPS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_gMDI_GOINTOPOPUPS" unsafe prim_gMDI_GOINTOPOPUPS :: IO (Word32)
mF_BYCOMMAND :: MenuFlag
mF_BYCOMMAND =
  unsafePerformIO(
    prim_mF_BYCOMMAND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_BYCOMMAND" unsafe prim_mF_BYCOMMAND :: IO (Word32)
mF_BYPOSITION :: MenuFlag
mF_BYPOSITION =
  unsafePerformIO(
    prim_mF_BYPOSITION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_BYPOSITION" unsafe prim_mF_BYPOSITION :: IO (Word32)

type MenuItem = UINT

mF_INSERT :: MenuItem
mF_INSERT =
  unsafePerformIO(
    prim_mF_INSERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_INSERT" unsafe prim_mF_INSERT :: IO (Word32)
mF_CHANGE :: MenuItem
mF_CHANGE =
  unsafePerformIO(
    prim_mF_CHANGE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_CHANGE" unsafe prim_mF_CHANGE :: IO (Word32)
mF_APPEND :: MenuItem
mF_APPEND =
  unsafePerformIO(
    prim_mF_APPEND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_APPEND" unsafe prim_mF_APPEND :: IO (Word32)
mF_DELETE :: MenuItem
mF_DELETE =
  unsafePerformIO(
    prim_mF_DELETE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_DELETE" unsafe prim_mF_DELETE :: IO (Word32)
mF_REMOVE :: MenuItem
mF_REMOVE =
  unsafePerformIO(
    prim_mF_REMOVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_REMOVE" unsafe prim_mF_REMOVE :: IO (Word32)
mF_USECHECKBITMAPS :: MenuItem
mF_USECHECKBITMAPS =
  unsafePerformIO(
    prim_mF_USECHECKBITMAPS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_USECHECKBITMAPS" unsafe prim_mF_USECHECKBITMAPS :: IO (Word32)
mF_POPUP :: MenuItem
mF_POPUP =
  unsafePerformIO(
    prim_mF_POPUP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_POPUP" unsafe prim_mF_POPUP :: IO (Word32)
mF_SYSMENU :: MenuItem
mF_SYSMENU =
  unsafePerformIO(
    prim_mF_SYSMENU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_SYSMENU" unsafe prim_mF_SYSMENU :: IO (Word32)
mF_HELP :: MenuItem
mF_HELP =
  unsafePerformIO(
    prim_mF_HELP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_HELP" unsafe prim_mF_HELP :: IO (Word32)
mF_MOUSESELECT :: MenuItem
mF_MOUSESELECT =
  unsafePerformIO(
    prim_mF_MOUSESELECT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_MOUSESELECT" unsafe prim_mF_MOUSESELECT :: IO (Word32)
mF_END :: MenuItem
mF_END =
  unsafePerformIO(
    prim_mF_END
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mF_END" unsafe prim_mF_END :: IO (Word32)

mFT_STRING :: MenuFlag
mFT_STRING =
  unsafePerformIO(
    prim_mFT_STRING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_STRING" unsafe prim_mFT_STRING :: IO (Word32)
mFT_BITMAP :: MenuFlag
mFT_BITMAP =
  unsafePerformIO(
    prim_mFT_BITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_BITMAP" unsafe prim_mFT_BITMAP :: IO (Word32)
mFT_MENUBARBREAK :: MenuFlag
mFT_MENUBARBREAK =
  unsafePerformIO(
    prim_mFT_MENUBARBREAK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_MENUBARBREAK" unsafe prim_mFT_MENUBARBREAK :: IO (Word32)
mFT_MENUBREAK :: MenuFlag
mFT_MENUBREAK =
  unsafePerformIO(
    prim_mFT_MENUBREAK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_MENUBREAK" unsafe prim_mFT_MENUBREAK :: IO (Word32)
mFT_OWNERDRAW :: MenuFlag
mFT_OWNERDRAW =
  unsafePerformIO(
    prim_mFT_OWNERDRAW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_OWNERDRAW" unsafe prim_mFT_OWNERDRAW :: IO (Word32)
mFT_RADIOCHECK :: MenuFlag
mFT_RADIOCHECK =
  unsafePerformIO(
    prim_mFT_RADIOCHECK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_RADIOCHECK" unsafe prim_mFT_RADIOCHECK :: IO (Word32)
mFT_SEPARATOR :: MenuFlag
mFT_SEPARATOR =
  unsafePerformIO(
    prim_mFT_SEPARATOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_SEPARATOR" unsafe prim_mFT_SEPARATOR :: IO (Word32)
mFT_RIGHTORDER :: MenuFlag
mFT_RIGHTORDER =
  unsafePerformIO(
    prim_mFT_RIGHTORDER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_RIGHTORDER" unsafe prim_mFT_RIGHTORDER :: IO (Word32)
mFT_RIGHTJUSTIFY :: MenuFlag
mFT_RIGHTJUSTIFY =
  unsafePerformIO(
    prim_mFT_RIGHTJUSTIFY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFT_RIGHTJUSTIFY" unsafe prim_mFT_RIGHTJUSTIFY :: IO (Word32)


mFS_GRAYED :: MenuState
mFS_GRAYED =
  unsafePerformIO(
    prim_mFS_GRAYED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_GRAYED" unsafe prim_mFS_GRAYED :: IO (Word32)
mFS_DISABLED :: MenuState
mFS_DISABLED =
  unsafePerformIO(
    prim_mFS_DISABLED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_DISABLED" unsafe prim_mFS_DISABLED :: IO (Word32)
mFS_CHECKED :: MenuState
mFS_CHECKED =
  unsafePerformIO(
    prim_mFS_CHECKED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_CHECKED" unsafe prim_mFS_CHECKED :: IO (Word32)
mFS_HILITE :: MenuState
mFS_HILITE =
  unsafePerformIO(
    prim_mFS_HILITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_HILITE" unsafe prim_mFS_HILITE :: IO (Word32)
mFS_ENABLED :: MenuState
mFS_ENABLED =
  unsafePerformIO(
    prim_mFS_ENABLED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_ENABLED" unsafe prim_mFS_ENABLED :: IO (Word32)
mFS_UNCHECKED :: MenuState
mFS_UNCHECKED =
  unsafePerformIO(
    prim_mFS_UNCHECKED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_UNCHECKED" unsafe prim_mFS_UNCHECKED :: IO (Word32)
mFS_UNHILITE :: MenuState
mFS_UNHILITE =
  unsafePerformIO(
    prim_mFS_UNHILITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_UNHILITE" unsafe prim_mFS_UNHILITE :: IO (Word32)
mFS_DEFAULT :: MenuState
mFS_DEFAULT =
  unsafePerformIO(
    prim_mFS_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mFS_DEFAULT" unsafe prim_mFS_DEFAULT :: IO (Word32)

type TrackMenuFlag = UINT

tPM_LEFTBUTTON :: TrackMenuFlag
tPM_LEFTBUTTON =
  unsafePerformIO(
    prim_tPM_LEFTBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_LEFTBUTTON" unsafe prim_tPM_LEFTBUTTON :: IO (Word32)
tPM_RIGHTBUTTON :: TrackMenuFlag
tPM_RIGHTBUTTON =
  unsafePerformIO(
    prim_tPM_RIGHTBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_RIGHTBUTTON" unsafe prim_tPM_RIGHTBUTTON :: IO (Word32)
tPM_LEFTALIGN :: TrackMenuFlag
tPM_LEFTALIGN =
  unsafePerformIO(
    prim_tPM_LEFTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_LEFTALIGN" unsafe prim_tPM_LEFTALIGN :: IO (Word32)
tPM_CENTERALIGN :: TrackMenuFlag
tPM_CENTERALIGN =
  unsafePerformIO(
    prim_tPM_CENTERALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_CENTERALIGN" unsafe prim_tPM_CENTERALIGN :: IO (Word32)
tPM_RIGHTALIGN :: TrackMenuFlag
tPM_RIGHTALIGN =
  unsafePerformIO(
    prim_tPM_RIGHTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_RIGHTALIGN" unsafe prim_tPM_RIGHTALIGN :: IO (Word32)
tPM_TOPALIGN :: TrackMenuFlag
tPM_TOPALIGN =
  unsafePerformIO(
    prim_tPM_TOPALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_TOPALIGN" unsafe prim_tPM_TOPALIGN :: IO (Word32)
tPM_VCENTERALIGN :: TrackMenuFlag
tPM_VCENTERALIGN =
  unsafePerformIO(
    prim_tPM_VCENTERALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_VCENTERALIGN" unsafe prim_tPM_VCENTERALIGN :: IO (Word32)
tPM_BOTTOMALIGN :: TrackMenuFlag
tPM_BOTTOMALIGN =
  unsafePerformIO(
    prim_tPM_BOTTOMALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_BOTTOMALIGN" unsafe prim_tPM_BOTTOMALIGN :: IO (Word32)
tPM_HORIZONTAL :: TrackMenuFlag
tPM_HORIZONTAL =
  unsafePerformIO(
    prim_tPM_HORIZONTAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_HORIZONTAL" unsafe prim_tPM_HORIZONTAL :: IO (Word32)
tPM_VERTICAL :: TrackMenuFlag
tPM_VERTICAL =
  unsafePerformIO(
    prim_tPM_VERTICAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_VERTICAL" unsafe prim_tPM_VERTICAL :: IO (Word32)
tPM_NONOTIFY :: TrackMenuFlag
tPM_NONOTIFY =
  unsafePerformIO(
    prim_tPM_NONOTIFY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_NONOTIFY" unsafe prim_tPM_NONOTIFY :: IO (Word32)
tPM_RETURNCMD :: TrackMenuFlag
tPM_RETURNCMD =
  unsafePerformIO(
    prim_tPM_RETURNCMD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_tPM_RETURNCMD" unsafe prim_tPM_RETURNCMD :: IO (Word32)

type SystemMenuCommand = UINT

sC_SIZE :: SystemMenuCommand
sC_SIZE =
  unsafePerformIO(
    prim_sC_SIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_SIZE" unsafe prim_sC_SIZE :: IO (Word32)
sC_MOVE :: SystemMenuCommand
sC_MOVE =
  unsafePerformIO(
    prim_sC_MOVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_MOVE" unsafe prim_sC_MOVE :: IO (Word32)
sC_MINIMIZE :: SystemMenuCommand
sC_MINIMIZE =
  unsafePerformIO(
    prim_sC_MINIMIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_MINIMIZE" unsafe prim_sC_MINIMIZE :: IO (Word32)
sC_MAXIMIZE :: SystemMenuCommand
sC_MAXIMIZE =
  unsafePerformIO(
    prim_sC_MAXIMIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_MAXIMIZE" unsafe prim_sC_MAXIMIZE :: IO (Word32)
sC_NEXTWINDOW :: SystemMenuCommand
sC_NEXTWINDOW =
  unsafePerformIO(
    prim_sC_NEXTWINDOW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_NEXTWINDOW" unsafe prim_sC_NEXTWINDOW :: IO (Word32)
sC_PREVWINDOW :: SystemMenuCommand
sC_PREVWINDOW =
  unsafePerformIO(
    prim_sC_PREVWINDOW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_PREVWINDOW" unsafe prim_sC_PREVWINDOW :: IO (Word32)
sC_CLOSE :: SystemMenuCommand
sC_CLOSE =
  unsafePerformIO(
    prim_sC_CLOSE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_CLOSE" unsafe prim_sC_CLOSE :: IO (Word32)
sC_VSCROLL :: SystemMenuCommand
sC_VSCROLL =
  unsafePerformIO(
    prim_sC_VSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_VSCROLL" unsafe prim_sC_VSCROLL :: IO (Word32)
sC_HSCROLL :: SystemMenuCommand
sC_HSCROLL =
  unsafePerformIO(
    prim_sC_HSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_HSCROLL" unsafe prim_sC_HSCROLL :: IO (Word32)
sC_MOUSEMENU :: SystemMenuCommand
sC_MOUSEMENU =
  unsafePerformIO(
    prim_sC_MOUSEMENU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_MOUSEMENU" unsafe prim_sC_MOUSEMENU :: IO (Word32)
sC_KEYMENU :: SystemMenuCommand
sC_KEYMENU =
  unsafePerformIO(
    prim_sC_KEYMENU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_KEYMENU" unsafe prim_sC_KEYMENU :: IO (Word32)
sC_ARRANGE :: SystemMenuCommand
sC_ARRANGE =
  unsafePerformIO(
    prim_sC_ARRANGE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_ARRANGE" unsafe prim_sC_ARRANGE :: IO (Word32)
sC_RESTORE :: SystemMenuCommand
sC_RESTORE =
  unsafePerformIO(
    prim_sC_RESTORE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_RESTORE" unsafe prim_sC_RESTORE :: IO (Word32)
sC_TASKLIST :: SystemMenuCommand
sC_TASKLIST =
  unsafePerformIO(
    prim_sC_TASKLIST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_TASKLIST" unsafe prim_sC_TASKLIST :: IO (Word32)
sC_SCREENSAVE :: SystemMenuCommand
sC_SCREENSAVE =
  unsafePerformIO(
    prim_sC_SCREENSAVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_SCREENSAVE" unsafe prim_sC_SCREENSAVE :: IO (Word32)
sC_HOTKEY :: SystemMenuCommand
sC_HOTKEY =
  unsafePerformIO(
    prim_sC_HOTKEY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_HOTKEY" unsafe prim_sC_HOTKEY :: IO (Word32)
sC_DEFAULT :: SystemMenuCommand
sC_DEFAULT =
  unsafePerformIO(
    prim_sC_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_DEFAULT" unsafe prim_sC_DEFAULT :: IO (Word32)
sC_MONITORPOWER :: SystemMenuCommand
sC_MONITORPOWER =
  unsafePerformIO(
    prim_sC_MONITORPOWER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_MONITORPOWER" unsafe prim_sC_MONITORPOWER :: IO (Word32)
sC_CONTEXTHELP :: SystemMenuCommand
sC_CONTEXTHELP =
  unsafePerformIO(
    prim_sC_CONTEXTHELP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_CONTEXTHELP" unsafe prim_sC_CONTEXTHELP :: IO (Word32)
sC_SEPARATOR :: SystemMenuCommand
sC_SEPARATOR =
  unsafePerformIO(
    prim_sC_SEPARATOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sC_SEPARATOR" unsafe prim_sC_SEPARATOR :: IO (Word32)

isMenu :: HMENU -> IO Bool
isMenu arg1 =
  prim_isMenu arg1
  >>= \  gc_res2  ->
  (unmarshall_bool_ gc_res2) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_isMenu" unsafe prim_isMenu :: Addr -> IO (Int)

getSystemMenu :: HWND -> Bool -> IO MbHMENU
getSystemMenu arg1 gc_arg1 =
  (marshall_bool_ gc_arg1) >>= \ (arg2) ->
  prim_getSystemMenu arg1 arg2
  >>= \  res1  ->
  (if nullHANDLE == (res1)
   then return Nothing
   else (return ((Just res1)))) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_getSystemMenu" unsafe prim_getSystemMenu :: Addr -> Int -> IO (Addr)

getMenu :: HWND -> IO MbHMENU
getMenu arg1 =
  prim_getMenu arg1
  >>= \  res1  ->
  (if nullHANDLE == (res1)
   then return Nothing
   else (return ((Just res1)))) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_getMenu" unsafe prim_getMenu :: Addr -> IO (Addr)

getMenuDefaultItem :: HMENU -> Bool -> GMDIFlag -> IO MenuItem
getMenuDefaultItem arg1 gc_arg1 arg3 =
  (marshall_bool_ gc_arg1) >>= \ (arg2) ->
  prim_getMenuDefaultItem arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_getMenuDefaultItem_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getMenuDefaultItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuDefaultItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getMenuDefaultItem" unsafe prim_getMenuDefaultItem :: Addr -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getMenuDefaultItem_res1" unsafe access_prim_getMenuDefaultItem_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getMenuDefaultItem_gc_failed" unsafe access_prim_getMenuDefaultItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuDefaultItem_gc_failstring" unsafe access_prim_getMenuDefaultItem_gc_failstring :: Addr -> IO (Addr)

getMenuState :: HMENU -> MenuItem -> MenuFlag -> IO MenuState
getMenuState arg1 arg2 arg3 =
  prim_getMenuState arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_getMenuState_res (gc_result :: Addr) >>= \ res ->
  access_prim_getMenuState_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuState_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res))
foreign import  ccall "prim_getMenuState" unsafe prim_getMenuState :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getMenuState_res" unsafe access_prim_getMenuState_res :: Addr -> IO (Word32)
foreign import ccall "access_prim_getMenuState_gc_failed" unsafe access_prim_getMenuState_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuState_gc_failstring" unsafe access_prim_getMenuState_gc_failstring :: Addr -> IO (Addr)


getSubMenu :: HMENU -> MenuItem -> IO MbHMENU
getSubMenu arg1 arg2 =
  prim_getSubMenu arg1 arg2
  >>= \  res1  ->
  (if nullHANDLE == (res1)
   then return Nothing
   else (return ((Just res1)))) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_getSubMenu" unsafe prim_getSubMenu :: Addr -> Word32 -> IO (Addr)

setMenu :: HWND -> HMENU -> IO ()
setMenu arg1 arg2 =
  prim_setMenu arg1 arg2
  >>= \ gc_result ->
  access_prim_setMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setMenu" unsafe prim_setMenu :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_setMenu_gc_failed" unsafe access_prim_setMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setMenu_gc_failstring" unsafe access_prim_setMenu_gc_failstring :: Addr -> IO (Addr)

getMenuItemCount :: HMENU -> IO Int
getMenuItemCount arg1 =
  prim_getMenuItemCount arg1
  >>= \ gc_result ->
  access_prim_getMenuItemCount_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getMenuItemCount_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuItemCount_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getMenuItemCount" unsafe prim_getMenuItemCount :: Addr -> IO (Addr)
foreign import ccall "access_prim_getMenuItemCount_res1" unsafe access_prim_getMenuItemCount_res1 :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemCount_gc_failed" unsafe access_prim_getMenuItemCount_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemCount_gc_failstring" unsafe access_prim_getMenuItemCount_gc_failstring :: Addr -> IO (Addr)

type MenuID = UINT

getMenuItemID :: HMENU -> MenuItem -> IO MenuID
getMenuItemID arg1 arg2 =
  prim_getMenuItemID arg1 arg2
  >>= \ gc_result ->
  access_prim_getMenuItemID_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getMenuItemID_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuItemID_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getMenuItemID" unsafe prim_getMenuItemID :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getMenuItemID_res1" unsafe access_prim_getMenuItemID_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getMenuItemID_gc_failed" unsafe access_prim_getMenuItemID_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemID_gc_failstring" unsafe access_prim_getMenuItemID_gc_failstring :: Addr -> IO (Addr)

data MenuItemInfo
 = MenuItemInfo  {
      menuItemType    :: MenuFlag,
      menuItemState   :: MenuState,
      menuItemID      :: UINT,
      menuItemSubMenu :: HMENU,
      menuItemBitmapChecked :: HBITMAP,
      menuItemBitmapUnchecked :: HBITMAP,
      menuItemData    :: DWORD,
      menuItemTypeData :: String
   }



marshall_menuItemInfo :: MenuItemInfo -> IO Addr
marshall_menuItemInfo (MenuItemInfo miType 
				    miState
				    miItemID
				    miSubMenu
				    miChecked
				    miUnchecked
				    miData
				    miTypeData) = do
  ptr <- mallocMenuItemInfo
  pstr <- marshall_string_ miTypeData
  assignMenuItemInfo ptr
                     miType miState miItemID miSubMenu 
                     miChecked miUnchecked miData pstr (length miTypeData)
  return ptr

unmarshall_menuItemInfo :: Addr -> IO MenuItemInfo
unmarshall_menuItemInfo ptr = do
   mi <- unravelItemInfo ptr
   free ptr
   return mi

unravelItemInfo :: Addr -> IO MenuItemInfo
unravelItemInfo arg1 =
  prim_unravelItemInfo arg1
  >>= \ gc_result ->
  access_prim_unravelItemInfo_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_unravelItemInfo_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_unravelItemInfo_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_unravelItemInfo_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_unravelItemInfo_gc_res5 (gc_result :: Addr) >>= \ gc_res5 ->
  access_prim_unravelItemInfo_gc_res6 (gc_result :: Addr) >>= \ gc_res6 ->
  access_prim_unravelItemInfo_gc_res7 (gc_result :: Addr) >>= \ gc_res7 ->
  access_prim_unravelItemInfo_gc_res9 (gc_result :: Addr) >>= \ gc_res9 ->
  access_prim_unravelItemInfo_gc_res10 (gc_result :: Addr) >>= \ gc_res10 ->
  (unmarshall_stringLen_ gc_res9 gc_res10) >>= \ gc_res8 ->
  (return ((MenuItemInfo gc_res1 gc_res2 gc_res3 gc_res4 gc_res5 gc_res6 gc_res7 gc_res8)))
foreign import  ccall "prim_unravelItemInfo" unsafe prim_unravelItemInfo :: Addr -> IO (Addr)
foreign import ccall "access_prim_unravelItemInfo_gc_res1" unsafe access_prim_unravelItemInfo_gc_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_unravelItemInfo_gc_res2" unsafe access_prim_unravelItemInfo_gc_res2 :: Addr -> IO (Word32)
foreign import ccall "access_prim_unravelItemInfo_gc_res3" unsafe access_prim_unravelItemInfo_gc_res3 :: Addr -> IO (Word32)
foreign import ccall "access_prim_unravelItemInfo_gc_res4" unsafe access_prim_unravelItemInfo_gc_res4 :: Addr -> IO (Addr)
foreign import ccall "access_prim_unravelItemInfo_gc_res5" unsafe access_prim_unravelItemInfo_gc_res5 :: Addr -> IO (Addr)
foreign import ccall "access_prim_unravelItemInfo_gc_res6" unsafe access_prim_unravelItemInfo_gc_res6 :: Addr -> IO (Addr)
foreign import ccall "access_prim_unravelItemInfo_gc_res7" unsafe access_prim_unravelItemInfo_gc_res7 :: Addr -> IO (Word32)
foreign import ccall "access_prim_unravelItemInfo_gc_res9" unsafe access_prim_unravelItemInfo_gc_res9 :: Addr -> IO (Addr)
foreign import ccall "access_prim_unravelItemInfo_gc_res10" unsafe access_prim_unravelItemInfo_gc_res10 :: Addr -> IO (Int)

mallocMenuItemInfo :: IO Addr
mallocMenuItemInfo =
  prim_mallocMenuItemInfo
  >>= \ gc_result ->
  access_prim_mallocMenuItemInfo_mp (gc_result :: Addr) >>= \ mp ->
  access_prim_mallocMenuItemInfo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_mallocMenuItemInfo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (mp))
foreign import  ccall "prim_mallocMenuItemInfo" unsafe prim_mallocMenuItemInfo :: IO (Addr)
foreign import ccall "access_prim_mallocMenuItemInfo_mp" unsafe access_prim_mallocMenuItemInfo_mp :: Addr -> IO (Addr)
foreign import ccall "access_prim_mallocMenuItemInfo_gc_failed" unsafe access_prim_mallocMenuItemInfo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_mallocMenuItemInfo_gc_failstring" unsafe access_prim_mallocMenuItemInfo_gc_failstring :: Addr -> IO (Addr)

assignMenuItemInfo :: Addr -> UINT -> UINT -> UINT -> HMENU -> HBITMAP -> HBITMAP -> DWORD -> Addr -> Int -> IO ()
assignMenuItemInfo arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 =
  prim_assignMenuItemInfo arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
foreign import  ccall "prim_assignMenuItemInfo" unsafe prim_assignMenuItemInfo :: Addr -> Word32 -> Word32 -> Word32 -> Addr -> Addr -> Addr -> Word32 -> Addr -> Int -> IO ()

type MenuItemMask = UINT

mIIM_CHECKMARKS :: MenuItemMask
mIIM_CHECKMARKS =
  unsafePerformIO(
    prim_mIIM_CHECKMARKS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_CHECKMARKS" unsafe prim_mIIM_CHECKMARKS :: IO (Word32)
mIIM_DATA :: MenuItemMask
mIIM_DATA =
  unsafePerformIO(
    prim_mIIM_DATA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_DATA" unsafe prim_mIIM_DATA :: IO (Word32)
mIIM_ID :: MenuItemMask
mIIM_ID =
  unsafePerformIO(
    prim_mIIM_ID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_ID" unsafe prim_mIIM_ID :: IO (Word32)
mIIM_STATE :: MenuItemMask
mIIM_STATE =
  unsafePerformIO(
    prim_mIIM_STATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_STATE" unsafe prim_mIIM_STATE :: IO (Word32)
mIIM_SUBMENU :: MenuItemMask
mIIM_SUBMENU =
  unsafePerformIO(
    prim_mIIM_SUBMENU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_SUBMENU" unsafe prim_mIIM_SUBMENU :: IO (Word32)
mIIM_TYPE :: MenuItemMask
mIIM_TYPE =
  unsafePerformIO(
    prim_mIIM_TYPE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mIIM_TYPE" unsafe prim_mIIM_TYPE :: IO (Word32)

getMenuItemInfo :: HMENU -> MenuItem -> Bool -> MenuItemMask -> IO MenuItemInfo
getMenuItemInfo arg1 arg2 gc_arg1 arg4 =
  (marshall_bool_ gc_arg1) >>= \ (arg3) ->
  prim_getMenuItemInfo arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_getMenuItemInfo_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getMenuItemInfo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuItemInfo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else ( unmarshall_menuItemInfo  (gc_res2)) >>= \ gc_res1 ->
       (return (gc_res1))
foreign import  ccall "prim_getMenuItemInfo" unsafe prim_getMenuItemInfo :: Addr -> Word32 -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getMenuItemInfo_gc_res2" unsafe access_prim_getMenuItemInfo_gc_res2 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getMenuItemInfo_gc_failed" unsafe access_prim_getMenuItemInfo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemInfo_gc_failstring" unsafe access_prim_getMenuItemInfo_gc_failstring :: Addr -> IO (Addr)

getMenuItemRect :: HWND -> HMENU -> UINT -> IO RECT
getMenuItemRect arg1 arg2 arg3 =
  prim_getMenuItemRect arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_getMenuItemRect_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getMenuItemRect_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_getMenuItemRect_gc_res6 (gc_result :: Addr) >>= \ gc_res6 ->
  access_prim_getMenuItemRect_gc_res8 (gc_result :: Addr) >>= \ gc_res8 ->
  access_prim_getMenuItemRect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getMenuItemRect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       let gc_res5 = ( intToInt32  (gc_res6)) in
       let gc_res7 = ( intToInt32  (gc_res8)) in
       (return ((gc_res1,gc_res3,gc_res5,gc_res7)))
foreign import  ccall "prim_getMenuItemRect" unsafe prim_getMenuItemRect :: Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getMenuItemRect_gc_res2" unsafe access_prim_getMenuItemRect_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemRect_gc_res4" unsafe access_prim_getMenuItemRect_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemRect_gc_res6" unsafe access_prim_getMenuItemRect_gc_res6 :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemRect_gc_res8" unsafe access_prim_getMenuItemRect_gc_res8 :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemRect_gc_failed" unsafe access_prim_getMenuItemRect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getMenuItemRect_gc_failstring" unsafe access_prim_getMenuItemRect_gc_failstring :: Addr -> IO (Addr)

hiliteMenuItem :: HWND -> HMENU -> MenuItem -> MenuFlag -> IO Bool
hiliteMenuItem arg1 arg2 arg3 arg4 =
  prim_hiliteMenuItem arg1 arg2 arg3 arg4
  >>= \  gc_res2  ->
  (unmarshall_bool_ gc_res2) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_hiliteMenuItem" unsafe prim_hiliteMenuItem :: Addr -> Addr -> Word32 -> Word32 -> IO (Int)

insertMenuItem :: HMENU -> MenuItem -> Bool -> MenuItemInfo -> IO ()
insertMenuItem arg1 arg2 gc_arg1 gc_arg2 =
  (marshall_bool_ gc_arg1) >>= \ (arg3) ->
  ( marshall_menuItemInfo  gc_arg2) >>= \ arg4 ->
  prim_insertMenuItem arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_insertMenuItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_insertMenuItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_insertMenuItem" unsafe prim_insertMenuItem :: Addr -> Word32 -> Int -> Addr -> IO (Addr)
foreign import ccall "access_prim_insertMenuItem_gc_failed" unsafe access_prim_insertMenuItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_insertMenuItem_gc_failstring" unsafe access_prim_insertMenuItem_gc_failstring :: Addr -> IO (Addr)

type Menu = LPCSTR
-- intToMenu :: Int -> Menu
-- intToMenu i = makeIntResource (toWord i)

loadMenu :: MbHINSTANCE -> Menu -> IO HMENU
loadMenu arg1 arg2 =
  (case arg1 of {
      Nothing -> (return (nullHANDLE));
      (Just arg1) -> (return ((arg1)))
   }) >>= \ (arg1) ->
  prim_loadMenu arg1 arg2
  >>= \ gc_result ->
  access_prim_loadMenu_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_loadMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_loadMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_loadMenu" unsafe prim_loadMenu :: Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_loadMenu_res1" unsafe access_prim_loadMenu_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_loadMenu_gc_failed" unsafe access_prim_loadMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_loadMenu_gc_failstring" unsafe access_prim_loadMenu_gc_failstring :: Addr -> IO (Addr)

-- Dealing with mappings to/from structs is a pain in GC,
-- so we'll leave this one out for now.
-- %fun LoadMenuIndirect :: MenuTemplate -> IO HMENU

menuItemFromPoint :: HWND -> HMENU -> POINT -> IO UINT
menuItemFromPoint arg1 arg2 gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  prim_menuItemFromPoint arg1 arg2 gc_arg3 gc_arg5
  >>= \  res1  ->
  (return (res1))}}}
foreign import  ccall "prim_menuItemFromPoint" unsafe prim_menuItemFromPoint :: Addr -> Addr -> Int -> Int -> IO (Word32)

setMenuDefaultItem :: HMENU -> MenuItem -> Bool -> IO ()
setMenuDefaultItem arg1 arg2 gc_arg1 =
  (marshall_bool_ gc_arg1) >>= \ (arg3) ->
  prim_setMenuDefaultItem arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_setMenuDefaultItem_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setMenuDefaultItem_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setMenuDefaultItem" unsafe prim_setMenuDefaultItem :: Addr -> Word32 -> Int -> IO (Addr)
foreign import ccall "access_prim_setMenuDefaultItem_gc_failed" unsafe access_prim_setMenuDefaultItem_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setMenuDefaultItem_gc_failstring" unsafe access_prim_setMenuDefaultItem_gc_failstring :: Addr -> IO (Addr)

setMenuItemBitmaps :: HMENU -> MenuItem -> MenuFlag -> HBITMAP -> HBITMAP -> IO ()
setMenuItemBitmaps arg1 arg2 arg3 arg4 arg5 =
  prim_setMenuItemBitmaps arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_setMenuItemBitmaps_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setMenuItemBitmaps_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setMenuItemBitmaps" unsafe prim_setMenuItemBitmaps :: Addr -> Word32 -> Word32 -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_setMenuItemBitmaps_gc_failed" unsafe access_prim_setMenuItemBitmaps_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setMenuItemBitmaps_gc_failstring" unsafe access_prim_setMenuItemBitmaps_gc_failstring :: Addr -> IO (Addr)

destroyMenu :: HMENU -> IO ()
destroyMenu arg1 =
  prim_destroyMenu arg1
  >>= \ gc_result ->
  access_prim_destroyMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_destroyMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_destroyMenu" unsafe prim_destroyMenu :: Addr -> IO (Addr)
foreign import ccall "access_prim_destroyMenu_gc_failed" unsafe access_prim_destroyMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_destroyMenu_gc_failstring" unsafe access_prim_destroyMenu_gc_failstring :: Addr -> IO (Addr)

deleteMenu :: HMENU -> MenuItem -> MenuFlag -> IO ()
deleteMenu arg1 arg2 arg3 =
  prim_deleteMenu arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_deleteMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deleteMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deleteMenu" unsafe prim_deleteMenu :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_deleteMenu_gc_failed" unsafe access_prim_deleteMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deleteMenu_gc_failstring" unsafe access_prim_deleteMenu_gc_failstring :: Addr -> IO (Addr)

setMenuItemInfo :: HMENU -> MenuItem -> Bool -> MenuItemMask -> MenuItemInfo -> IO ()
setMenuItemInfo arg1 arg2 gc_arg1 arg4 gc_arg2 =
  (marshall_bool_ gc_arg1) >>= \ (arg3) ->
  ( marshall_menuItemInfo  gc_arg2) >>= \ arg5 ->
  prim_setMenuItemInfo arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_setMenuItemInfo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setMenuItemInfo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_setMenuItemInfo" unsafe prim_setMenuItemInfo :: Addr -> Word32 -> Int -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_setMenuItemInfo_gc_failed" unsafe access_prim_setMenuItemInfo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setMenuItemInfo_gc_failstring" unsafe access_prim_setMenuItemInfo_gc_failstring :: Addr -> IO (Addr)

trackPopupMenu :: HMENU -> TrackMenuFlag -> Int -> Int -> HWND -> RECT -> IO ()
trackPopupMenu arg1 arg2 arg3 arg4 arg5 gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_trackPopupMenu arg1 arg2 arg3 arg4 arg5 gc_arg3 gc_arg5 gc_arg7 gc_arg9
  >>= \ gc_result ->
  access_prim_trackPopupMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_trackPopupMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}
foreign import  ccall "prim_trackPopupMenu" unsafe prim_trackPopupMenu :: Addr -> Word32 -> Int -> Int -> Addr -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_trackPopupMenu_gc_failed" unsafe access_prim_trackPopupMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_trackPopupMenu_gc_failstring" unsafe access_prim_trackPopupMenu_gc_failstring :: Addr -> IO (Addr)

trackPopupMenuEx :: HMENU -> TrackMenuFlag -> Int -> Int -> HWND -> MbLPRECT -> IO ()
trackPopupMenuEx arg1 arg2 arg3 arg4 arg5 arg6 =
  (case arg6 of {
      Nothing -> (return (nullAddr));
      (Just arg6) -> (return ((arg6)))
   }) >>= \ (arg6) ->
  prim_trackPopupMenuEx arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_trackPopupMenuEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_trackPopupMenuEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_trackPopupMenuEx" unsafe prim_trackPopupMenuEx :: Addr -> Word32 -> Int -> Int -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_trackPopupMenuEx_gc_failed" unsafe access_prim_trackPopupMenuEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_trackPopupMenuEx_gc_failstring" unsafe access_prim_trackPopupMenuEx_gc_failstring :: Addr -> IO (Addr)



appendMenu :: HMENU -> MenuFlag -> MenuID -> String -> IO ()
appendMenu arg1 arg2 arg3 gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg4) ->
  prim_appendMenu arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_appendMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_appendMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_appendMenu" unsafe prim_appendMenu :: Addr -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_appendMenu_gc_failed" unsafe access_prim_appendMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_appendMenu_gc_failstring" unsafe access_prim_appendMenu_gc_failstring :: Addr -> IO (Addr)

insertMenu :: HMENU -> MenuItem -> MenuFlag -> MenuID -> String -> IO ()
insertMenu arg1 arg2 arg3 arg4 gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg5) ->
  prim_insertMenu arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_insertMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_insertMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_insertMenu" unsafe prim_insertMenu :: Addr -> Word32 -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_insertMenu_gc_failed" unsafe access_prim_insertMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_insertMenu_gc_failstring" unsafe access_prim_insertMenu_gc_failstring :: Addr -> IO (Addr)

modifyMenu :: HMENU -> MenuItem -> MenuFlag -> MenuID -> String -> IO ()
modifyMenu arg1 arg2 arg3 arg4 gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg5) ->
  prim_modifyMenu arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_modifyMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_modifyMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_modifyMenu" unsafe prim_modifyMenu :: Addr -> Word32 -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_modifyMenu_gc_failed" unsafe access_prim_modifyMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_modifyMenu_gc_failstring" unsafe access_prim_modifyMenu_gc_failstring :: Addr -> IO (Addr)

removeMenu :: HMENU -> MenuItem -> MenuFlag -> IO ()
removeMenu arg1 arg2 arg3 =
  prim_removeMenu arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_removeMenu_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_removeMenu_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_removeMenu" unsafe prim_removeMenu :: Addr -> Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_removeMenu_gc_failed" unsafe access_prim_removeMenu_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_removeMenu_gc_failstring" unsafe access_prim_removeMenu_gc_failstring :: Addr -> IO (Addr)


----------------------------------------------------------------
-- End
----------------------------------------------------------------
