{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "Win32Graphics2D_stub_ffi.h" #-}
module Win32Graphics2D
	where

import StdDIS
import Win32Types
import GDITypes
import Win32Bitmap


----------------------------------------------------------------
-- 2D graphics operations
----------------------------------------------------------------

moveToEx :: HDC -> Int32 -> Int32 -> IO POINT
moveToEx arg1 gc_arg1 gc_arg2 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  prim_moveToEx arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_moveToEx_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_moveToEx_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_moveToEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_moveToEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       (return ((gc_res1,gc_res3)))}}
foreign import  ccall "prim_moveToEx" unsafe prim_moveToEx :: Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_moveToEx_gc_res2" unsafe access_prim_moveToEx_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_moveToEx_gc_res4" unsafe access_prim_moveToEx_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_moveToEx_gc_failed" unsafe access_prim_moveToEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_moveToEx_gc_failstring" unsafe access_prim_moveToEx_gc_failstring :: Addr -> IO (Addr)

lineTo :: HDC -> Int32 -> Int32 -> IO ()
lineTo arg1 gc_arg1 gc_arg2 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  prim_lineTo arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_lineTo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_lineTo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}
foreign import  ccall "prim_lineTo" unsafe prim_lineTo :: Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_lineTo_gc_failed" unsafe access_prim_lineTo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_lineTo_gc_failstring" unsafe access_prim_lineTo_gc_failstring :: Addr -> IO (Addr)

polyline :: HDC -> [POINT] -> IO ()
polyline hdc gc_arg1 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  prim_polyline hdc ps num_ps
  >>= \ gc_result ->
  access_prim_polyline_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_polyline_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_polyline" unsafe prim_polyline :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_polyline_gc_failed" unsafe access_prim_polyline_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_polyline_gc_failstring" unsafe access_prim_polyline_gc_failstring :: Addr -> IO (Addr)

polylineTo :: HDC -> [POINT] -> IO ()
polylineTo hdc gc_arg1 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  prim_polylineTo hdc ps num_ps
  >>= \ gc_result ->
  access_prim_polylineTo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_polylineTo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_polylineTo" unsafe prim_polylineTo :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_polylineTo_gc_failed" unsafe access_prim_polylineTo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_polylineTo_gc_failstring" unsafe access_prim_polylineTo_gc_failstring :: Addr -> IO (Addr)

polygon :: HDC -> [POINT] -> IO ()
polygon hdc gc_arg1 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  prim_polygon hdc ps num_ps
  >>= \ gc_result ->
  access_prim_polygon_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_polygon_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_polygon" unsafe prim_polygon :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_polygon_gc_failed" unsafe access_prim_polygon_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_polygon_gc_failstring" unsafe access_prim_polygon_gc_failstring :: Addr -> IO (Addr)

polyBezier :: HDC -> [POINT] -> IO ()
polyBezier hdc gc_arg1 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  prim_polyBezier hdc ps num_ps
  >>= \ gc_result ->
  access_prim_polyBezier_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_polyBezier_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_polyBezier" unsafe prim_polyBezier :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_polyBezier_gc_failed" unsafe access_prim_polyBezier_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_polyBezier_gc_failstring" unsafe access_prim_polyBezier_gc_failstring :: Addr -> IO (Addr)

polyBezierTo :: HDC -> [POINT] -> IO ()
polyBezierTo hdc gc_arg1 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  prim_polyBezierTo hdc ps num_ps
  >>= \ gc_result ->
  access_prim_polyBezierTo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_polyBezierTo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
foreign import  ccall "prim_polyBezierTo" unsafe prim_polyBezierTo :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_polyBezierTo_gc_failed" unsafe access_prim_polyBezierTo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_polyBezierTo_gc_failstring" unsafe access_prim_polyBezierTo_gc_failstring :: Addr -> IO (Addr)

-- ToDo: We ought to be able to specify a colour instead of the
-- Brush by adding 1 to colour number.

fillRect :: HDC -> RECT -> HBRUSH -> IO ()
fillRect arg1 gc_arg1 arg3 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_fillRect arg1 gc_arg3 gc_arg5 gc_arg7 gc_arg9 arg3
  >>= \ gc_result ->
  access_prim_fillRect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_fillRect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}
foreign import  ccall "prim_fillRect" unsafe prim_fillRect :: Addr -> Int -> Int -> Int -> Int -> Addr -> IO (Addr)
foreign import ccall "access_prim_fillRect_gc_failed" unsafe access_prim_fillRect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_fillRect_gc_failstring" unsafe access_prim_fillRect_gc_failstring :: Addr -> IO (Addr)

frameRect :: HDC -> RECT -> HBRUSH -> IO ()
frameRect arg1 gc_arg1 arg3 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_frameRect arg1 gc_arg3 gc_arg5 gc_arg7 gc_arg9 arg3
  >>= \ gc_result ->
  access_prim_frameRect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_frameRect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}
foreign import  ccall "prim_frameRect" unsafe prim_frameRect :: Addr -> Int -> Int -> Int -> Int -> Addr -> IO (Addr)
foreign import ccall "access_prim_frameRect_gc_failed" unsafe access_prim_frameRect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_frameRect_gc_failstring" unsafe access_prim_frameRect_gc_failstring :: Addr -> IO (Addr)

invertRect :: HDC -> RECT -> IO ()
invertRect arg1 gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_invertRect arg1 gc_arg3 gc_arg5 gc_arg7 gc_arg9
  >>= \ gc_result ->
  access_prim_invertRect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_invertRect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}
foreign import  ccall "prim_invertRect" unsafe prim_invertRect :: Addr -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_invertRect_gc_failed" unsafe access_prim_invertRect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_invertRect_gc_failstring" unsafe access_prim_invertRect_gc_failstring :: Addr -> IO (Addr)

rectangle :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
rectangle arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  prim_rectangle arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_rectangle_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_rectangle_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}
foreign import  ccall "prim_rectangle" unsafe prim_rectangle :: Addr -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_rectangle_gc_failed" unsafe access_prim_rectangle_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_rectangle_gc_failstring" unsafe access_prim_rectangle_gc_failstring :: Addr -> IO (Addr)

roundRect :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
roundRect arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg6 ->
  case ( int32ToInt  gc_arg6) of { arg7 ->
  prim_roundRect arg1 arg2 arg3 arg4 arg5 arg6 arg7
  >>= \ gc_result ->
  access_prim_roundRect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_roundRect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}
foreign import  ccall "prim_roundRect" unsafe prim_roundRect :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_roundRect_gc_failed" unsafe access_prim_roundRect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_roundRect_gc_failstring" unsafe access_prim_roundRect_gc_failstring :: Addr -> IO (Addr)

ellipse :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
ellipse arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  prim_ellipse arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_ellipse_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_ellipse_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}
foreign import  ccall "prim_ellipse" unsafe prim_ellipse :: Addr -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_ellipse_gc_failed" unsafe access_prim_ellipse_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_ellipse_gc_failstring" unsafe access_prim_ellipse_gc_failstring :: Addr -> IO (Addr)

arc :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
arc arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 gc_arg7 gc_arg8 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg6 ->
  case ( int32ToInt  gc_arg6) of { arg7 ->
  case ( int32ToInt  gc_arg7) of { arg8 ->
  case ( int32ToInt  gc_arg8) of { arg9 ->
  prim_arc arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
  >>= \ gc_result ->
  access_prim_arc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_arc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_arc" unsafe prim_arc :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_arc_gc_failed" unsafe access_prim_arc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_arc_gc_failstring" unsafe access_prim_arc_gc_failstring :: Addr -> IO (Addr)

arcTo :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
arcTo arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 gc_arg7 gc_arg8 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg6 ->
  case ( int32ToInt  gc_arg6) of { arg7 ->
  case ( int32ToInt  gc_arg7) of { arg8 ->
  case ( int32ToInt  gc_arg8) of { arg9 ->
  prim_arcTo arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
  >>= \ gc_result ->
  access_prim_arcTo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_arcTo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_arcTo" unsafe prim_arcTo :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_arcTo_gc_failed" unsafe access_prim_arcTo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_arcTo_gc_failstring" unsafe access_prim_arcTo_gc_failstring :: Addr -> IO (Addr)

angleArc :: HDC -> Int32 -> Int32 -> WORD -> Double -> Double -> IO ()
angleArc arg1 gc_arg1 gc_arg2 gc_arg3 arg5 arg6 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( word16ToWord32  gc_arg3) of { arg4 ->
  prim_angleArc arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_angleArc_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_angleArc_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}
foreign import  ccall "prim_angleArc" unsafe prim_angleArc :: Addr -> Int -> Int -> Word32 -> Double -> Double -> IO (Addr)
foreign import ccall "access_prim_angleArc_gc_failed" unsafe access_prim_angleArc_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_angleArc_gc_failstring" unsafe access_prim_angleArc_gc_failstring :: Addr -> IO (Addr)

chord :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
chord arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 gc_arg7 gc_arg8 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg6 ->
  case ( int32ToInt  gc_arg6) of { arg7 ->
  case ( int32ToInt  gc_arg7) of { arg8 ->
  case ( int32ToInt  gc_arg8) of { arg9 ->
  prim_chord arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
  >>= \ gc_result ->
  access_prim_chord_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_chord_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_chord" unsafe prim_chord :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_chord_gc_failed" unsafe access_prim_chord_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_chord_gc_failstring" unsafe access_prim_chord_gc_failstring :: Addr -> IO (Addr)

pie :: HDC -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> Int32 -> IO ()
pie arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 gc_arg7 gc_arg8 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg6 ->
  case ( int32ToInt  gc_arg6) of { arg7 ->
  case ( int32ToInt  gc_arg7) of { arg8 ->
  case ( int32ToInt  gc_arg8) of { arg9 ->
  prim_pie arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
  >>= \ gc_result ->
  access_prim_pie_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_pie_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_pie" unsafe prim_pie :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_pie_gc_failed" unsafe access_prim_pie_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_pie_gc_failstring" unsafe access_prim_pie_gc_failstring :: Addr -> IO (Addr)

bitBlt :: HDC -> INT -> INT -> INT -> INT -> HDC -> INT -> INT -> RasterOp3 -> IO ()
bitBlt arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 arg6 gc_arg5 gc_arg6 arg9 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg7 ->
  case ( int32ToInt  gc_arg6) of { arg8 ->
  prim_bitBlt arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
  >>= \ gc_result ->
  access_prim_bitBlt_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_bitBlt_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}
foreign import  ccall "prim_bitBlt" unsafe prim_bitBlt :: Addr -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_bitBlt_gc_failed" unsafe access_prim_bitBlt_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_bitBlt_gc_failstring" unsafe access_prim_bitBlt_gc_failstring :: Addr -> IO (Addr)

maskBlt :: HDC -> INT -> INT -> INT -> INT -> HDC -> INT -> INT -> HBITMAP -> INT -> INT -> RasterOp4 -> IO ()
maskBlt arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 arg6 gc_arg5 gc_arg6 arg9 gc_arg7 gc_arg8 arg12 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg7 ->
  case ( int32ToInt  gc_arg6) of { arg8 ->
  case ( int32ToInt  gc_arg7) of { arg10 ->
  case ( int32ToInt  gc_arg8) of { arg11 ->
  prim_maskBlt arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 arg11 arg12
  >>= \ gc_result ->
  access_prim_maskBlt_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_maskBlt_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_maskBlt" unsafe prim_maskBlt :: Addr -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Addr -> Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_maskBlt_gc_failed" unsafe access_prim_maskBlt_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_maskBlt_gc_failstring" unsafe access_prim_maskBlt_gc_failstring :: Addr -> IO (Addr)

stretchBlt :: HDC -> INT -> INT -> INT -> INT -> HDC -> INT -> INT -> INT -> INT -> RasterOp3 -> IO ()
stretchBlt arg1 gc_arg1 gc_arg2 gc_arg3 gc_arg4 arg6 gc_arg5 gc_arg6 gc_arg7 gc_arg8 arg11 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case ( int32ToInt  gc_arg4) of { arg5 ->
  case ( int32ToInt  gc_arg5) of { arg7 ->
  case ( int32ToInt  gc_arg6) of { arg8 ->
  case ( int32ToInt  gc_arg7) of { arg9 ->
  case ( int32ToInt  gc_arg8) of { arg10 ->
  prim_stretchBlt arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 arg11
  >>= \ gc_result ->
  access_prim_stretchBlt_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_stretchBlt_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}
foreign import  ccall "prim_stretchBlt" unsafe prim_stretchBlt :: Addr -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_stretchBlt_gc_failed" unsafe access_prim_stretchBlt_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_stretchBlt_gc_failstring" unsafe access_prim_stretchBlt_gc_failstring :: Addr -> IO (Addr)

-- We deviate slightly from the Win32 interface

-- %C typedef POINT ThreePts[3];

-- Old 2nd line: 
-- %start POINT vertices[3];

plgBlt :: HDC -> POINT -> POINT -> POINT -> HDC -> INT -> INT -> INT -> INT -> MbHBITMAP -> INT -> INT -> IO ()
plgBlt arg1 gc_arg1 gc_arg7 gc_arg12 arg2 gc_arg17 gc_arg18 gc_arg19 gc_arg20 bm gc_arg21 gc_arg22 =
  case gc_arg1 of { (gc_arg2,gc_arg4) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case gc_arg7 of { (gc_arg8,gc_arg10) ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  case ( int32ToInt  gc_arg10) of { gc_arg11 ->
  case gc_arg12 of { (gc_arg13,gc_arg15) ->
  case ( int32ToInt  gc_arg13) of { gc_arg14 ->
  case ( int32ToInt  gc_arg15) of { gc_arg16 ->
  case ( int32ToInt  gc_arg17) of { x ->
  case ( int32ToInt  gc_arg18) of { y ->
  case ( int32ToInt  gc_arg19) of { w ->
  case ( int32ToInt  gc_arg20) of { h ->
  (case bm of {
      Nothing -> (return (nullHANDLE));
      (Just bm) -> (return ((bm)))
   }) >>= \ (bm) ->
  case ( int32ToInt  gc_arg21) of { sx ->
  case ( int32ToInt  gc_arg22) of { sy ->
  prim_plgBlt arg1 gc_arg3 gc_arg5 gc_arg9 gc_arg11 gc_arg14 gc_arg16 arg2 x y w h bm sx sy
  >>= \ gc_result ->
  access_prim_plgBlt_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_plgBlt_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}}}}}}}}}}}}}}
foreign import  ccall "prim_plgBlt" unsafe prim_plgBlt :: Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_plgBlt_gc_failed" unsafe access_prim_plgBlt_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_plgBlt_gc_failstring" unsafe access_prim_plgBlt_gc_failstring :: Addr -> IO (Addr)

textOut :: HDC -> INT -> INT -> String -> IO ()
textOut arg1 gc_arg1 gc_arg2 gc_arg3 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  (marshall_stringLen_ gc_arg3) >>= \ (arg4,arg5) ->
  prim_textOut arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_textOut_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_textOut_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}}
foreign import  ccall "prim_textOut" unsafe prim_textOut :: Addr -> Int -> Int -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_textOut_gc_failed" unsafe access_prim_textOut_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_textOut_gc_failstring" unsafe access_prim_textOut_gc_failstring :: Addr -> IO (Addr)

-- missing TabbedTextOut from WinFonts.ss; GSL ???

getTextExtentPoint32 :: HDC -> String -> IO SIZE
getTextExtentPoint32 hdc gc_arg1 =
  (marshall_stringLen_ gc_arg1) >>= \ (str,l) ->
  prim_getTextExtentPoint32 hdc str l
  >>= \ gc_result ->
  access_prim_getTextExtentPoint32_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getTextExtentPoint32_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_getTextExtentPoint32_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getTextExtentPoint32_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       (return ((gc_res1,gc_res3)))
foreign import  ccall "prim_getTextExtentPoint32" unsafe prim_getTextExtentPoint32 :: Addr -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_getTextExtentPoint32_gc_res2" unsafe access_prim_getTextExtentPoint32_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_getTextExtentPoint32_gc_res4" unsafe access_prim_getTextExtentPoint32_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_getTextExtentPoint32_gc_failed" unsafe access_prim_getTextExtentPoint32_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getTextExtentPoint32_gc_failstring" unsafe access_prim_getTextExtentPoint32_gc_failstring :: Addr -> IO (Addr)

-- missing getTabbedTextExtent from WinFonts.ss; GSL ???
-- missing SetTextJustification from WinFonts.ss; GSL ???
-- missing a whole family of techandfamily functionality; GSL ???
-- missing DrawText and DrawTextFormat in WinFonts.ss; GSL ???

----------------------------------------------------------------
-- End
----------------------------------------------------------------
