module StdWindowDef ( module StdWindowDef
                    , module StdIOCommon
                    , module StdGUI
                    ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdWindowDef contains the types to define the standard set of dialogs.
--	********************************************************************************


import StdGUI
import StdIOCommon
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


#if MVAR
data	Dialog c
 =	Dialog Title c [WindowAttribute]
#else
data	Dialog c ls ps
 =	Dialog Title (c ls ps) [WindowAttribute ls ps]
#endif

data	WindowAttribute IF_MVAR(,ls ps)              -- Default:
 --	Attributes for Windows and Dialogs:
 =	WindowActivate   (GUIFun IF_MVAR((),ls ps))  -- id
 |	WindowClose      (GUIFun IF_MVAR((),ls ps))  -- user can't close window
 |	WindowDeactivate (GUIFun IF_MVAR((),ls ps))  -- id
 |	WindowId         Id                          -- system defined id
 |	WindowInit       (GUIFun IF_MVAR((),ls ps))  -- no actions after opening window
 |	WindowViewSize   Size                        -- screen size

data	WindowType
	= String
