module StdProcessDef ( module StdProcessDef, module StdIOCommon, module StdGUI ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdProcessDef contains the types to define interactive processes.
--	********************************************************************************


import StdGUI
import StdIOCommon
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


#if MVAR
data	Process
	= Process 
		DocumentInterface		-- The process document interface
		ProcessInit			-- The process initialisation
		[ProcessAttribute]		-- The process attributes
type	ProcessInit
	= GUI ()
#else
data	Process
	= forall ps . Process
			DocumentInterface	-- The process document interface
			ps			-- The process private state
			(ProcessInit ps)	-- The process initialisation
			[ProcessAttribute ps]	-- The process attributes
type	ProcessInit ps
	= ps -> GUI ps ps
#endif
