module StdProcess (module StdProcess) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdProcess contains the process creation and manipulation functions.
--	********************************************************************************


import CleanStdMisc
import Commondef (dumpFatalError)
import IOstate
import Processdevice
import Scheduler
import StdProcessDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


stdprocessFatalError :: String -> String -> x
stdprocessFatalError function error
	= dumpFatalError function "StdProcess" error


--	General process topology creation functions:

class Processes pdef where
	startProcesses :: pdef -> IO ()
	openProcesses  :: pdef -> GUI IF_MVAR(,ps) ()

instance Processes Process where
	startProcesses (Process xDI IF_MVAR(,ps_init) io_init atts)
		= do {
			initialContext  <- initContext atts io_init1 IF_MVAR(,ps_init) xDI;
			case initialContext of
				Just context -> handleEvents context >>= closeContext
				initFailed   -> stdprocessFatalError "startProcesses" "should not be evaluated inside GUI context"
		  }
		where
#if MVAR
			io_init1    = dOpen processFunctions >> io_init
#else
			io_init1 ps = dOpen processFunctions ps >>= io_init
#endif
	
	openProcesses (Process xDI IF_MVAR(,ps_init) io_init atts)
		= addInteractiveProcess atts io_init1 IF_MVAR(,ps_init) xDI
		where
#if MVAR
			io_init1    = dOpen processFunctions >> io_init
#else
			io_init1 ps = dOpen processFunctions ps >>= io_init
#endif


instance Processes pdef => Processes [pdef] where
	startProcesses []
		= return ()
	startProcesses pdefs
		= do {
			initialContext  <- initContext [] io_init1 IF_MVAR(,()) NDI;
			case initialContext of
				Just context -> handleEvents context >>= closeContext
				initFailed   -> stdprocessFatalError "startProcesses" "should not be evaluated inside GUI context"
		  }
		where
#if MVAR
			io_init1    = dOpen processFunctions >> openProcesses pdefs >> closeProcess
#else
			io_init1 ps = dOpen processFunctions ps >>= (\ps1 -> openProcesses pdefs >> closeProcess ps1)
#endif
	
	openProcesses pdefs
		= sequence_ (map openProcesses pdefs)


--	Specialised process creation functions:

startIO :: DocumentInterface -> IF_MVAR(,ps ->) ProcessInit IF_MVAR(,ps) -> [ProcessAttribute IF_MVAR(,ps)] -> IO ()
startIO xDI IF_MVAR(,ps) io_init atts
	= startProcesses (Process xDI IF_MVAR(,ps) io_init atts)


--	Close this interactive process.

#if MVAR
closeProcess :: GUI ()
closeProcess = quitProcess
#else
closeProcess :: ps -> GUI ps ps
closeProcess ps = quitProcess ps
#endif
