module StdId ( Ids(..)
             , getParentId
             , Id.Id
             , IOstate.GUI, IOstate.IOSt
             ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdId specifies the generation functions for identification values.
--	********************************************************************************


import Concurrent
import Id
import IOstate
import StdMaybe
import World
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


class Ids envM where
	openId   ::        envM Id
	openIds  :: Int -> envM [Id]
	
	openRId  ::        envM (RId m)
	openRIds :: Int -> envM [RId m]

instance Ids IO where
	openId    = loadWorld >>= (\i -> storeWorld (i-1) >> return (toId i))
	openIds n = loadWorld >>= (\i -> storeWorld (i-n) >> return [toId nr | nr<-[i-n+1..i]])
	
	openRId
		= do {
			i   <- loadWorld;
			cIn <- newChan;
			storeWorld (i-1);
			return (toRId i cIn)
		  }
	openRIds n
		= do {
			i    <- loadWorld;
			cIns <- sequence (replicate n newChan);
			storeWorld (i-n);
			return (map (\(nr,cIn) -> toRId nr cIn) (zip [i-n+1..i] cIns))
		  }

instance Ids (GUI IF_MVAR(,ps)) where
	openId    = ioStGetIdSeed >>= (\i -> ioStSetIdSeed (i-1) >> return (toId i))
	openIds n = ioStGetIdSeed >>= (\i -> ioStSetIdSeed (i-n) >> return [toId nr | nr<-[i-n+1..i]])
	
	openRId
		= do {
			i   <- ioStGetIdSeed;
			cIn <- liftIO newChan;
			ioStSetIdSeed (i-1);
			return (toRId i cIn)
		  }
	openRIds n
		= do {
			i    <- ioStGetIdSeed;
			cIns <- liftIO (sequence (replicate n newChan));
			ioStSetIdSeed (i-n);
			return (map (\(nr,cIn) -> toRId nr cIn) (zip [i-n+1..i] cIns))
		  }

getParentId :: Id -> GUI IF_MVAR(,ps) (Maybe Id)
getParentId id
	= ioStGetIdTable >>= (\idtable -> return (fmap idpId (getIdParent id idtable)))
