module WindowCCall_12 ( winInitialiseWindows
                      , winInvalidateWindow, winInvalidateRect
                      , winValidateRect, winValidateRgn
                      , winGetDC, winReleaseDC
                      , module Ostypes
                      ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	WindowCCall_12 contains C calls for handling windows. 
--	********************************************************************************


import Cutil_12
import Ostoolbox
import Ostypes
import RgnCCall_12
import PictCCall_12


winInitialiseWindows :: IO ()
winInitialiseWindows
	= cInstallCrossCallWindows osNewToolbox >> return ()
foreign import stdcall "cCrossCallWindows_121" "InstallCrossCallWindows" cInstallCrossCallWindows :: Int -> IO Int

winInvalidateWindow :: HWND -> IO ()
winInvalidateWindow a1
	= cWinInvalidateWindow a1 osNewToolbox >> return ()
foreign import stdcall "cCCallWindows_121" "WinInvalidateWindow" cWinInvalidateWindow :: HWND -> Int -> IO Int

winInvalidateRect :: HWND -> (Int,Int,Int,Int) -> IO ()
winInvalidateRect a1 (a2,a3,a4,a5)
	= cWinInvalidateRect a1 a2 a3 a4 a5 osNewToolbox >> return ()
foreign import stdcall "cCCallWindows_121" "WinInvalidateRect" cWinInvalidateRect :: HWND -> Int -> Int -> Int -> Int -> Int -> IO Int

winValidateRect :: HWND -> (Int,Int,Int,Int) -> IO ()
winValidateRect a1 (a2,a3,a4,a5)
	= cWinValidateRect a1 a2 a3 a4 a5 osNewToolbox >> return ()
foreign import stdcall "cCCallWindows_121" "WinValidateRect" cWinValidateRect :: HWND -> Int -> Int -> Int -> Int -> Int -> IO Int

winValidateRgn :: HWND -> HRGN -> IO ()
winValidateRgn a1 a2
	= cWinValidateRgn a1 a2 osNewToolbox >> return ()
foreign import stdcall "cCCallWindows_121" "WinValidateRgn" cWinValidateRgn :: HWND -> HRGN -> Int -> IO Int

winGetDC :: HWND -> IO HDC
winGetDC a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinGetDC a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinGetDC" cWinGetDC :: HWND -> Int -> Addr -> Addr -> IO ()

winReleaseDC :: HWND -> HDC -> IO ()
winReleaseDC a1 a2
	= cWinReleaseDC a1 a2 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinReleaseDC" cWinReleaseDC :: HWND -> HDC -> Int -> IO Int
