module ClCCall_12 ( CSTR, ACCLPTR
                  , maxRand
                  , winHelpKey, winEscapeKey, winReturnKey, winTabKey, winDelKey, winBackSpKey
                  , winEndKey, winBeginKey, winPgDownKey, winPgUpKey, winRightKey, winLeftKey, winDownKey, winUpKey
                  , winF1Key, winF2Key, winF3Key, winF4Key, winF5Key, winF6Key, 
                  , winF7Key, winF8Key, winF9Key, winF10Key, winF11Key, winF12Key
                  , ctrlBIT, altBIT, shiftBIT
                  , keyREPEAT, keyUP, keyDOWN
                  , buttonUP, buttonSTILLDOWN, buttonTRIPLEDOWN, buttonDOUBLEDOWN, buttonDOWN, buttonSTILLUP
                  , winLaunchApp, winLaunchApp2, winCallProcess
                  , winGetModulePath, winFileModifiedDate, winFileExists
                  , winBeep
                  , rand
                  , winReleaseCString, winGetCStringAndFree, winGetCString, winMakeCString
                  , winGetAppPath
                  , winSetDoubleDownDist
                  , winGetHorzResolution, winGetVertResolution
                  , winMaxFixedWindowSize, winMaxScrollWindowSize
                  , winScreenYSize, winScreenXSize
                  , winMinimumWinSize
                  , winScrollbarSize
                  , winMDIClientToOuterSizeDims, winSDIClientToOuterSizeDims
                  , winPlaySound
                  ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	ClCCall_12 collects all the C call routines related to windows.
--	********************************************************************************


import Cutil_12
import IOExts
import Ostoolbox


type	CSTR		= Int
type	ACCLPTR		= Int

maxRand :: Int
maxRand			= 32767

winHelpKey, winEscapeKey, winReturnKey, winTabKey, winDelKey, winBackSpKey, winEndKey, winBeginKey
	  , winPgDownKey, winPgUpKey, winRightKey, winLeftKey, winDownKey, winUpKey
	  , winF1Key, winF2Key, winF3Key, winF4Key, winF5Key, winF6Key, winF7Key
	  , winF8Key, winF9Key, winF10Key, winF11Key, winF12Key :: Int
winHelpKey		= 5
winEscapeKey		= 27
winReturnKey		= 13
winTabKey		= 9
winDelKey		= 127
winBackSpKey		= 8
winEndKey		= 4
winBeginKey		= 1
winPgDownKey		= 12
winPgUpKey		= 11
winRightKey		= 29
winLeftKey		= 28
winDownKey		= 31
winUpKey		= 30
winF1Key		= 1001
winF2Key		= 1002
winF3Key		= 1003
winF4Key		= 1004
winF5Key		= 1005
winF6Key		= 1006
winF7Key		= 1007
winF8Key		= 1008
winF9Key		= 1009
winF10Key		= 1010
winF11Key		= 1011
winF12Key		= 1012

ctrlBIT, altBIT, shiftBIT :: Int
ctrlBIT			= 4
altBIT			= 2
shiftBIT		= 1

keyREPEAT, keyUP, keyDOWN :: Int
keyREPEAT		= 4
keyUP			= 2
keyDOWN			= 1

buttonUP, buttonSTILLDOWN, buttonTRIPLEDOWN, buttonDOUBLEDOWN, buttonDOWN, buttonSTILLUP :: Int
buttonUP		= 50
buttonSTILLDOWN		= 40
buttonTRIPLEDOWN	= 3
buttonDOUBLEDOWN	= 2
buttonDOWN		= 1
buttonSTILLUP		= 0		{- constant for passing mouse move events. -}


winLaunchApp :: String -> Bool -> IO Bool
winLaunchApp a1 a2
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinLaunchApp s1 (btoi a2) osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		free o2;
		return (itob r1)
	  }
foreign import stdcall "cCrossCall_121" "WinLaunchApp" cWinLaunchApp :: Addr -> Int -> Int -> Addr -> Addr -> IO ()

winLaunchApp2 :: String -> String -> Bool -> IO Bool
winLaunchApp2 a1 a2 a3
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		s2 <- createCLEAN_STRING a2;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinLaunchApp2 s1 s2 (btoi a3) osNewToolbox o1 o2;
		-- Read/free:
		mapM_ freeCLEAN_STRING [s1, s2];
		r1 <- fpeek o1;
		free o2;
		return (itob r1)
	  }
foreign import stdcall "cCrossCall_121" "WinLaunchApp2" cWinLaunchApp2 :: Addr -> Addr -> Int -> Int -> Addr -> Addr -> IO ()

winCallProcess :: CSTR -> CSTR -> CSTR -> CSTR -> CSTR -> CSTR -> IO (Bool,Int)
winCallProcess a1 a2 a3 a4 a5 a6
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		-- Call C:
		cWinCallProcess a1 a2 a3 a4 a5 a6 osNewToolbox o1 o2 o3;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		free o3;
		return (itob r1,r2)
	  }
foreign import stdcall "cCrossCall_121" "WinCallProcess" cWinCallProcess :: CSTR -> CSTR -> CSTR -> CSTR -> CSTR -> CSTR -> Int -> Addr -> Addr -> Addr -> IO ()

winGetModulePath :: String
winGetModulePath
	= unsafePerformIO winGetModulePath'
	where
		winGetModulePath' :: IO String
		winGetModulePath'
			= do {
				r1 <- cWinGetModulePath;
				s1 <- readCLEAN_STRING r1;
				freeCLEAN_STRING r1;
				return s1;
			  }
foreign import stdcall "cCrossCall_121" "WinGetModulePath" cWinGetModulePath :: IO Addr

winFileModifiedDate :: String -> (Bool,Int,Int,Int,Int,Int,Int)
winFileModifiedDate a1
	= unsafePerformIO (winFileModifiedDate' a1)
	where
		winFileModifiedDate' :: String -> IO (Bool,Int,Int,Int,Int,Int,Int)
		winFileModifiedDate' a1
			= do {
				-- Marshal arguments:
				s1 <- createCLEAN_STRING a1;
				o1 <- malloc 4;
				o2 <- malloc 4;
				o3 <- malloc 4;
				o4 <- malloc 4;
				o5 <- malloc 4;
				o6 <- malloc 4;
				o7 <- malloc 4;
				-- Call C:
				cWinFileModifiedDate s1 o1 o2 o3 o4 o5 o6 o7;
				-- Read/free:
				freeCLEAN_STRING s1;
				r1 <- fpeek o1;
				r2 <- fpeek o2;
				r3 <- fpeek o3;
				r4 <- fpeek o4;
				r5 <- fpeek o5;
				r6 <- fpeek o6;
				r7 <- fpeek o7;
				return (itob r1,r2,r3,r4,r5,r6,r7)
			  }
foreign import stdcall "cCrossCall_121" "WinFileModifiedDate" cWinFileModifiedDate :: Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()

winFileExists :: String -> Bool
winFileExists a1
	= unsafePerformIO (winFileExists' a1)
	where
		winFileExists' :: String -> IO Bool
		winFileExists' a1
			= do {
				-- Marshal arguments:
				s1 <- createCLEAN_STRING a1;
				-- Call C:
				o1 <- cWinFileExists s1;
				-- Read/free:
				freeCLEAN_STRING s1;
				return (itob o1)
			  }
foreign import stdcall "cCrossCall_121" "WinFileExists" cWinFileExists :: Addr -> IO Int

winBeep :: IO ()
winBeep
	= cWinBeep osNewToolbox >> return ()
foreign import stdcall "cCCallSystem_121" "WinBeep" cWinBeep :: Int -> IO Int

rand :: Int
rand
	= unsafePerformIO cRand
foreign import stdcall "cdebug_121" "Rand" cRand :: IO Int

winReleaseCString :: CSTR -> IO ()
winReleaseCString a1
	= cWinReleaseCString a1 osNewToolbox >> return ()
foreign import stdcall "util_121" "WinReleaseCString" cWinReleaseCString :: CSTR -> Int -> IO Int

winGetCStringAndFree :: CSTR -> IO String
winGetCStringAndFree a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinGetCStringAndFree a1 osNewToolbox o1 o2;
		-- Read/free:
		clstr1 <- peek o1;		-- dereference *CLEAN_STRING
		r1 <- readCLEAN_STRING clstr1;	-- read CLEAN_STRING
		freeCLEAN_STRING o1;
		free o2;
		return r1
	  }
foreign import stdcall "util_121" "WinGetCStringAndFree" cWinGetCStringAndFree :: CSTR -> Int -> Addr -> Addr -> IO ()

winGetCString :: CSTR -> IO String
winGetCString a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinGetCString a1 osNewToolbox o1 o2;
		-- Read/free:
		clstr1 <- peek o1;		-- dereference *CLEAN_STRING
		r1 <- readCLEAN_STRING clstr1;	-- read CLEAN_STRING
		freeCLEAN_STRING o1;
		free o2;
		return r1
	  }
foreign import stdcall "util_121" "WinGetCString" cWinGetCString :: CSTR -> Int -> Addr -> Addr -> IO ()

winMakeCString :: String -> IO CSTR
winMakeCString a1
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinMakeCString s1 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s1;
		r1 <- fpeek o1;
		free o2;
		return r1
	  }
foreign import stdcall "util_121" "WinMakeCString" cWinMakeCString :: Addr -> Int -> Addr -> Addr -> IO ()

winGetAppPath :: CSTR
winGetAppPath
	= unsafePerformIO cWinGetAppPath
foreign import stdcall "cCrossCall_121" "WinGetAppPath" cWinGetAppPath :: IO CSTR


winSetDoubleDownDist :: Int -> IO ()
winSetDoubleDownDist a1
	= cWinSetDoubleDownDist a1 osNewToolbox >> return ()
foreign import stdcall "cCrossCallxDI_121" "WinSetDoubleDownDist" cWinSetDoubleDownDist :: Int -> Int -> IO Int

winGetHorzResolution :: Int
winGetHorzResolution
	= unsafePerformIO cWinGetHorzResolution
foreign import stdcall "cpicture_121" "WinGetHorzResolution" cWinGetHorzResolution :: IO Int

winGetVertResolution :: Int
winGetVertResolution
	= unsafePerformIO cWinGetVertResolution
foreign import stdcall "cpicture_121" "WinGetVertResolution" cWinGetVertResolution :: IO Int

winMaxFixedWindowSize :: (Int,Int)
winMaxFixedWindowSize
	= unsafePerformIO winMaxFixedWindowSize'
	where
		winMaxFixedWindowSize' :: IO (Int,Int)
		winMaxFixedWindowSize'
			= do {
				-- Marshal arguments:
				o1 <- malloc 4;
				o2 <- malloc 4;
				-- Call C:
				cWinMaxFixedWindowSize o1 o2;
				-- Read/free:
				r1 <- fpeek o1;
				r2 <- fpeek o2;
				return (r1,r2)
			  }
foreign import stdcall "cCCallWindows_121" "WinMaxFixedWindowSize" cWinMaxFixedWindowSize :: Addr -> Addr -> IO ()

winMaxScrollWindowSize :: (Int,Int)
winMaxScrollWindowSize
	= unsafePerformIO winMaxScrollWindowSize'
	where
		winMaxScrollWindowSize' :: IO (Int,Int)
		winMaxScrollWindowSize'
			= do {
				-- Marshal arguments:
				o1 <- malloc 4;
				o2 <- malloc 4;
				-- Call C:
				cWinMaxScrollWindowSize o1 o2;
				-- Read/free:
				r1 <- fpeek o1;
				r2 <- fpeek o2;
				return (r1,r2)
			  }
foreign import stdcall "cCCallWindows_121" "WinMaxScrollWindowSize" cWinMaxScrollWindowSize :: Addr -> Addr -> IO ()

winScreenYSize :: IO Int
winScreenYSize
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinScreenYSize osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		free o2;
		return r1
	  }
foreign import stdcall "cCCallWindows_121" "WinScreenYSize" cWinScreenYSize :: Int -> Addr -> Addr -> IO ()

winScreenXSize :: IO Int
winScreenXSize
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinScreenXSize osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		free o2;
		return r1
	  }
foreign import stdcall "cCCallWindows_121" "WinScreenXSize" cWinScreenXSize :: Int -> Addr -> Addr -> IO ()

winMinimumWinSize :: (Int,Int)
winMinimumWinSize
	= unsafePerformIO winMinimumWinSize'
	where
		winMinimumWinSize' :: IO (Int,Int)
		winMinimumWinSize'
			= do {
				-- Marshal arguments:
				o1 <- malloc 4;
				o2 <- malloc 4;
				-- Call C:
				cWinMinimumWinSize o1 o2;
				-- Read/free:
				r1 <- fpeek o1;
				r2 <- fpeek o2;
				return (r1, r2)
			  }
foreign import stdcall "cCCallWindows_121" "WinMinimumWinSize" cWinMinimumWinSize :: Addr -> Addr -> IO ()

winScrollbarSize :: IO (Int,Int)
winScrollbarSize
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		-- Call C:
		cWinScrollbarSize osNewToolbox o1 o2 o3;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		free o3;
		return (r1, r2)
	  }
foreign import stdcall "cCCallWindows_121" "WinScrollbarSize" cWinScrollbarSize :: Int -> Addr -> Addr -> Addr -> IO ()

{-	The routines (win(M/S)DIClientToOuterSizeDims convert between the
		client and outer size of (M/S)DI windows. The Int argument contains the style flags 
		of the window.
-}
winMDIClientToOuterSizeDims :: Int -> IO (Int,Int)
winMDIClientToOuterSizeDims a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		-- Call C:
		cWinMDIClientToOuterSizeDims a1 osNewToolbox o1 o2 o3;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		free o3;
		return (r1, r2)
	  }
foreign import stdcall "cCCallWindows_121" "WinMDIClientToOuterSizeDims" cWinMDIClientToOuterSizeDims :: Int -> Int -> Addr -> Addr -> Addr -> IO ()

winSDIClientToOuterSizeDims :: Int -> IO (Int,Int)
winSDIClientToOuterSizeDims a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		-- Call C:
		cWinSDIClientToOuterSizeDims a1 osNewToolbox o1 o2 o3;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		free o3;
		return (r1, r2)
	  }
foreign import stdcall "cCCallWindows_121" "WinSDIClientToOuterSizeDims" cWinSDIClientToOuterSizeDims :: Int -> Int -> Addr -> Addr -> Addr -> IO ()

winPlaySound :: String -> IO Bool
winPlaySound a1
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinPlaySound s1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		free o2;
		return (itob r1)
	  }
foreign import stdcall "cCCallSystem_121" "WinPlaySound" cWinPlaySound :: Addr -> Int -> Addr -> Addr -> IO ()
