-----------------------------------------------------------------------------
--  $Id: IArray.hs,v 1.7 2001/04/14 22:27:00 qrczak Exp $
--
-- (c) The GHC Team 2000
--

module IArray ( 
    module Ix,

    -- Class of immutable array types
    IArray,     -- :: (* -> * -> *) -> * -> class
    -- Class of array types with immutable bounds
    HasBounds,  -- :: (* -> * -> *) -> class

    -- Non-strict polymorphic arrays
    Array,      -- :: * -> * -> *
    -- Strict unboxed arrays
    UArray,     -- :: * -> * -> *

    array,      -- :: (IArray a e, Ix i) => (i,i) -> [(i, e)] -> a i e
    listArray,  -- :: (IArray a e, Ix i) => (i,i) -> [e] -> a i e
    (!),        -- :: (IArray a e, Ix i) => a i e -> i -> e
    bounds,     -- :: (HasBounds a, Ix i) => a i e -> (i,i)
    indices,    -- :: (HasBounds a, Ix i) => a i e -> [i]
    elems,      -- :: (IArray a e, Ix i) => a i e -> [e]
    assocs,     -- :: (IArray a e, Ix i) => a i e -> [(i, e)]
    accumArray, -- :: (IArray a e, Ix i) => (e -> e' -> e) -> e -> (i,i) -> [(i, e')] -> a i e
    (//),       -- :: (IArray a e, Ix i) => a i e -> [(i, e)] -> a i e
    accum,      -- :: (IArray a e, Ix i) => (e -> e' -> e) -> a i e -> [(i, e')] -> a i e
    amap,       -- :: (IArray a e', IArray a e, Ix i) => (e' -> e) -> a i e' -> a i e
    ixmap)      -- :: (IArray a e, Ix i, Ix j) => (i,i) -> (i -> j) -> a j e -> a i e
    where

import Ix
import ArrayBase
import Array     (Array)
