{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to table 6.11 (Rasterization) of the OpenGL 1.2.1 specs.
-}

module GL_QueryRaster (
   VarRasterSizes(..),
   VarLineStipplePattern(..),
   VarLineStippleRepeat(..),
   VarCullFaceMode(..),
   VarFrontFace(..),
   VarPolygonMode(..),
   VarPolygonOffset(..),
   VarPolygonStipple(..)
) where

import Monad            ( liftM )

import GL_Constants     ( gl_POINT_SIZE, gl_LINE_WIDTH, gl_LINE_STIPPLE_PATTERN,
                          gl_LINE_STIPPLE_REPEAT, gl_CULL_FACE_MODE,
                          gl_FRONT_FACE, gl_POLYGON_MODE,
                          gl_POLYGON_OFFSET_FACTOR, gl_POLYGON_OFFSET_UNITS )
import GL_BasicTypes    ( GLushort, GLfloat, GLint, Gettable(..) )
import GL_Polygons      ( StipplePattern, PolygonMode )
import GL_Colors        ( Face, FrontOrientation, unmarshalFrontOrientation)
import GL_QueryUtils    ( getGLushort, getGLfloat, getGLint, getGLenum,
                          getPolygonModes, getPolygonStipple, getFace )

---------------------------------------------------------------------------

data VarRasterSizes =
     VarPointSize
   | VarLineWidth
   deriving (Eq,Ord)

instance Gettable VarRasterSizes GLfloat where
   get VarPointSize = getGLfloat gl_POINT_SIZE
   get VarLineWidth = getGLfloat gl_LINE_WIDTH

data VarLineStipplePattern = VarLineStipplePattern deriving (Eq,Ord)

instance Gettable VarLineStipplePattern GLushort where
   get VarLineStipplePattern = getGLushort gl_LINE_STIPPLE_PATTERN

data VarLineStippleRepeat = VarLineStippleRepeat deriving (Eq,Ord)

instance Gettable VarLineStippleRepeat GLint where
   get VarLineStippleRepeat = getGLint gl_LINE_STIPPLE_REPEAT

data VarCullFaceMode = VarCullFaceMode deriving (Eq,Ord)

instance Gettable VarCullFaceMode Face where
   get VarCullFaceMode = getFace gl_CULL_FACE_MODE

data VarFrontFace = VarFrontFace deriving (Eq,Ord)

instance Gettable VarFrontFace FrontOrientation where
   get VarFrontFace = liftM unmarshalFrontOrientation $ getGLenum gl_FRONT_FACE

data VarPolygonMode = VarPolygonMode deriving (Eq,Ord)

instance Gettable VarPolygonMode (PolygonMode, PolygonMode) where
   get VarPolygonMode = getPolygonModes gl_POLYGON_MODE

data VarPolygonOffset =
     VarPolygonOffsetFactor
   | VarPolygonOffsetUnits
   deriving (Eq,Ord)

instance Gettable VarPolygonOffset GLfloat where
   get VarPolygonOffsetFactor = getGLfloat gl_POLYGON_OFFSET_FACTOR
   get VarPolygonOffsetUnits  = getGLfloat gl_POLYGON_OFFSET_UNITS

data VarPolygonStipple = VarPolygonStipple deriving (Eq,Ord)

instance Gettable VarPolygonStipple StipplePattern where
   get VarPolygonStipple = getPolygonStipple
