/************************************************
 *
 * $GAMGI/src/global/gamgi_global_remove.c
 *
 * Copyright (C) 2009 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_global.h"

#include "gamgi_engine_list.h"
#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_object.h"
#include "gamgi_gtk_history.h"

void gamgi_global_selection_focus (void)
{
gamgi_window *window;

/************************************************************
 * for all windows: set current layer as new current object *
 ************************************************************/

for (window = gamgi->window_start; window != NULL; window = window->next)
  gamgi_gtk_object_focus_local (GAMGI_CAST_OBJECT window->layer, window);
}

void gamgi_global_selection_undo (void)
{
gamgi_window *window;
gamgi_layer *layer;
gamgi_dlist *dlist;

/***************************************************
 * for all windows: save all layers as undo layers *
 ***************************************************/

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
    {
    layer = GAMGI_CAST_LAYER dlist->data;
    gamgi_gtk_history_update (layer, layer->undo, GAMGI_ENGINE_UNDO);
    }
  }
}

void gamgi_global_selection_draw (void)
{
gamgi_window *window;

/*****************************************
 * for all windows: redraw gl_area image *
 *****************************************/

for (window = gamgi->window_start; window != NULL; window = window->next)
  gtk_widget_queue_draw (window->area);
}

void gamgi_global_selection_show (char *name)
{
gamgi_window *window;
GtkWidget *button;
GtkWidget *label;
GdkColor color;

gamgi_gtk_dialog_color (&color,
GAMGI_GTK_MOVE_R, GAMGI_GTK_MOVE_G, GAMGI_GTK_MOVE_B);

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (window->window), name);
  label = gtk_bin_get_child (GTK_BIN (button));
  gamgi_gtk_dialog_color_fg (label, color);
  }
}

void gamgi_global_selection_hide (char *name)
{
gamgi_window *window;
GtkWidget *button;
GtkWidget *label;

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (window->window), name);
  label = gtk_bin_get_child (GTK_BIN (button));
  gamgi_gtk_dialog_color_default (label, window);
  }
}

void gamgi_global_selection_link (gamgi_dlist *start)
{
gamgi_dlist *dlist;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  (GAMGI_CAST_OBJECT dlist->data)->selection = dlist;
}

void gamgi_global_selection_unlink (gamgi_dlist *start)
{
gamgi_dlist *dlist;

/********************************************************************
 * when the list is removed in the end, the objects no longer exist *
 ********************************************************************/

for (dlist = start; dlist != NULL; dlist = dlist->next)
  if (dlist->data != NULL)
    (GAMGI_CAST_OBJECT dlist->data)->selection = NULL;
}

void gamgi_global_selection_remove (gamgi_dlist **start, char *label)
{
if (*start == NULL) return;

gamgi_global_selection_unlink (*start);
gamgi_engine_dlist_remove_all (*start);
gamgi_global_selection_hide (label);

*start = NULL;
}

void gamgi_global_selection_remove_all (void)
{
gamgi_global_selection_remove (&gamgi->texts, "button_text");
gamgi_global_selection_remove (&gamgi->orbitals, "button_orbital");
gamgi_global_selection_remove (&gamgi->bonds, "button_bond");
gamgi_global_selection_remove (&gamgi->atoms, "button_atom");
gamgi_global_selection_remove (&gamgi->directions, "button_direction");
gamgi_global_selection_remove (&gamgi->planes, "button_plane");
gamgi_global_selection_remove (&gamgi->groups, "button_group");
gamgi_global_selection_remove (&gamgi->molecules, "button_molecule");
gamgi_global_selection_remove (&gamgi->clusters, "button_cluster");
gamgi_global_selection_remove (&gamgi->cells, "button_cell");
gamgi_global_selection_remove (&gamgi->arrows, "button_arrow");
gamgi_global_selection_remove (&gamgi->shapes, "button_shape");
gamgi_global_selection_remove (&gamgi->graphs, "button_graph");
gamgi_global_selection_remove (&gamgi->assemblys, "button_assembly");
gamgi_global_selection_remove (&gamgi->lights, "button_light");
gamgi_global_selection_remove (&gamgi->layers, "button_layer");
gamgi_global_selection_remove (&gamgi->windows, "button_window");
}

void gamgi_global_selection_clean (gamgi_dlist **start,
gamgi_dlist *selection, char *label)
{
/****************************************************************
 * before removing this object, check if it is in the selection *
 * list, in which case the selection list should be removed.    *
 ****************************************************************/

if (selection != NULL)
  {
  /***********************************************************************
   * set selection->data to NULL, to signal that this object has been    *
   * removed: this is needed because: 1) recursive objects might be      *
   * removed recursively and show up later in the list; 2) when removing *
   * a list of objects, is better to remove the list only in the end.    *
   ***********************************************************************/

  selection->data = NULL;

  /*******************************************************
   * When start is not NULL, the selection list still    *
   * exists, is available, should be removed immediately *
   *******************************************************/

  if (*start != NULL)
    gamgi_global_selection_remove (start, label);
  }
}
