/*******************************************
 *
 * $GAMGI/src/engine/gamgi_engine_select.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"

#include "gamgi_engine_list.h"
#include "gamgi_engine_unlink.h"
#include "gamgi_engine_remove.h"
#include "gamgi_math_measure.h"

gamgi_dlist *gamgi_engine_select_bond_length (gamgi_dlist *bonds, 
double min, double max)
{
gamgi_atom *atom1, *atom2;
gamgi_bond* bond;
gamgi_dlist *dlist;
double length;

for (dlist = bonds; dlist != NULL; dlist = dlist->next)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  atom1 = bond->atom1;
  atom2 = bond->atom2;
  gamgi_math_measure_length_2atom (atom1, atom2, &length);

  if (length < min || length > max)
    {
    if (dlist->before == NULL) bonds = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    gamgi_engine_unlink_bond (bond);
    gamgi_engine_remove_bond (bond);
    }
  }

return bonds;
}

gamgi_dlist *gamgi_engine_select_bond_element (gamgi_dlist *bonds, 
int z1, int z2)
{
gamgi_bond* bond;
gamgi_dlist *dlist;
int element1, element2;

for (dlist = bonds; dlist != NULL; dlist = dlist->next)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  element1 = bond->atom1->element;
  element2 = bond->atom2->element;

  if ((z1 != element1 && z1 != element2) || (z2 != element1 && z2 != element2))
    {
    if (dlist->before == NULL) bonds = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    gamgi_engine_unlink_bond (bond);
    gamgi_engine_remove_bond (bond);
    }
  }

return bonds;
}

gamgi_dlist *gamgi_engine_select_atom_element (gamgi_dlist *atoms, 
int z1, int z2)
{
gamgi_atom *atom;
gamgi_dlist *dlist;
int element;

for (dlist = atoms; dlist != NULL; dlist = dlist->next)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  element = atom->element;

  if (element != z1 && element != z2)
    {
    if (dlist->before == NULL) atoms = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    }
  }

return atoms;
}
