/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class Panorama
extends Canvas
implements Runnable {
    private Thread animation;
    private Image tile;
    private Image buffer;
    private Vector imageList;
    private Scroller scroller;
    private int imagePosX;
    private int panoramaWidth;
    private int panoramaHeight;
    private int panoramaPosX;
    private int panoramaPosY;
    private int animationOffset;
    private int delay;
    private int mousePosX;
    private int mousePosY;
    private int savePosX;
    private int savePosY;

    public Panorama(int n, int n2, int n3, int n4) {
        this.panoramaWidth = n;
        this.panoramaHeight = n2;
        this.panoramaPosX = 0;
        this.panoramaPosY = n3 == this.panoramaHeight ? 0 : (n3 - this.panoramaHeight) / 2;
        this.animationOffset = 0;
        this.delay = n4;
        this.imageList = new Vector();
        this.imagePosX = 0;
        if (n4 > 0) {
            this.animation = new Thread(this);
            this.animation.start();
        }
    }

    public void setAnimationOffset(int n) {
        this.animationOffset = n;
    }

    public void setTile(Image image) {
        this.tile = image;
        if (image != null) {
            this.repaint();
        }
    }

    public void setScroller(Scroller scroller) {
        this.scroller = scroller;
    }

    public void addPanoramaImage(Image image) {
        this.addPicture(image, null, 0, this.imagePosX, 0, 1, 1);
        this.imagePosX += image.getWidth(this);
    }

    public Picture addPicture(Image image, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = image.getWidth(this);
        int n7 = image.getWidth(this);
        if (n2 + n6 > this.panoramaWidth) {
            n2 -= this.panoramaWidth;
        }
        Picture picture = new Picture(image, string, n, n2, n3, n6, n7, n4, n5);
        this.imageList.addElement(picture);
        int n8 = n2 - this.panoramaPosX;
        if (n8 < this.size().width - this.panoramaWidth) {
            n8 = this.panoramaWidth - this.panoramaPosX + n2;
        }
        if (n8 + n6 > 0 && n8 < this.size().width) {
            this.repaint();
        }
        return picture;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.size().width;
        int n4 = this.size().height;
        if (this.buffer == null) {
            this.buffer = this.createImage(n3, n4);
        }
        Graphics graphics2 = this.buffer.getGraphics();
        if (this.tile != null) {
            n2 = this.tile.getWidth(this);
            int n5 = this.tile.getHeight(this);
            int n6 = -(this.panoramaPosX % n2);
            while (n6 < n3) {
                n = Math.min(0, this.panoramaPosY);
                while (n < n4) {
                    graphics2.drawImage(this.tile, n6, n, this);
                    n += n5;
                }
                n6 += n2;
            }
        } else {
            graphics2.setColor(this.getParent().getBackground());
            graphics2.fillRect(0, 0, n3, n4);
        }
        n2 = 0;
        while (n2 < this.imageList.size()) {
            Picture picture = (Picture)this.imageList.elementAt(n2);
            Rectangle rectangle = picture.getRect();
            n = rectangle.x - this.panoramaPosX;
            if (n < n3 - this.panoramaWidth) {
                n = this.panoramaWidth - this.panoramaPosX + rectangle.x;
            }
            if (n + rectangle.width > 0 && n < n3) {
                graphics2.drawImage(picture.getImage(), n, this.panoramaPosY + rectangle.y, this);
            }
            ++n2;
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.panoramaPosX = (this.savePosX + this.panoramaWidth - n + this.mousePosX) % this.panoramaWidth;
        if (this.panoramaHeight > this.size().height) {
            this.panoramaPosY = Math.min(0, Math.max(this.size().height - this.panoramaHeight, this.savePosY + n2 - this.mousePosY));
        }
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.animationOffset = 0;
        this.mousePosX = n;
        this.mousePosY = n2;
        this.savePosX = this.panoramaPosX;
        this.savePosY = this.panoramaPosY;
        if (this.scroller != null) {
            this.scroller.reset();
        }
        return true;
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    boolean bl = false;
                    int n = 0;
                    while (n < this.imageList.size()) {
                        Picture picture = (Picture)this.imageList.elementAt(n);
                        bl |= picture.animate();
                        ++n;
                    }
                    this.panoramaPosX = (this.panoramaPosX + this.animationOffset + this.panoramaWidth) % this.panoramaWidth;
                    if (this.animationOffset != 0 || bl) {
                        this.repaint();
                    }
                    Thread.sleep(this.delay);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

