/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: main.cpp,v 1.71 2004/09/22 04:41:53 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"

#include <getopt.h>

#include <qapplication.h>
#include <qtextcodec.h>
#include <qtooltip.h>

/*
#ifdef _WIN32
#  include <windows.h>
#endif
*/

#include "FWBSettings.h"
#include "RCS.h"
#include "FWWindow.h"
#include "ObjectManipulator.h"
#include "ObjectEditor.h"
#include "FWObjectClipboard.h"
#include "FWBTree.h"
#include "StartWizard.h"
#include "findDialog.h"
#include "listOfLibraries.h"

#include "fwbuilder/FWObject.h"
#include "fwbuilder/Tools.h"
#include "fwbuilder/dns.h"
//#include "fwbuilder/crypto.h"
#include "fwbuilder/XMLTools.h"
#include "fwbuilder/Resources.h"
#include "fwbuilder/FWException.h"

#ifndef _WIN32
#  include <sys/wait.h>
#  include <unistd.h>
#  include <termios.h>
#  include <time.h>
#  include <sys/select.h>
#  include <utmp.h>
#else
#  include <direct.h>
#endif

#ifdef HAVE_PTY_H
#include <pty.h>
#endif

#ifdef HAVE_LIBUTIL_H
#include <libutil.h>
#endif

#ifdef HAVE_UTIL_H
#include <util.h>
#endif

//#ifdef Q_OS_MACX
//#  include <util.h>
//#endif

#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "../common/init.cpp"

#ifdef ELC
extern bool init2(const std::string &a1,
                  const std::string &moduleName,
                  const std::string &rp,
                  const std::string &rp1,
                  bool f1, bool f2);
#endif

using namespace libfwbuilder;
using namespace std;

static QString    filename;
static QString    objid;

QApplication      *app;
FWWindow          *mw;
ObjectManipulator *om;
ObjectEditor      *oe;
QTextEdit         *oi;
FWBSettings       *st;
findDialog        *fd;
int                fwbdebug;
int                safemode;
bool               registered=false;
    
listOfLibraries  *addOnLibs;




void usage()
{
    cerr << "Usage: fwbuilder [-?hv] [filename]\n";
}



int main( int argc, char ** argv )
{
    bool        ssh_wrapper=false;
    bool        scp_wrapper=false;
    const char *arg[64];
    int         i, j;

    filename="";
    objid="";
    fwbdebug=0;
    safemode=0;

    bool desktopaware = true;

#if defined(Q_OS_MACX)
    desktopaware = false;
#endif

/*
 * I am using njamd a lot, but gtkmm and probably some other libs
 * generate trap in their global static initialization code. Therefore
 * I need to start the program with env. var. NJAMD_PROT set to "none"
 * and then reset it to something useful here.
 */
#ifdef HAVE_SETENV
    setenv("NJAMD_PROT","strict",1);
#else
#  ifdef HAVE_PUTENV
    putenv("NJAMD_PROT=strict");
#  endif
#endif


#ifndef _WIN32

    i=1;
    j=1;

    for ( ; argv[i]!=NULL; i++)
    {
        if (strncmp(argv[i], "-X", 2)==0) { ssh_wrapper=true; continue; }
        else
            if (strncmp(argv[i], "-Y", 2)==0) { scp_wrapper=true; continue; }
            else
                arg[j]=strdup(argv[i]);
        j++;
    }
    arg[j]=NULL;

    if (ssh_wrapper || scp_wrapper)
    {

/* need to create and initialize settings to be able to use ssh/scp
 * configuration in the wrapper
 *
 * Note:
 *
 * We need to keep installation data and program settings in registry
 * folders with different names. QSettings always looks into Current
 * User registry first, so if the folders have the same names, then we
 * store evaluation key in Current User, while it is better to put it
 * in the Local Machine branch.
 *
 * So, installation data goes to HKLM Software\NetCitadel\FirewallBuilder
 * and settings to HKCU Software\NetCitadel\FirewallBuilder2
 * 
 * fwbuilder-lm determines folder path for the license file by
 * reading key Install_Dir under HKLM Software\NetCitadel\FirewallBuilder
 */
        st = new FWBSettings();

/* initialize preferences */
        st->init();

        QString sshcmd=st->getSSHPath();
        QString scpcmd=st->getSCPPath();

        if (sshcmd.isEmpty()) sshcmd="ssh";
        if (scpcmd.isEmpty()) scpcmd="scp";
        
        if (ssh_wrapper)  arg[0]=strdup( sshcmd.latin1() );
        else              arg[0]=strdup( scpcmd.latin1() );

//        qDebug("cmd: %s",arg[0]);


/* forks ssh with a pty and proxies its communication on stdin/stdout
 * to avoid having to deal with pty. This is only needed on Unix.
 */
        pid_t pid;
        int   mfd;
        char  slave_name[64];
//        char  *pgm;

        pid=forkpty(&mfd,slave_name,NULL,NULL);
        if (pid<0)
        {
            cerr << "Fork failed" << strerror(errno) << endl;
            exit(1);
        }
        if (pid==0)
        { // child

// turn echo off on stdin
//            echo_off(STDIN_FILENO);

            struct stat statbuf;
            if (fstat(STDIN_FILENO,&statbuf)!=0) return 0;

            struct termios stermios;
            if (tcgetattr(STDIN_FILENO, &stermios)<0)
            {
                cerr << "tcgetattr error";
                exit(1);
            }
            stermios.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL);
            stermios.c_oflag &= ~(ONLCR);

            if (tcsetattr(STDIN_FILENO, TCSANOW, &stermios)<0)
            {
                cerr << "tcsetattr error";
                exit(1);
            }

            execvp(arg[0],(char* const*)arg);

// if we've got here there was an error
            cerr << "Exec error: " << strerror(errno) << " " << arg[0] << endl;
            exit(1);
        }

        FILE  *ssh=fdopen(mfd,"w+");
        setvbuf(ssh,NULL,_IONBF,0);

        fd_set  rfds;
        struct timeval tv;
        int     retval;
        char    buf[8192];
        bool    watchstdin = true;

        while (true)
        {
            tv.tv_sec  = 5;
            tv.tv_usec = 0;

            FD_ZERO(&rfds);
            FD_SET(mfd,            &rfds);
            if (watchstdin)  FD_SET(STDIN_FILENO  , &rfds);

            retval = select( max(STDIN_FILENO,mfd)+1 , &rfds, NULL, NULL, &tv);
            if (retval)
            {
                if (FD_ISSET(STDIN_FILENO, &rfds))
                {
                    int n=read(0,buf,sizeof(buf));
                    if (n==0)
                    {
// eof on stdin
                        watchstdin=false;
                        int r=fflush(ssh);
                        if (r) cerr << "fflush error: " << strerror(errno) << endl;
/*
 * ugly hack, but closing mfd kills ssh before the process on the
 * other side writes all data to the file
 */
                        sleep(2);
                        close(mfd);
                    } else
                        write(mfd,buf,n);
                }
                if (FD_ISSET(mfd, &rfds))
                {
                    int n;
                    buf[0]='\0';
                    n=read(mfd,buf,sizeof(buf));
                    if (n<=0)
                    {
/* eof on mfd - this means ssh process has died */
                        break;
                    } else
                    {
                        buf[n]='\0';
//                  cerr << "read " << n << " bytes" << endl;
                        write(1,buf,n);
                    }
                }
            }
        }
        int status;
        waitpid(pid, &status, 0);
        exit(status);
    }
#endif



    int c;
    while ((c = getopt (argc , argv , "hvf:o:p:dxs")) != EOF )
	switch (c) {
	case 'h':
	    usage();
	    exit(0);

	case 'f':
	    filename=optarg;
	    break;

	case 'o':
	    objid=optarg;
	    break;

        case 'd':
            fwbdebug++;
            break;

	case 'v':
	    cout << VERSION << endl;
	    exit(0);

        case 'x':
            desktopaware=!desktopaware;
            break;

        case 's':
            safemode++;
            break;
	}

    if ( (argc-1)==optind)
        filename = strdup( argv[optind++] );


    try
    {

        if (fwbdebug) qDebug("initializing ...");
    
/* need to initialize in order to be able to use FWBSettings */
        init(argv);

        if (fwbdebug) qDebug("creating app ...");
    
        QApplication::setDesktopSettingsAware(desktopaware);
        app = new QApplication( argc, argv );

        if (fwbdebug) qDebug("reading settings ...");
    
        st = new FWBSettings();

/* initialize preferences */
        st->init();

        if (fwbdebug) qDebug("done");
    
#ifdef ELC
        registered=init2(argv0, "Firewall Builder","fwb_gui","FirewallBuilder",true,true);
#endif

        if (fwbdebug) qDebug("reading resources ...");
        new Resources(respath+FS_SEPARATOR+"resources.xml");
        if (fwbdebug) qDebug("done");

#if 0
        QApplication::setDesktopSettingsAware(desktopaware);
        app = new QApplication( argc, argv );
#endif

        vector<std::string> platforms=Resources::getListOfPlatforms();
        if (platforms.empty() || ( platforms.size()==1 && platforms.front()=="unknown" ))
        {
            qDebug("Failed to load list of supported platforms");
            exit(1);
        }

        if (fwbdebug) qDebug("creating widgets ...");

        new FWBTree();
        new FWObjectDatabase();
        new FWObjectClipboard();

//    cerr << "*** Current locale: " << QTextCodec::locale() << endl;

//    app = new QApplication( argc, argv );

        if (fwbdebug) qDebug("loading translation for the current locale ...");

        QTranslator *translator = new QTranslator (NULL);
        translator->load(QString("fwbuilder_")+QTextCodec::locale(), localepath.c_str() );

        app->installTranslator (translator);

#if 0
        st = new FWBSettings();

/* initialize preferences */
        st->init();
#endif

/* must build list of available libraries _after_ creation of
 * FWObjectDatabase and settings */

        if (fwbdebug) qDebug("loading libraries ...");

        addOnLibs = new listOfLibraries();

        mw  = new FWWindow();
        oe  = new ObjectEditor(mw);
        oe->open(FWObjectDatabase::db);
        oe->hide();
        fd  = new findDialog(mw);
        fd->hide();

        if (fwbdebug) qDebug("loading data file ...");

        if (safemode)  mw->load(NULL);
        else
        {
            if (filename!="")
            {
                RCS *rcs=new RCS(filename);
                rcs->co();
                mw->load(NULL,rcs);
            } else
            {
                int sa = st->getStartupAction();
                switch (sa) 
                {
                case 1:
                {
                    filename=st->getLastEdited();
                    if (filename!="")
                    {
                        RCS *rcs=new RCS(filename);
                        rcs->co();
                        mw->load(NULL,rcs);

                    } else
                        mw->load(NULL);
                    break;
                }
                default:
                {
/* no file specified on command line and autoload option is off */
                    StartWizard sw;
                    if ( sw.exec() != QDialog::Accepted )
                        mw->load(NULL); // load standard objects
                }
                }
            }
        }

        mw->showFirewalls();

        if ( st->getStartupAction()==1 && safemode==0 )
        {
            QString id = st->getStr("UI/visibleFirewall");
            FWObject *o=NULL;
            if ( !id.isEmpty() ) o=mw->db()->getById(id.latin1(),true);
            if (o)
            {
                if (fwbdebug)
                    qDebug("open firewall %s",o->getName().c_str());
                mw->showFirewall(o);
            }

            id = st->getStr("UI/visibleObject");
            o=NULL;
            if ( !id.isEmpty() ) o=mw->db()->getById(id.latin1(),true);
            if (o)
            {
                if (fwbdebug)
                    qDebug("open object %s",o->getName().c_str());
                om->openObject(o);
            }
        }

        QToolTip::setWakeUpDelay( st->getTooltipDelay()*1000 );

        mw->show();

        app->connect( app, SIGNAL( lastWindowClosed() ), app, SLOT( quit() ) );
        app->exec();

        oe->hide();
        fd->hide();
        mw->hide();  // must do this before settings object is destroyed

        addOnLibs->save();  // ditto

        if ( st->getStartupAction()==1 )
        {
/* save the state of the GUI (opened firewall, opened object tree page, etc */
            FWObject *o=mw->getVisibleFirewall();
            if (o) st->setStr("UI/visibleFirewall", o->getId().c_str() );

            o=om->getOpened();
            if (o) st->setStr("UI/visibleObject",   o->getId().c_str() );
        }


        st->save();
        delete st;
    }
    catch (FWException &ex)
    {
        qDebug("Exception: %s",ex.toString().c_str());
    }
}
