<!--
   Filename:     0.9.1/FWBuilderPreferences.xslt
   Author:       Vadim Kurland
   Build date:   05/29/2001
   Last changed: 06/02/2001
   Version:      1.0.0
   Description:  translates fwbuilder user preferences from v0.9.1 to v0.9.2
                 This transformation removes obsolete elements 
		 SNMPget and SNMPwalk   and adds element "Network" with
		 timeout and retry parameters for SNMP and DNS queries.
-->

<xsl:stylesheet version="1.0"
       xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>


<xsl:output method="xml" version="1.0" 
   doctype-system="fwbuilder_preferences.dtd" indent="yes" encoding="utf-8"/>
<xsl:strip-space elements="*"/>


<xsl:template match="SNMPget">
</xsl:template>

<xsl:template match="SNMPwalk">
</xsl:template>

<xsl:template match="Wdir">
<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="Paths">
<Paths>
<xsl:apply-templates/>
</Paths>
</xsl:template>

<xsl:template match="*">
<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="FWBuilderPreferences">
  <FWBuilderPreferences version="0.9.2">
  <Network>
    <SNMPTimeout>10</SNMPTimeout>
    <SNMPRetries>1</SNMPRetries>
    <DNSTimeout>10</DNSTimeout>
    <DNSRetries>1</DNSRetries>
  </Network>
  <xsl:apply-templates/>
  </FWBuilderPreferences>
</xsl:template>

</xsl:stylesheet>


