/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BackgroundRunWidget.cc,v 1.8 2001/12/23 07:15:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include <fcntl.h>
#include <unistd.h>
#include <gtk--/main.h>

#include <fstream>

#include "BackgroundRunWidget.hh"
#include "ExecBgr.hh"

using namespace libfwbuilder;


BackgroundRunWidget::BackgroundRunWidget(bool modal) : 
    BackgroundOpWidget(new ExecBgr() , modal)
{
}

BackgroundRunWidget::~BackgroundRunWidget()
{
    delete bio;
}

/*
 *  Class BackgroundRunWidget inherits all the methods of
 *  BackgroundOpWidget with only one exception - its background
 *  operation class ExecBgr requires additional parameters for
 *  start_operation. So we had to copy method execute almost
 *  completely from BackgroundOpWidget but add parameters and change
 *  the way we call start_operation. That's all the difference there
 *  is.  (vk)
 */
void BackgroundRunWidget::execute(string cmd, string args) throw(FWException)
{
    assert(bio!=NULL);
    
    show();
    
    try 
    {
	showBusy(true);

        int pipe_fd[2];
        pipe(pipe_fd);
        fcntl(pipe_fd[0], F_SETFL, O_NONBLOCK);
        
        Gtk::Main::input.connect(SigC::slot(this,&BackgroundOpWidget::get_line),
                        pipe_fd[0],
                       (GdkInputCondition)(GDK_INPUT_READ|GDK_INPUT_EXCEPTION));
#ifdef STL_HAS_OFSTREAM_FD
        logger=new ofstream(pipe_fd[1]);
        logger->setbuf(NULL,0);
#else
        FILE *fff=fdopen(pipe_fd[1],"w");
	if(!fff)
		throw FWException("Error opening descriptor");
	fbuf=new filebuf(fff,ios_base::out,0);
	logger=new ostream(fbuf);
#endif
	static_cast<ExecBgr*>(bio)->start_operation( logger, cmd, args);
        Gtk::Main::idle.connect(SigC::slot(bio,&BackgroundOp::monitor_operation));
    } catch(FWException &ex)
    {
	*this << "\n* " << ex.toString();
        throw;
    }

//    if(bio->get_latest_error())
//        throw *bio->get_latest_error();

}
