/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef VALUELINE_H
#define VALUELINE_H

#include <qcanvas.h>
#include <qpainter.h>
#include "defs.h"

/**
@author Predrag Viceic
\class ValueLine

\brief This class implemets one automation value in  EffectPortFrame.

Every value line holds the pointer to the value in LADSPAPort::valuesOverTime

\sa EffectFrame

\sa LADSPAPort

*/
class ValueLine : public QCanvasRectangle
{
public:
    ValueLine(QCanvas*,long,float*);

    ~ValueLine();
    long getSamplePos();
    float getValue();
    float* getValuePointer();
    int rtti() const;
    QPoint startPoint();
    QPoint endPoint();
    void setPoints(int x1, int y1, int x2, int y2);
    void setWidth(int);
    void setSamplePos(long pos);
    void setValuePointer(float* val);

private:
    long samplePos;

protected:
    float* value; /** < pointer to the value in LADSPAPort#valuesOverTime */
    void drawShape ( QPainter & p ) ;
};

#endif
