/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "playline.h"

PlayLine::PlayLine(QCanvas* canvas,long _pos)
 : QCanvasLine(canvas)
{
    position=_pos;
    state=STATE_STOPPED;
}


PlayLine::~PlayLine()
{
}

void PlayLine::drawShape( QPainter &p ){
    RasterOp oldROP=p.rasterOp();
    p.setBrush(pen().color());
    p.setRasterOp(CopyROP);
    setPoints(int(x()),0,int(x()),canvas()->height());
    p.drawLine(startPoint(),endPoint());
    p.drawPixmap(int(x())-8,12,QPixmap(qembed_findImage("1downarrow-red")));
    p.drawPixmap(int(x())-8,canvas()->height()-16,QPixmap(qembed_findImage("1uparrow-red")));
    if(state==STATE_STOPPED)
        p.drawPixmap(int(x())-5,0,QPixmap(qembed_findImage("player_pause-small")));
    else if(state==STATE_PLAYING)
        p.drawPixmap(int(x())-5,0,QPixmap(qembed_findImage("player_play-small")));
    else if(state==STATE_PAUSED)
        p.drawPixmap(int(x())-5,0,QPixmap(qembed_findImage("player_pause-small")));

    p.setRasterOp(oldROP);
}





/*!
    \fn PlayLine::setPosition(long)
 */
void PlayLine::setPosition(long _pos)
{
    position=_pos;
}


/*!
    \fn PlayLine::getPosition()
 */
long PlayLine::getPosition()
{
    return position;
}

QPointArray  PlayLine::areaPoints() const{
    QPointArray result(4);
    result.setPoint(0,QPoint((int)x()-9,-1));
    result.setPoint(1,QPoint((int)x()+9,-1));
    result.setPoint(2,QPoint((int)x()+9,canvas()->height()+1));
    result.setPoint(3,QPoint((int)x()-9,canvas()->height()+1));

    return result;
}


/*!
    \fn PlayLine::setState(State _state)
 */
void PlayLine::setState(State _state)
{
    state=_state;
}
