//
// C++ Implementation: pitchshiftrect
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "pitchshiftrect.h"

PitchShiftRect::PitchShiftRect(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
    setSize(60,21);
    transpDownRect=new QRect(0,0,17,17);
    transpUpRect=new QRect(0,0,17,17);
    counterRect=new QRect(0,0,18,18);
    control_active=PS_NONE;
    transpose=0;
    maxTranspose=24;
}


PitchShiftRect::~PitchShiftRect()
{
}

/*!
    \fn PitchShiftRect::rtti()
 */
int PitchShiftRect::rtti() const
{
    return RTTI_PITCHSHIFTRECT;
}

void PitchShiftRect::drawShape(QPainter & p)
{
    RasterOp oldRop=p.rasterOp();
    p.setRasterOp(AndROP);
    transpDownRect->moveTop(rect().top()+2);
    transpDownRect->moveLeft(rect().left()+3);
    transpUpRect->moveTop(rect().top()+2);
    transpUpRect->moveRight(rect().right()-3);
    counterRect->moveTop(rect().top()+2);
    counterRect->moveLeft(transpDownRect->right()+1);
    
    p.fillRect(rect(),QBrush(QColor(20,100,0)));
    if(control_active==PS_TRANSP_DOWN){
        p.drawPixmap(*transpDownRect,QPixmap(qembed_findImage("1leftarrow-blue-red")));
        p.drawPixmap(*transpUpRect,QPixmap(qembed_findImage("1rightarrow-blue")));
    }else if(control_active==PS_TRANSP_UP){
        p.drawPixmap(*transpDownRect,QPixmap(qembed_findImage("1leftarrow-blue")));
        p.drawPixmap(*transpUpRect,QPixmap(qembed_findImage("1rightarrow-blue-red")));
    }else{
        p.drawPixmap(*transpDownRect,QPixmap(qembed_findImage("1leftarrow-blue")));
        p.drawPixmap(*transpUpRect,QPixmap(qembed_findImage("1rightarrow-blue")));
    }
    p.setRasterOp(oldRop);
    p.setPen(white);
    QFont font=p.font();
    font.setPixelSize(15);
    p.setFont(font);
    p.drawText(*counterRect,Qt::AlignCenter,QString::number(transpose));
    
    

}

/*!
    \fn PitchShiftRect::mouseReleaseEvent(QMouseEvent * e)
 */
void PitchShiftRect::mouseReleaseEvent(QMouseEvent * /*e*/)
{
    control_active=PS_NONE;
    update();
}


/*!
    \fn PitchShiftRect::mousePressEvent(QMouseEvent * e)
 */
void PitchShiftRect::mousePressEvent(QMouseEvent * e)
{
    QPoint pos=e->pos();
    if(transpDownRect->contains(pos)){
        control_active=PS_TRANSP_DOWN;
        if (transpose>-maxTranspose) transpose--;
    }
    if(transpUpRect->contains(pos)){
        control_active=PS_TRANSP_UP;
        if (transpose<maxTranspose) transpose++;
    }
    update();
}




QRect* PitchShiftRect::getTranspDownRect() const {
    return transpDownRect;
}


QRect* PitchShiftRect::getTranspUpRect() const {
    return transpUpRect;
}

/*!
    \fn PitchShiftRect::setY(double y)
 */
void PitchShiftRect::setY(double y)
{
    int y2=int(y<0?0:y>canvas()->height()-rect().height()-20?canvas()->height()-rect().height()-20:y);
    QCanvasRectangle::setY(y2);
}


/*!
    \fn PitchShiftRect::setX(double x)
 */
void PitchShiftRect::setX(double x)
{
    int x2=int(x>canvas()->width()-rect().width()-20?canvas()->width()-rect().width()-20:x);
    QCanvasRectangle::setX(x2);
}


int PitchShiftRect::getTranspose() const {
    return transpose;
}
